/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import javajs.util.BS;
import javajs.util.P3d;
import javajs.util.P3i;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.shape.Shape;
import org.jmol.util.C;
import org.jmol.util.Font;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public class Text {
    public static final int PYMOL_LABEL_OFFSET_JMOL = -1;
    public static final int PYMOL_LABEL_OFFSET_ABS = 0;
    public static final int PYMOL_LABEL_OFFSET_ANG = 0;
    public static final int PYMOL_LABEL_OFFSET_REL = 1;
    public static final int PYMOL_LABEL_OFFSET_PIX = 2;
    public static final int PYMOL_LABEL_OFFSET_ABS_ANG = 0;
    public static final int PYMOL_LABEL_OFFSET_REL_ANG = 1;
    public static final int PYMOL_LABEL_OFFSET_ABS_PIX = 2;
    public static final int PYMOL_LABEL_OFFSET_REL_PIX = 3;
    private Viewer vwr;
    public boolean doFormatText;
    public Font font;
    private int fid;
    private int ascent;
    public int descent;
    public int lineHeight;
    protected int offsetX;
    protected int offsetY;
    public int boxYoff2;
    private int[] widths;
    private int textWidth;
    private int textHeight;
    public String text;
    public String textUnformatted;
    public String[] lines;
    public Object image;
    public double imageScale = 1.0;
    public int barPixels;
    public double barDistance;
    public boolean isMeasure;
    public boolean isEcho;
    public P3d xyz;
    public String target;
    public String script;
    public short colix;
    public short bgcolix;
    public int pointer;
    public double fontScale;
    public int align;
    public int valign;
    public int atomX;
    public int atomY;
    public int atomZ = Integer.MAX_VALUE;
    public int movableX;
    public int movableY;
    public int movableZ;
    public int movableXPercent = Integer.MAX_VALUE;
    public int movableYPercent = Integer.MAX_VALUE;
    public int movableZPercent = Integer.MAX_VALUE;
    public int z = 1;
    public int zSlab = Integer.MIN_VALUE;
    private double xAdj;
    private double yAdj;
    private double y0;
    public P3d pointerPt;
    public double[] pymolOffset;
    protected int windowWidth;
    protected int windowHeight;
    public boolean adjustForWindow;
    public double boxWidth;
    public double boxHeight;
    public double boxX;
    public double boxY;
    public int modelIndex = -1;
    public boolean thisModelOnly;
    public boolean visible = true;
    public boolean hidden = false;
    public double[] boxXY = new double[5];
    public double scalePixelsPerMicron;
    public int barPixelsXYZ;
    private double sppa;

    public static Text newLabel(Viewer vwr, Font font, String text, short colix, short bgcolix, int align, double scalePixelsPerMicron) {
        Text t = new Text();
        t.vwr = vwr;
        t.set(font, colix, align, scalePixelsPerMicron);
        t.setText(text);
        t.bgcolix = bgcolix;
        return t;
    }

    public static Text newMeasure(Viewer vwr, Font font, short colix) {
        Text t = new Text();
        t.vwr = vwr;
        t.set(font, colix, 0, 0.0);
        t.isMeasure = true;
        return t;
    }

    public static Text newEcho(Viewer vwr, Font font, String target, short colix, int valign, int align, double scalePixelsPerMicron) {
        Text t = new Text();
        t.isEcho = true;
        t.vwr = vwr;
        t.set(font, colix, align, scalePixelsPerMicron);
        t.target = target;
        t.valign = valign;
        t.z = 2;
        t.zSlab = Integer.MIN_VALUE;
        return t;
    }

    private void set(Font font, short colix, int align, double scalePixelsPerMicron) {
        this.scalePixelsPerMicron = scalePixelsPerMicron;
        this.colix = colix;
        this.align = align;
        this.setFont(font, !this.isEcho);
    }

    public void setOffset(int offset) {
        this.offsetX = JC.getXOffset(offset);
        this.offsetY = JC.getYOffset(offset);
        this.pymolOffset = null;
        this.valign = 3;
    }

    private void getFontMetrics() {
        this.descent = this.font.getDescent();
        this.ascent = this.font.getAscent();
        this.lineHeight = this.ascent + this.descent;
    }

    public void setFontFromFid(int fid) {
        if (this.fid == fid) {
            return;
        }
        this.fontScale = 0.0;
        this.setFont(Font.getFont3D(fid), true);
    }

    public void setText(String text) {
        if (this.image != null) {
            this.getFontMetrics();
            this.image = null;
        }
        this.barPixels = 0;
        if (text != null && text.length() == 0) {
            text = null;
        }
        if (this.text != null && this.text.equals(text)) {
            return;
        }
        this.text = this.textUnformatted = text;
        boolean bl = this.doFormatText = this.isEcho && text != null && (text.indexOf("%{") >= 0 || text.indexOf("@{") >= 0);
        if (!this.doFormatText) {
            this.recalc();
        }
    }

    public void setImage(Object image) {
        this.image = image;
        this.recalc();
    }

    public void setScale(double scale) {
        this.imageScale = scale;
        this.recalc();
    }

    public void setFont(Font f3d, boolean doAll) {
        this.font = f3d;
        if (this.font == null) {
            return;
        }
        this.getFontMetrics();
        if (!doAll) {
            return;
        }
        this.fid = this.font.fid;
        this.recalc();
    }

    public void setFontScale(double scale) {
        if (this.fontScale == scale) {
            return;
        }
        this.fontScale = scale;
        if (this.fontScale != 0.0 && this.font != null) {
            this.setFont(this.vwr.gdata.getFont3DScaled(this.font, scale), true);
        }
    }

    private void recalc() {
        if (this.image != null) {
            this.textHeight = 0;
            this.textWidth = 0;
            this.boxWidth = (double)this.vwr.apiPlatform.getImageWidth(this.image) * this.fontScale * this.imageScale;
            this.boxHeight = (double)this.vwr.apiPlatform.getImageHeight(this.image) * this.fontScale * this.imageScale;
            this.ascent = 0;
            return;
        }
        if (this.text == null) {
            this.text = null;
            this.lines = null;
            this.widths = null;
            return;
        }
        if (this.font == null) {
            return;
        }
        this.lines = PT.split(this.text, this.text.indexOf("\n") >= 0 ? "\n" : "|");
        this.textWidth = 0;
        this.widths = new int[this.lines.length];
        int i = this.lines.length;
        while (--i >= 0) {
            this.widths[i] = this.stringWidth(this.lines[i]);
            this.textWidth = Math.max(this.textWidth, this.widths[i]);
        }
        this.textHeight = this.lines.length * this.lineHeight;
        this.boxWidth = this.textWidth + (this.fontScale >= 2.0 ? 16 : 8);
        this.boxHeight = this.textHeight + (this.fontScale >= 2.0 ? 16 : 8);
    }

    public void setPosition(double scalePixelsPerMicron, double imageFontScaling, boolean isAbsolute, double[] boxXY) {
        if (boxXY == null) {
            boxXY = this.boxXY;
        } else {
            this.boxXY = boxXY;
        }
        this.setWindow(this.vwr.gdata.width, this.vwr.gdata.height, scalePixelsPerMicron);
        if (this.font.fontSizeAngstroms != 0.0 || scalePixelsPerMicron != 0.0 && this.scalePixelsPerMicron != 0.0) {
            if (this.font.fontSizeAngstroms == 0.0) {
                this.setFontScale(scalePixelsPerMicron / this.scalePixelsPerMicron);
            } else {
                this.setFontScale(this.sppa * this.font.fontSizeAngstroms / this.font.fontSizeNominal);
            }
        } else if (this.fontScale != imageFontScaling) {
            this.setFontScale(imageFontScaling);
        }
        if (this.doFormatText) {
            this.text = this.isEcho ? this.vwr.formatText(this.textUnformatted) : this.textUnformatted;
            this.recalc();
        } else if (this.textUnformatted != null && this.textUnformatted.startsWith("%SCALE")) {
            double[] ret = new double[2];
            this.text = this.vwr.getScaleText(this.textUnformatted.substring(6).trim(), this.vwr.antialiased, this.xyz == null ? 15 : 8, ret);
            this.barPixels = (int)(ret[0] * (double)(this.vwr.antialiased ? 2 : 1));
            this.barDistance = ret[1];
            this.recalc();
        }
        double dx = (double)this.offsetX * imageFontScaling;
        double dy = (double)this.offsetY * imageFontScaling;
        this.xAdj = this.fontScale >= 2.0 ? 8 : 4;
        this.yAdj = (double)(this.ascent - this.lineHeight) + this.xAdj;
        if (!this.isEcho || this.pymolOffset != null) {
            boolean isAng;
            boxXY[0] = this.movableX;
            boxXY[1] = this.movableY;
            boolean bl = isAng = !this.isPymolOffsetPixels();
            if (this.pymolOffset != null && isAng) {
                double pixelsPerAngstrom = this.vwr.tm.scaleToScreen(this.z, 1000);
                double pz = this.pymolOffset[3];
                double dz = (double)(pz < 0.0 ? -1 : 1) * Math.max(pz == 0.0 ? 0.0 : 0.0, Math.abs(pz) - 1.0) * pixelsPerAngstrom;
                this.z -= (int)dz;
                pixelsPerAngstrom = this.vwr.tm.scaleToScreen(this.z, 1000);
                dx = this.xyz != null && this.barPixels > 0 ? 0.0 : Text.getPymolXYOffset(this.pymolOffset[1], this.textWidth, pixelsPerAngstrom);
                int dh = this.ascent - this.descent;
                dy = -Text.getPymolXYOffset(-this.pymolOffset[2], dh, pixelsPerAngstrom) - (double)((this.textHeight + dh) / 2);
                if (this.pymolOffset[0] == 1.0) {
                    dy -= (double)this.descent;
                }
                this.xAdj = this.fontScale >= 2.0 ? 8 : 4;
                this.yAdj = -this.descent;
                boxXY[0] = (double)this.movableX - this.xAdj;
                boxXY[1] = (double)this.movableY - this.yAdj + (double)((this.descent - this.ascent) / 2) + 8.0;
                isAbsolute = true;
                this.boxYoff2 = -2;
            } else {
                this.boxYoff2 = 0;
            }
            if (this.pymolOffset == null) {
                switch (this.align) {
                    case 8: {
                        dy = 0.0;
                        dx = 0.0;
                        break;
                    }
                    case 12: {
                        boxXY[0] = boxXY[0] - this.boxWidth;
                    }
                    case 4: {
                        dy = 0.0;
                    }
                }
            }
            Text.setBoxXY(this.boxWidth, this.boxHeight, dx, dy, boxXY, isAbsolute);
        } else {
            this.setPos(this.fontScale);
        }
        this.boxX = boxXY[0];
        this.boxY = boxXY[1];
        if (this.adjustForWindow) {
            this.setBoxOffsetsInWindow(0.0, this.isEcho ? 0.0 : 16.0 * this.fontScale + (double)this.lineHeight, this.boxY - (double)this.textHeight);
        }
        this.y0 = this.boxY + this.yAdj;
        if (this.isMeasure && this.align != 8) {
            this.y0 += (double)this.ascent + (double)(this.lines.length - 1) / 2.0 * (double)this.lineHeight;
        }
    }

    private static double getPymolXYOffset(double x, int width, double ppa) {
        double f;
        double d = x < -1.0 ? -1.0 : (f = x > 1.0 ? 0.0 : (x - 1.0) / 2.0);
        double offset = x < -1.0 || x > 1.0 ? x + (double)(x < 0.0 ? 1 : -1) : 0.0;
        return f * (double)width + offset * ppa;
    }

    private void setPos(double scale) {
        double xLeft;
        double xRight;
        double xCenter;
        boolean is3dEcho;
        boolean bl = is3dEcho = this.xyz != null;
        if (this.valign == 3 || this.valign == 4) {
            double x = this.movableXPercent != Integer.MAX_VALUE ? (double)(this.movableXPercent * this.windowWidth / 100) : (is3dEcho ? (double)this.movableX : (double)this.movableX * scale);
            double offsetX = (double)this.offsetX * scale;
            xRight = xCenter = x + offsetX + (double)this.barPixels;
            xLeft = xCenter;
        } else {
            xLeft = 5.0 * scale;
            xCenter = (this.windowWidth + this.barPixels) / 2;
            xRight = (double)this.windowWidth - xLeft;
            xLeft += (double)this.barPixels;
        }
        switch (this.align) {
            case 8: {
                this.boxXY[0] = xCenter - this.boxWidth / 2.0;
                break;
            }
            case 12: {
                this.boxXY[0] = xRight - this.boxWidth;
                break;
            }
            default: {
                this.boxXY[0] = xLeft;
            }
        }
        this.boxXY[1] = 0.0;
        switch (this.valign) {
            case 0: {
                break;
            }
            case 2: {
                this.boxXY[1] = this.windowHeight / 2;
                break;
            }
            case 1: {
                this.boxXY[1] = this.windowHeight;
                break;
            }
            default: {
                double y = this.movableYPercent != Integer.MAX_VALUE ? (double)(this.movableYPercent * this.windowHeight / 100) : (is3dEcho ? (double)this.movableY : (double)this.movableY * scale);
                this.boxXY[1] = (is3dEcho ? y : (double)this.windowHeight - y) + (double)this.offsetY * scale;
            }
        }
        if (this.align == 8) {
            this.boxXY[1] = this.boxXY[1] - (this.image != null ? this.boxHeight : (this.xyz != null ? this.boxHeight : (double)this.ascent - this.boxHeight)) / 2.0;
        } else if (this.image != null) {
            this.boxXY[1] = this.boxXY[1] - 0.0;
        } else if (this.xyz != null) {
            this.boxXY[1] = this.boxXY[1] - (double)(this.ascent / 2);
        }
    }

    public static void setBoxXY(double boxWidth, double boxHeight, double xOffset, double yOffset, double[] boxXY, boolean isAbsolute) {
        double xBoxOffset;
        if (xOffset > 0.0 || isAbsolute) {
            xBoxOffset = xOffset;
        } else {
            xBoxOffset = -boxWidth;
            xBoxOffset = xOffset == 0.0 ? (xBoxOffset /= 2.0) : (xBoxOffset += xOffset);
        }
        double yBoxOffset = isAbsolute || yOffset > 0.0 ? -boxHeight - yOffset : (yOffset == 0.0 ? -boxHeight / 2.0 : -yOffset);
        boxXY[0] = boxXY[0] + xBoxOffset;
        boxXY[1] = boxXY[1] + yBoxOffset;
        boxXY[2] = boxWidth;
        boxXY[3] = boxHeight;
    }

    private int stringWidth(String str) {
        int w = 0;
        int f = 1;
        int subscale = 1;
        if (str == null) {
            return 0;
        }
        if (str.indexOf("<su") < 0 && str.indexOf("<color") < 0) {
            return this.font.stringWidth(str);
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) == '<') {
                String s;
                int i1;
                if (i + 8 <= len && (str.substring(i, i + 7).equals("<color ") || str.substring(i, i + 8).equals("</color>")) && (i1 = str.indexOf(">", i)) >= 0) {
                    i = i1;
                    continue;
                }
                if (i + 5 <= len && ((s = str.substring(i, i + 5)).equals("<sub>") || s.equals("<sup>"))) {
                    i += 4;
                    f = subscale;
                    continue;
                }
                if (i + 6 <= len && ((s = str.substring(i, i + 6)).equals("</sub>") || s.equals("</sup>"))) {
                    i += 5;
                    f = 1;
                    continue;
                }
            }
            w += this.font.stringWidth(str.substring(i, i + 1)) * f;
        }
        return w;
    }

    public void setXYA(double[] xy, int i) {
        if (i == 0) {
            xy[2] = this.boxX;
            switch (this.align) {
                case 8: {
                    xy[2] = xy[2] + this.boxWidth / 2.0;
                    break;
                }
                case 12: {
                    xy[2] = xy[2] + (this.boxWidth - this.xAdj);
                    break;
                }
                default: {
                    xy[2] = xy[2] + this.xAdj;
                }
            }
            xy[0] = xy[2];
            xy[1] = this.y0;
        }
        switch (this.align) {
            case 8: {
                xy[0] = xy[2] - (double)(this.widths[i] / 2);
                break;
            }
            case 12: {
                xy[0] = xy[2] - (double)this.widths[i];
            }
        }
        xy[1] = xy[1] + (double)this.lineHeight;
    }

    public void appendFontCmd(SB s) {
        s.append("  " + Shape.getFontCommand("echo", this.font));
        if (this.scalePixelsPerMicron > 0.0) {
            s.append(" " + 10000.0 / this.scalePixelsPerMicron);
        }
    }

    public void setScalePixelsPerMicron(double scalePixelsPerMicron) {
        this.fontScale = 0.0;
        this.scalePixelsPerMicron = scalePixelsPerMicron;
    }

    public void setXYZ(P3d xyz, boolean doAdjust) {
        this.xyz = xyz;
        if (xyz == null) {
            this.zSlab = Integer.MIN_VALUE;
            this.pymolOffset = null;
        }
        if (doAdjust) {
            this.valign = xyz == null ? 3 : 4;
            this.adjustForWindow = xyz == null;
        }
    }

    public void setTranslucent(double level, boolean isBackground) {
        if (isBackground) {
            if (this.bgcolix != 0) {
                this.bgcolix = C.getColixTranslucent3(this.bgcolix, !Double.isNaN(level), level);
            }
        } else {
            this.colix = C.getColixTranslucent3(this.colix, !Double.isNaN(level), level);
        }
    }

    public void setMovableX(int x) {
        this.valign = this.valign == 4 ? 4 : 3;
        this.movableX = x;
        this.movableXPercent = Integer.MAX_VALUE;
    }

    public void setMovableY(int y) {
        this.valign = this.valign == 4 ? 4 : 3;
        this.movableY = y;
        this.movableYPercent = Integer.MAX_VALUE;
    }

    public void setMovableXPercent(int x) {
        this.valign = this.valign == 4 ? 4 : 3;
        this.movableX = Integer.MAX_VALUE;
        this.movableXPercent = x;
    }

    public void setMovableYPercent(int y) {
        this.valign = this.valign == 4 ? 4 : 3;
        this.movableY = Integer.MAX_VALUE;
        this.movableYPercent = y;
    }

    public void setMovableZPercent(int z) {
        if (this.valign != 4) {
            this.valign = 3;
        }
        this.movableZ = Integer.MAX_VALUE;
        this.movableZPercent = z;
    }

    public void setZs(int z, int zSlab) {
        this.z = z;
        this.zSlab = zSlab;
    }

    public void setXYZs(int x, int y, int z, int zSlab) {
        this.setMovableX(x);
        this.setMovableY(y);
        this.setZs(z, zSlab);
    }

    public void setScript(String script) {
        this.script = script == null || script.length() == 0 ? null : script;
    }

    public boolean setAlignmentLCR(String align) {
        if (align != null) {
            if ("left".equals(align)) {
                return this.setAlignment(4);
            }
            if ("center".equals(align)) {
                return this.setAlignment(8);
            }
            if ("right".equals(align)) {
                return this.setAlignment(12);
            }
        }
        return false;
    }

    public boolean setAlignment(int align) {
        if (this.align != align) {
            this.align = align;
            this.recalc();
        }
        return true;
    }

    public void setBoxOffsetsInWindow(double margin, double vMargin, double vTop) {
        double x = this.boxX;
        double bw = this.boxWidth + margin;
        if (x + bw > (double)this.windowWidth) {
            x = (double)this.windowWidth - bw;
        }
        if (x < margin) {
            x = margin;
        }
        this.boxX = x;
        double y = vTop;
        double bh = this.boxHeight;
        if (y + bh > (double)this.windowHeight) {
            y = (double)this.windowHeight - bh;
        }
        if (y < vMargin) {
            y = vMargin;
        }
        this.boxY = y;
    }

    public void setWindow(int width, int height, double scalePixelsPerMicron) {
        this.windowWidth = width;
        this.windowHeight = height;
        if (this.pymolOffset == null && this.scalePixelsPerMicron < 0.0 && scalePixelsPerMicron != 0.0) {
            this.setScalePixelsPerMicron(scalePixelsPerMicron);
        }
    }

    public boolean checkObjectClicked(boolean isAntialiased, int x, int y, BS bsVisible) {
        if (this.hidden || this.script == null || this.modelIndex >= 0 && !bsVisible.get(this.modelIndex)) {
            return false;
        }
        if (isAntialiased) {
            x <<= 1;
            y <<= 1;
        }
        return (double)x >= this.boxX && (double)x <= this.boxX + this.boxWidth && (double)y >= this.boxY && (double)y <= this.boxY + this.boxHeight;
    }

    public void getPymolScreenOffset(P3d atomPt, P3i screen, int zSlab, P3d pTemp, double sppa) {
        this.sppa = sppa;
        boolean isPixel = this.isPymolOffsetPixels();
        boolean isRelative = this.isPymolOffsetRelative();
        if (atomPt != null && isRelative) {
            pTemp.setT(atomPt);
        } else {
            pTemp.set(0.0, 0.0, 0.0);
        }
        pTemp.add3(this.pymolOffset[4], this.pymolOffset[5], this.pymolOffset[6]);
        this.vwr.tm.transformPtScr(pTemp, screen);
        if (isPixel) {
            screen.x = (int)((double)screen.x + this.pymolOffset[1]);
            screen.y = (int)((double)screen.y + this.pymolOffset[2]);
            screen.z = (int)((double)screen.z + this.pymolOffset[3]);
        }
        this.setXYZs(screen.x, screen.y, screen.z, zSlab);
    }

    private boolean isPymolOffsetRelative() {
        int mode = this.pymolOffset == null ? -1 : (int)this.pymolOffset[0];
        return (mode & 1) == 1;
    }

    private boolean isPymolOffsetPixels() {
        int mode = this.pymolOffset == null ? -1 : (int)this.pymolOffset[0];
        return mode != -1 && (mode & 2) == 2;
    }

    public String getStateText() {
        return this.doFormatText ? PT.rep(this.text, "@{", "\\@{") : this.text;
    }

    public String toString() {
        return this.textUnformatted;
    }
}

