/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import javajs.util.BS;
import javajs.util.P3d;
import javajs.util.T3d;
import org.jmol.api.AtomIndexIterator;
import org.jmol.atomdata.RadiusData;
import org.jmol.bspt.Bspf;
import org.jmol.bspt.CubeIterator;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelSet;
import org.jmol.viewer.Viewer;

public class AtomIteratorWithinModel
implements AtomIndexIterator {
    protected CubeIterator cubeIterator;
    protected Bspf bspf;
    private boolean threadSafe;
    private boolean hemisphereOnly;
    private boolean isZeroBased;
    protected int modelIndex = Integer.MAX_VALUE;
    private int atomIndex = -1;
    private int zeroBase;
    private double distanceSquared;
    private BS bsSelected;
    private boolean isGreaterOnly;
    private boolean checkGreater;
    private RadiusData radiusData;
    private double vdw1;
    private boolean isVdw;
    private Atom[] atoms;
    private Viewer vwr;
    private int iNext;

    AtomIteratorWithinModel() {
    }

    void initialize(Bspf bspf, BS bsSelected, boolean isGreaterOnly, boolean isZeroBased, boolean hemisphereOnly, boolean threadSafe) {
        this.bspf = bspf;
        this.bsSelected = bsSelected;
        this.isGreaterOnly = isGreaterOnly;
        this.isZeroBased = isZeroBased;
        this.hemisphereOnly = hemisphereOnly;
        this.threadSafe = threadSafe;
        this.cubeIterator = null;
    }

    @Override
    public void setModel(ModelSet modelSet, int modelIndex, int firstModelAtom, int atomIndex, T3d center, double distance, RadiusData rd) {
        if (this.threadSafe) {
            modelIndex = -1 - modelIndex;
        }
        if (modelIndex != this.modelIndex || this.cubeIterator == null) {
            this.cubeIterator = this.bspf.getCubeIterator(modelIndex);
            this.modelIndex = modelIndex;
        }
        int n = this.zeroBase = this.isZeroBased ? firstModelAtom : 0;
        if (distance == -2.147483648E9) {
            return;
        }
        this.atomIndex = distance < 0.0 ? -1 : atomIndex;
        boolean bl = this.isVdw = rd != null;
        if (this.isVdw) {
            this.radiusData = rd;
            this.atoms = modelSet.at;
            this.vwr = modelSet.vwr;
            distance = rd.factorType == RadiusData.EnumType.OFFSET ? 5.0 + rd.value : 5.0 * rd.value;
            this.vdw1 = this.atoms[atomIndex].getVanderwaalsRadiusFloat(this.vwr, rd.vdwType);
        }
        this.checkGreater = this.isGreaterOnly && atomIndex != Integer.MAX_VALUE;
        this.setCenter(center, distance);
    }

    @Override
    public void setCenter(T3d center, double distance) {
        this.setCenter2(center, distance);
    }

    protected void setCenter2(T3d center, double distance) {
        if (this.cubeIterator == null) {
            return;
        }
        this.cubeIterator.initialize(center, distance, this.hemisphereOnly);
        this.distanceSquared = distance * distance;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext2();
    }

    protected boolean hasNext2() {
        if (this.atomIndex >= 0) {
            while (this.cubeIterator.hasMoreElements()) {
                Atom a = (Atom)this.cubeIterator.nextElement();
                this.iNext = a.i;
                if (this.iNext == this.atomIndex || this.checkGreater && this.iNext <= this.atomIndex || this.bsSelected != null && !this.bsSelected.get(this.iNext)) continue;
                return true;
            }
        } else if (this.cubeIterator.hasMoreElements()) {
            Atom a = (Atom)this.cubeIterator.nextElement();
            this.iNext = a.i;
            return true;
        }
        this.iNext = -1;
        return false;
    }

    @Override
    public int next() {
        return this.iNext - this.zeroBase;
    }

    @Override
    public double foundDistance2() {
        return this.cubeIterator == null ? -1.0 : this.cubeIterator.foundDistance2();
    }

    @Override
    public void addAtoms(BS bsResult) {
        while (this.hasNext()) {
            double d;
            int iAtom = this.next();
            if (iAtom < 0) continue;
            if (this.isVdw) {
                d = this.atoms[iAtom].getVanderwaalsRadiusFloat(this.vwr, this.radiusData.vdwType) + this.vdw1;
                switch (this.radiusData.factorType) {
                    case OFFSET: {
                        d += this.radiusData.value * 2.0;
                        break;
                    }
                    case FACTOR: {
                        d *= this.radiusData.value;
                    }
                }
                d *= d;
            } else {
                d = this.distanceSquared;
            }
            if (!(this.foundDistance2() <= d)) continue;
            bsResult.set(iAtom);
        }
    }

    @Override
    public void release() {
        if (this.cubeIterator != null) {
            this.cubeIterator.release();
            this.cubeIterator = null;
        }
    }

    @Override
    public P3d getPosition() {
        return null;
    }
}

