/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.Map;
import java.util.Random;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.MeasureD;
import javajs.util.P3d;
import javajs.util.PT;
import javajs.util.T3d;
import javajs.util.V3d;
import org.jmol.api.Interface;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.AtomDataReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.quantum.MOCalculation;
import org.jmol.quantum.NciCalculation;
import org.jmol.quantum.QS;
import org.jmol.quantum.QuantumCalculation;
import org.jmol.quantum.QuantumPlaneCalculation;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

class IsoMOReader
extends AtomDataReader {
    private Random random;
    private P3d[] points;
    private V3d vTemp;
    private QuantumCalculation q;
    private Lst<Map<String, Object>> mos;
    private boolean isNci;
    private double[] coef;
    private int[][] dfCoefMaps;
    private double[] linearCombination;
    private double[][] coefs;
    private boolean isElectronDensityCalc;
    private Map<String, Object> mo;
    private final double[] vDist = new double[3];
    private boolean qSetupDone;

    IsoMOReader() {
    }

    @Override
    void init(SurfaceGenerator sg) {
        this.initADR(sg);
        boolean bl = this.isNci = this.params.qmOrbitalType == 3;
        if (this.isNci) {
            this.hasColorData = true;
            this.isXLowToHigh = true;
            this.precalculateVoxelData = false;
            this.params.insideOut = !this.params.insideOut;
        }
    }

    @Override
    protected void setup(boolean isMapData) {
        String className;
        this.mos = (Lst)this.params.moData.get("mos");
        this.linearCombination = this.params.qm_moLinearCombination;
        this.mo = this.mos != null && this.linearCombination == null ? (Map)this.mos.get(this.params.qm_moNumber - 1) : null;
        boolean haveVolumeData = this.params.moData.containsKey("haveVolumeData");
        if (haveVolumeData && this.mo != null) {
            this.params.volumeData = (VolumeData)this.mo.get("volumeData");
        }
        this.setup2();
        this.doAddHydrogens = false;
        this.getAtoms(this.params.bsSelected, this.doAddHydrogens, !this.isNci, this.isNci, this.isNci, false, false, this.params.qm_marginAngstroms, this.isNci ? null : this.params.modelInvRotation);
        if (this.isNci) {
            className = "quantum.NciCalculation";
            this.setHeader("NCI (promolecular)", "see NCIPLOT: A Program for Plotting Noncovalent Interaction Regions, Julia Contreras-Garcia, et al., J. of Chemical Theory and Computation, 2011, 7, 625-632");
        } else {
            className = "quantum.MOCalculation";
            this.setHeader("MO", "calculation type: " + this.params.moData.get("calculationType"));
        }
        this.setRanges(this.params.qm_ptsPerAngstrom, this.params.qm_gridMax, 0.0);
        if (haveVolumeData) {
            int i = this.params.title.length;
            while (--i >= 0) {
                this.fixTitleLine(i, this.mo);
            }
        } else {
            this.q = (QuantumCalculation)Interface.getOption(className, (Viewer)this.sg.atomDataServer, "file");
            if (this.isNci) {
                this.qpc = (QuantumPlaneCalculation)this.q;
            } else if (this.linearCombination == null) {
                int i = this.params.title.length;
                while (--i >= 0) {
                    this.fixTitleLine(i, this.mo);
                }
                this.coef = (double[])this.mo.get("coefficients");
                this.dfCoefMaps = (int[][])this.mo.get("dfCoefMaps");
            } else {
                int i;
                this.coefs = AU.newDouble2(this.mos.size());
                for (i = 1; i < this.linearCombination.length; i += 2) {
                    int j = (int)this.linearCombination[i];
                    if (j > this.mos.size() || j < 1) {
                        return;
                    }
                    this.coefs[j - 1] = (double[])((Map)this.mos.get(j - 1)).get("coefficients");
                }
                i = this.params.title.length;
                while (--i >= 0) {
                    this.fixTitleLine(i, null);
                }
            }
            this.isElectronDensityCalc = this.coef == null && this.linearCombination == null && !this.isNci;
        }
        this.volumeData.sr = null;
        if (isMapData && !this.isElectronDensityCalc && !haveVolumeData) {
            this.volumeData.doIterate = false;
            this.voxelData = new double[1][1][1];
            this.volumeData.setVoxelDataAsArray(this.voxelData);
            this.volumeData.sr = this;
            this.points = new P3d[1];
            this.points[0] = new P3d();
            if (!this.setupCalculation()) {
                this.q = null;
            }
        } else if (this.params.psi_monteCarloCount > 0) {
            this.vertexDataOnly = true;
            this.random = new Random(this.params.randomSeed);
        }
    }

    @Override
    protected boolean readVolumeParameters(boolean isMapData) {
        this.setup(isMapData);
        if (this.volumeData.sr == null) {
            this.initializeVolumetricData();
        }
        return true;
    }

    private void fixTitleLine(int iLine, Map<String, Object> mo) {
        String s;
        String nboType;
        if (this.params.title == null) {
            return;
        }
        String line = this.params.title[iLine];
        if (line.indexOf(" MO ") >= 0 && (nboType = (String)this.params.moData.get("nboType")) != null) {
            line = PT.rep(line, " MO ", " " + nboType + " ");
        }
        if (line.indexOf("%M") >= 0) {
            line = this.params.title[iLine] = PT.formatStringS(line, "M", this.atomData.modelName);
        }
        if (line.indexOf("%F") >= 0) {
            line = this.params.title[iLine] = PT.formatStringS(line, "F", PT.rep(this.params.fileName, "DROP_", ""));
        }
        int pt = line.indexOf("%");
        if (line.length() == 0 || pt < 0) {
            return;
        }
        int rep = 0;
        if (line.indexOf("%I") >= 0) {
            line = PT.formatStringS(line, "I", this.params.qm_moLinearCombination == null ? "" + this.params.qm_moNumber : QS.getMOString(this.params.qm_moLinearCombination));
        }
        if (line.indexOf("%N") >= 0) {
            line = PT.formatStringS(line, "N", "" + this.params.qmOrbitalCount);
        }
        Number energy = null;
        if (mo == null) {
            for (int i = 0; i < this.linearCombination.length; i += 2) {
                if (this.linearCombination[i] == 0.0) continue;
                mo = (Map)this.mos.get((int)this.linearCombination[i + 1] - 1);
                Number e = (Number)mo.get("energy");
                if (energy == null) {
                    if (e != null) {
                        energy = e;
                        continue;
                    }
                } else {
                    if (energy.equals(e)) continue;
                    energy = null;
                }
                break;
            }
        } else if (mo.containsKey("energy")) {
            energy = (Number)mo.get("energy");
        }
        if (line.indexOf("%E") >= 0) {
            line = PT.formatStringS(line, "E", energy != null && ++rep != 0 ? "" + energy : "");
        } else if (energy != null && (s = PT.formatStringD(line, "E", energy.doubleValue())) != line) {
            line = s;
            ++rep;
        }
        if (line.indexOf("%U") >= 0) {
            line = PT.formatStringS(line, "U", energy != null && this.params.moData.containsKey("energyUnits") && ++rep != 0 ? (String)this.params.moData.get("energyUnits") : "");
        }
        if (line.indexOf("%L") >= 0) {
            String[] labels = (String[])this.params.moData.get("nboLabels");
            line = PT.formatStringS(line, "L", labels != null && this.params.qm_moNumber > 0 && ++rep != 0 ? labels[(this.params.qm_moNumber - 1) % labels.length] : "");
        }
        if (line.indexOf("%S") >= 0) {
            line = PT.formatStringS(line, "S", mo != null && mo.containsKey("symmetry") && ++rep != 0 ? "" + mo.get("symmetry") : "");
        }
        if (line.indexOf("%O") >= 0) {
            double o;
            Number obj = mo == null ? (Number)null : (Number)((Number)mo.get("occupancy"));
            double d = o = obj == null ? 0.0 : obj.doubleValue();
            line = PT.formatStringS(line, "O", obj != null && this.params.qm_moLinearCombination == null && ++rep != 0 ? (o == (double)((int)o) ? "" + (int)o : PT.formatD(o, 0, 4, false, false)) : "");
        }
        if (line.indexOf("%T") >= 0) {
            line = PT.formatStringS(line, "T", mo != null && mo.containsKey("type") ? (this.params.qm_moLinearCombination == null && ++rep != 0 ? "" + mo.get("type") : "") + ((this.params.isSquared || this.params.isSquaredLinear) && ++rep != 0 ? " ^2" : "") : "");
        }
        if (line.equals("string")) {
            this.params.title[iLine] = "";
            return;
        }
        boolean isOptional = line.indexOf("?") == 0;
        this.params.title[iLine] = !isOptional ? line : (rep > 0 && !line.trim().endsWith("=") ? line.substring(1) : "");
    }

    @Override
    protected void readSurfaceData(boolean isMapData) throws Exception {
        if (this.volumeData.sr != null) {
            return;
        }
        if (this.params.psi_monteCarloCount <= 0) {
            this.readSurfaceDataVDR(isMapData);
            return;
        }
        if (this.points != null) {
            return;
        }
        this.points = new P3d[1000];
        for (int j = 0; j < 1000; ++j) {
            this.points[j] = new P3d();
        }
        if (this.params.thePlane != null) {
            this.vTemp = new V3d();
        }
        for (int i = 0; i < 3; ++i) {
            this.vDist[i] = this.volumeData.volumetricVectorLengths[i] * (double)this.volumeData.voxelCounts[i];
        }
        this.voxelData = new double[1000][1][1];
        this.volumeData.setVoxelDataAsArray(this.voxelData);
        this.getValues();
        double f = 0.0;
        for (int j = 0; j < 1000; ++j) {
            double d;
            double value = Math.abs(this.voxelData[j][0][0]);
            if (!(d > f)) continue;
            f = value;
        }
        if (f < (double)1.0E-4f) {
            return;
        }
        if (f > this.params.cutoff) {
            f = this.params.cutoff;
        }
        int i = 0;
        block3: while (i < this.params.psi_monteCarloCount) {
            this.getValues();
            for (int j = 0; j < 1000; ++j) {
                double value = this.voxelData[j][0][0];
                double absValue = Math.abs(value);
                if (absValue <= this.getRnd(f)) continue;
                this.addVC(this.points[j], value, 0, false);
                if (++i == this.params.psi_monteCarloCount) continue block3;
            }
        }
    }

    @Override
    protected void postProcessVertices() {
    }

    private void getValues() {
        for (int j = 0; j < 1000; ++j) {
            this.voxelData[j][0][0] = 0.0;
            this.points[j].set(this.volumeData.volumetricOrigin.x + this.getRnd(this.vDist[0]), this.volumeData.volumetricOrigin.y + this.getRnd(this.vDist[1]), this.volumeData.volumetricOrigin.z + this.getRnd(this.vDist[2]));
            if (this.params.thePlane == null) continue;
            MeasureD.getPlaneProjection(this.points[j], this.params.thePlane, this.points[j], this.vTemp);
        }
        this.createOrbital();
    }

    @Override
    public double getValueAtPoint(T3d pt, boolean getSource) {
        return this.q == null ? 0.0 : this.q.processPt(pt);
    }

    private double getRnd(double f) {
        return (double)this.random.nextFloat() * f;
    }

    @Override
    protected void generateCube() {
        if (this.params.volumeData != null) {
            return;
        }
        this.newVoxelDataCube();
        this.createOrbital();
    }

    protected void createOrbital() {
        boolean isMonteCarlo;
        boolean bl = isMonteCarlo = this.params.psi_monteCarloCount > 0;
        if (this.isElectronDensityCalc) {
            if (this.mos == null || isMonteCarlo) {
                return;
            }
            int i = this.params.qm_moNumber;
            while (--i >= 0) {
                Logger.info(" generating isosurface data for MO " + (i + 1));
                Map mo = (Map)this.mos.get(i);
                this.coef = (double[])mo.get("coefficients");
                this.dfCoefMaps = (int[][])mo.get("dfCoefMaps");
                if (!this.setupCalculation()) {
                    return;
                }
                this.q.createCube();
            }
        } else {
            if (!isMonteCarlo) {
                Logger.info("generating isosurface data for MO using cutoff " + this.params.cutoff);
            }
            if (!this.setupCalculation()) {
                return;
            }
            this.q.createCube();
            this.jvxlData.integration = this.q.getIntegration();
            if (this.mo != null) {
                this.mo.put("integration", this.jvxlData.integration);
            }
        }
    }

    @Override
    public double[] getPlane(int x) {
        if (!this.qSetupDone) {
            this.setupCalculation();
        }
        return this.getPlaneSR(x);
    }

    private boolean setupCalculation() {
        this.qSetupDone = true;
        switch (this.params.qmOrbitalType) {
            case 5: {
                break;
            }
            case 1: 
            case 2: {
                return ((MOCalculation)this.q).setupCalculation(this.params.moData, this.params.qmOrbitalType == 2, this.volumeData, this.bsMySelected, this.atomData.xyz, this.atomData.atoms, this.atomData.firstAtomIndex, this.dfCoefMaps, this.coef, this.linearCombination, this.params.isSquaredLinear, this.coefs, this.points);
            }
            case 3: {
                return ((NciCalculation)this.q).setupCalculation(this.volumeData, this.bsMySelected, this.params.bsSolvent, this.atomData.bsMolecules, this.atomData.atoms, this.atomData.firstAtomIndex, true, this.points, this.params.parameters, this.params.testFlags);
            }
        }
        return false;
    }

    @Override
    protected double getSurfacePointAndFraction(double cutoff, boolean isCutoffAbsolute, double valueA, double valueB, T3d pointA, V3d edgeVector, int x, int y, int z, int vA, int vB, double[] fReturn, T3d ptReturn) {
        double zero = this.getSPF(cutoff, isCutoffAbsolute, valueA, valueB, pointA, edgeVector, x, y, z, vA, vB, fReturn, ptReturn);
        if (this.q != null && !Double.isNaN(zero)) {
            zero = this.q.processPt(ptReturn);
            if (this.params.isSquared) {
                zero *= zero;
            }
        }
        return zero;
    }
}

