/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.util.Map;
import javajs.util.CifDataParser;
import javajs.util.Lst;
import javajs.util.SB;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;

class CifsfReader
extends VolumeFileReader {
    int h0;
    int k0;
    int l0;
    int nh;
    int nk;
    int nl;
    int vpt = 0;

    CifsfReader() {
    }

    @Override
    void init2(SurfaceGenerator sg, BufferedReader br) {
        this.readCIFData(br);
        this.init2VFR(sg, br);
        this.nSurfaces = 1;
    }

    private void readCIFData(BufferedReader br) {
        CifDataParser parser = new CifDataParser();
        parser.set(null, br, false);
        Map<String, Object> map = parser.getAllCifDataType("_refln", "_diffrn");
        this.processMap(map);
    }

    private void processMap(Map<String, Object> map) {
        Lst models = (Lst)map.get("models");
        if (models.size() == 0) {
            return;
        }
        Map model = (Map)models.get(0);
        this.h0 = (int)CifsfReader.getValue(model.get("_diffrn_reflns_limit_h_min"));
        this.k0 = (int)CifsfReader.getValue(model.get("_diffrn_reflns_limit_k_min"));
        this.l0 = (int)CifsfReader.getValue(model.get("_diffrn_reflns_limit_l_min"));
        this.nh = (int)(CifsfReader.getValue(model.get("_diffrn_reflns_limit_h_max")) - (double)this.h0 + 1.0);
        this.nk = (int)(CifsfReader.getValue(model.get("_diffrn_reflns_limit_k_max")) - (double)this.k0 + 1.0);
        this.nl = (int)(CifsfReader.getValue(model.get("_diffrn_reflns_limit_l_max")) - (double)this.l0 + 1.0);
        this.jvxlFileHeaderBuffer = new SB();
        this.jvxlFileHeaderBuffer.append("CIF structure factor data\n");
        this.jvxlFileHeaderBuffer.append("\n");
        this.volumetricOrigin.set(this.h0, this.k0, this.l0);
        this.voxelCounts[0] = this.nh;
        this.voxelCounts[1] = this.nk;
        this.voxelCounts[2] = this.nl;
        this.volumetricVectors[0].set(this.nh - 1, 0.0, 0.0);
        this.volumetricVectors[1].set(0.0, this.nk - 1, 0.0);
        this.volumetricVectors[2].set(0.0, 0.0, this.nl - 1);
        this.jvxlFileHeaderBuffer.append(this.nh + " 0 0 " + (this.nh - 1) + "\n");
        this.jvxlFileHeaderBuffer.append(this.nk + " 0 0 " + (this.nk - 1) + "\n");
        this.jvxlFileHeaderBuffer.append(this.nl + " 0 0 " + (this.nl - 1) + "\n");
        this.voxelData = new double[this.nh][this.nk][this.nl];
        double[] hdata = this.getValueArray(model, "_refln_index_h");
        double[] kdata = this.getValueArray(model, "_refln_index_k");
        double[] ldata = this.getValueArray(model, "_refln_index_l");
        double[] m1data = this.getValueArray(model, "_refln_index_m1");
        double[] value = this.getValueArray(model, "_refln_F_squared_meas");
        if (m1data == null) {
            for (int i = 0; i < hdata.length; ++i) {
                this.voxelData[(int)hdata[i]][(int)kdata[i]][(int)ldata[i]] = value[i];
            }
        } else {
            for (int i = 0; i < m1data.length; ++i) {
                if (m1data[i] != 0.0) continue;
                this.voxelData[(int)hdata[i]][(int)kdata[i]][(int)ldata[i]] = value[i];
            }
        }
        System.out.println("OK");
    }

    private double[] getValueArray(Map<String, Object> model, String key) {
        Lst data = (Lst)model.get(key);
        if (data == null) {
            return null;
        }
        double[] d = new double[data.size()];
        int i = data.size();
        while (--i >= 0) {
            d[i] = ((Number)data.get(i)).doubleValue();
        }
        return d;
    }

    private static double getValue(Object v) {
        return v == null ? Double.NaN : ((Number)v).doubleValue();
    }

    @Override
    protected void readParameters() throws Exception {
    }

    @Override
    protected double nextVoxel() throws Exception {
        int l = this.vpt % this.nl;
        int k = (this.vpt - l) / this.nl % (this.nk * this.nl);
        return 0.0;
    }
}

