/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.calc;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.P3d;
import javajs.util.P4d;
import org.jmol.jvxl.api.VertexDataServer;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.util.Logger;

public class MarchingSquares {
    public static final int CONTOUR_POINT = -1;
    public static final int VERTEX_POINT = -2;
    public static final int EDGE_POINT = -3;
    VertexDataServer surfaceReader;
    VolumeData volumeData;
    private static final int nContourMax = 100;
    public static final int defaultContourCount = 9;
    private int nContourSegments;
    public int contourType;
    int thisContour = 0;
    private double valueMin;
    private double valueMax;
    final P3d pointA = new P3d();
    final P3d pointB = new P3d();
    private boolean contourFromZero = true;
    private double[] contoursDiscrete;
    public int contourVertexCount;
    ContourVertex[] contourVertexes = new ContourVertex[1000];
    double contourPlaneMinimumValue;
    double contourPlaneMaximumValue;
    public double[] contourValuesUsed;
    final P3d ptTemp = new P3d();
    private int triangleCount = 0;
    private Triangle[] triangles = new Triangle[1000];
    Map<String, Integer> htPts = new Hashtable<String, Integer>();

    public MarchingSquares(VertexDataServer surfaceReader, VolumeData volumeData, P4d thePlane, double[] contoursDiscrete, int nContours, int thisContour, boolean contourFromZero) {
        this.surfaceReader = surfaceReader;
        this.volumeData = volumeData;
        this.thisContour = thisContour;
        this.contoursDiscrete = contoursDiscrete;
        this.contourFromZero = contourFromZero;
        if (contoursDiscrete == null) {
            int i = 0;
            this.nContourSegments = (nContours == 0 ? 9 : nContours) + i;
            if (this.nContourSegments > 100) {
                this.nContourSegments = 100;
            }
        } else {
            this.nContourSegments = nContours = contoursDiscrete.length;
            this.contourFromZero = false;
        }
    }

    public void setMinMax(double valueMin, double valueMax) {
        this.valueMin = valueMin;
        this.valueMax = valueMax;
    }

    public int addContourVertex(P3d vertexXYZ, double value) {
        if (this.contourVertexCount == this.contourVertexes.length) {
            this.contourVertexes = (ContourVertex[])AU.doubleLength(this.contourVertexes);
        }
        int vPt = this.surfaceReader.addVertexCopy(vertexXYZ, value, -2, true);
        this.contourVertexes[this.contourVertexCount++] = new ContourVertex(vertexXYZ);
        return vPt;
    }

    public void setContourData(int i, double value) {
        this.contourVertexes[i].setValue(value);
    }

    double calcContourPoint(double cutoff, double valueA, double valueB, P3d pt) {
        return this.volumeData.calculateFractionalPoint(cutoff, this.pointA, this.pointB, valueA, valueB, pt);
    }

    public int addTriangle(int iA, int iB, int iC, int check, int iContour) {
        if (this.triangleCount == this.triangles.length) {
            this.triangles = (Triangle[])AU.doubleLength(this.triangles);
        }
        this.triangles[this.triangleCount++] = new Triangle(iA, iB, iC, check, iContour);
        return 0;
    }

    public int generateContourData(boolean haveData, double zeroOffset) {
        Logger.info("generateContours: " + this.nContourSegments + " segments");
        this.getVertexValues(haveData);
        this.createContours(this.valueMin, this.valueMax, zeroOffset);
        this.addAllTriangles();
        return this.contourVertexCount;
    }

    private void getVertexValues(boolean haveData) {
        this.contourPlaneMinimumValue = Double.MAX_VALUE;
        this.contourPlaneMaximumValue = -1.7976931348623157E308;
        for (int i = 0; i < this.contourVertexCount; ++i) {
            double value;
            ContourVertex c = this.contourVertexes[i];
            if (haveData) {
                value = c.value;
            } else {
                value = this.volumeData.lookupInterpolatedVoxelValue(c, false);
                c.setValue(value);
            }
            if (value < this.contourPlaneMinimumValue) {
                this.contourPlaneMinimumValue = value;
            }
            if (!(value > this.contourPlaneMaximumValue)) continue;
            this.contourPlaneMaximumValue = value;
        }
    }

    private boolean createContours(double min, double max, double zeroOffset) {
        double minCutoff;
        double diff = max - min;
        this.contourValuesUsed = new double[this.nContourSegments];
        int i = this.triangleCount;
        while (--i >= 0) {
            this.triangles[i].check = 0;
        }
        double cutoff = minCutoff = -1.7976931348623157E308;
        for (int i2 = 0; i2 < this.nContourSegments; ++i2) {
            double d = this.contoursDiscrete != null ? this.contoursDiscrete[i2] : (this.contourFromZero ? min + (double)i2 * 1.0 / (double)this.nContourSegments * diff : (i2 == 0 ? -1.7976931348623157E308 : (cutoff = i2 == this.nContourSegments - 1 ? Double.MAX_VALUE : min + (double)(i2 - 1) * 1.0 / (double)(this.nContourSegments - 1) * diff)));
            if (this.contoursDiscrete == null && Math.abs(cutoff) < zeroOffset) {
                cutoff = cutoff < 0.0 ? -zeroOffset : zeroOffset;
            }
            this.contourValuesUsed[i2] = cutoff;
            Logger.info("#contour " + (i2 + 1) + " " + cutoff + " " + this.triangleCount);
            this.htPts.clear();
            int ii = this.triangleCount;
            while (--ii >= 0) {
                if (!this.triangles[ii].isValid) continue;
                this.checkContour(this.triangles[ii], i2, cutoff);
            }
            if (this.thisContour <= 0 || i2 + 1 != this.thisContour) continue;
            minCutoff = cutoff;
        }
        if (this.contoursDiscrete != null) {
            minCutoff = this.contoursDiscrete[0];
        }
        this.valueMin = this.contourValuesUsed[0];
        this.valueMax = this.contourValuesUsed.length == 0 ? this.valueMin : this.contourValuesUsed[this.contourValuesUsed.length - 1];
        return true;
    }

    private int intercept(Triangle t, int i, double value) {
        double f;
        String key;
        int iA = t.pts[i];
        int iB = t.pts[(i + 1) % 3];
        if (iA == Integer.MAX_VALUE || iB == Integer.MAX_VALUE) {
            return -1;
        }
        String string = key = iA < iB ? iA + "_" + iB : iB + "_" + iA;
        if (this.htPts.containsKey(key)) {
            return this.htPts.get(key);
        }
        double valueA = this.contourVertexes[iA].value;
        double valueB = this.contourVertexes[iB].value;
        int iPt = -1;
        if (valueA != valueB && (f = (value - valueA) / (valueB - valueA)) >= 0.0 && f <= 1.0) {
            this.pointA.setT(this.contourVertexes[iA]);
            this.pointB.setT(this.contourVertexes[iB]);
            value = this.calcContourPoint(value, valueA, valueB, this.ptTemp);
            if (!Double.isNaN(value)) {
                iPt = this.addContourVertex(this.ptTemp, value);
                if (iPt < 0) {
                    return -1;
                }
                this.contourVertexes[iPt].setValue(value);
            }
        }
        this.htPts.put(key, iPt);
        return iPt;
    }

    private void checkContour(Triangle t, int i, double value) {
        if (this.thisContour > 0 && i + 1 != this.thisContour) {
            return;
        }
        int ipt0 = this.intercept(t, 0, value);
        int ipt1 = this.intercept(t, 1, value);
        int ipt2 = this.intercept(t, 2, value);
        int[] pts = t.pts;
        int mode = 0;
        if (ipt0 >= 0) {
            ++mode;
        }
        if (ipt1 >= 0) {
            mode += 2;
        }
        if (ipt2 >= 0) {
            mode += 4;
        }
        switch (mode) {
            case 3: {
                this.addTriangle(pts[0], ipt0, ipt1, 2 | t.check & 1, i);
                this.addTriangle(ipt0, pts[1], ipt1, 4 | t.check & 3, i);
                this.addTriangle(pts[0], ipt1, pts[2], t.check & 6, i);
                break;
            }
            case 5: {
                this.addTriangle(pts[0], ipt0, ipt2, 2 | t.check & 5, i);
                this.addTriangle(ipt0, pts[1], ipt2, 4 | t.check & 1, i);
                this.addTriangle(ipt2, pts[1], pts[2], t.check & 6, i);
                break;
            }
            case 6: {
                this.addTriangle(pts[0], pts[1], ipt2, t.check & 5, i);
                this.addTriangle(ipt2, pts[1], ipt1, 4 | t.check & 2, i);
                this.addTriangle(ipt2, ipt1, pts[2], 1 | t.check & 6, i);
                break;
            }
            default: {
                return;
            }
        }
        t.isValid = false;
    }

    public double[] getMinMax() {
        return new double[]{this.valueMin, this.valueMax};
    }

    private void addAllTriangles() {
        for (int i = 0; i < this.triangleCount; ++i) {
            if (!this.triangles[i].isValid) continue;
            Triangle t = this.triangles[i];
            this.surfaceReader.addTriangleCheck(t.pts[0], t.pts[1], t.pts[2], t.check, t.contourIndex, false, -1);
        }
    }

    private class Triangle {
        protected int[] pts;
        protected int check;
        protected boolean isValid = true;
        protected int contourIndex;

        Triangle(int iA, int iB, int iC, int check, int contourIndex) {
            this.pts = new int[]{iA, iB, iC};
            this.check = check;
            this.contourIndex = contourIndex;
        }
    }

    private class ContourVertex
    extends P3d {
        double value;

        ContourVertex(P3d vertexXYZ) {
            this.setT(vertexXYZ);
        }

        void setValue(double value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value + " " + this.x + " " + this.y + " " + this.z;
        }
    }
}

