/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Map;
import javajs.util.M3d;
import javajs.util.M4d;
import javajs.util.P3d;
import javajs.util.T3d;
import org.jmol.export.___Exporter;
import org.jmol.modelset.Atom;
import org.jmol.util.GData;
import org.jmol.viewer.Viewer;

abstract class __RayTracerExporter
extends ___Exporter {
    protected boolean isSlabEnabled;
    protected int minScreenDimension;
    protected boolean wasPerspective;

    public __RayTracerExporter() {
        this.exportType = 2;
        this.lineWidthMad = (short)2;
    }

    @Override
    protected boolean initOutput(Viewer vwr, double privateKey, GData g3d, Map<String, Object> params) {
        this.wasPerspective = vwr.tm.perspectiveDepth;
        if (super.initOutput(vwr, privateKey, g3d, params)) {
            vwr.tm.perspectiveDepth = false;
            if (this.wasPerspective) {
                vwr.shm.finalizeAtoms(null, false);
            }
            return true;
        }
        return false;
    }

    @Override
    protected String finalizeOutput2() {
        this.vwr.tm.perspectiveDepth = this.wasPerspective;
        return super.finalizeOutput2();
    }

    @Override
    protected void outputVertex(T3d pt, T3d offset) {
        __RayTracerExporter.setTempVertex(pt, offset, this.tempP1);
        this.tm.transformPt3f(this.tempP1, this.tempP1);
        this.output(this.tempP1);
    }

    protected abstract void outputCircle(int var1, int var2, int var3, double var4, short var6, boolean var7);

    protected abstract void outputCylinder(P3d var1, P3d var2, double var3, short var5, boolean var6);

    protected abstract void outputCylinderConical(P3d var1, P3d var2, double var3, double var5, short var7);

    protected abstract void outputEllipsoid(P3d var1, double var2, double[] var4, short var5);

    protected abstract void outputSphere(double var1, double var3, double var5, double var7, short var9);

    protected abstract void outputTextPixel(int var1, int var2, int var3, int var4);

    protected abstract void outputTriangle(T3d var1, T3d var2, T3d var3, short var4);

    protected abstract void outputCone(P3d var1, P3d var2, double var3, short var5, boolean var6);

    protected P3d getScreenNormal(T3d pt, T3d normal, double factor) {
        if (Double.isNaN(normal.x)) {
            this.tempP3.set(0.0, 0.0, 0.0);
            return this.tempP3;
        }
        this.tempP1.add2(pt, normal);
        this.tm.transformPt3f(pt, this.tempP2);
        this.tm.transformPt3f(this.tempP1, this.tempP3);
        this.tempP3.sub(this.tempP2);
        this.tempP3.scale(factor);
        return this.tempP3;
    }

    protected void initVars() {
        this.isSlabEnabled = this.tm.slabEnabled;
        this.minScreenDimension = Math.min(this.screenWidth, this.screenHeight);
    }

    @Override
    void drawAtom(Atom atom, double radius) {
        this.outputSphere(atom.sX, atom.sY, atom.sZ, (double)atom.sD / 2.0, atom.colixAtom);
    }

    @Override
    void drawCircle(int x, int y, int z, int diameter, short colix, boolean doFill) {
        double radius = (double)diameter / 2.0;
        this.outputCircle(x, y, z, radius, colix, doFill);
    }

    @Override
    boolean drawEllipse(P3d ptAtom, P3d ptX, P3d ptY, short colix, boolean doFill) {
        return false;
    }

    @Override
    void drawPixel(short colix, int x, int y, int z, int scale) {
        this.outputSphere(x, y, z, 0.75 * (double)scale, colix);
    }

    @Override
    void drawTextPixel(int argb, int x, int y, int z) {
        this.outputTextPixel(x, y, this.fixScreenZ(z), argb);
    }

    @Override
    void fillConeScreen(short colix, byte endcap, int screenDiameter, P3d screenBase, P3d screenTip, boolean isBarb) {
        this.outputCone(screenBase, screenTip, (double)screenDiameter / 2.0, colix, isBarb);
    }

    @Override
    void drawCylinder(P3d screenA, P3d screenB, short colix1, short colix2, byte endcaps, int madBond, int bondOrder) {
        if (colix1 == colix2) {
            this.fillConicalCylinder(screenA, screenB, madBond, colix1, endcaps);
        } else {
            this.tempV2.ave(screenB, screenA);
            this.tempP1.setT(this.tempV2);
            this.fillConicalCylinder(screenA, this.tempP1, madBond, colix1, endcaps);
            this.fillConicalCylinder(this.tempP1, screenB, madBond, colix2, endcaps);
        }
        if (endcaps != 3) {
            return;
        }
        double radius = this.vwr.tm.scaleToScreen((int)screenA.z, madBond) / 2.0;
        if (radius <= 1.0) {
            return;
        }
        this.outputSphere(screenA.x, screenA.y, screenA.z, radius, colix1);
        radius = this.vwr.tm.scaleToScreen((int)screenB.z, madBond) / 2.0;
        if (radius <= 1.0) {
            return;
        }
        this.outputSphere(screenB.x, screenB.y, screenB.z, radius, colix2);
    }

    protected void fillConicalCylinder(P3d screenA, P3d screenB, int madBond, short colix, byte endcaps) {
        double radius1 = this.vwr.tm.scaleToScreen((int)screenA.z, madBond) / 2.0;
        if (radius1 == 0.0) {
            return;
        }
        if (radius1 < 1.0) {
            radius1 = 1.0;
        }
        if (screenA.distance(screenB) == 0.0) {
            this.outputSphere(screenA.x, screenA.y, screenA.z, radius1, colix);
            return;
        }
        double radius2 = this.vwr.tm.scaleToScreen((int)screenB.z, madBond) / 2.0;
        if (radius2 == 0.0) {
            return;
        }
        if (radius2 < 1.0) {
            radius2 = 1.0;
        }
        this.outputCylinderConical(screenA, screenB, radius1, radius2, colix);
    }

    @Override
    void fillCylinderScreenMad(short colix, byte endcaps, int diameter, P3d screenA, P3d screenB) {
        if (diameter == 0) {
            return;
        }
        if (diameter < 1) {
            diameter = 1;
        }
        double radius = (double)diameter / 2.0;
        if (screenA.distance(screenB) == 0.0) {
            this.outputSphere(screenA.x, screenA.y, screenA.z, radius, colix);
            return;
        }
        this.outputCylinder(screenA, screenB, radius, colix, endcaps == 2);
        if (endcaps != 3 || radius <= 1.0) {
            return;
        }
        this.outputSphere(screenA.x, screenA.y, screenA.z, radius, colix);
        this.outputSphere(screenB.x, screenB.y, screenB.z, radius, colix);
    }

    @Override
    void fillCylinderScreen(short colix, byte endcaps, int screenDiameter, P3d screenA, P3d screenB, P3d ptA, P3d ptB, double radius) {
        this.fillCylinderScreenMad(colix, endcaps, screenDiameter, screenA, screenB);
    }

    @Override
    void fillSphere(short colix, int diameter, P3d pt) {
        this.outputSphere(pt.x, pt.y, pt.z, (double)diameter / 2.0, colix);
    }

    @Override
    protected void fillTriangle(short colix, T3d ptA, T3d ptB, T3d ptC, boolean twoSided) {
        this.outputTriangle(ptA, ptB, ptC, colix);
    }

    @Override
    void fillEllipsoid(P3d center, P3d[] points, short colix, int x, int y, int z, int diameter, M3d toEllipsoidal, double[] coef, M4d deriv, P3d[] octantPoints) {
        double radius = (double)diameter / 2.0;
        if (radius == 0.0) {
            return;
        }
        if (radius < 1.0) {
            radius = 1.0;
        }
        this.outputEllipsoid(center, radius, coef, colix);
    }
}

