/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Hashtable;
import javajs.util.A4d;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3d;
import javajs.util.M4d;
import javajs.util.P3d;
import javajs.util.T3d;
import org.jmol.export.___Exporter;
import org.jmol.modelset.Atom;
import org.jmol.util.C;
import org.jmol.util.Font;
import org.jmol.util.Logger;

public abstract class __CartesianExporter
extends ___Exporter {
    protected A4d viewpoint = new A4d();
    protected boolean canCapCylinders;
    protected boolean noColor;
    protected M4d sphereMatrix = new M4d();

    public __CartesianExporter() {
        this.exportType = 1;
        this.lineWidthMad = (short)100;
    }

    protected P3d getModelCenter() {
        return this.referenceCenter;
    }

    protected P3d getCameraPosition() {
        P3d ptCamera = new P3d();
        P3d pt = P3d.new3(this.screenWidth / 2, this.screenHeight / 2, 0.0);
        this.tm.unTransformPoint(pt, ptCamera);
        ptCamera.sub(this.center);
        this.tempP3.set(this.screenWidth / 2, this.screenHeight / 2, this.cameraDistance * this.scalePixelsPerAngstrom);
        this.tm.unTransformPoint(this.tempP3, this.tempP3);
        this.tempP3.sub(this.center);
        ptCamera.add(this.tempP3);
        return this.cameraPosition;
    }

    private void setTempPoints(P3d ptA, P3d ptB, boolean isCartesian) {
        if (isCartesian) {
            this.tempP1.setT(ptA);
            this.tempP2.setT(ptB);
        } else {
            this.tm.unTransformPoint(ptA, this.tempP1);
            this.tm.unTransformPoint(ptB, this.tempP2);
        }
    }

    protected int getCoordinateMap(T3d[] vertices, int[] coordMap, BS bsValid) {
        int n = 0;
        for (int i = 0; i < coordMap.length; ++i) {
            if (bsValid != null && !bsValid.get(i) || Double.isNaN(vertices[i].x)) {
                if (bsValid == null) continue;
                bsValid.clear(i);
                continue;
            }
            coordMap[i] = n++;
        }
        return n;
    }

    protected int[] getNormalMap(T3d[] normals, int nNormals, BS bsValid, Lst<String> vNormals) {
        Hashtable<String, Integer> htNormals = new Hashtable<String, Integer>();
        int[] normalMap = new int[nNormals];
        for (int i = 0; i < nNormals; ++i) {
            if (bsValid != null && !bsValid.get(i) || Double.isNaN(normals[i].x)) {
                if (bsValid == null) continue;
                bsValid.clear(i);
                continue;
            }
            String s = this.getTriad(normals[i]) + "\n";
            if (htNormals.containsKey(s)) {
                normalMap[i] = (Integer)htNormals.get(s);
                continue;
            }
            normalMap[i] = vNormals.size();
            vNormals.addLast(s);
            htNormals.put(s, normalMap[i]);
        }
        return normalMap;
    }

    protected void outputIndices(int[][] indices, int[] map, int nPolygons, BS bsPolygons, int faceVertexMax) {
        int i0;
        boolean isAll = bsPolygons == null;
        int i = i0 = isAll ? nPolygons - 1 : bsPolygons.nextSetBit(0);
        while (i >= 0) {
            this.outputFace(indices[i], map, faceVertexMax);
            i = isAll ? i - 1 : bsPolygons.nextSetBit(i + 1);
        }
    }

    protected abstract void outputFace(int[] var1, int[] var2, int var3);

    protected abstract void outputCircle(P3d var1, P3d var2, double var3, short var5, boolean var6);

    protected abstract void outputCone(P3d var1, P3d var2, double var3, short var5);

    protected abstract boolean outputCylinder(P3d var1, P3d var2, P3d var3, short var4, byte var5, double var6, P3d var8, P3d var9, boolean var10);

    protected abstract void outputEllipsoid(P3d var1, P3d[] var2, short var3);

    protected abstract void outputSphere(P3d var1, double var2, short var4, boolean var5);

    protected abstract void outputTextPixel(P3d var1, int var2);

    protected abstract void outputTriangle(T3d var1, T3d var2, T3d var3, short var4);

    @Override
    void plotText(int x, int y, int z, short colix, String text, Font font3d) {
        this.gdata.plotText(x, y, z, this.gdata.getColorArgbOrGray(colix), 0, text, font3d, this.export3D);
    }

    @Override
    void plotImage(int x, int y, int z, Object image, short bgcolix, int width, int height) {
    }

    @Override
    void drawAtom(Atom atom, double radius) {
        if (Logger.debugging) {
            this.outputComment("atom " + atom);
        }
        short colix = atom.colixAtom;
        this.outputSphere(atom, radius == 0.0 ? (double)atom.madAtom / 2000.0 : radius, colix, C.isColixTranslucent(colix));
    }

    @Override
    void drawCircle(int x, int y, int z, int diameter, short colix, boolean doFill) {
        this.tempP3.set(x, y, z);
        this.tm.unTransformPoint(this.tempP3, this.tempP1);
        double radius = this.vwr.tm.unscaleToScreen(z, diameter) / 2.0;
        this.tempP3.set(x, y, z + 1);
        this.tm.unTransformPoint(this.tempP3, this.tempP3);
        this.outputCircle(this.tempP1, this.tempP3, radius, colix, doFill);
    }

    @Override
    boolean drawEllipse(P3d ptCenter, P3d ptX, P3d ptY, short colix, boolean doFill) {
        this.tempV1.sub2(ptX, ptCenter);
        this.tempV2.sub2(ptY, ptCenter);
        this.tempV2.cross(this.tempV1, this.tempV2);
        this.tempV2.normalize();
        this.tempV2.scale(doFill ? (double)0.002f : 0.005);
        this.tempP1.sub2(ptCenter, this.tempV2);
        this.tempP2.add2(ptCenter, this.tempV2);
        return this.outputCylinder(ptCenter, this.tempP1, this.tempP2, colix, doFill ? (byte)2 : 0, 1.01f, ptX, ptY, true);
    }

    @Override
    void drawPixel(short colix, int x, int y, int z, int scale) {
        this.tempP3.set(x, y, z);
        this.tm.unTransformPoint(this.tempP3, this.tempP1);
        this.outputSphere(this.tempP1, 0.02f * (float)scale, colix, true);
    }

    @Override
    void drawTextPixel(int argb, int x, int y, int z) {
        this.tempP3.set(x, y, z);
        this.tm.unTransformPoint(this.tempP3, this.tempP1);
        this.outputTextPixel(this.tempP1, argb);
    }

    @Override
    void fillConeScreen(short colix, byte endcap, int screenDiameter, P3d screenBase, P3d screenTip, boolean isBarb) {
        this.tm.unTransformPoint(screenBase, this.tempP1);
        this.tm.unTransformPoint(screenTip, this.tempP2);
        double radius = this.vwr.tm.unscaleToScreen(screenBase.z, screenDiameter) / 2.0;
        if (radius < 0.05) {
            radius = 0.05;
        }
        this.outputCone(this.tempP1, this.tempP2, radius, colix);
    }

    @Override
    void drawCylinder(P3d ptA, P3d ptB, short colix1, short colix2, byte endcaps, int mad, int bondOrder) {
        this.setTempPoints(ptA, ptB, bondOrder < 0);
        double radius = (double)mad / 2000.0;
        if (Logger.debugging) {
            this.outputComment("bond " + ptA + " " + ptB);
        }
        if (colix1 == colix2 || this.noColor) {
            this.outputCylinder(null, this.tempP1, this.tempP2, colix1, endcaps, radius, null, null, bondOrder != -1);
        } else {
            this.tempV2.ave(this.tempP2, this.tempP1);
            this.tempP3.setT(this.tempV2);
            if (this.solidOnly && endcaps == 0) {
                endcaps = (byte)2;
            } else if (this.canCapCylinders && endcaps == 3) {
                endcaps = (byte)(this.solidOnly ? 5 : 4);
            }
            this.outputCylinder(null, this.tempP3, this.tempP1, colix1, endcaps == 3 ? (byte)0 : endcaps, radius, null, null, true);
            this.outputCylinder(null, this.tempP3, this.tempP2, colix2, endcaps == 3 ? (byte)0 : endcaps, radius, null, null, true);
            if (endcaps == 3) {
                this.outputSphere(this.tempP1, radius * (double)1.01f, colix1, bondOrder != -2);
                this.outputSphere(this.tempP2, radius * (double)1.01f, colix2, bondOrder != -2);
            }
        }
    }

    @Override
    void fillCylinderScreenMad(short colix, byte endcaps, int mad, P3d screenA, P3d screenB) {
        double radius = (double)mad / 2000.0;
        this.setTempPoints(screenA, screenB, false);
        this.outputCylinder(null, this.tempP1, this.tempP2, colix, endcaps, radius, null, null, true);
    }

    @Override
    void fillCylinderScreen(short colix, byte endcaps, int screenDiameter, P3d screenA, P3d screenB, P3d ptA, P3d ptB, double radius) {
        if (ptA != null) {
            this.drawCylinder(ptA, ptB, colix, colix, endcaps, (int)Math.round(radius * 2000.0), -1);
            return;
        }
        int mad = screenDiameter < 0 ? -screenDiameter * 10 : (int)Math.round(this.vwr.tm.unscaleToScreen((screenA.z + screenB.z) / 2.0, screenDiameter)) * 1000;
        this.fillCylinderScreenMad(colix, endcaps, mad, screenA, screenB);
    }

    @Override
    void fillEllipsoid(P3d center, P3d[] points, short colix, int x, int y, int z, int diameter, M3d toEllipsoidal, double[] coef, M4d deriv, P3d[] octantPoints) {
        this.outputEllipsoid(center, points, colix);
    }

    @Override
    void fillSphere(short colix, int diameter, P3d pt) {
        this.tm.unTransformPoint(pt, this.tempP1);
        this.outputSphere(this.tempP1, this.vwr.tm.unscaleToScreen(pt.z, diameter) / 2.0, colix, true);
    }

    @Override
    protected void fillTriangle(short colix, T3d ptA, T3d ptB, T3d ptC, boolean twoSided) {
        this.tm.unTransformPoint(ptA, this.tempP1);
        this.tm.unTransformPoint(ptB, this.tempP2);
        this.tm.unTransformPoint(ptC, this.tempP3);
        if (this.solidOnly) {
            this.outputSolidPlate(this.tempP1, this.tempP2, this.tempP3, colix);
        } else {
            this.outputTriangle(this.tempP1, this.tempP2, this.tempP3, colix);
            if (twoSided) {
                this.outputTriangle(this.tempP1, this.tempP3, this.tempP2, colix);
            }
        }
    }

    protected void outputSolidPlate(P3d tempP1, P3d tempP2, P3d tempP3, short colix) {
    }

    protected void setSphereMatrix(T3d center, double rx, double ry, double rz, A4d a, M4d sphereMatrix) {
        if (a != null) {
            M3d m = new M3d();
            m.m00 = rx;
            m.m11 = ry;
            m.m22 = rz;
            M3d mq = new M3d().setAA(a);
            mq.mul(m);
            sphereMatrix.setToM3(mq);
        } else {
            sphereMatrix.setIdentity();
            sphereMatrix.m00 = rx;
            sphereMatrix.m11 = ry;
            sphereMatrix.m22 = rz;
        }
        sphereMatrix.m03 = center.x;
        sphereMatrix.m13 = center.y;
        sphereMatrix.m23 = center.z;
        sphereMatrix.m33 = 1.0;
    }
}

