/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.writers;

import javajs.util.BS;
import javajs.util.OC;
import javajs.util.P3d;
import javajs.util.PT;
import org.jmol.api.JmolWriter;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.Atom;
import org.jmol.viewer.Viewer;

public class XSFWriter
implements JmolWriter {
    private Viewer vwr;
    private OC oc;
    private SymmetryInterface uc;
    private int len;

    @Override
    public void set(Viewer viewer, OC oc, Object[] data) {
        this.vwr = viewer;
        this.oc = oc == null ? this.vwr.getOutputChannel(null, null) : oc;
    }

    @Override
    public String write(BS bs) {
        if (bs == null) {
            bs = this.vwr.bsA();
        }
        this.len = bs.length();
        if (this.len == 0) {
            return "";
        }
        try {
            boolean isAnim;
            Atom[] a = this.vwr.ms.at;
            int i0 = bs.nextSetBit(0);
            this.uc = this.vwr.ms.getUnitCellForAtom(i0);
            int model1 = a[i0].getModelIndex();
            int model2 = a[this.len - 1].getModelIndex();
            boolean bl = isAnim = model2 != model1;
            if (isAnim) {
                int nModels = this.vwr.ms.getModelBS(bs, false).cardinality();
                this.oc.append("ANIMSTEPS " + nModels + "\n");
            }
            if (this.uc != null) {
                this.oc.append("CRYSTAL\n");
            }
            String f = "%4i%18.12p%18.12p%18.12p\n";
            String prefix = this.uc == null ? "ATOMS" : "PRIMCOORD";
            int lastmi = -1;
            int imodel = 0;
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                Atom atom = a[i];
                int mi = atom.getModelIndex();
                if (mi != lastmi) {
                    String sn = isAnim ? " " + ++imodel : "";
                    String header = prefix + sn + "\n";
                    this.uc = this.vwr.ms.getUnitCellForAtom(i);
                    if (this.uc == null) {
                        this.oc.append(header);
                    } else {
                        this.writeLattice(sn);
                        this.oc.append(header);
                        BS bsm = this.vwr.restrictToModel(bs, mi);
                        this.oc.append(PT.formatStringI("%6i 1\n", "i", bsm.cardinality()));
                    }
                    lastmi = mi;
                }
                this.oc.append(PT.sprintf(f, "ip", new Object[]{atom.getElementNumber(), atom}));
                i = bs.nextSetBit(i + 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.toString();
    }

    private void writeLattice(String sn) {
        P3d[] abc = this.uc.getUnitCellVectors();
        String f = "%18.10p%18.10p%18.10p\n";
        String s = PT.sprintf(f, "p", new Object[]{abc[1]}) + PT.sprintf(f, "p", new Object[]{abc[2]}) + PT.sprintf(f, "p", new Object[]{abc[3]});
        this.oc.append("PRIMVEC" + sn + "\n").append(s).append("CONVVEC" + sn + "\n").append(s);
    }

    public String toString() {
        return this.oc == null ? "" : this.oc.toString();
    }
}

