/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;

public class XmlArgusReader
extends XmlReader {
    private static String[] keepCharsList = new String[]{"name", "x", "y", "z", "formalchg", "atomkey", "atsym", "e00", "e01", "e02", "e03", "e10", "e11", "e12", "e13", "e20", "e21", "e22", "e23", "e30", "e31", "e32", "e33"};
    private String atomName1;
    private String atomName2;
    private int bondOrder;
    private int elementContext;
    private static final int UNSET = 0;
    private static final int MOLECULE = 1;
    private static final int ATOM = 2;
    private static final int BOND = 3;
    private static final int TRANSFORMMAT = 4;
    private double[] trans;
    private int ptTrans;

    @Override
    public void processStartElement(String localName, String nodeName) {
        int i = keepCharsList.length;
        while (--i >= 0) {
            if (!keepCharsList[i].equals(localName)) continue;
            this.setKeepChars(true);
            break;
        }
        if ("molecule".equals(localName)) {
            this.asc.newAtomSet();
            return;
        }
        if ("atom".equals(localName)) {
            this.elementContext = 2;
            this.atom = new Atom();
            return;
        }
        if ("bond".equals(localName)) {
            this.elementContext = 3;
            this.atomName1 = null;
            this.atomName2 = null;
            this.bondOrder = this.parseBondToken((String)this.atts.get("order"));
            return;
        }
        if ("transformmat".equals(localName)) {
            this.elementContext = 4;
            this.trans = new double[16];
            return;
        }
    }

    private int parseBondToken(String str) {
        double floatOrder = this.parseDoubleStr(str);
        if (Double.isNaN(floatOrder) && str.length() >= 1) {
            str = str.toUpperCase();
            switch (str.charAt(0)) {
                case 'S': {
                    return 1;
                }
                case 'D': {
                    return 2;
                }
                case 'T': {
                    return 3;
                }
                case 'A': {
                    return 515;
                }
            }
            return this.parseIntStr(str);
        }
        if (floatOrder == 1.5) {
            return 515;
        }
        if (floatOrder == 2.0) {
            return 2;
        }
        if (floatOrder == 3.0) {
            return 3;
        }
        return 1;
    }

    @Override
    void processEndElement(String localName) {
        int n = this.chars.length();
        if (n > 0 && this.chars.charAt(n - 1) == '\n') {
            this.chars.setLength(n - 1);
        }
        if ("molecule".equals(localName)) {
            this.elementContext = 0;
            return;
        }
        if ("atom".equals(localName)) {
            if (this.atom.elementSymbol != null && !Double.isNaN(this.atom.z)) {
                this.parent.setAtomCoord(this.atom);
                this.asc.addAtomWithMappedName(this.atom);
            }
            this.atom = null;
            this.elementContext = 0;
            return;
        }
        if ("bond".equals(localName)) {
            if (this.atomName2 != null) {
                this.asc.addNewBondFromNames(this.atomName1, this.atomName2, this.bondOrder);
            }
            this.elementContext = 0;
            return;
        }
        if ("transformmat".equals(localName)) {
            this.elementContext = 0;
            this.parent.setTransform(this.trans[0], this.trans[1], this.trans[2], this.trans[4], this.trans[5], this.trans[6], this.trans[8], this.trans[9], this.trans[10]);
            return;
        }
        if (this.elementContext == 1) {
            if ("name".equals(localName)) {
                this.asc.setAtomSetName(this.chars.toString());
                this.setKeepChars(false);
            }
            return;
        }
        if (this.atom != null && this.elementContext == 2) {
            if ("x".equals(localName)) {
                this.atom.x = this.parseDoubleStr(this.chars.toString());
            } else {
                if ("y".equals(localName)) {
                    this.atom.y = this.parseDoubleStr(this.chars.toString());
                    return;
                }
                if ("z".equals(localName)) {
                    this.atom.z = this.parseDoubleStr(this.chars.toString());
                    return;
                }
                if ("atsym".equals(localName)) {
                    this.atom.elementSymbol = this.chars.toString();
                    return;
                }
                if ("formalchg".equals(localName)) {
                    this.atom.formalCharge = this.parseIntStr(this.chars.toString());
                } else if ("atomkey".equals(localName)) {
                    this.atom.atomName = this.chars.toString();
                }
            }
            this.setKeepChars(false);
            return;
        }
        if (this.elementContext == 3) {
            if ("atomkey".equals(localName)) {
                if (this.atomName1 == null) {
                    this.atomName1 = this.chars.toString();
                } else {
                    this.atomName2 = this.chars.toString();
                }
                this.setKeepChars(false);
            }
            return;
        }
        if (this.elementContext == 4) {
            this.trans[this.ptTrans++] = this.parseDoubleStr(this.chars.toString());
            this.setKeepChars(false);
            return;
        }
    }
}

