/*
 * Decompiled with CFR 0.152.
 */
package org.iupac.fairdata.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.iupac.fairdata.util.IFDDefaultJSONSerializer;

public class ZipUtil {
    private static byte[] b264;

    public static boolean isGzipS(InputStream is) {
        return ZipUtil.isGzipB(ZipUtil.getMagic(is, 2));
    }

    public static boolean isGzipB(byte[] bytes) {
        return bytes != null && bytes.length >= 2 && (bytes[0] & 0xFF) == 31 && (bytes[1] & 0xFF) == 139;
    }

    public static boolean isTar(BufferedInputStream bis) {
        byte[] bytes = ZipUtil.getMagic(bis, 264);
        return bytes[0] != 0 && (bytes[257] & 0xFF) == 117 && (bytes[258] & 0xFF) == 115 && (bytes[259] & 0xFF) == 116 && (bytes[260] & 0xFF) == 97 && (bytes[261] & 0xFF) == 114;
    }

    public static boolean isZipS(InputStream is) {
        return ZipUtil.isZipB(ZipUtil.getMagic(is, 4));
    }

    public static boolean isZipB(byte[] bytes) {
        return bytes.length >= 4 && bytes[0] == 80 && bytes[1] == 75 && bytes[2] == 3 && bytes[3] == 4;
    }

    public static byte[] getMagic(InputStream is, int n) {
        byte[] byArray;
        if (n > 264) {
            byArray = new byte[n];
        } else if (b264 == null) {
            b264 = new byte[264];
            byArray = b264;
        } else {
            byArray = b264;
        }
        byte[] abMagic = byArray;
        try {
            is.mark(n + 1);
            int i = is.read(abMagic, 0, n);
            if (i < n) {
                abMagic[257] = 0;
                abMagic[0] = 0;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            is.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return abMagic;
    }

    public static TarArchiveInputStream newTarGZInputStream(InputStream is) throws IOException {
        return new TarArchiveInputStream(new GZIPInputStream(is, 512));
    }

    public static TarArchiveInputStream newTarInputStream(InputStream is) throws IOException {
        return new TarArchiveInputStream(is);
    }

    public static String getBase64(byte[] bytes) {
        long nBytes = bytes.length;
        StringBuffer sout = new StringBuffer();
        if (nBytes == 0L) {
            return sout.toString();
        }
        int i = 0;
        int nPad = 0;
        while ((long)i < nBytes && nPad == 0) {
            if (i % 75 == 0 && i != 0) {
                sout.append("\r\n");
            }
            nPad = (long)(i + 2) == nBytes ? 1 : ((long)(i + 1) == nBytes ? 2 : 0);
            int outbytes = bytes[i++] << 16 & 0xFF0000 | (nPad == 2 ? 0 : bytes[i++] << 8) & 0xFF00 | (nPad >= 1 ? 0 : bytes[i++]) & 0xFF;
            sout.append(IFDDefaultJSONSerializer.Base64.base64.charAt(outbytes >> 18 & 0x3F));
            sout.append(IFDDefaultJSONSerializer.Base64.base64.charAt(outbytes >> 12 & 0x3F));
            sout.append(nPad == 2 ? (char)'=' : IFDDefaultJSONSerializer.Base64.base64.charAt(outbytes >> 6 & 0x3F));
            sout.append(nPad >= 1 ? (char)'=' : IFDDefaultJSONSerializer.Base64.base64.charAt(outbytes & 0x3F));
        }
        return sout.toString();
    }

    public static byte[] decodeBase64(String strBase64) {
        int ch;
        char[] chars64;
        int len64;
        int nBytes = 0;
        int pt0 = strBase64.indexOf(";base64,") + 1;
        if (pt0 > 0) {
            pt0 += 7;
        }
        if ((len64 = (chars64 = strBase64.toCharArray()).length) == 0) {
            return new byte[0];
        }
        int i = len64;
        while (--i >= pt0) {
            ch = chars64[i] & 0x7F;
            nBytes += ch == 65 || IFDDefaultJSONSerializer.Base64.decode64[ch] > 0 ? 3 : 0;
        }
        byte[] bytes = new byte[nBytes >>= 2];
        int offset = 18;
        int pt = 0;
        int b = 0;
        for (int i2 = pt0; i2 < len64; ++i2) {
            ch = chars64[i2] & 0x7F;
            if (IFDDefaultJSONSerializer.Base64.decode64[ch] <= 0 && ch != 65 && ch != 61) continue;
            b |= IFDDefaultJSONSerializer.Base64.decode64[ch] << offset;
            if ((offset -= 6) >= 0) continue;
            bytes[pt++] = (byte)((b & 0xFF0000) >> 16);
            if (pt < nBytes) {
                bytes[pt++] = (byte)((b & 0xFF00) >> 8);
            }
            if (pt < nBytes) {
                bytes[pt++] = (byte)(b & 0xFF);
            }
            offset = 18;
            b = 0;
        }
        return bytes;
    }
}

