/*
 * Decompiled with CFR 0.152.
 */
package org.iupac.fairdata.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.iupac.fairdata.api.IFDSerializableI;
import org.iupac.fairdata.api.IFDSerializerI;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecUtilities;
import org.iupac.fairdata.core.IFDCollection;
import org.iupac.fairdata.core.IFDObject;
import org.iupac.fairdata.util.ZipUtil;

public class IFDDefaultJSONSerializer
implements IFDSerializerI {
    private boolean byID;
    private Obj thisObj;
    private List<Obj> stack = new ArrayList<Obj>();

    public IFDDefaultJSONSerializer(boolean byID) {
        this.byID = byID;
    }

    @Override
    public void setByID(boolean tf) {
        this.byID = tf;
    }

    @Override
    public boolean isByID() {
        return this.byID;
    }

    @Override
    public String serialize(IFDSerializableI obj) {
        this.openObject();
        obj.serialize(this);
        return this.closeObject();
    }

    @Override
    public void openObject() {
        this.thisObj = new Obj();
        this.stack.add(this.thisObj);
    }

    @Override
    public void addAttr(String key, String val) {
        if (val != null) {
            this.thisObj.append(key, val);
        }
    }

    @Override
    public void addAttrInt(String key, long ival) {
        this.thisObj.appendNoEsc(key, "" + ival);
    }

    @Override
    public void addAttrBoolean(String key, boolean val) {
        this.thisObj.appendNoEsc(key, "" + val);
    }

    @Override
    public void addObject(String key, Object o) {
        this.thisObj.appendKey(key);
        this.addValue(o, false, true);
    }

    @Override
    public void addValue(Object val) {
        this.addValue(val, true, true);
    }

    @Override
    public void addCollection(String key, IFDCollection<? extends IFDObject<?>> list, boolean byID) {
        if (!byID) {
            this.addList(key, list);
            return;
        }
        this.thisObj.appendKey(key);
        String sep = "";
        this.thisObj.append("{");
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            this.thisObj.append(sep);
            IFDObject e = (IFDObject)list.get(i);
            key = e.getID();
            this.thisObj.append(FAIRSpecUtilities.esc(key) + ":");
            this.addValue(e, false, true);
            sep = ",\n";
        }
        this.thisObj.append("}");
    }

    @Override
    public void addList(String key, List<?> list) {
        this.thisObj.appendKey(key);
        this.addValue(list, false, false);
    }

    private void addValue(Object val, boolean addKey, boolean allowSerializable) {
        if (allowSerializable && val instanceof IFDSerializableI) {
            val = this.serialize((IFDSerializableI)val);
        } else {
            if (val instanceof List) {
                List list = (List)val;
                String sep = "";
                this.thisObj.append("[");
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    this.thisObj.append(sep);
                    Object v = list.get(i);
                    this.addValue(v, false, true);
                    if (sep != "") continue;
                    sep = v instanceof Number ? "," : ",\n";
                }
                this.thisObj.append("]");
                return;
            }
            if (val instanceof Map) {
                this.thisObj.append("{");
                Map map = (Map)val;
                String sep = "";
                for (Map.Entry e : map.entrySet()) {
                    this.thisObj.append(sep);
                    this.thisObj.append(FAIRSpecUtilities.esc(e.getKey().toString()));
                    this.thisObj.append(":");
                    this.addValue(e.getValue(), false, true);
                    sep = ",\n";
                }
                this.thisObj.append("}");
                return;
            }
            if (val instanceof String) {
                val = FAIRSpecUtilities.esc((String)val);
            } else if (val instanceof byte[]) {
                val = FAIRSpecUtilities.esc(";base64," + ZipUtil.getBase64((byte[])val));
            }
        }
        if (addKey) {
            this.thisObj.appendNoEsc("value", val.toString());
        } else {
            this.thisObj.append(val == null ? null : val.toString());
        }
    }

    @Override
    public String closeObject() {
        int n = this.stack.size();
        this.thisObj = n > 1 ? this.stack.get(n - 2) : null;
        return this.stack.remove(n - 1).close();
    }

    @Override
    public String getFileExt() {
        return "json";
    }

    static class Base64 {
        static String base64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        static int[] decode64 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 0, 62, 0, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 0, 0, 0, 0, 63, 0, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 0, 0, 0, 0, 0};

        Base64() {
        }

        public static byte[] getBytes64(byte[] bytes) {
            return ZipUtil.getBase64(bytes).getBytes();
        }
    }

    protected class Obj {
        private StringBuffer sb = new StringBuffer();

        Obj() {
            this.sb.append("{");
        }

        String close() {
            this.sb.append("}");
            return this.sb.toString();
        }

        public void append(String s) {
            this.sb.append(s);
        }

        public void append(String key, String val) {
            this.appendKey(key).append(FAIRSpecUtilities.esc(val));
        }

        public void appendNoEsc(String key, String val) {
            this.appendKey(key).append(val);
        }

        public StringBuffer appendKey(String key) {
            if (this.sb.length() > 1) {
                this.sb.append(",\n");
            }
            this.sb.append(FAIRSpecUtilities.esc(key)).append(":");
            return this.sb;
        }
    }
}

