/*
 * Decompiled with CFR 0.152.
 */
package org.iupac.fairdata.extract;

import com.actelion.research.chem.SmilesParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.JStructureView;
import com.actelion.research.gui.generic.GenericRectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Base64;
import javax.imageio.ImageIO;
import org.iupac.fairdata.common.IFDConst;
import org.iupac.fairdata.extract.MetadataReceiverI;
import org.iupac.fairdata.extract.PropertyManagerI;
import org.jmol.api.JmolViewer;
import org.jmol.util.DefaultLogger;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class DefaultStructureHelper
implements PropertyManagerI {
    private static final String defaultStructureFilePattern = IFDConst.getProp("IFD_DEFAULT_STRUCTURE_FILE_PATTERN");
    private MetadataReceiverI extractor;
    private Viewer jmolViewer;
    private Map<String, String> fileToType = new HashMap<String, String>();
    private boolean createRepresentation;
    String jmolVersion = null;
    public static final String PNG_FILE_DATA = "_struc.png";
    public static final String MOL_FILE_DATA = "_struc.mol";
    public static final String CDX_FILE_DATA = "_struc.cdx";
    public static final String CDXML_FILE_DATA = "_struc.cdxml";
    public static final String CIF_FILE_DATA = "_struc.cif";
    public static final String CML_FILE_DATA = "_struc.cml";
    public static final String STRUC_FILE_DATA_KEY = "_struc.";
    private static final String SMILES = IFDConst.getProp("IFD_REP_STRUCTURE.SMILES");
    private static final String STANDARD_INCHI = IFDConst.getProp("IFD_REP_STRUCTURE.STANDARD_INCHI");
    private static final String FIXEDH_INCHI = IFDConst.getProp("IFD_REP_STRUCTURE.FIXEDH_INCHI");
    private static final String INCHIKEY = IFDConst.getProp("IFD_PROPERTY_STRUCTURE.INCHIKEY");
    private static final String MOLECULAR_FORMULA = IFDConst.getProp("IFD_PROPERTY_STRUCTURE.MOLECULAR_FORMULA");
    private static final String EMPIRICAL_FORMULA = IFDConst.getProp("IFD_PROPERTY_STRUCTURE.EMPIRICAL_FORMULA");
    private static final String CELL_FORMULA = IFDConst.getProp("IFD_PROPERTY_STRUCTURE.CELL_FORMULA");

    public DefaultStructureHelper(MetadataReceiverI extractor) {
        this.extractor = extractor;
    }

    @Override
    public String getParamRegex() {
        return defaultStructureFilePattern;
    }

    @Override
    public boolean doExtract(String entryName) {
        return true;
    }

    @Override
    public String accept(MetadataReceiverI extractor, String originPath, byte[] bytes) {
        this.extractor = extractor;
        this.createRepresentation = extractor != null;
        return this.processRepresentation(originPath, bytes);
    }

    protected Viewer getJmolViewer() {
        if (this.jmolViewer == null) {
            System.out.println("IFDDefaultStructurePropertyManager initializing Jmol...");
            this.jmolViewer = (Viewer)JmolViewer.allocateViewer(null, null);
            this.jmolVersion = JmolViewer.getJmolVersionNoDate();
            Logger.setLogger(new DefaultLogger(){

                @Override
                protected String log(PrintStream out, int level, String txt, Throwable e) {
                    if (txt != null) {
                        DefaultStructureHelper.this.extractor.log("!Jmol " + txt.trim());
                    }
                    return txt;
                }
            });
        }
        return this.jmolViewer;
    }

    @Override
    public String processRepresentation(String originPath, byte[] bytes) {
        return this.processStructureRepresentation(originPath, bytes, null, null, this.createRepresentation, false);
    }

    public String processStructureRepresentation(String originPath, byte[] bytes, String type, String standardInChI, boolean isEmbedded, boolean returnInChI) {
        if (type == null && (type = this.fileToType.get(originPath)) != null) {
            return returnInChI ? null : type;
        }
        String ext = originPath.substring(originPath.lastIndexOf(46) + 1);
        if (type == null) {
            type = DefaultStructureHelper.getType(ext, bytes, true);
        }
        String smiles = null;
        String fixedhInchi = null;
        String inchiKey = null;
        String molecularFormula = null;
        String cellFormula = null;
        String empiricalFormula = null;
        boolean isCIF = ext.equals("cif");
        boolean isCDXML = !isCIF && ext.equals("cdxml");
        boolean isCDX = !isCIF && ext.equals("cdx");
        boolean isCML = ext.equals("cml");
        String note = null;
        String warning = null;
        if (isCIF || isCDX || isCDXML || isCML || ext.equals("mol") || ext.equals("sdf")) {
            try {
                String data = isCDX ? ";base64," + Base64.getBase64(bytes) : new String(bytes);
                Viewer v = this.getJmolViewer();
                String s = "set allowembeddedscripts false;load DATA \"model\"\n" + data + "\nend \"model\" 1 FILTER 'no3D;noHydrogen'";
                s = v.scriptWait(s);
                int pt = s.indexOf("Warning:");
                warning = pt >= 0 ? s.substring(pt, s.indexOf("\\n", pt)) : null;
                BS atoms = v.bsA();
                if (standardInChI == null) {
                    standardInChI = v.getInchi(atoms, null, null);
                }
                if (standardInChI == null) {
                    this.extractor.log("! InChI could not be created for " + originPath);
                }
                if (isEmbedded) {
                    String stype = isCIF ? CIF_FILE_DATA : (isCDXML ? CDXML_FILE_DATA : (isCDX ? CDX_FILE_DATA : (isCML ? CML_FILE_DATA : MOL_FILE_DATA)));
                    this.extractor.addDeferredPropertyOrRepresentation(stype, DefaultStructureHelper.getDeferredObject(bytes, originPath, type, standardInChI, IFDConst.getMediaTypesForExtension(ext)), false, null, warning, "Helper.procRep");
                    return returnInChI ? standardInChI : stype;
                }
                note = warning == null ? "generated from " + originPath + " by Jmol " + this.jmolVersion : warning;
                boolean is2D = "2D".equals(v.getCurrentModelAuxInfo().get("dimension"));
                if (isCIF) {
                    if (v.getCurrentModelAuxInfo().containsKey("hasBonds")) {
                        v.scriptWait("configuration 1;display selected;set zshade;rotate best;refresh");
                        molecularFormula = v.evaluateExpression("{visible && configuration=1}.find('MF')").toString();
                        bytes = v.getImageAsBytes("png", 500, 500, -1, new String[1]);
                    }
                    v.scriptWait("load DATA \"model\"\n" + data + "\nend \"model\" 1 packed;configuration 1;display selected;set zshade;rotate best");
                    cellFormula = v.evaluateExpression("{visible && configuration=1}.find('CELLFORMULA')").toString();
                    empiricalFormula = v.evaluateExpression("{visible && configuration=1}.find('CELLFORMULA', true)").toString();
                } else {
                    bytes = null;
                    if (warning == null) {
                        smiles = v.getSmilesOpt(atoms, 0, 0, 0, "/noaromatic/");
                        molecularFormula = v.evaluateExpression("{1.1 && configuration=1}.find('SMILES','MF')").toString();
                    }
                    if (smiles == null || smiles.indexOf("Xx") >= 0) {
                        this.extractor.log("! DefaultStructureHelper WARNING: SMILES could not be created for " + originPath + " MF=" + molecularFormula);
                        smiles = null;
                        molecularFormula = null;
                    } else if (standardInChI == null) {
                        this.extractor.log("! DefaultStructureHelper WARNING: InChI could not be created for " + originPath);
                    } else {
                        fixedhInchi = v.getInchi(atoms, null, "fixedh");
                        inchiKey = v.getInchi(atoms, null, "key");
                    }
                    String mol2d = null;
                    if ((isCDXML || isCDX) && (mol2d = (String)v.evaluateExpression("write('MOL')")) != null && mol2d.indexOf("2D") >= 0) {
                        this.extractor.addDeferredPropertyOrRepresentation(IFDConst.IFD_REP_STRUCTURE_MOL_2D, DefaultStructureHelper.getDeferredObject(mol2d.getBytes(), originPath + ".mol", null, standardInChI, null), false, "chemical/x-mdl-molfile", note, null);
                    }
                    if (is2D && smiles != null) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        DefaultStructureHelper.writeMoleculePNG(smiles, bos);
                        bytes = bos.toByteArray();
                    }
                }
                if (bytes == null && !is2D) {
                    bytes = v.getImageAsBytes("png", 500, 500, -1, new String[1]);
                }
            }
            catch (Exception e) {
                this.extractor.log("!! Jmol error generating " + (smiles == null ? "SMILES" : (standardInChI == null ? "InChI" : "InChIKey")) + " for " + originPath);
                this.jmolViewer = null;
                e.printStackTrace();
            }
            if (standardInChI != null && !"?".equals(standardInChI)) {
                this.extractor.addDeferredPropertyOrRepresentation(STANDARD_INCHI, standardInChI, true, "chemical/x-inchi", note, null);
                if (fixedhInchi != null) {
                    this.extractor.addDeferredPropertyOrRepresentation(FIXEDH_INCHI, fixedhInchi, true, "chemical/x-inchi", note, null);
                }
                if (inchiKey != null) {
                    this.extractor.addDeferredPropertyOrRepresentation(INCHIKEY, inchiKey, true, "chemical/x-inchikey", null, null);
                }
            } else {
                standardInChI = null;
            }
            if (smiles != null) {
                this.extractor.addDeferredPropertyOrRepresentation(SMILES, smiles, true, "chemical/x-smiles", note, null);
            }
            if (bytes != null) {
                this.extractor.addDeferredPropertyOrRepresentation(IFDConst.IFD_REP_STRUCTURE_PNG, DefaultStructureHelper.getDeferredObject(bytes, originPath + ".png", IFDConst.IFD_REP_STRUCTURE_PNG, standardInChI, "image/png"), false, "image/png", note, null);
            }
            if (molecularFormula != null) {
                this.extractor.addDeferredPropertyOrRepresentation(MOLECULAR_FORMULA, molecularFormula, true, null, note, null);
            }
            if (empiricalFormula != null) {
                this.extractor.addDeferredPropertyOrRepresentation(EMPIRICAL_FORMULA, empiricalFormula, true, null, note, null);
            }
            if (cellFormula != null) {
                this.extractor.addDeferredPropertyOrRepresentation(CELL_FORMULA, cellFormula, true, null, note, null);
            }
        }
        this.fileToType.put(originPath, type);
        return returnInChI ? standardInChI : type;
    }

    private static void writeMoleculePNG(String smiles, OutputStream os) throws IOException {
        StereoMolecule mol = new SmilesParser().parseMolecule(smiles);
        GenericRectangle rect = mol.getBounds(null);
        int w = (int)(rect.getWidth() * 30.0);
        int h = (int)(rect.getHeight() / rect.getWidth() * (double)w);
        int mode = 224;
        JStructureView mArea = new JStructureView(mol);
        mArea.setDisplayMode(mode);
        mArea.setSize(w, h);
        BufferedImage bi = new BufferedImage(w, h, 2);
        mArea.paint(bi.getGraphics());
        ImageIO.write((RenderedImage)bi, "png", os);
    }

    private static Object[] getDeferredObject(byte[] bytes, String originPath, String type, String standardInChI, String mediaType) {
        return new Object[]{bytes, originPath, type, standardInChI == null ? "?" : standardInChI, mediaType};
    }

    public static String getType(String ext, byte[] bytes, boolean allowNone) {
        switch (ext) {
            case "png": {
                return IFDConst.IFD_REP_STRUCTURE_PNG;
            }
            case "mol": {
                return DefaultStructureHelper.isMol2D(bytes) ? IFDConst.IFD_REP_STRUCTURE_MOL_2D : IFDConst.IFD_REP_STRUCTURE_MOL;
            }
            case "sdf": {
                return DefaultStructureHelper.isMol2D(bytes) ? IFDConst.IFD_REP_STRUCTURE_SDF_2D : IFDConst.IFD_REP_STRUCTURE_SDF;
            }
            case "cdx": {
                return IFDConst.IFD_REP_STRUCTURE_CDX;
            }
            case "cdxml": {
                return IFDConst.IFD_REP_STRUCTURE_CDXML;
            }
            case "cif": {
                return IFDConst.IFD_REP_STRUCTURE_CIF;
            }
            case "cml": {
                return IFDConst.IFD_REP_STRUCTURE_CML;
            }
        }
        return allowNone ? ext.toUpperCase() : null;
    }

    private static boolean isMol2D(byte[] bytes) {
        if (bytes == null) {
            return false;
        }
        int line = 0;
        int linept = 0;
        block4: for (int i = 0; i < bytes.length; ++i) {
            switch (bytes[i]) {
                case 13: {
                    if (bytes[i + 1] == 10) continue block4;
                }
                case 10: {
                    if (++line == 2) {
                        int ptdim = linept + 20;
                        return i > ptdim + 1 && bytes[ptdim] == 50 && bytes[ptdim + 1] == 68;
                    }
                    linept = i + 1;
                }
            }
        }
        return false;
    }
}

