/*
 * Decompiled with CFR 0.152.
 */
package org.iupac.fairdata.derived;

import org.iupac.fairdata.common.IFDConst;
import org.iupac.fairdata.common.IFDException;
import org.iupac.fairdata.core.IFDAssociation;
import org.iupac.fairdata.core.IFDCollection;
import org.iupac.fairdata.dataobject.IFDDataObject;
import org.iupac.fairdata.dataobject.IFDDataObjectCollection;
import org.iupac.fairdata.sample.IFDSample;
import org.iupac.fairdata.sample.IFDSampleCollection;

public class IFDSampleDataAssociation
extends IFDAssociation {
    private static final int ITEM_SAMPLE = 0;
    private static final int ITEM_DATA = 1;
    private static final String sdaPrefix = IFDConst.concat(IFDConst.IFD_PROPERTY_FLAG, IFDConst.IFD_SAMPLEDATA_ASSOCIATION_FLAG);

    @Override
    protected String getIFDPropertyPrefix() {
        return sdaPrefix;
    }

    public IFDSampleDataAssociation() throws IFDException {
        super(null, new IFDSampleCollection(), new IFDDataObjectCollection());
    }

    public IFDSampleDataAssociation(String type, IFDSample sample, IFDDataObject data) throws IFDException {
        super(null, new IFDSampleCollection(sample), new IFDDataObjectCollection(data));
        if (!data.isValid()) {
            System.out.println("IFDSDA " + data);
        }
    }

    public IFDSampleDataAssociation(String type, IFDSampleCollection sampleCollection, IFDDataObjectCollection dataCollection) throws IFDException {
        super(type, sampleCollection, dataCollection);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof IFDSampleDataAssociation)) {
            return false;
        }
        IFDSampleDataAssociation ss = (IFDSampleDataAssociation)o;
        return ((IFDCollection)ss.get(0)).equals(this.get(0)) && ((IFDCollection)ss.get(1)).equals(this.get(1));
    }

    public IFDSampleCollection getSampleCollection() {
        return (IFDSampleCollection)this.get(0);
    }

    public IFDDataObjectCollection getDataObjectCollection() {
        return (IFDDataObjectCollection)this.get(1);
    }

    public IFDSample getSample(int i) {
        return (IFDSample)this.getSampleCollection().get(i);
    }

    public IFDDataObject getDataObject(int i) {
        return (IFDDataObject)this.getDataObjectCollection().get(i);
    }

    public IFDSample getFirstSample() {
        return (IFDSample)this.getSampleCollection().get(0);
    }

    public IFDDataObject getFirstDataObject() {
        return (IFDDataObject)this.getDataObjectCollection().get(0);
    }

    public boolean addSample(IFDSample s) {
        return this.getSampleCollection().add(s);
    }

    public boolean addDataObject(IFDDataObject data) {
        return this.getDataObjectCollection().add(data);
    }
}

