/*
 * Decompiled with CFR 0.152.
 */
package org.iupac.fairdata.core;

import org.iupac.fairdata.api.IFDSerializableI;
import org.iupac.fairdata.api.IFDSerializerI;
import org.iupac.fairdata.common.IFDConst;

public class IFDProperty
implements IFDSerializableI {
    private final String name;
    private final IFDConst.PROPERTY_TYPE dataType;
    private final IFDConst.PROPERTY_UNIT units;
    private Object value;
    private String source;
    public static final String NULL = "\u0001";

    public IFDProperty(String name, Object value, IFDConst.PROPERTY_TYPE dataType, IFDConst.PROPERTY_UNIT units) {
        this.name = name;
        this.dataType = dataType;
        this.units = units;
        this.setValue(value);
    }

    public IFDProperty(String name, IFDConst.PROPERTY_TYPE dataType, IFDConst.PROPERTY_UNIT units) {
        this(name, null, dataType, units);
    }

    public IFDProperty(String name, IFDConst.PROPERTY_TYPE dataType) {
        this(name, null, dataType, IFDConst.PROPERTY_UNIT.NONE);
    }

    public IFDProperty(String name) {
        this(name, null, IFDConst.PROPERTY_TYPE.STRING, IFDConst.PROPERTY_UNIT.NONE);
    }

    public String getName() {
        return this.name;
    }

    public IFDConst.PROPERTY_UNIT getUnits() {
        return this.units;
    }

    public IFDConst.PROPERTY_TYPE getType() {
        return this.dataType;
    }

    public Object getValue() {
        return this.value;
    }

    public IFDProperty getInherited(String newName) {
        return new IFDProperty(newName, null, this.dataType, this.units);
    }

    public IFDProperty getClone(Object value) {
        return new IFDProperty(this.name, value, this.dataType, this.units);
    }

    @Override
    public String getSerializedType() {
        return "IFDProperty";
    }

    @Override
    public void serialize(IFDSerializerI serializer) {
    }

    public String toString() {
        return this.value == null ? "" : "[IFDProp " + this.name + "=" + this.value + "]";
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public void setValue(Object val) {
        this.value = val == NULL ? null : val;
        this.source = null;
    }
}

