/*
 * Decompiled with CFR 0.152.
 */
package org.gennbo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Stack;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.gennbo.NBOConfig;
import org.gennbo.NBODialog;
import org.gennbo.NBOFileHandler;
import org.gennbo.NBORequest;
import org.gennbo.NBOUtil;
import org.jmol.i18n.GT;
import org.jmol.util.Elements;
import org.jmol.viewer.Viewer;

class NBOModel {
    protected NBODialog dialog;
    Viewer vwr;
    static final int MODEL_ACTION_ALTER = 0;
    static final int MODEL_ACTION_CLIP = 1;
    static final int MODEL_ACTION_FUSE = 2;
    static final int MODEL_ACTION_LINK = 3;
    static final int MODEL_ACTION_MUTATE = 4;
    static final int MODEL_ACTION_SWITCH = 5;
    static final int MODEL_ACTION_TWIST = 6;
    static final int MODEL_ACTION_VALUE = 7;
    static final int MODEL_ACTION_3CHB = 8;
    static final int MODEL_ACTION_MAX = 9;
    static final int MODEL_ACTION_REBOND = 9;
    static final int MODEL_ACTION_SYMMETRY = 10;
    static final int MODEL_ACTION_HBOND = 11;
    static final int MODEL_ACTION_VIBRATE = 12;
    static final int MODE_MODEL_EDIT = 21;
    static final int MODE_MODEL_NEW = 31;
    static final int MODE_MODEL_SAVE = 41;
    static final int MODE_MODEL_TO_NBO = 51;
    static final int MODE_MODEL_UNDO_REDO = 61;
    static final String[] MODEL_ACTIONS = new String[]{"Alter", "Clip", "Fuse", "Link", "Mutate", "Switch", "Twist", "Value", "3chb", "Rebond", "Sym.", "H-Bonds", "Vib."};
    static final String[] EDIT_INFO = new String[]{"Edit nuclear charge, bond length, bond angle, or dihedral angle", "Remove bond between two atoms", "Delete monovalent atoms and replace with bond", "Add bond between two atoms", "Replace atom with a new substituent-group", "Switch location of two groups", "Perform rigid torsional twist about dihedral angle", "Value of nuclear charge, bond length, bond angle, and dihedral angle", "Create 3-center linkage between two atoms and a ligand", "Change bonding symmetry around transition metal", "Display point-group symmetry of current model", "Show NBOPro6-derived hydrogen bonds", "TODO: Add info for Vibrate here"};
    static final int BOX_COUNT_4 = 4;
    static final int BOX_COUNT_2 = 2;
    static final int BOX_COUNT_1 = 1;
    static final int MAX_HISTORY = 5;
    NBOFileHandler saveFileHandler;
    Box innerEditBox;
    JTextField jtNIHInput;
    JTextField jtLineFormula;
    JTextField currVal;
    JComboBox<String> jcSymOps;
    JButton rebond;
    JButton vibrate;
    JButton jbClear;
    JLabel atomsLabel;
    Box editComponent;
    Box inputHeader;
    Box saveHeader;
    Component inputComponent;
    Box saveComponent;
    Box editHeader;
    JTextField[] atomNumBoxes;
    JLabel valueLabel = new JLabel("");
    protected JTextField editValueTf;
    protected JButton jbApply;
    protected JComboBox<String> jComboSave;
    protected JButton undo;
    protected JButton redo;
    protected Stack<String> undoStack;
    protected Stack<String> redoStack;
    int actionID;
    int boxCount;
    boolean notFromNBO;
    boolean resetOnAtomClick;
    Box innerLinkOptionBox;
    JRadioButton radLinkBond;
    String inputFileType;
    String saveFileType;
    String vibrateData;
    JScrollPane vibrationScroll;
    String prevJobStem;
    File currentLogFile;
    String logFilePath;
    int previousVibrateFrame;
    boolean loadLogFileForVibrate;
    static final String[][] REBOND_LISTS = new String[][]{{"td", "c3v", "c4v"}, {"c4vo", "c4vi"}, {"c3vo", "c3vi", "c5vo", "c5vi"}};
    ActionListener redoAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String curr = NBOModel.this.redoStack.pop();
            if (NBOModel.this.redoStack.isEmpty()) {
                NBOModel.this.redo.setEnabled(false);
            }
            NBOModel.this.loadModelToNBO(curr, true);
            NBOModel.this.dialog.logCmd("Redo");
        }
    };
    ActionListener undoAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String curr = NBOModel.this.undoStack.pop();
            if (NBOModel.this.undoStack.isEmpty()) {
                NBOModel.this.undo.setEnabled(false);
                return;
            }
            String tmp = NBOModel.this.undoStack.pop();
            NBOModel.this.loadModelToNBO(tmp, true);
            NBOModel.this.redoStack.push(curr);
            if (NBOModel.this.redoStack.size() > 5) {
                NBOModel.this.redoStack.removeElementAt(5);
            }
            NBOModel.this.dialog.logCmd("Undo");
        }
    };
    boolean showSelectedOnFileLoad;
    int currentRebondSymOp;
    int serverMode;
    String measures = "";

    protected NBOModel(NBODialog dialog) {
        this.dialog = dialog;
        this.vwr = dialog.vwr;
    }

    protected void setModelNotFromNBO() {
        this.notFromNBO = true;
    }

    void showComponents(boolean tf) {
        this.editHeader.setVisible(tf);
        this.editComponent.setVisible(tf);
        this.innerLinkOptionBox.setVisible(false);
        this.saveHeader.setVisible(tf);
        this.saveComponent.setVisible(tf);
    }

    void modelSetSaveParametersFromInput(NBOFileHandler nboFileHandler, String dir, String name, String ext) {
        if (this.saveFileHandler != null && nboFileHandler != this.saveFileHandler) {
            this.saveFileHandler.setInput(dir, name, PT.isOneOf(ext, "adf;cfi;gau;gms;jag;mm2;mnd;mp;nw;orc;pqs;qc;mol;xyz;vfi;g09;com") ? ext : "gau");
        }
    }

    protected JPanel buildModelPanel() {
        this.resetVariables();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        NBODialog nBODialog = this.dialog;
        nBODialog.getClass();
        this.inputHeader = NBOUtil.createTitleBoxForNBOModel(" Input Model ", nBODialog.new NBODialog.HelpBtn("model_input_intro_help.htm"));
        panel.add(this.inputHeader);
        this.inputComponent = this.getInputComponent();
        panel.add(this.inputComponent);
        this.editHeader = this.getEditHeader();
        panel.add(this.editHeader).setVisible(false);
        this.editComponent = this.getEditComponent();
        panel.add(this.editComponent).setVisible(false);
        NBODialog nBODialog2 = this.dialog;
        nBODialog2.getClass();
        this.saveHeader = NBOUtil.createTitleBox(" Save Model ", nBODialog2.new NBODialog.HelpBtn("model_save_intro_help.htm"));
        panel.add(this.saveHeader).setVisible(false);
        this.saveComponent = this.getSaveComponent();
        panel.add(this.saveComponent).setVisible(false);
        panel.add(Box.createGlue());
        if (this.vwr.ms.ac > 0) {
            this.loadModelToNBO(null, false);
        }
        return panel;
    }

    void resetVariables() {
        this.actionID = 0;
        this.boxCount = 0;
        this.notFromNBO = false;
        this.showSelectedOnFileLoad = false;
        this.resetOnAtomClick = true;
        this.serverMode = 0;
        this.saveFileType = "";
    }

    Box getEditHeader() {
        Box topBox = Box.createHorizontalBox();
        this.undo = new JButton("<HTML>&#8592Undo</HTML>");
        this.redo = new JButton("<HTML>Redo&#8594</HTML>");
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        this.redo.addActionListener(this.redoAction);
        this.undo.addActionListener(this.undoAction);
        topBox.add(this.undo);
        topBox.add(this.redo);
        NBODialog nBODialog = this.dialog;
        nBODialog.getClass();
        topBox.add(nBODialog.new NBODialog.HelpBtn("model_edit_intro_help.htm"));
        return NBOUtil.createTitleBox(" Edit Model ", topBox);
    }

    Component getInputComponent() {
        Box inputBox = NBOUtil.createBorderBox(true);
        inputBox.setMaximumSize(new Dimension(360, 140));
        inputBox.setPreferredSize(new Dimension(360, 140));
        inputBox.setMinimumSize(new Dimension(360, 140));
        JPanel p2 = new JPanel(new GridLayout(3, 2));
        p2.setMaximumSize(new Dimension(360, 90));
        p2.setPreferredSize(new Dimension(360, 90));
        p2.setMinimumSize(new Dimension(360, 90));
        JRadioButton jrJmolIn = new JRadioButton("NIH/PubChem/PDB");
        jrJmolIn.setFont(NBOConfig.monoFont);
        JRadioButton jrLineIn = new JRadioButton("Line Formula");
        jrLineIn.setFont(NBOConfig.monoFont);
        jrLineIn.setSelected(true);
        JRadioButton jrFileIn = new JRadioButton("File Input");
        jrFileIn.setFont(NBOConfig.monoFont);
        ButtonGroup rg = new ButtonGroup();
        rg.add(jrJmolIn);
        rg.add(jrLineIn);
        rg.add(jrFileIn);
        this.jtNIHInput = new JTextField();
        this.createInput(this.jtNIHInput, jrJmolIn);
        this.jtLineFormula = new JTextField();
        this.createInput(this.jtLineFormula, jrLineIn);
        this.jtNIHInput.setFont(NBOConfig.userInputFont);
        this.jtLineFormula.setFont(NBOConfig.userInputFont);
        this.jtLineFormula.add(new JLabel("line formula"));
        String[] useOps = new String[]{"<Select File  Type>", "[.47]   NBO Archive", "[.gau]  Gaussian Input", "[.log]  Gaussian Output", "[.gms]  GAMESS Input", "[.adf]  ADF Input", "[.jag]  Jaguar Input", "[.mm2]  MM2-Input", "[.mnd]  Dewar Type Input", "[.mp]   Molpro Input", "[.nw]   NWChem Input", "[.orc]  Orca Input", "[.pqs]  PQS Input", "[.qc]   Q-Chem Input", "[.xyz]  XYZ", "[.mol]  MOL", "[.cfi]  NBO Cartesian", "[.vfi]  NBO Valence"};
        final JComboBox<String> jComboUse = new JComboBox<String>(useOps);
        jComboUse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOModel.this.doComboUseAction(jComboUse.getSelectedIndex() > 0 ? jComboUse.getSelectedItem().toString() : null);
            }
        });
        p2.add(jrLineIn);
        p2.add(this.jtLineFormula);
        p2.add(jrJmolIn);
        p2.add(this.jtNIHInput);
        p2.add(jrFileIn);
        p2.add(jComboUse);
        this.addFocusListeners(jComboUse, jrFileIn);
        inputBox.add(p2);
        this.prevJobStem = this.dialog.inputFileHandler != null ? (this.dialog.inputFileHandler.jobStem != null ? this.dialog.inputFileHandler.jobStem : null) : null;
        this.dialog.inputFileHandler = new NBOFileHandler("", "", 1, "adf;cfi;com;g09;gau;gms;jag;log;mm2;mnd;mol;mp;nw;orc;pqs;qc;vfi;xyz;47", this.dialog){

            @Override
            protected boolean doFileBrowsePressed() {
                String ext;
                String folder = this.tfDir.getText().trim();
                String name = this.tfName.getText();
                if (name.length() == 0) {
                    name = "*";
                }
                if ((ext = this.tfExt.getText()).length() == 0) {
                    ext = "*";
                }
                folder = NBOUtil.getWindowsFullNameFor(folder, name, ext);
                JFileChooser myChooser = new JFileChooser();
                String filter = this.useExt;
                if (name.equals("*") && !ext.equals("*")) {
                    filter = ext;
                }
                if (filter.contains(";")) {
                    myChooser.setFileFilter(new FileNameExtensionFilter(filter, filter.split(";")));
                } else {
                    myChooser.setFileFilter(new FileNameExtensionFilter(filter, filter));
                }
                myChooser.setFileHidingEnabled(true);
                if (folder.endsWith("/")) {
                    folder = folder + "*.*";
                }
                if (!folder.equals("")) {
                    myChooser.setSelectedFile(new File(folder));
                }
                int button = myChooser.showDialog(this, GT.$("Select"));
                if (NBOModel.this.vibrate != null) {
                    NBOModel.this.vibrate.setEnabled(false);
                }
                if (button == 0) {
                    if (PT.isOneOf(NBOModel.this.inputFileType, "adf;cfi;com;g09;gau;gms;jag;log;mm2;mnd;mol;mp;nw;orc;pqs;qc;vfi;xyz;47")) {
                        File newFile = myChooser.getSelectedFile();
                        if (newFile.toString().indexOf(".") < 0) {
                            this.dialog.logError("File not found");
                            return false;
                        }
                        this.fullFilePath = newFile.getParent();
                        this.jobStem = NBOUtil.getJobStem(newFile);
                        NBOModel.this.loadModelFromNBO(newFile.getParent(), this.jobStem, NBOUtil.getExt(newFile));
                        this.dialog.inputFileHandler.setInput(this.fullFilePath, this.jobStem, NBOUtil.getExt(newFile));
                        if (NBOModel.this.inputFileType.equals("log")) {
                            NBOModel.this.currentLogFile = newFile;
                            NBOModel.this.postVibrateRequestToNBO(newFile.getParent(), this.jobStem, NBOUtil.getExt(newFile));
                        } else {
                            NBOModel.this.currentLogFile = null;
                        }
                        return true;
                    }
                    this.dialog.logError("Invalid input file type defined");
                }
                return false;
            }
        };
        jComboUse.setSelectedIndex(1);
        if (this.prevJobStem != null) {
            this.dialog.inputFileHandler.tfName.setText(this.prevJobStem);
        }
        this.addFocusListeners(this.dialog.inputFileHandler.tfDir, jrFileIn);
        this.addFocusListeners(this.dialog.inputFileHandler.tfExt, jrFileIn);
        this.addFocusListeners(this.dialog.inputFileHandler.tfName, jrFileIn);
        this.addFocusListeners(this.dialog.inputFileHandler.btnBrowse, jrFileIn);
        inputBox.add(this.dialog.inputFileHandler);
        inputBox.add(Box.createGlue());
        return inputBox;
    }

    protected void doComboUseAction(String item) {
        if (item == null) {
            this.dialog.inputFileHandler.tfExt.setText("");
            this.dialog.inputFileHandler.useExt = "adf;cfi;com;g09;gau;gms;jag;log;mm2;mnd;mol;mp;nw;orc;pqs;qc;vfi;xyz;47";
        } else {
            item = item.substring(item.indexOf("[") + 2, item.indexOf("]"));
            this.dialog.inputFileHandler.tfExt.setText(item);
            this.inputFileType = item;
            this.dialog.inputFileHandler.useExt = item;
        }
    }

    Box getEditComponent() {
        Box editBox = NBOUtil.createBorderBox(false);
        Box actionBox = Box.createVerticalBox();
        JRadioButton[] jrModelActions = new JRadioButton[9];
        ButtonGroup rg = new ButtonGroup();
        for (int i = 0; i < 9; ++i) {
            jrModelActions[i] = new JRadioButton(MODEL_ACTIONS[i]);
            jrModelActions[i].setToolTipText(EDIT_INFO[i]);
            actionBox.add(jrModelActions[i]);
            rg.add(jrModelActions[i]);
            final int op = i;
            jrModelActions[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NBOModel.this.doModelAction(op);
                }
            });
        }
        editBox.add(actionBox);
        Box rightBox = Box.createVerticalBox();
        this.createInnerEditBox();
        rightBox.add(this.innerEditBox);
        Box lowBox = Box.createHorizontalBox();
        JButton sym = new JButton(MODEL_ACTIONS[10]);
        sym.setToolTipText(EDIT_INFO[10]);
        sym.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOModel.this.doGetSymmetry();
            }
        });
        lowBox.add(sym);
        this.rebond = new JButton(MODEL_ACTIONS[9]);
        this.rebond.setEnabled(false);
        this.rebond.setToolTipText(EDIT_INFO[9]);
        this.rebond.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOModel.this.doModelAction(9);
            }
        });
        lowBox.add(this.rebond);
        JButton hbond = new JButton(MODEL_ACTIONS[11]);
        hbond.setToolTipText(EDIT_INFO[11]);
        hbond.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOModel.this.doGetHBonds();
            }
        });
        lowBox.add(hbond);
        this.vibrate = new JButton(MODEL_ACTIONS[12]);
        this.vibrate.setEnabled(false);
        this.vibrate.setToolTipText(EDIT_INFO[12]);
        this.vibrate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOModel.this.doVibrate();
            }
        });
        lowBox.add(this.vibrate);
        rightBox.add(lowBox);
        editBox.add(rightBox);
        return editBox;
    }

    void createInnerEditBox() {
        this.innerEditBox = Box.createVerticalBox();
        this.innerEditBox.setBorder(BorderFactory.createLoweredBevelBorder());
        this.innerEditBox.setMaximumSize(new Dimension(275, 200));
        this.innerEditBox.setAlignmentX(0.5f);
        this.innerEditBox.setVisible(false);
        Box atBox = Box.createHorizontalBox();
        this.atomsLabel = new JLabel("");
        atBox.add(this.atomsLabel);
        this.atomNumBoxes = new JTextField[4];
        for (int i = 0; i < 4; ++i) {
            this.atomNumBoxes[i] = new JTextField();
            this.atomNumBoxes[i].setFont(NBOConfig.userInputFont);
            this.atomNumBoxes[i].setMaximumSize(new Dimension(50, 50));
            atBox.add(this.atomNumBoxes[i]).setVisible(false);
            final int num = i;
            this.atomNumBoxes[i].addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    NBOModel.this.editValueTf.setText("");
                    NBOModel.this.editValueTf.setEnabled(NBOModel.this.modelEditGetSelected().length() > 0);
                }
            });
            this.atomNumBoxes[i].addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent arg0) {
                    NBOModel.this.doAtomNumBoxFocus(true, num);
                }

                @Override
                public void focusLost(FocusEvent arg0) {
                    NBOModel.this.doAtomNumBoxFocus(false, 0);
                }
            });
            this.atomNumBoxes[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NBOModel.this.doSetAtomBoxesFromSelection(null, false);
                }
            });
        }
        this.innerEditBox.add(atBox);
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("Symmetry Type: "));
        this.jcSymOps = new JComboBox();
        this.jcSymOps.addItem("<Select Transition Metal>");
        this.jcSymOps.setMaximumSize(new Dimension(180, 40));
        this.jcSymOps.setEnabled(false);
        box.add(this.jcSymOps);
        box.setVisible(false);
        this.innerEditBox.add(box);
        this.currVal = new JTextField("pick atoms...");
        this.currVal.setFont(NBOConfig.titleFont);
        this.currVal.setBackground(new Color(220, 220, 220));
        this.currVal.setMinimumSize(new Dimension(250, 40));
        this.currVal.setPreferredSize(new Dimension(250, 40));
        this.currVal.setMaximumSize(new Dimension(250, 40));
        this.currVal.setHorizontalAlignment(0);
        this.innerEditBox.add(this.currVal).setVisible(false);
        this.valueLabel = new JLabel();
        this.valueLabel.setAlignmentX(0.5f);
        this.innerEditBox.add(this.valueLabel).setVisible(false);
        this.editValueTf = new JTextField("Select atoms...");
        this.editValueTf.setVisible(false);
        this.editValueTf.setMaximumSize(new Dimension(200, 30));
        this.editValueTf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOModel.this.doEditValueTextField();
            }
        });
        this.editValueTf.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent arg0) {
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                if (!NBOModel.this.editValueTf.getText().equals("") && !NBOModel.this.editValueTf.getText().contains("Select")) {
                    NBOModel.this.jbApply.setEnabled(true);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                if (NBOModel.this.editValueTf.getText().equals("")) {
                    NBOModel.this.jbApply.setEnabled(false);
                }
            }
        });
        this.innerEditBox.add(this.editValueTf).setVisible(false);
        this.innerLinkOptionBox = Box.createHorizontalBox();
        this.radLinkBond = new JRadioButton("Bond");
        this.radLinkBond.setSelected(true);
        JRadioButton radLinkDotted = new JRadioButton("Dotted");
        this.innerLinkOptionBox.add(this.radLinkBond);
        this.innerLinkOptionBox.add(radLinkDotted);
        ButtonGroup g = new ButtonGroup();
        g.add(this.radLinkBond);
        g.add(radLinkDotted);
        this.innerEditBox.add(this.innerLinkOptionBox).setVisible(false);
        Box lowBox = Box.createHorizontalBox();
        this.jbClear = new JButton("Clear Selected");
        this.jbClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOModel.this.clearSelected(true);
            }
        });
        this.jbApply = new JButton("Apply");
        this.jbApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOModel.this.doApply();
            }
        });
        lowBox.add(this.jbClear).setVisible(false);
        lowBox.add(this.jbApply).setVisible(false);
        this.innerEditBox.add(lowBox);
    }

    protected void doLinkDotted() {
        String atomList = this.modelEditGetSelected();
        String[] atoms = PT.getTokens(atomList);
        if (atoms.length == 2) {
            this.processHBonds("1 " + atomList);
        }
    }

    protected void doAtomNumBoxFocus(boolean isGained, int num) {
        System.out.println("atomnumbfocus" + isGained + " " + num);
        if (!isGained) {
            int atnum = PT.parseInt(this.atomNumBoxes[num].getText());
            if (atnum > this.vwr.ms.ac || atnum < 1) {
                this.atomNumBoxes[num].setText("");
            } else {
                this.doSetAtomBoxesFromSelection(null, false);
            }
        } else if (num == this.boxCount - 1) {
            this.jbApply.setEnabled(this.modelEditGetSelected().length() > 0);
        }
    }

    protected void doApply() {
        this.postActionToNBO(this.actionID);
    }

    protected void doEditValueTextField() {
        this.postActionToNBO(this.actionID);
    }

    protected void updateSelected(boolean doPost, boolean setFocus) {
        String selected = this.modelEditGetSelected();
        String script = "measure delete;";
        int cnt = selected.split(" ").length;
        this.editValueTf.setEnabled(cnt > 0);
        this.editValueTf.setText("");
        if (this.editValueTf.isVisible()) {
            this.editValueTf.requestFocus();
        }
        switch (this.boxCount) {
            case 4: {
                String desc = "";
                if (cnt > 1) {
                    script = script + "measure " + selected + " \" \";";
                }
                switch (cnt) {
                    case 0: {
                        this.currVal.setText("pick atoms...");
                        break;
                    }
                    case 1: {
                        desc = this.actionID == 0 ? "atomic number or symbol" : "atomic number";
                        break;
                    }
                    case 2: {
                        desc = "distance";
                        break;
                    }
                    case 3: 
                    case 4: {
                        desc = cnt == 3 ? "angle" : "dihedral angle";
                    }
                }
                this.valueLabel.setText("(" + desc + ")");
                this.valueLabel.setVisible(cnt > 0);
                break;
            }
            case 2: {
                if (cnt != 2) break;
                this.jbApply.setEnabled(true);
                if (this.editValueTf.isVisible()) {
                    this.editValueTf.requestFocus();
                    break;
                }
                if (!setFocus) break;
                this.atomNumBoxes[1].requestFocus();
                break;
            }
            case 1: {
                if (cnt != 1 || this.actionID != 9) break;
                this.jcSymOps.removeAllItems();
                this.jcSymOps.setEnabled(true);
                int atomNumber = PT.parseInt(this.atomNumBoxes[0].getText());
                if (atomNumber < 1) {
                    return;
                }
                int val = this.vwr.ms.at[atomNumber - 1].getValence();
                this.jbApply.setEnabled(true);
                String[] symlist = NBOModel.getRebondSymList(val);
                if (symlist != null) {
                    for (int i = 0; i < symlist.length; ++i) {
                        this.jcSymOps.addItem(symlist[i]);
                    }
                    if (this.currentRebondSymOp > 0) {
                        this.jcSymOps.setSelectedIndex(this.currentRebondSymOp);
                    }
                    this.currentRebondSymOp = 0;
                    break;
                }
                this.jcSymOps.addItem("<Select Transition Metal>");
                this.jcSymOps.setEnabled(false);
                this.jbApply.setEnabled(false);
            }
        }
        if (this.actionID == 0 || this.actionID == 6 && cnt == 4) {
            this.postActionToNBO(7);
        }
        if (this.actionID == 3) {
            script = "";
        }
        this.dialog.runScriptQueued(script);
        this.editValueTf.setText("");
        this.editValueTf.setEnabled(selected.length() > 0);
        this.dialog.showSelected(selected);
        if (this.actionID == 7 || doPost) {
            this.postActionToNBO(this.actionID);
        }
    }

    static String[] getRebondSymList(int val) {
        return val - 4 < REBOND_LISTS.length ? REBOND_LISTS[val - 4] : null;
    }

    protected String modelEditGetSelected() {
        String s = "";
        for (int j = 0; j < this.boxCount; ++j) {
            s = s + this.atomNumBoxes[j].getText().trim() + " ";
        }
        return PT.rep(s.trim(), "  ", " ").trim();
    }

    Box getSaveComponent() {
        Box sBox = NBOUtil.createBorderBox(true);
        String[] SAVE_OPTIONS = new String[]{"<Select File Type>", "Gaussian Input             [.gau]", "Gaussian Input (Cartesian) [.gau]", "Gaussian Input (z-Matrix)  [.gau]", "GAMESS Input               [.gms]", "ADF Input                  [.adf]", "Jaguar Input               [.jag]", "MM2-Input                  [.mm2]", "Dewar Type Input           [.mnd]", "Molpro Input               [.mp]", "NWChem Input               [.nw]", "Orca Input                 [.orc]", "PQS Input                  [.pqs]", "Q-Chem Input               [.qc]", "XYZ                        [.xyz]", "MOL                        [.mol]", "NBO Cartesian              [.cfi]", "NBO Valence                [.vfi]"};
        this.jComboSave = new JComboBox<String>(SAVE_OPTIONS);
        this.jComboSave.setFont(NBOConfig.monoFont);
        this.jComboSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NBOModel.this.jComboSave.getSelectedIndex() > 0) {
                    NBOModel.this.doComboSaveAction(NBOModel.this.jComboSave.getSelectedItem().toString());
                } else if (NBOModel.this.jComboSave.getSelectedIndex() == 0) {
                    NBOModel.this.saveFileType = "";
                }
            }
        });
        sBox.add(this.jComboSave);
        this.saveFileHandler = new NBOFileHandler("", "", 5, "adf;cfi;gau;gms;jag;mm2;mnd;mp;nw;orc;pqs;qc;mol;xyz;vfi;g09;com", this.dialog){

            @Override
            protected boolean doFileBrowsePressed() {
                String folder = this.tfDir.getText().trim();
                String name = this.tfName.getText().trim();
                String ext = this.tfExt.getText().trim();
                JFileChooser myChooser = new JFileChooser();
                this.useExt = ext.equals("") ? "adf;cfi;gau;gms;jag;mm2;mnd;mp;nw;orc;pqs;qc;mol;xyz;vfi;g09;com" : ext;
                myChooser.setFileFilter(new FileNameExtensionFilter(this.useExt, this.useExt.split(",")));
                myChooser.setFileHidingEnabled(true);
                String savePath = this.fullFilePath;
                folder = NBOUtil.getWindowsFolderFor(folder, this.fullFilePath);
                savePath = name.equals("") && this.jobStem != null ? this.tfDir.getText() + "/" + (this.jobStem.equals("") ? "new.cfi" : this.jobStem + (ext.contains(";") ? "" : "." + ext)) : this.tfDir.getText() + "/" + name + "." + ext;
                myChooser.setSelectedFile(new File(savePath));
                int button = myChooser.showSaveDialog(this);
                if (button == 0) {
                    File newFile = myChooser.getSelectedFile();
                    ext = NBOUtil.getExt(newFile);
                    if (PT.isOneOf(NBOModel.this.saveFileType, "adf;cfi;gau;gms;jag;mm2;mnd;mp;nw;orc;pqs;qc;mol;xyz;vfi;g09;com")) {
                        int i;
                        if (newFile.exists() && (i = JOptionPane.showConfirmDialog(null, "File " + newFile + " already exists, do you want to overwrite contents?", "Warning", 0)) == 1) {
                            return false;
                        }
                        this.dialog.inputFileHandler.setInput(folder, name, ext);
                        this.fullFilePath = newFile.getParent();
                        NBOModel.this.saveModel(newFile.getParent(), NBOUtil.getJobStem(newFile), ext);
                        this.dialog.saveWorkingPath(this.fullFilePath);
                    } else {
                        this.dialog.logError("Invalid output file type defined");
                    }
                }
                return false;
            }
        };
        this.jComboSave.setSelectedIndex(1);
        sBox.add(this.saveFileHandler);
        return sBox;
    }

    protected void doComboSaveAction(String item) {
        String ext;
        this.saveFileType = ext = item.substring(item.indexOf("[") + 2, item.indexOf("]"));
        this.saveFileHandler.tfExt.setText(ext);
    }

    void createInput(final JTextField field, JRadioButton radio) {
        field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOModel.this.doLoadtModelFromTextBox(field);
            }
        });
        this.addFocusListeners(field, radio);
    }

    void addFocusListeners(final JComponent field, final JRadioButton radio) {
        field.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                radio.setSelected(true);
            }

            @Override
            public void focusLost(FocusEvent arg0) {
            }
        });
        radio.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                field.requestFocus();
            }

            @Override
            public void focusLost(FocusEvent arg0) {
            }
        });
    }

    protected void doModelAction(int action) {
        this.actionID = action;
        this.dialog.runScriptQueued("set refreshing true; measurements delete");
        this.clearSelected(true);
        if (action != 3) {
            if (action != 1) {
                this.measures = "";
            }
            this.innerLinkOptionBox.setVisible(false);
        }
        switch (action) {
            case 4: {
                this.boxCount = 1;
                this.setEditBox("Radical name or line formula...");
                break;
            }
            case 9: {
                this.boxCount = 1;
                this.setEditBox(null);
                break;
            }
            case 3: {
                this.innerLinkOptionBox.setVisible(true);
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: {
                this.boxCount = 2;
                this.setEditBox(null);
                break;
            }
            case 0: 
            case 6: 
            case 7: {
                this.boxCount = 4;
                this.setEditBox(null);
            }
        }
    }

    void setEditBox(String label) {
        if (label == null) {
            label = "Select atom" + (this.boxCount > 1 ? "s" : "") + "...";
        }
        this.jbApply.setEnabled(false);
        for (int i = 0; i < 4; ++i) {
            this.atomNumBoxes[i].setVisible(i < this.boxCount);
        }
        this.atomsLabel.setText(this.boxCount == 0 ? "" : "Atom" + (this.boxCount > 1 ? "s" : "") + ":");
        this.editValueTf.setText(label);
        this.editValueTf.setEnabled(false);
        this.jcSymOps.getParent().setVisible(this.actionID == 9);
        switch (this.actionID) {
            case 0: 
            case 4: 
            case 6: 
            case 8: {
                this.editValueTf.setVisible(true);
                break;
            }
            default: {
                this.editValueTf.setVisible(false);
            }
        }
        this.currVal.setVisible(this.boxCount == 4);
        this.valueLabel.setVisible(true);
        this.jbApply.setVisible(this.actionID != 7);
        this.jbClear.setVisible(true);
        this.innerEditBox.repaint();
        this.innerEditBox.revalidate();
    }

    protected void clearSelected(boolean andShow) {
        for (int i = 0; i < this.boxCount; ++i) {
            this.atomNumBoxes[i].setText("");
        }
        if (this.currVal != null) {
            this.currVal.setText("");
        }
        if (this.valueLabel != null) {
            this.valueLabel.setText(" ");
        }
        if (this.editValueTf != null) {
            this.editValueTf.setText("Select atoms...");
            this.editValueTf.setEnabled(false);
            this.jbApply.setEnabled(false);
        }
        if (andShow) {
            this.updateSelected(false, true);
        }
    }

    protected void postActionToNBO(int actionID) {
        if (actionID == 3 && !this.radLinkBond.isSelected()) {
            this.doLinkDotted();
            return;
        }
        SB sb = new SB();
        String selected = this.modelEditGetSelected();
        String cmd = MODEL_ACTIONS[actionID].toLowerCase() + " " + selected + " ";
        String val = this.editValueTf.getText().trim();
        if (actionID == 0 && PT.parseInt(val) == Integer.MIN_VALUE) {
            if (val.length() == 0) {
                return;
            }
            val = "" + Elements.elementNumberFromSymbol(val, true);
        }
        if (this.boxCount == 4 || this.boxCount == 1) {
            cmd = cmd + val;
        } else if (actionID == 8) {
            if (!val.startsWith(":")) {
                cmd = cmd + ":";
            }
            cmd = cmd + val;
        }
        if (actionID == 9) {
            this.currentRebondSymOp = this.jcSymOps.getSelectedIndex();
            cmd = cmd + this.jcSymOps.getItemAt(this.currentRebondSymOp);
        }
        NBOUtil.postAddCmd(sb, cmd);
        this.dialog.logCmd(cmd);
        this.jbApply.setEnabled(false);
        this.resetOnAtomClick = actionID != 7;
        this.postNBO(sb, actionID, actionID == 7 ? "Checking value" : "Editing model", null, null);
    }

    protected void doGetSymmetry() {
        String cmd = "symmetry";
        this.dialog.logCmd(cmd);
        this.postNBO(NBOUtil.postAddCmd(new SB(), cmd), 10, "Checking Symmetry", null, null);
    }

    protected void doGetHBonds() {
        String cmd = "hbond";
        this.dialog.logCmd(cmd);
        this.postNBO(NBOUtil.postAddCmd(new SB(), cmd), 11, "Getting Hydrogen Bonds", null, null);
    }

    protected void doVibrate() {
        int i;
        this.dialog.logCmd("vibrate");
        String[] lines = this.vibrateData.split("\\r?\\n");
        ArrayList<String> vibrateMenu = new ArrayList<String>();
        for (i = 0; i < lines.length; ++i) {
            if (lines[i].trim().length() <= 0) continue;
            vibrateMenu.add(lines[i]);
        }
        Box box = NBOUtil.createTitleBox(" Harmonic Vibration Modes ", null);
        JLabel heading = new JLabel("       nu(cm-1) IR inten. sym.");
        heading.setFont(NBOConfig.listFont);
        JPanel mainPanel = new JPanel(new GridLayout(1, 0));
        JPanel vibratePanel = new JPanel(new GridLayout(0, 1, 0, 0));
        JRadioButton[] vibrateButton = new JRadioButton[vibrateMenu.size()];
        ButtonGroup bg = new ButtonGroup();
        for (i = 0; i < vibrateMenu.size(); ++i) {
            String vibrateRow = (String)vibrateMenu.get(i);
            vibrateButton[i] = new JRadioButton(vibrateRow);
            vibrateButton[i].setFont(NBOConfig.listFont);
            vibrateButton[i].setOpaque(true);
            bg.add(vibrateButton[i]);
            vibratePanel.add(vibrateButton[i]);
            final int op = i;
            vibrateButton[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NBOModel.this.doVibrateAction(op);
                }
            });
        }
        int height = vibrateMenu.size() * 30;
        if (height > 500) {
            height = 500;
        }
        this.vibrationScroll = new JScrollPane(vibratePanel);
        this.vibrationScroll.setMaximumSize(new Dimension(300, height));
        this.vibrationScroll.setHorizontalScrollBarPolicy(31);
        mainPanel.add(this.vibrationScroll);
        this.vibrationScroll.getVerticalScrollBar().setUnitIncrement(25);
        Box box2 = Box.createVerticalBox();
        box2.add(heading);
        box2.add(mainPanel);
        box2.setAlignmentX(0.0f);
        box.add(box2);
        this.previousVibrateFrame = -1;
        JDialog vibrateDialog = new JDialog((Dialog)this.dialog, "Vibration Menu");
        vibrateDialog.setMaximumSize(new Dimension(300, height + 30));
        vibrateDialog.setMinimumSize(new Dimension(300, height + 30));
        vibrateDialog.setPreferredSize(new Dimension(300, height + 30));
        vibrateDialog.setVisible(true);
        vibrateDialog.add(box);
        this.centerDialog(vibrateDialog, 150);
        vibrateDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NBOModel.this.closeVibrateMenu();
            }
        });
    }

    void closeVibrateMenu() {
        this.dialog.runScriptQueued(";vibration OFF;");
        this.loadModelFromNBO(this.currentLogFile.getParent(), NBOUtil.getJobStem(this.currentLogFile), NBOUtil.getExt(this.currentLogFile));
        this.previousVibrateFrame = -1;
    }

    void doVibrateAction(int op) {
        int difference;
        if (this.previousVibrateFrame == -1) {
            this.dialog.runScriptQueued(";load " + this.logFilePath + ";");
            this.loadLogFileForVibrate = true;
            this.dialog.runScriptQueued(";animation MODE ONCE;");
            this.dialog.runScriptQueued(";vibration ON;");
            this.dialog.runScriptQueued(";frame NEXT;");
            this.previousVibrateFrame = 0;
        }
        if ((difference = ++op - this.previousVibrateFrame) >= 0) {
            for (int i = 0; i < difference; ++i) {
                this.dialog.runScriptQueued(";frame NEXT;");
            }
        } else {
            for (int i = 0; i < Math.abs(difference); ++i) {
                this.dialog.runScriptQueued(";frame previous;");
            }
        }
        this.previousVibrateFrame = op;
    }

    void centerDialog(JDialog d, int h) {
        int x = (this.dialog.getX() + this.dialog.getWidth()) / 2 + 150;
        int y = (this.dialog.getY() + this.dialog.getHeight()) / 2 - h;
        d.setLocation(x, y);
    }

    protected void doLoadtModelFromTextBox(JTextField textBox) {
        String model = textBox.getText().trim();
        if (model.length() == 0) {
            return;
        }
        String s = "";
        this.dialog.inputFileHandler.setInput(null, "", "");
        this.saveFileHandler.setInput(null, "", "");
        this.clearSelected(false);
        if (textBox == this.jtNIHInput) {
            if (model.startsWith("!")) {
                this.dialog.runScriptQueued(model.substring(1));
                return;
            }
            this.dialog.modelOrigin = 1;
            this.notFromNBO = true;
            if ("$:=".indexOf(model.charAt(0)) < 0) {
                model = "$" + model;
            }
            if (model.startsWith("=")) {
                switch (model.length()) {
                    case 5: {
                        break;
                    }
                    case 4: {
                        model = "=" + model;
                        break;
                    }
                    default: {
                        if (model.indexOf("/") >= 0) break;
                        this.dialog.logError("PDB codes must be of the form XXX for ligands and XXXX for standard PDB entries.");
                    }
                }
            }
            this.jtLineFormula.setText("");
            this.saveFileHandler.setInput(null, model, "gau");
            this.dialog.logCmd("get " + model);
            this.dialog.iAmLoading = true;
            if (this.dialog.loadModelFileNow(model) == null) {
                if ((model = (model.charAt(0) == ':' ? "$" : ":") + model.substring(1)).startsWith("$=")) {
                    this.dialog.logError("RCSB does not recognize ligand code " + model.substring(2) + ".");
                    this.dialog.iAmLoading = false;
                    return;
                }
                this.dialog.logCmd("get " + model);
                if (this.dialog.loadModelFileNow(model) == null) {
                    this.dialog.logError("Neither NIH/CIR nor PubChem have recognize this identifier.");
                    this.notFromNBO = false;
                    this.dialog.iAmLoading = false;
                }
            }
        } else {
            this.dialog.modelOrigin = 2;
            SB sb = new SB();
            this.jtNIHInput.setText("");
            s = "show " + model;
            this.saveFileHandler.setInput(null, "line", "gau");
            NBOUtil.postAddCmd(sb, s);
            this.dialog.logCmd(s);
            this.postNBO(sb, 31, "model from line input...", null, null);
        }
    }

    protected void loadModelToNBO(String s, boolean undoRedo) {
        boolean alsoLoadJmol = true;
        if (s == null) {
            s = this.dialog.getCFIData();
            alsoLoadJmol = false;
        }
        SB sb = new SB();
        NBOUtil.postAddGlobalC(sb, "PATH", this.dialog.nboService.getServerPath(null) + "/");
        NBOUtil.postAddGlobalC(sb, "ESS", "c");
        NBOUtil.postAddGlobalC(sb, "FNAME", "jmol_outfile");
        NBOUtil.postAddGlobalC(sb, "IN_EXT", "cfi");
        NBOUtil.postAddCmd(sb, "use");
        this.postNBO(sb, undoRedo ? 61 : 51, (alsoLoadJmol ? "Loading" : "Sending") + " model to NB", "jmol_outfile.cfi", s);
    }

    protected void loadModelFromNBO(String path, String fname, String ext) {
        if (PT.isOneOf(ext, "xyz;mol")) {
            this.notFromNBO = true;
            this.dialog.runScriptQueued("set refreshing false");
            this.dialog.loadModelFileQueued(new File(path + "\\" + fname + "." + ext), false);
            this.dialog.runScriptQueued("set refreshing true");
            return;
        }
        String ess = this.inputFileType == null ? this.getEss(ext, true) : this.getEss(this.inputFileType, true);
        SB sb = new SB();
        if (this.jtNIHInput != null) {
            this.jtNIHInput.setText("");
            this.jtLineFormula.setText("");
        }
        this.dialog.modelOrigin = 3;
        NBOUtil.postAddGlobalC(sb, "PATH", path);
        NBOUtil.postAddGlobalC(sb, "ESS", ess);
        NBOUtil.postAddGlobalC(sb, "FNAME", fname);
        NBOUtil.postAddGlobalC(sb, "IN_EXT", ext.toLowerCase());
        NBOUtil.postAddCmd(sb, "use");
        this.clearSelected(false);
        this.dialog.logCmd("use." + ess + " " + fname + "." + ext);
        this.postNBO(sb, 31, "Loading model from NBO...", null, null);
    }

    protected void saveModel(String path, String fname, String ext) {
        if (PT.isOneOf(ext, "xyz;mol")) {
            String s = this.vwr.getModelExtract("1.1", false, false, ext.toUpperCase());
            String ret = this.vwr.writeTextFile(path + "\\" + fname + "." + ext, s);
            this.dialog.logValue(ret);
            return;
        }
        String ess = this.getEss(this.saveFileType, false);
        SB sb = new SB();
        NBOUtil.postAddGlobalC(sb, "PATH", path);
        NBOUtil.postAddGlobalC(sb, "ESS", ess);
        NBOUtil.postAddGlobalC(sb, "FNAME", fname);
        NBOUtil.postAddGlobalC(sb, "OUT_EXT", ext.toLowerCase());
        NBOUtil.postAddCmd(sb, "save");
        this.postNBO(sb, 41, "Saving model...", null, null);
        this.dialog.logCmd("save." + ess + " " + fname);
        this.dialog.logValue("--Model Saved--<br>" + path + "\\" + fname + "." + ext);
    }

    String getEss(String ext, boolean isLoading) {
        if (((ext = ext.toLowerCase()).equals("gau") || ext.equals("g09") || ext.equals("com")) && !isLoading) {
            if (this.jComboSave.getSelectedItem().toString().contains("(C")) {
                return ext.charAt(0) + "c";
            }
            if (this.jComboSave.getSelectedItem().toString().contains("(z")) {
                return ext.charAt(0) + "z";
            }
            return "g";
        }
        if (ext.equals("cfi") || ext.equals("vfi") || ext.equals("gau") || ext.equals("log") || ext.equals("g09")) {
            return "" + ext.charAt(0);
        }
        if (ext.equals("47")) {
            return "a";
        }
        if (ext.equals("mm2")) {
            return "mm";
        }
        if (ext.equals("com")) {
            return "g";
        }
        return ext;
    }

    protected void notifyPick(int[] picked) {
        this.dialog.runScriptQueued("measure delete;" + (this.resetOnAtomClick ? "select none" : ""));
        if (this.resetOnAtomClick) {
            this.clearSelected(false);
        }
        this.resetOnAtomClick = false;
        if (this.boxCount == 0) {
            return;
        }
        String selected = " " + this.modelEditGetSelected() + " ";
        int at1 = picked[0];
        int at2 = picked[1];
        if (at2 == Integer.MIN_VALUE) {
            boolean isSelected = this.vwr.bsA().get(at1 - 1);
            if (isSelected) {
                selected = PT.rep(selected, " " + at1 + " ", " ").trim();
            } else {
                if (PT.getTokens(selected).length >= this.boxCount) {
                    this.clearSelected(true);
                    selected = "";
                }
                selected = selected + " " + at1;
            }
            this.doSetAtomBoxesFromSelection(selected, true);
        } else {
            if (this.boxCount != 2) {
                return;
            }
            this.clearSelected(true);
            this.notifyPick(new int[]{at1, Integer.MIN_VALUE});
            this.notifyPick(new int[]{at2, Integer.MIN_VALUE});
        }
    }

    protected void doSetAtomBoxesFromSelection(String selected, boolean setFocus) {
        if (selected == null) {
            selected = this.modelEditGetSelected();
        }
        String[] split = PT.getTokens(selected);
        for (int i = 0; i < this.atomNumBoxes.length; ++i) {
            this.atomNumBoxes[i].setText(i >= split.length ? "" : "  " + split[i]);
        }
        this.updateSelected(false, setFocus);
    }

    void setCurrentValue(String sval) {
        this.currVal.setText(sval.length() == 0 ? "pick atoms..." : "current value: " + sval);
    }

    protected void notifyFileLoaded() {
        String fileContents = this.dialog.getCFIData();
        if (this.notFromNBO) {
            this.notFromNBO = false;
            if (!this.loadLogFileForVibrate) {
                this.loadModelToNBO(fileContents, false);
            } else {
                this.loadLogFileForVibrate = false;
            }
            return;
        }
        if (this.loadLogFileForVibrate) {
            this.loadLogFileForVibrate = false;
        }
        this.dialog.runScriptQueued(";set fontscaling true;select _H; font label 10 arial plain 0.025;select !_H;font label 10 arial bold 0.025;select none;");
        this.dialog.doSetStructure(null);
        this.showComponents(true);
        this.innerEditBox.setVisible(true);
        if (this.vwr.ms.ac > 0 && fileContents != null) {
            this.undoStack.push(fileContents);
            if (this.undoStack.size() > 5) {
                this.undoStack.removeElementAt(0);
            }
        }
        this.undo.setEnabled(this.undoStack.size() > 1);
        this.redo.setEnabled(!this.redoStack.isEmpty());
        this.rebond.setEnabled(this.dialog.evaluateJmolString("{transitionMetal}").length() > 4);
        if (this.actionID == 4) {
            this.doModelAction(this.actionID);
        }
        if (this.showSelectedOnFileLoad) {
            this.updateSelected(false, true);
            this.showSelectedOnFileLoad = false;
        } else {
            this.dialog.runScriptQueued("select none; select on;refresh");
        }
    }

    void postNBO(SB sb, final int mode, String statusMessage, String fileName, String fileData) {
        final NBORequest req = new NBORequest();
        this.serverMode = mode;
        req.set(new Runnable(){

            @Override
            public void run() {
                NBOModel.this.processNBO(mode, req);
            }
        }, false, statusMessage, "m_cmd.txt", sb.toString(), fileName, fileData);
        this.dialog.nboService.postToNBO(req);
    }

    protected void processNBO(int mode, NBORequest req) {
        String s = req.getReply();
        if (s.trim().equals("")) {
            return;
        }
        boolean doClear = true;
        switch (mode) {
            case 0: {
                this.dialog.runScriptQueued("z = show('zoom');set refreshing false;x = {*}.xyz.all;load " + s + ";set fontscaling true;select _H; font label 10 arial plain 0.025;select !_H;font label 10 arial bold 0.025;select none;" + ";compare {*} @x rotate translate 0;script inline @z;set refreshing true");
                break;
            }
            case 6: 
            case 9: {
                doClear = false;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 21: 
            case 31: {
                if (s.length() == 0) {
                    this.dialog.logError("Return message from NBOServe was empty.");
                    return;
                }
                s = s + ";set fontscaling true;select _H; font label 10 arial plain 0.025;select !_H;font label 10 arial bold 0.025;select none;";
                s = ";load " + s;
                if (doClear) {
                    this.clearSelected(false);
                } else {
                    this.showSelectedOnFileLoad = true;
                }
                this.dialog.loadModelDataQueued(s);
                break;
            }
            case 41: {
                break;
            }
            case 51: {
                s = "load " + s + ";set fontscaling true;select _H; font label 10 arial plain 0.025;select !_H;font label 10 arial bold 0.025;select none;" + ";set refreshing true;";
                this.dialog.loadModelDataQueued(s);
                break;
            }
            case 61: {
                this.dialog.loadModelDataQueued(s + ";set fontscaling true;select _H; font label 10 arial plain 0.025;select !_H;font label 10 arial bold 0.025;select none;");
                break;
            }
            case 7: {
                String sval = s.trim();
                this.dialog.logValue(sval);
                this.setCurrentValue(sval);
                break;
            }
            case 11: {
                this.measures = "";
                this.processHBonds(s);
                break;
            }
            case 10: {
                String symmetry = s.substring(0, s.indexOf("\n"));
                this.dialog.logValue(symmetry);
                s = s.substring(s.indexOf("\n") + 1);
                s = "set refreshing false;load " + s + ";set fontscaling true;select _H; font label 10 arial plain 0.025;select !_H;font label 10 arial bold 0.025;select none;" + ";set refreshing true";
                this.showSelectedOnFileLoad = true;
                this.dialog.loadModelDataQueued(s);
                break;
            }
            case 12: {
                if (s.trim().equals("no data")) break;
                this.vibrate.setEnabled(true);
                this.vibrateData = s;
            }
        }
    }

    void processHBonds(String s) {
        double[] atomList = PT.parseDoubleArray(s);
        if (atomList.length == 0 || atomList[0] == 0.0) {
            return;
        }
        String script = "";
        for (int i = atomList.length % 2; i < atomList.length; i += 2) {
            int a1 = (int)atomList[i];
            int a2 = (int)atomList[i + 1];
            String a1a2 = " @" + a1 + " @" + a2;
            script = script + "measure ID m" + ("" + Math.random()).substring(2) + a1a2 + " radius 0.1 ' ';";
            this.dialog.logValue(this.dialog.evaluateJmolString("@" + a1 + ".atomName + '-' + @" + a2 + ".atomName + ' d='+ distance(" + a1a2 + ")"));
        }
        this.measures = this.measures + script;
        this.dialog.runScriptQueued(this.measures);
    }

    void postVibrateRequestToNBO(String path, String fname, String ext) {
        String vibrateCommand = "vibrate=" + fname + "." + ext;
        this.logFilePath = Paths.get(path, fname + "." + ext).toString();
        SB sb = new SB();
        NBOUtil.postAddCmd(sb, vibrateCommand);
        this.postNBO(sb, 12, "Checking Vibration", null, null);
    }
}

