/*
 * Decompiled with CFR 0.152.
 */
package jspecview.java;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.net.URL;
import jspecview.common.JSViewer;
import jspecview.java.AwtColor;
import org.jmol.api.PlatformViewer;

class Image {
    private static final DirectColorModel rgbColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
    private static final int[] sampleModelBitMasks = new int[]{0xFF0000, 65280, 255};

    Image() {
    }

    static Object createImage(Object data) {
        if (data instanceof URL) {
            return Toolkit.getDefaultToolkit().createImage((URL)data);
        }
        if (data instanceof String) {
            return Toolkit.getDefaultToolkit().createImage((String)data);
        }
        if (data instanceof byte[]) {
            return Toolkit.getDefaultToolkit().createImage((byte[])data);
        }
        return null;
    }

    static void waitForDisplay(PlatformViewer viewer, Object image) throws InterruptedException {
        Object display = null;
        MediaTracker mediaTracker = new MediaTracker(display);
        int rnd = (int)(Math.random() * 100000.0);
        mediaTracker.addImage((java.awt.Image)image, rnd);
        mediaTracker.waitForID(rnd);
    }

    static int getWidth(Object image) {
        return ((java.awt.Image)image).getWidth(null);
    }

    static int getHeight(Object image) {
        return ((java.awt.Image)image).getHeight(null);
    }

    static int[] grabPixels(Object imageobj, int width, int height, int[] pixels) {
        java.awt.Image image = (java.awt.Image)imageobj;
        PixelGrabber pixelGrabber = pixels == null ? new PixelGrabber(image, 0, 0, width, height, true) : new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException e) {
            return null;
        }
        return (int[])pixelGrabber.getPixels();
    }

    static int[] drawImageToBuffer(Object gOffscreen, Object imageOffscreen, Object imageobj, int width, int height, int bgcolor) {
        Graphics g = (Graphics)gOffscreen;
        java.awt.Image image = (java.awt.Image)imageobj;
        int width0 = image.getWidth(null);
        int height0 = image.getHeight(null);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(5, 1.0f));
            g.setColor(bgcolor == 0 ? new AwtColor(0, 0, 0, 0) : new AwtColor(bgcolor));
            g.fillRect(0, 0, width, height);
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 1.0f));
            g.drawImage(image, 0, 0, width, height, 0, 0, width0, height0, null);
        } else {
            g.clearRect(0, 0, width, height);
            g.drawImage(image, 0, 0, width, height, 0, 0, width0, height0, null);
        }
        return Image.grabPixels(imageOffscreen, width, height, null);
    }

    public static int[] getTextPixels(String text, org.jmol.util.Font font3d, Object gObj, Object image, int width, int height, int ascent) {
        Graphics g = (Graphics)gObj;
        g.setColor(Color.black);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.white);
        g.setFont((Font)font3d.font);
        g.drawString(text, 0, ascent);
        return Image.grabPixels(image, width, height, null);
    }

    static Object newBufferedImage(Object image, int w, int h) {
        return new BufferedImage(w, h, ((BufferedImage)image).getType());
    }

    static Object newBufferedImage(int w, int h) {
        return new BufferedImage(w, h, 2);
    }

    static Object allocateRgbImage(int windowWidth, int windowHeight, int[] pBuffer, int windowSize, boolean backgroundTransparent) {
        return new BufferedImage(rgbColorModel, Raster.createWritableRaster(new SinglePixelPackedSampleModel(3, windowWidth, windowHeight, sampleModelBitMasks), new DataBufferInt(pBuffer, windowSize), null), false, null);
    }

    static Object getStaticGraphics(Object image, boolean backgroundTransparent) {
        Graphics2D g2d = ((BufferedImage)image).createGraphics();
        if (!JSViewer.isJS) {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        }
        return g2d;
    }

    static Object getGraphics(Object image) {
        return ((java.awt.Image)image).getGraphics();
    }

    static void drawImage(Object g, Object img, int x, int y, int width, int height) {
        ((Graphics)g).drawImage((java.awt.Image)img, x, y, null);
    }

    static void flush(Object image) {
        if (!JSViewer.isJS) {
            ((java.awt.Image)image).flush();
        }
    }

    static void disposeGraphics(Object graphicForText) {
        ((Graphics)graphicForText).dispose();
    }
}

