/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javajs.util.Lst;
import javajs.util.PT;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import jspecview.api.JSVPanel;
import jspecview.api.ScriptInterface;
import jspecview.application.DisplaySchemesProcessor;
import jspecview.application.MainFrame;
import jspecview.common.ColorParameters;
import jspecview.common.JSVFileManager;
import jspecview.common.JSVersion;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.PanelNode;
import jspecview.common.Parameters;
import jspecview.common.ScriptToken;
import jspecview.common.Spectrum;
import jspecview.java.AwtFileHelper;
import jspecview.java.AwtMainPanel;
import jspecview.java.AwtPanel;
import jspecview.source.JDXSource;
import org.jmol.api.JSVInterface;
import org.jmol.api.JmolSyncInterface;
import org.jmol.util.Logger;

public class JSpecView
implements JSVInterface,
ScriptInterface {
    private MainFrame mainFrame;
    JSViewer vwr = new JSViewer(this, false, false);
    public String defaultDisplaySchemeName;
    private DisplaySchemesProcessor dsp;
    public JmolSyncInterface jmol;
    private JSVPanel prevPanel;
    private static String propertiesFileName = "jspecview.properties";

    public void setMainFrame(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public JSpecView(boolean hasDisplay, JSVInterface jmol) {
        JSVFileManager.setDocumentBase(this.vwr, null);
        this.vwr.mainPanel = new AwtMainPanel(new BorderLayout());
        if (hasDisplay) {
            this.mainFrame = new MainFrame(this, null, jmol == null ? this : jmol);
        } else {
            this.initHeadless();
        }
    }

    private void initHeadless() {
        this.dsp = this.getDisplaySchemesProcessor(this);
        this.setApplicationProperties(true);
    }

    public static void main(String[] args) {
        boolean noDisplay;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Logger.info("JSpecView Application " + JSVersion.VERSION);
        boolean autoexit = noDisplay = GraphicsEnvironment.isHeadless();
        int n = args.length;
        if (n > 0 && args[n - 1].equalsIgnoreCase("-exit")) {
            autoexit = true;
            --n;
        }
        if (n > 0 && args[n - 1].equalsIgnoreCase("-nodisplay")) {
            autoexit = true;
            noDisplay = true;
            --n;
        }
        if (autoexit) {
            System.out.println("JSpecview running headless");
        }
        if (noDisplay) {
            System.out.println("JSpecview has no display");
        }
        JSpecView jsv = new JSpecView(!noDisplay, null);
        if (n >= 2) {
            if (n == 2 && args[0].equalsIgnoreCase("-script")) {
                String script = args[1];
                System.out.println("JSpecView is running script " + script);
                jsv.vwr.runScriptNow(args[1]);
            } else {
                for (int i = 0; i < args.length; ++i) {
                    System.out.println("JSpecView is attempting to open " + args[i]);
                    jsv.vwr.openFile(args[i], false);
                }
            }
        }
        if (noDisplay || autoexit) {
            JSpecView.exitNow();
        }
        jsv.mainFrame.setVisible(true);
    }

    @Override
    public void runScript(String script) {
        this.vwr.runScriptNow(script);
    }

    @Override
    public void setProperties(Properties properties) {
        try {
            FileInputStream fileIn = new FileInputStream(propertiesFileName);
            properties.load(fileIn);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void saveProperties(Properties properties) {
        try {
            FileOutputStream fileOut = new FileOutputStream(propertiesFileName);
            properties.store(fileOut, "JSpecView Application Properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void exitJSpecView(boolean withDialog, Object frame) {
        if (!withDialog) {
            JSpecView.exitNow();
        }
        if (withDialog && JOptionPane.showConfirmDialog((Component)frame, "Exit JSpecView?", "Exit", 0, 3) != 0) {
            return;
        }
        JSpecView.exitNow();
    }

    private static void exitNow() {
        System.out.println("JSpecView exit");
        System.exit(0);
    }

    @Override
    public void siOpenDataOrFile(Object data, String name, Lst<Spectrum> specs, String url, int firstSpec, int lastSpec, boolean isAppend, String script, String id) {
        boolean isOne = this.vwr.currentSource == null;
        switch (name == null && url == null ? -3 : this.vwr.openDataOrFile(data, name, specs, url, firstSpec, lastSpec, isAppend, id)) {
            case 0: {
                if (script == null && isOne && this.vwr.currentSource.isCompoundSource && this.vwr.pd().getSpectrum().isGC()) {
                    script = "VIEW ALL;PEAK GC/MS ID=#1";
                }
                if (script == null) break;
                this.runScript(script);
                break;
            }
            case -3: {
                if (this.mainFrame == null) break;
                this.mainFrame.awaken(false);
                this.mainFrame.awaken(true);
                JOptionPane.showMessageDialog(this.mainFrame, "There was an error reading " + (name != null ? name : url));
            }
        }
        this.siValidateAndRepaint(false);
    }

    @Override
    public void siSetCurrentSource(JDXSource source) {
        this.vwr.currentSource = source;
        if (source != null && this.mainFrame != null) {
            this.mainFrame.appMenu.setCloseMenuItem(JSVFileManager.getTagName(source.getFilePath()));
        }
        boolean isError = source != null && source.getErrorLog().length() > 0;
        this.setError(isError, isError && source.getErrorLog().indexOf("Warning") >= 0);
    }

    private void setError(boolean isError, boolean isWarningOnly) {
        if (this.mainFrame != null) {
            this.mainFrame.setError(isError, isWarningOnly);
        }
    }

    @Override
    public void siSetPropertiesFromPreferences(JSVPanel jsvp, boolean includeMeasures) {
        ColorParameters ds = this.dsp.getDisplaySchemes().get(this.defaultDisplaySchemeName);
        jsvp.getPanelData().addListener(this.mainFrame);
        this.vwr.parameters.setFor(jsvp, ds == null ? this.dsp.getDefaultScheme() : ds, includeMeasures);
        this.vwr.checkAutoIntegrate();
        jsvp.doRepaint(true);
    }

    @Override
    public void siProcessCommand(String script) {
        this.runScriptNow(script);
    }

    @Override
    public void siSetSelectedPanel(JSVPanel jsvp) {
        if (this.mainFrame != null) {
            this.mainFrame.setSelectedPanel(jsvp);
        } else {
            this.vwr.mainPanel.setSelectedPanel(this.vwr, jsvp, this.vwr.panelNodes);
            this.vwr.selectedPanel = jsvp;
            this.vwr.spectraTree.setSelectedPanel(this, jsvp);
            if (jsvp != null) {
                jsvp.setEnabled(true);
                jsvp.setFocusable(true);
            }
        }
    }

    @Override
    public void siSendPanelChange() {
        if (this.vwr.selectedPanel == this.prevPanel) {
            return;
        }
        this.prevPanel = this.vwr.selectedPanel;
        this.vwr.sendPanelChange();
    }

    @Override
    public void siSyncLoad(String filePath) {
        this.vwr.closeSource(null);
        this.siOpenDataOrFile(null, null, null, filePath, -1, -1, false, null, null);
        if (this.vwr.currentSource == null) {
            return;
        }
        if (((PanelNode)this.vwr.panelNodes.get(0)).getSpectrum().isAutoOverlayFromJmolClick()) {
            this.vwr.execView("*", false);
        }
    }

    @Override
    public void siValidateAndRepaint(boolean isAll) {
        if (this.mainFrame != null) {
            this.mainFrame.validateAndRepaint(isAll);
        }
    }

    @Override
    public void siExecHidden(boolean b) {
        if (this.mainFrame != null) {
            this.mainFrame.execHidden(b);
        }
    }

    @Override
    public String siLoaded(String value) {
        PanelData pd = this.vwr.pd();
        return !pd.getSpectrum().is1D() && pd.getDisplay1D() ? "Click on the spectrum and use UP or DOWN keys to see subspectra." : null;
    }

    @Override
    public void siExecScriptComplete(String msg, boolean isOK) {
        this.vwr.requestRepaint();
        if (msg != null) {
            this.writeStatus(msg);
            if (msg.length() == 0) {
                msg = null;
            }
        }
    }

    @Override
    public void siExecSetCallback(ScriptToken st, String value) {
        if (this.mainFrame != null) {
            this.mainFrame.setCallback(st, value);
        }
    }

    @Override
    public void siUpdateBoolean(ScriptToken st, boolean TF) {
        if (this.mainFrame != null) {
            this.mainFrame.updateToolbar(st, TF);
        }
    }

    @Override
    public void siCheckCallbacks(String title) {
    }

    @Override
    public void siNodeSet(PanelNode panelNode) {
        this.siSetMenuEnables(panelNode, false);
        this.writeStatus("");
    }

    @Override
    public void siSourceClosed(JDXSource source) {
        this.setError(false, false);
        if (this.mainFrame != null) {
            this.mainFrame.sourceClosed(source);
        }
    }

    @Override
    public void siSetLoaded(String fileName, String filePath) {
        if (this.mainFrame != null) {
            this.mainFrame.setLoading(fileName, filePath);
        }
    }

    @Override
    public void siUpdateRecentMenus(String filePath) {
        if (this.mainFrame != null) {
            this.mainFrame.updateRecentMenus(filePath);
        }
    }

    @Override
    public void siSetMenuEnables(PanelNode node, boolean isSplit) {
        if (this.mainFrame != null) {
            this.mainFrame.setMenuEnables(node, isSplit);
        }
    }

    @Override
    public JSVPanel siGetNewJSVPanel(Spectrum spec) {
        return spec == null ? null : AwtPanel.getPanelOne(this.vwr, spec);
    }

    @Override
    public JSVPanel siGetNewJSVPanel2(Lst<Spectrum> specs) {
        return AwtPanel.getPanelMany(this.vwr, specs);
    }

    @Override
    public void siExecTest(String value) {
        System.out.println(PT.toJSON(null, this.vwr.getPropertyAsJavaObject(value)));
    }

    @Override
    public void siNewWindow(boolean isSelected, boolean fromFrame) {
    }

    @Override
    public synchronized void syncToJmol(String msg) {
        Logger.info("JSV>Jmol " + msg);
        if (this.jmol != null) {
            this.jmol.syncScript(msg);
            return;
        }
        if (this.mainFrame != null) {
            this.mainFrame.syncToJmol(msg);
        }
    }

    @Override
    public void repaint() {
        if (this.mainFrame != null) {
            this.mainFrame.repaint();
        }
    }

    @Override
    public void setCursor(int id) {
        if (this.mainFrame != null) {
            this.mainFrame.setCursor(id);
        }
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public boolean runScriptNow(String script) {
        return this.vwr.runScriptNow(script);
    }

    @Override
    public void writeStatus(String msg) {
        if (this.mainFrame != null) {
            this.mainFrame.writeStatus(msg);
        }
    }

    public DisplaySchemesProcessor getDisplaySchemesProcessor(JSVInterface jmolOrAdvancedApplet) {
        Properties properties = this.vwr.properties = new Properties();
        properties.setProperty("recentFilePaths", "");
        properties.setProperty("confirmBeforeExit", "true");
        properties.setProperty("automaticallyOverlay", "false");
        properties.setProperty("automaticallyShowLegend", "false");
        properties.setProperty("useDirectoryLastOpenedFile", "true");
        properties.setProperty("useDirectoryLastExportedFile", "false");
        properties.setProperty("directoryLastOpenedFile", "");
        properties.setProperty("directoryLastExportedFile", "");
        properties.setProperty("showSidePanel", "true");
        properties.setProperty("showToolBar", "true");
        properties.setProperty("showStatusBar", "true");
        properties.setProperty("defaultDisplaySchemeName", "Default");
        properties.setProperty("showGrid", "false");
        properties.setProperty("showCoordinates", "false");
        properties.setProperty("showXScale", "true");
        properties.setProperty("showYScale", "true");
        properties.setProperty("svgForInkscape", "false");
        properties.setProperty("automaticTAConversion", "false");
        properties.setProperty("AtoTSeparateWindow", "false");
        properties.setProperty("automaticallyIntegrate", "false");
        properties.setProperty("integralMinY", "0.1");
        properties.setProperty("integralFactor", "50");
        properties.setProperty("integralOffset", "30");
        properties.setProperty("integralPlotColor", "#ff0000");
        jmolOrAdvancedApplet.setProperties(properties);
        this.dsp = new DisplaySchemesProcessor();
        return this.dsp;
    }

    public void setApplicationProperties(boolean shouldApplySpectrumDisplaySettings) {
        Properties properties = this.vwr.properties;
        this.vwr.interfaceOverlaid = Boolean.parseBoolean(properties.getProperty("automaticallyOverlay"));
        this.vwr.autoShowLegend = Boolean.parseBoolean(properties.getProperty("automaticallyShowLegend"));
        AwtFileHelper fh = (AwtFileHelper)this.vwr.fileHelper;
        fh.useDirLastOpened = Boolean.parseBoolean(properties.getProperty("useDirectoryLastOpenedFile"));
        fh.useDirLastExported = Boolean.parseBoolean(properties.getProperty("useDirectoryLastExportedFile"));
        fh.dirLastOpened = properties.getProperty("directoryLastOpenedFile");
        fh.dirLastExported = properties.getProperty("directoryLastExportedFile");
        this.defaultDisplaySchemeName = properties.getProperty("defaultDisplaySchemeName");
        if (shouldApplySpectrumDisplaySettings) {
            this.vwr.parameters.setBoolean(ScriptToken.GRIDON, Parameters.isTrue(properties.getProperty("showGrid")));
            this.vwr.parameters.setBoolean(ScriptToken.COORDINATESON, Parameters.isTrue(properties.getProperty("showCoordinates")));
            this.vwr.parameters.setBoolean(ScriptToken.XSCALEON, Parameters.isTrue(properties.getProperty("showXScale")));
            this.vwr.parameters.setBoolean(ScriptToken.YSCALEON, Parameters.isTrue(properties.getProperty("showYScale")));
        }
        this.vwr.setIRmode(properties.getProperty("automaticTAConversion"));
        try {
            this.vwr.autoIntegrate = Boolean.parseBoolean(properties.getProperty("automaticallyIntegrate"));
            this.vwr.parameters.integralMinY = JSpecView.parseDoubleSafely(properties.getProperty("integralMinY"), this.vwr.parameters.integralMinY);
            this.vwr.parameters.integralRange = JSpecView.parseDoubleSafely(properties.getProperty("integralRange"), this.vwr.parameters.integralRange);
            this.vwr.parameters.integralOffset = JSpecView.parseDoubleSafely(properties.getProperty("integralOffset"), this.vwr.parameters.integralOffset);
            this.vwr.parameters.set(null, ScriptToken.INTEGRALPLOTCOLOR, properties.getProperty("integralPlotColor"));
        }
        catch (Exception e) {
            System.err.println("Bad PropertyValue ");
            e.printStackTrace();
        }
    }

    private static double parseDoubleSafely(String sval, double defVal) {
        return sval == null ? defVal : Double.parseDouble(sval);
    }
}

