/*
 * Decompiled with CFR 0.152.
 */
package jme.io;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.List;

public class FileDropper
implements DropTargetListener {
    public static final String PROPERTY_FILEDROPPER_INLINE = "FileDropper.inline";
    public static final String PROPERTY_FILEDROPPER_FILE = "FileDropper.file";
    public static DataFlavor uriDrop;
    private PropertyChangeSupport fd_propSupport = new PropertyChangeSupport(this);
    private PropertyChangeListener pcl;

    public FileDropper(PropertyChangeListener fileDropListener) {
        this.addPropertyChangeListener(fileDropListener);
        this.pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("inline")) {
                    FileDropper.this.loadInline(evt.getNewValue());
                }
            }
        };
        this.addPropertyChangeListener(this.pcl);
        Component receiver = (Component)((Object)fileDropListener);
        receiver.setDropTarget(new DropTarget(receiver, this));
    }

    public void dispose() {
        this.removePropertyChangeListener(this.pcl);
        this.pcl = null;
        this.fd_propSupport.removePropertyChangeListener(null);
        this.fd_propSupport = null;
    }

    private void loadFile(String fname) {
        this.fd_propSupport.firePropertyChange(PROPERTY_FILEDROPPER_FILE, null, fname);
    }

    private void loadInline(Object content) {
        this.fd_propSupport.firePropertyChange(PROPERTY_FILEDROPPER_INLINE, null, content);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.fd_propSupport.addPropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.fd_propSupport.removePropertyChangeListener(l);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(3);
    }

    @Override
    public void dragExit(DropTargetEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        DataFlavor[] df;
        boolean isAccepted;
        Transferable t;
        block15: {
            System.out.println("FileDropper? " + dtde.getDropTargetContext().getComponent());
            t = dtde.getTransferable();
            isAccepted = false;
            if (uriDrop != null && t.isDataFlavorSupported(uriDrop) && this.doURIDrop(t, dtde, isAccepted, uriDrop)) {
                return;
            }
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                Object o = null;
                try {
                    dtde.acceptDrop(3);
                    o = t.getTransferData(DataFlavor.javaFileListFlavor);
                    isAccepted = true;
                    if (!(o instanceof List)) break block15;
                    List fileList = (List)o;
                    int length = fileList.size();
                    if (length >= 1) {
                        String fileName = ((File)fileList.get(0)).getAbsolutePath().trim();
                        if (!fileName.endsWith(".URL")) {
                            dtde.getDropTargetContext().dropComplete(true);
                            this.loadFile(fileName);
                            return;
                        }
                        break block15;
                    }
                    dtde.getDropTargetContext().dropComplete(true);
                    return;
                }
                catch (Exception e) {
                    System.err.println("jme.FileDropper failed " + e);
                }
            }
        }
        if ((df = t.getTransferDataFlavors()) == null || df.length == 0) {
            return;
        }
        for (int i = 0; i < df.length; ++i) {
            DataFlavor flavor = df[i];
            Object o = null;
            String mimeType = flavor.getMimeType();
            if (mimeType.startsWith("text/uri-list") && flavor.getRepresentationClass().getName().equals("java.lang.String")) {
                uriDrop = flavor;
                if (!this.doURIDrop(t, dtde, isAccepted, flavor)) continue;
                return;
            }
            if (!mimeType.equals("application/x-java-serialized-object; class=java.lang.String") && !mimeType.startsWith("text/plain;")) continue;
            try {
                if (!isAccepted) {
                    dtde.acceptDrop(3);
                }
                isAccepted = true;
                o = t.getTransferData(df[i]);
            }
            catch (Exception e) {
                System.err.println("D.....");
            }
            if (!(o instanceof String)) continue;
            String content = (String)o;
            if (content.startsWith("file:/")) {
                this.loadFile(content);
            } else {
                this.loadInline(content);
            }
            dtde.getDropTargetContext().dropComplete(true);
            return;
        }
        if (!isAccepted) {
            dtde.rejectDrop();
        }
    }

    private boolean doURIDrop(Transferable t, DropTargetDropEvent dtde, boolean isAccepted, DataFlavor flavor) {
        try {
            if (!isAccepted) {
                dtde.acceptDrop(3);
            }
            isAccepted = true;
            Object o = t.getTransferData(flavor);
            if (o instanceof String) {
                System.err.println("jme.FileDropper drop for " + o);
                this.loadFile(o.toString());
                dtde.getDropTargetContext().dropComplete(true);
                return true;
            }
        }
        catch (Exception e) {
            System.err.println("jme.FileDropper failed drop for " + flavor);
        }
        return false;
    }
}

