/*
 * Decompiled with CFR 0.152.
 */
package jme.io;

import jme.util.JMEUtil;

public class ChemicalMimeType {
    public static String typeName = "chemical";
    public static String url = "http://www.ch.ic.ac.uk/chemime/";
    public static String molfile = "x-mdl-molfile";

    private ChemicalMimeType() {
    }

    public static String molfile(String separator) {
        return typeName + separator + molfile;
    }

    public static String chemicalMimeTag() {
        return ChemicalMimeType.molfile(":");
    }

    public static String extractEmbeddedChemicalString(String svg) {
        String result = null;
        String tag = ChemicalMimeType.chemicalMimeTag();
        int tagStart = svg.indexOf(tag);
        if (tagStart > 0) {
            int molStart = svg.indexOf(">", tagStart) + 1;
            int molEnd = svg.indexOf("</" + tag, molStart);
            if (molEnd - molStart > 20) {
                result = svg.substring(molStart, molEnd);
            }
        }
        if (result == null) {
            return null;
        }
        if (result.indexOf(10) < 0) {
            result = result.replaceAll("\\\n", "\n");
        }
        return JMEUtil.unwrapCData(result);
    }

    public static String additionalNameSpaces(String post) {
        return "xmlns:" + typeName + "=\"" + url + "\"" + post;
    }
}

