/*
 * Decompiled with CFR 0.152.
 */
package jme.event;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import jme.JME;
import jme.JMEmol;
import jme.event.ChangeAtomPropertyCallback;
import jme.gui.AtomInspector;

public class InspectorEvent
implements ActionListener {
    public JME jme;
    public JMEmol mol;
    public int atomIndex;
    public int bondIndex;
    public int molIndex;
    public int x;
    public int y;

    public InspectorEvent(JME jme) {
        this.jme = jme;
    }

    public void reset() {
        this.mol = null;
        this.y = 0;
        this.x = 0;
        this.bondIndex = 0;
        this.atomIndex = 0;
        this.molIndex = 0;
    }

    protected int getAtomMap() {
        return this.mol.findAtomMapForOutput(this.atomIndex);
    }

    protected int getAtomCharge() {
        return this.mol.findAtomChargeForOutput(this.atomIndex);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SwingUtilities.invokeLater(() -> {
            String actionType;
            ChangeAtomPropertyCallback change = null;
            if (e.getActionCommand() == JME.changeAtomMapAction || e.getActionCommand() == JME.changeAtomMarkAction) {
                actionType = e.getActionCommand() == JME.changeAtomMapAction ? "map" : "mark";
                change = new ChangeAtomPropertyCallback(){

                    @Override
                    public void setAtomValue(int newValue) {
                        InspectorEvent.this.changeAtomMap(newValue);
                    }

                    @Override
                    public int getAtomValue() {
                        return InspectorEvent.this.getAtomMap();
                    }

                    @Override
                    public String actionType() {
                        return actionType;
                    }

                    @Override
                    public void reportError(String errorMessage) {
                        InspectorEvent.this.showError(errorMessage);
                    }

                    @Override
                    public void finished() {
                        InspectorEvent.this.jme.setAtomToHighLight(InspectorEvent.this.molIndex, 0);
                        InspectorEvent.this.jme.requestFocusInWindow();
                    }
                };
            } else if (e.getActionCommand() == JME.changeAtomChargeAction) {
                actionType = "charge";
                change = new ChangeAtomPropertyCallback(){

                    @Override
                    public void setAtomValue(int newValue) {
                        InspectorEvent.this.changeAtomCharge(newValue);
                    }

                    @Override
                    public int getAtomValue() {
                        return InspectorEvent.this.getAtomCharge();
                    }

                    @Override
                    public String actionType() {
                        return actionType;
                    }

                    @Override
                    public void reportError(String errorMessage) {
                        InspectorEvent.this.showError(errorMessage);
                    }

                    @Override
                    public void finished() {
                        InspectorEvent.this.jme.setAtomToHighLight(InspectorEvent.this.molIndex, 0);
                        InspectorEvent.this.jme.requestFocusInWindow();
                    }
                };
            }
            if (change != null) {
                change.atomSymbol = this.mol.getAtomLabel(this.atomIndex);
                AtomInspector atomInspector = new AtomInspector(change);
                this.jme.setAtomToHighLight(this.molIndex, this.atomIndex);
                atomInspector.action(this);
            }
        });
    }

    protected void changeAtomMap(int newMap) {
        if (newMap >= 0) {
            this.jme.changeAtomMap(this.mol, this.atomIndex, newMap);
        } else {
            this.showError("Atom map or mark should be positive");
        }
    }

    protected void changeAtomCharge(int newCharge) {
        this.jme.changeAtomCharge(this.mol, this.atomIndex, newCharge);
    }

    public void showError(String message) {
        this.jme.showError(message);
    }
}

