/*
 * Decompiled with CFR 0.152.
 */
package jme.canvas;

import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import jme.canvas.Graphical2DObject;
import jme.canvas.PreciseGraphicsAWT;
import jme.util.Box;

public class ReactionArrow
implements Graphical2DObject {
    double arrowWidth = 48.0;
    double centerX = 0.0;
    double centerY = 0.0;
    public boolean hasBeenPlaced = false;
    Rectangle2D.Double boundingBox;
    Line2D.Double horizontalLine = new Line2D.Double();
    Line2D.Double topTipLine = new Line2D.Double();
    Line2D.Double bottomTipLine = new Line2D.Double();
    Line2D.Double[] lines = new Line2D.Double[]{this.horizontalLine, this.topTipLine, this.bottomTipLine};

    public ReactionArrow(double size) {
        this.boundingBox = new Rectangle2D.Double();
        this.arrowWidth = size;
    }

    public double width() {
        return this.arrowWidth;
    }

    @Override
    public void draw(PreciseGraphicsAWT og) {
        double m = this.arrowHeigth() / 2.0;
        og.setColor(Color.magenta);
        double xLeft = this.centerX - this.arrowWidth / 2.0;
        double xRight = this.centerX + this.arrowWidth / 2.0;
        this.horizontalLine.setLine(xLeft, this.centerY, xRight, this.centerY);
        this.topTipLine.setLine(xRight, this.centerY, xRight - m, this.centerY + m);
        this.bottomTipLine.setLine(xRight, this.centerY, xRight - m, this.centerY - m);
        for (Line2D.Double eachLine : this.lines) {
            og.drawLine(eachLine.x1, eachLine.y1, eachLine.x2, eachLine.y2);
        }
    }

    protected double arrowHeigth() {
        return this.arrowWidth / 4.0;
    }

    public void XY(double x, double y) {
        this.hasBeenPlaced = true;
        this.centerX = x;
        this.centerY = y;
    }

    @Override
    public void moveXY(double moveX, double moveY) {
        this.hasBeenPlaced = true;
        this.centerX += moveX;
        this.centerY += moveY;
    }

    public Rectangle2D.Double updateBoundingBox() {
        this.boundingBox.setRect(this.centerX - this.arrowWidth / 2.0, this.centerY() + this.arrowHeigth() / 2.0, this.arrowWidth, this.arrowHeigth());
        return this.boundingBox;
    }

    @Override
    public Rectangle2D.Double computeBoundingBoxWithAtomLabels(Rectangle2D.Double union) {
        this.updateBoundingBox();
        if (union != null) {
            return Box.createUnion(this.boundingBox, union, union);
        }
        union = new Rectangle2D.Double();
        union.setFrame(this.boundingBox);
        return union;
    }

    @Override
    public double centerX() {
        return this.centerX;
    }

    @Override
    public double centerY() {
        return this.centerY;
    }

    @Override
    public double closestDistance(double x, double y) {
        double min = Double.MAX_VALUE;
        for (Line2D.Double eachLine : this.lines) {
            double d = Graphical2DObject.closestDistancePointToLine(x, y, eachLine);
            min = Math.min(d, min);
        }
        return min;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

