/*
 * Decompiled with CFR 0.152.
 */
package jme.canvas;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import jme.JME;

public class PreciseGraphicsAWT {
    static BasicStroke defaultStroke = new BasicStroke(1.0f);
    public Graphics2D baseGraphics;
    ExtendedGraphics2D extendedBaseGraphics;
    protected double scale = 1.0;
    protected Font unscaledFont;
    protected Font enlargeddFont;
    protected BasicStroke unscaledStroke;
    protected BasicStroke enlargedStroke;
    protected Color colorOverride = null;
    protected Color defaultBackGroundColor = null;
    protected Color savedColor = null;
    Rectangle2D.Double screenArea = new Rectangle2D.Double();

    public double getWidth() {
        return this.screenArea.width / this.scale;
    }

    public double getHeight() {
        return this.screenArea.height / this.scale;
    }

    void setDrawOnScreenCoordinates(int x, int y) {
        this.screenArea.x = x;
        this.screenArea.y = y;
    }

    public void setDrawOnScreenCoordinates(Rectangle2D.Double screenArea) {
        this.screenArea.x = screenArea.x;
        this.screenArea.y = screenArea.y;
        this.screenArea.height = screenArea.height;
        this.screenArea.width = screenArea.width;
    }

    void setDrawOnScreenCoordinates(int x, int y, int width, int height) {
        this.screenArea.x = x;
        this.screenArea.y = y;
        this.screenArea.height = height;
        this.screenArea.width = width;
    }

    public int screenX() {
        return (int)this.screenArea.x;
    }

    public int screenY() {
        return (int)this.screenArea.y;
    }

    double screenToCoord(int pixel) {
        return (double)pixel / this.scale;
    }

    public int coordToScreen(double coord) {
        return (int)(coord * this.scale + 0.5);
    }

    public double screenToCoordX(int x) {
        return this.screenToCoord(x - (int)this.screenArea.x);
    }

    public double screenToCoordY(int y) {
        return this.screenToCoord(y - (int)this.screenArea.y);
    }

    public double currentZoomFactor() {
        return this.scale;
    }

    public PreciseGraphicsAWT(Graphics graphics) {
        this.baseGraphics = (Graphics2D)graphics;
        if (JME.precision > 1.0) {
            this.setStroke(defaultStroke);
        }
        this.extendedBaseGraphics = new ExtendedGraphics2D();
    }

    public void initPrecisionScale() {
        this.initPrecisionScale(1.0);
    }

    public void initPrecisionScale(double absoluteScale) {
        if (absoluteScale != this.scale) {
            double transformScale = absoluteScale / this.scale;
            this.baseGraphics.scale(transformScale / JME.precision, transformScale / JME.precision);
            this.scale = absoluteScale;
        }
    }

    public Graphics2D getGraphics() {
        return this.baseGraphics;
    }

    public Color getDefaultBackGroundColor() {
        return this.defaultBackGroundColor;
    }

    public void setDefaultBackGroundColor(Color backGroundColor) {
        this.defaultBackGroundColor = backGroundColor;
    }

    public void setBackGroundColor() {
        this.setColor(this.defaultBackGroundColor);
    }

    public void overrideColor(Color color) {
        this.colorOverride = color;
        this.savedColor = this.baseGraphics.getColor();
        this.baseGraphics.setColor(color);
    }

    public void resetOverrideColor() {
        this.colorOverride = null;
        this.baseGraphics.setColor(this.savedColor);
    }

    public void setColor(Color color) {
        if (this.colorOverride == null) {
            this.baseGraphics.setColor(color);
        } else if (color == this.defaultBackGroundColor || color.equals(this.defaultBackGroundColor)) {
            this.baseGraphics.setColor(this.defaultBackGroundColor);
        } else {
            this.baseGraphics.setColor(this.colorOverride);
        }
    }

    public void fillRect(double x, double y, double width, double height) {
        this.baseGraphics.fillRect(this.r(x), this.r(y), this.r(width), this.r(height));
    }

    public void fillRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        this.baseGraphics.fillRoundRect(this.r(x), this.r(y), this.r(width), this.r(height), this.r(arcWidth), this.r(arcHeight));
    }

    public void fill3DRect(double x, double y, double width, double height, boolean raised) {
        Color colorDown;
        Color colorUp;
        Paint savedPaint = this.baseGraphics.getPaint();
        Color color = this.baseGraphics.getColor();
        if (raised) {
            colorUp = color.brighter();
            colorDown = color.darker();
            this.baseGraphics.setColor(color);
        } else {
            colorUp = color.darker();
            colorDown = color.brighter();
            this.baseGraphics.setColor(colorUp);
        }
        int border = this.r(1.0);
        int widthInt = this.r(width);
        int heightInt = this.r(height);
        int xInt = this.r(x);
        int yInt = this.r(y);
        this.baseGraphics.fillRect(xInt + border, yInt + border, (widthInt -= border) - border, (heightInt -= border) - border);
        this.baseGraphics.setColor(colorUp);
        this.baseGraphics.fillRect(xInt, yInt, widthInt, border);
        this.baseGraphics.fillRect(xInt, yInt + border, border, heightInt);
        this.baseGraphics.setColor(colorDown);
        this.baseGraphics.fillRect(xInt + widthInt, yInt, border, heightInt + border);
        this.baseGraphics.fillRect(xInt + 1, yInt + heightInt, widthInt, border);
        this.baseGraphics.setPaint(savedPaint);
    }

    public void drawRect(double x, double y, double width, double height) {
        this.baseGraphics.drawRect(this.r(x), this.r(y), this.r(width), this.r(height));
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.baseGraphics.drawLine(this.r(x1), this.r(y1), this.r(x2), this.r(y2));
    }

    public void setFont(Font font) {
        if (this.unscaledFont == font) {
            return;
        }
        this.unscaledFont = font;
        this.enlargeddFont = font.deriveFont((float)((double)font.getSize() * JME.precision));
        this.baseGraphics.setFont(this.enlargeddFont);
    }

    public void drawString(String str, double x, double y) {
        this.baseGraphics.drawString(str, this.r(x), this.r(y));
    }

    public void drawStringWithStroke(String str, double x, double y, Color strokeColor, double strokeWidth) {
        this.extendedBaseGraphics.drawStringWithStroke(str, this.r(x), this.r(y), strokeColor, this.r(strokeWidth));
    }

    public void drawStringWithStrokeAndBaselineShifts(String str, double x, double y, Color strokeColor, double strokeWidth, int[][] subscripts, int[][] superscript) {
        this.extendedBaseGraphics.drawStringWithStrokeAndBaselineShifts(str, this.r(x), this.r(y), strokeColor, this.r(strokeWidth), subscripts, superscript);
    }

    protected int r(double v) {
        return (int)Math.round(v * JME.precision);
    }

    protected double ir(int v) {
        return (double)v / JME.precision;
    }

    public void fillOval(double x, double y, double width, double height) {
        this.baseGraphics.fillOval(this.r(x), this.r(y), this.r(width), this.r(height));
    }

    public void drawOval(double x, double y, double width, double height) {
        this.baseGraphics.drawOval(this.r(x), this.r(y), this.r(width), this.r(height));
    }

    public void drawArc(double x, double y, double width, double height, double startAngle, double arcAngle) {
        this.baseGraphics.drawArc(this.r(x), this.r(y), this.r(width), this.r(height), (int)Math.round(startAngle), (int)Math.round(arcAngle));
    }

    public void translate(double x, double y) {
        this.baseGraphics.translate(this.r(x), this.r(y));
    }

    public void drawPolygon(double[] xPoints, double[] yPoints, int nPoints) {
        int[] xPointsInt = new int[nPoints];
        int[] yPointsInt = new int[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            xPointsInt[i] = this.r(xPoints[i]);
            yPointsInt[i] = this.r(yPoints[i]);
        }
        this.baseGraphics.drawPolygon(xPointsInt, yPointsInt, nPoints);
    }

    public void fillPolygon(double[] xPoints, double[] yPoints, int nPoints) {
        int[] xPointsInt = new int[nPoints];
        int[] yPointsInt = new int[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            xPointsInt[i] = this.r(xPoints[i]);
            yPointsInt[i] = this.r(yPoints[i]);
        }
        this.baseGraphics.fillPolygon(xPointsInt, yPointsInt, nPoints);
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.baseGraphics.setRenderingHint(hintKey, hintValue);
    }

    public void setStroke(BasicStroke basicStroke) {
        this.unscaledStroke = basicStroke;
        this.enlargedStroke = new BasicStroke((float)(JME.precision * (double)basicStroke.getLineWidth()));
        this.baseGraphics.setStroke(this.enlargedStroke);
    }

    public class ExtendedGraphics2D {
        public void drawStringWithStroke(String str, int x, int y, Color strokeColor, int strokeWidth) {
            PreciseGraphicsAWT.this.baseGraphics.drawString(str, x, y);
        }

        public void drawStringWithStrokeAndBaselineShifts(String str, int x, int y, Color strokeColor, int strokeWidth, int[][] subscripts, int[][] superscript) {
            PreciseGraphicsAWT.this.baseGraphics.drawString(str, x, y);
        }
    }
}

