/*
 * Decompiled with CFR 0.152.
 */
package jme.canvas;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import jme.canvas.Graphical2DObject;
import jme.canvas.PreciseGraphicsAWT;
import jme.util.Box;

public class Graphical2DObjectGroup<T extends Graphical2DObject>
implements Graphical2DObject {
    public ArrayList<T> group;

    public Graphical2DObjectGroup() {
        this.group = new ArrayList();
    }

    public Graphical2DObjectGroup(ArrayList<T> initGroup) {
        this.group = new ArrayList<T>(initGroup);
    }

    @Override
    public void draw(PreciseGraphicsAWT og) {
        for (Graphical2DObject go : this.group) {
            go.draw(og);
        }
    }

    @Override
    public void moveXY(double movex, double movey) {
        for (Graphical2DObject go : this.group) {
            go.moveXY(movex, movey);
        }
    }

    @Override
    public Rectangle2D.Double computeBoundingBoxWithAtomLabels(Rectangle2D.Double union) {
        for (Graphical2DObject go : this.group) {
            union = go.computeBoundingBoxWithAtomLabels(union);
        }
        return union;
    }

    @Override
    public double centerX() {
        double center = 0.0;
        for (Graphical2DObject go : this.group) {
            center += go.centerX();
        }
        if (this.group.size() > 0) {
            center /= (double)this.group.size();
        }
        return center;
    }

    @Override
    public double centerY() {
        double center = 0.0;
        for (Graphical2DObject go : this.group) {
            center += go.centerY();
        }
        if (this.group.size() > 0) {
            center /= (double)this.group.size();
        }
        return center;
    }

    public void alignCenter(Box.Axis xOrY) {
        double groupCenter = Graphical2DObject.center(this, xOrY);
        for (Graphical2DObject go : this.group) {
            double delta = groupCenter - Graphical2DObject.center(go, xOrY);
            Graphical2DObject.move(go, xOrY, delta);
        }
    }

    @Override
    public double closestDistance(double x, double y) {
        double min = Double.MAX_VALUE;
        for (Graphical2DObject go : this.group) {
            min = Math.min(min, go.closestDistance(x, y));
        }
        return min;
    }

    public void add(T element) {
        this.group.add(element);
    }

    public void add(int pos, T element) {
        this.group.add(pos, element);
    }

    public int size() {
        return this.group.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void distributePositions(Box.Axis xOrY, double margin) {
        this.distributePositions(xOrY, margin, true);
    }

    public void distributePositions(final Box.Axis xOrY, double margin, boolean keepXorYorder) {
        if (this.size() <= 1) {
            return;
        }
        Graphical2DObjectGroup<T> sorted = new Graphical2DObjectGroup<T>();
        sorted.addAll(this);
        sorted.removeNoSizeObjects();
        if (sorted.size() <= 1) {
            return;
        }
        double beforeAlignCenter = Graphical2DObject.center(sorted, xOrY);
        if (keepXorYorder) {
            Collections.sort(sorted.group, new Comparator<T>(){

                @Override
                public int compare(T m1, T m2) {
                    double x2 = Box.get(m1.computeBoundingBoxWithAtomLabels(null), xOrY);
                    double x1 = Box.get(m2.computeBoundingBoxWithAtomLabels(null), xOrY);
                    return x1 > x2 ? -1 : (x2 < x1 ? 1 : 0);
                }
            });
        }
        double sumMove = 0.0;
        for (Graphical2DObject mol : sorted.group) {
            Rectangle2D.Double moleculeBox = mol.computeBoundingBoxWithAtomLabels(null);
            double move = sumMove - Box.get(moleculeBox, xOrY);
            Graphical2DObject.move(mol, xOrY, move);
            sumMove += Box.getDim(moleculeBox, xOrY) + margin;
        }
        double afterAlignCenter = Graphical2DObject.center(sorted, xOrY);
        Graphical2DObject.move(sorted, xOrY, beforeAlignCenter - afterAlignCenter);
        assert (Math.abs(beforeAlignCenter - Graphical2DObject.center(sorted, xOrY)) < 0.001);
    }

    boolean removeNoSizeObjects() {
        Graphical2DObjectGroup<Graphical2DObject> emptyList = new Graphical2DObjectGroup<Graphical2DObject>();
        for (Graphical2DObject mol : this.group) {
            Rectangle2D.Double moleculeBox = mol.computeBoundingBoxWithAtomLabels(null);
            if (moleculeBox != null && !moleculeBox.isEmpty()) continue;
            emptyList.add(mol);
        }
        for (Graphical2DObject mol : emptyList.group) {
            this.group.remove(mol);
        }
        return emptyList.size() > 0;
    }

    public void addAll(Graphical2DObjectGroup<T> graphical2dObjectGroup) {
        this.addAll(graphical2dObjectGroup.group);
    }

    public void addAll(ArrayList<T> graphical2dObjectList) {
        this.group.addAll(graphical2dObjectList);
    }
}

