/*
 * Decompiled with CFR 0.152.
 */
package jme;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.StringTokenizer;
import jme.JME;
import jme.canvas.ColorManager;
import jme.canvas.Graphical2DObject;
import jme.canvas.PreciseGraphicsAWT;
import jme.core.Atom;
import jme.core.AtomBondCommon;
import jme.core.Bond;
import jme.core.JMECore;
import jme.core.JMESmiles;
import jme.event.JMEStatusListener;
import jme.gui.AtomDisplayLabel;
import jme.gui.GUI;
import jme.io.JMEReader;
import jme.io.JMEWriter;
import jme.ocl.OclAdapter;
import jme.util.Box;
import jme.util.JMEUtil;

public class JMEmol
extends JMECore
implements Graphical2DObject {
    static final boolean doTags = false;
    public JME jme;
    public int[] chain = new int[101];
    public int touchedAtom = 0;
    public int touchedBond = 0;
    public int touched_org = 0;
    public double xorg;
    public double yorg;
    public int nchain;
    boolean stopChain = false;
    boolean needRecentering = false;
    boolean isQuery = false;
    Color uniColor = null;
    private int reactionRole = 0;
    protected boolean mixPastelBackGroundColors = true;
    private double centerx = Double.NaN;
    private double centery;
    private AtomDisplayLabel[] atomLabels;
    private GUI.RingInfo ringInfo;
    private boolean haveMultipleBonds;
    public static final int NAV_UP = 1;
    public static final int NAV_DOWN = 2;
    public static final int NAV_LEFT = 3;
    public static final int NAV_RIGHT = 4;

    public JMEmol() {
        this(null, (JMECore.Parameters)null);
    }

    public JMEmol(JMECore.Parameters pars) {
        this(null, pars);
    }

    public JMEmol(JME jme, JMECore.Parameters pars) {
        super((JMEStatusListener)jme, pars);
        this.jme = jme;
    }

    JMEmol(JMEmol m) {
        super(m);
        this.jme = m.jme;
        this.haveMultipleBonds = m.haveMultipleBonds;
        this.reactionRole = m.reactionRole;
        this.ringInfo = m.ringInfo;
    }

    public JMEmol(JME jme, JMEmol[] mols) {
        super((JMEStatusListener)jme, mols);
        this.jme = jme;
        if (mols.length > 0) {
            this.reactionRole = mols[0].reactionRole;
        }
    }

    public JMEmol(JME jme, JMEmol m, int part) {
        super(jme, m, part);
        this.jme = jme;
        this.reactionRole = m.reactionRole;
        this.ringInfo = m.ringInfo;
    }

    public JMEmol(JME jme, JMEmol m, int part, Object NOT_USED) {
        this(jme, m.parameters);
        this.setPart(m, part);
    }

    public JMEmol(JME jme, Object molecule, JMEReader.SupportedInputFileFormat type, JMECore.Parameters pars) throws Exception {
        this(jme, pars);
        if (molecule == null) {
            return;
        }
        switch (type) {
            case JME: {
                this.createFromJMEString((String)molecule);
                break;
            }
            case MOL: {
                this.createFromMOLString((String)molecule);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized format");
            }
        }
    }

    public String createJMEString(Rectangle2D.Double boundingBox) {
        return JMEWriter.createJMEString(this, false, boundingBox);
    }

    private void createFromJMEString(String jmeString) {
        JMEReader.createMolFromString(this, jmeString);
    }

    private void createFromMOLString(String molData) {
        JMEReader.createMolFromMolData(this, molData);
    }

    public static JMEmol mergeMols(ArrayList<JMEmol> mols) {
        return mols.size() == 0 ? new JMEmol() : new JMEmol(mols.get((int)0).jme, mols.toArray(new JMEmol[mols.size()]));
    }

    protected Color setPresetPastelBackGroundColor(PreciseGraphicsAWT og, int ab, boolean isAtom) {
        Color color;
        Atom atom;
        AtomBondCommon atomOrBond;
        int[] colors = new int[1];
        boolean colorIsSet = false;
        boolean showMappingNumbers = this.parameters.number;
        boolean showColorMark = this.parameters.mark;
        boolean showAtomMapNumberWithBackgroundColor = this.parameters.showAtomMapNumberWithBackgroundColor;
        AtomBondCommon atomBondCommon = atomOrBond = isAtom ? this.atoms[ab] : this.bonds[ab];
        if (showMappingNumbers && showAtomMapNumberWithBackgroundColor && isAtom && (atom = this.atoms[ab]).isMapped()) {
            int map;
            int max_map = this.jme.colorManager.numberOfBackgroundColors();
            for (map = atom.getMap(); map > max_map; map -= max_map) {
            }
            colors[0] = map;
            colorIsSet = true;
        }
        if (!colorIsSet && showColorMark && atomOrBond.isMarked()) {
            colors[0] = atomOrBond.getMark();
            colorIsSet = true;
        }
        if (!colorIsSet) {
            colors = isAtom ? this.getAtomBackgroundColors(ab) : this.getBondBackgroundColors(ab);
        }
        Color color2 = color = colors != null && colors.length > 0 ? this.jme.colorManager.averageColor(colors) : null;
        if (color != null) {
            og.setColor(color);
        }
        return color;
    }

    public void forceUniColor(Color color) {
        this.uniColor = color;
    }

    public void resetForceUniColor() {
        this.uniColor = null;
    }

    public int getReactionRole() {
        return this.reactionRole;
    }

    public void setReactionRole(int reactionRole) {
        this.reactionRole = reactionRole;
    }

    public void center() {
        this.center(1.0);
    }

    public void center(double factor) {
        if (this.natoms == 0) {
            return;
        }
        Rectangle2D.Double widthAndHeight = this.jme.getMolecularAreaCoordBoundingBox();
        double xpix = widthAndHeight.width;
        double ypix = widthAndHeight.height;
        if (xpix <= 0.0 || ypix <= 0.0) {
            this.needRecentering = true;
            return;
        }
        Rectangle2D.Double cad = this.computeBoundingBoxWithAtomLabels(null);
        double shiftx = xpix / 2.0 - cad.getCenterX();
        double shifty = ypix / 2.0 - cad.getCenterY();
        if (!this.jme.nocenter) {
            this.moveXY(shiftx * factor, shifty * factor);
        }
    }

    @Override
    public double closestDistance(double x, double y) {
        return this.closestAtomDistance(x, y);
    }

    @Override
    public void draw(PreciseGraphicsAWT og) {
        int i;
        double rs;
        double offset2 = 2.0;
        double offset3 = 3.0;
        if (this.nAtoms() == 0) {
            return;
        }
        boolean markColorBackground = this.parameters.mark;
        Color[] atomTextStrokeColorArray = new Color[this.nAtoms() + 1];
        og.setDefaultBackGroundColor(this.jme.canvasBg);
        if (this.jme.options.depictBorder) {
            og.setColor(Color.black);
            og.drawRect(0.0, 0.0, this.jme.dimension.width - 1, this.jme.dimension.height - 1);
        }
        if (this.uniColor != null) {
            og.overrideColor(this.uniColor);
        }
        if (this.needRecentering) {
            this.center();
            this.jme.alignMolecules(1, this.jme.moleculePartsList.size(), 0);
            this.needRecentering = false;
        }
        if ((rs = this.jme.options.bondBGrectRelativeSize) > 0.0) {
            for (int i2 = 1; i2 <= this.nbonds; ++i2) {
                if (this.setPresetPastelBackGroundColor(og, i2, false) == null) continue;
                int atom1 = this.bonds[i2].va;
                int atom2 = this.bonds[i2].vb;
                this.setCosSin(atom1, atom2);
                double cos2 = 9.0 * this.temp[0];
                double sin2 = 9.0 * this.temp[1];
                double[] xr = new double[4];
                double[] yr = new double[4];
                xr[0] = this.x(atom1) + (sin2 *= rs);
                yr[0] = this.y(atom1) - (cos2 *= rs);
                xr[1] = this.x(atom2) + sin2;
                yr[1] = this.y(atom2) - cos2;
                xr[2] = this.x(atom2) - sin2;
                yr[2] = this.y(atom2) + cos2;
                xr[3] = this.x(atom1) - sin2;
                yr[3] = this.y(atom1) + cos2;
                og.fillPolygon(xr, yr, 4);
            }
        }
        double cs = 24.0;
        rs = this.jme.options.atomBGcircleRelativeSize;
        if (rs > 0.0) {
            for (int i3 = 1; i3 <= this.natoms; ++i3) {
                Color contrastColor;
                Color backgroundColor = this.setPresetPastelBackGroundColor(og, i3, true);
                if (backgroundColor == null) continue;
                double scs = cs * rs;
                og.fillOval(this.x(i3) - scs / 2.0, this.y(i3) - scs / 2.0, scs, scs);
                if (!(og.currentZoomFactor() >= 2.0)) continue;
                atomTextStrokeColorArray[i3] = contrastColor = ColorManager.contrast(backgroundColor);
            }
        }
        if (this.ringInfo == null && this.haveMultipleBonds) {
            this.setRingInfo();
        }
        this.computeAtomLabels();
        og.setFont(this.jme.gui.getAtomDrawingFont());
        FontMetrics fm = this.jme.gui.getAtomDrawingFontMetrics();
        double h = GUI.stringHeight(fm);
        block12: for (i = 1; i <= this.nbonds; ++i) {
            Bond bond = this.bonds[i];
            int atom1 = bond.va;
            int atom2 = bond.vb;
            og.setColor(bond.isCoordination() ? Color.LIGHT_GRAY : Color.BLACK);
            if (this.jme.action == 106 && this.touchedBond == i && this.isRotatableBond(i)) continue;
            if (bond.stereo == 3 || bond.stereo == 4 || bond.stereo == 6) {
                int d = atom1;
                atom1 = atom2;
                atom2 = d;
            }
            double xa = this.x(atom1);
            double ya = this.y(atom1);
            double xb = this.x(atom2);
            double yb = this.y(atom2);
            if (!bond.isSingle() && !bond.isCoordination() || bond.stereo != 0) {
                this.setCosSin(atom1, atom2);
            }
            switch (bond.bondType) {
                case 2: {
                    double cos2 = 2.0 * this.temp[0];
                    double sin2 = 2.0 * this.temp[1];
                    if (this.bondIsSidelined(bond)) {
                        og.drawLine(xa, ya, xb, yb);
                        this.drawSideLine(og, bond, xa, ya, xb, yb, cos2, sin2);
                    } else if (bond.stereo == 10) {
                        og.drawLine(xa + sin2, ya - cos2, xb - sin2, yb + cos2);
                        og.drawLine(xa - sin2, ya + cos2, xb + sin2, yb - cos2);
                    } else {
                        og.drawLine(xa + sin2, ya - cos2, xb + sin2, yb - cos2);
                        og.drawLine(xa - sin2, ya + cos2, xb - sin2, yb + cos2);
                    }
                    og.setColor(Color.black);
                    continue block12;
                }
                case 3: {
                    og.drawLine(xa, ya, xb, yb);
                    double cos3 = 3.0 * this.temp[0];
                    double sin3 = 3.0 * this.temp[1];
                    og.drawLine(xa + sin3, ya - cos3, xb + sin3, yb - cos3);
                    og.drawLine(xa - sin3, ya + cos3, xb - sin3, yb + cos3);
                    continue block12;
                }
                case 9: {
                    for (int k = 0; k < 10; ++k) {
                        double xax = xa - (xa - xb) / 10.0 * (double)k;
                        double yax = ya - (ya - yb) / 10.0 * (double)k;
                        og.drawLine(xax, yax, xax, yax);
                    }
                    String o = bond.btag;
                    String z = "?";
                    if (o != null) {
                        z = o;
                    }
                    double w = fm.stringWidth(z);
                    double xstart = (xa + xb) / 2.0 - w / 2.0;
                    double ystart = (ya + yb) / 2.0 + h / 2.0 - 1.0;
                    og.setColor(Color.magenta);
                    og.drawString(z, xstart, ystart);
                    og.setColor(Color.black);
                    continue block12;
                }
                default: {
                    double sin2;
                    double cos2;
                    switch (bond.stereo) {
                        default: {
                            og.drawLine(xa, ya, xb, yb);
                            continue block12;
                        }
                        case 1: 
                        case 3: {
                            cos2 = 3.0 * this.temp[0];
                            sin2 = 3.0 * this.temp[1];
                            double[] px = new double[3];
                            double[] py = new double[3];
                            px[0] = xb + sin2;
                            py[0] = yb - cos2;
                            px[1] = xa;
                            py[1] = ya;
                            px[2] = xb - sin2;
                            py[2] = yb + cos2;
                            og.fillPolygon(px, py, 3);
                            continue block12;
                        }
                        case 2: 
                        case 4: {
                            cos2 = 3.0 * this.temp[0];
                            sin2 = 3.0 * this.temp[1];
                            for (double k = 0.0; k < 10.0; k += 1.0) {
                                double xax = xa - (xa - xb) / 10.0 * k;
                                double yax = ya - (ya - yb) / 10.0 * k;
                                double sc = k / 10.0;
                                og.drawLine(xax + sin2 * sc, yax - cos2 * sc, xax - sin2 * sc, yax + cos2 * sc);
                            }
                            continue block12;
                        }
                        case 5: 
                        case 6: {
                            double x1 = 0.0;
                            double x2 = 0.0;
                            double y1 = 0.0;
                            double y2 = 0.0;
                            cos2 = 3.0 * this.temp[0];
                            sin2 = 3.0 * this.temp[1];
                            double m = 8.0;
                            for (double k = 0.0; k < m + 1.0; k += 1.0) {
                                double xax = xa - (xa - xb) / m * k;
                                double yax = ya - (ya - yb) / m * k;
                                double sc = k / m;
                                x1 = xax + sin2 * sc;
                                y1 = yax - cos2 * sc;
                                if (k > 0.0) {
                                    og.drawLine(x2, y2, x1, y1);
                                }
                                x2 = xax - sin2 * sc;
                                y2 = yax + cos2 * sc;
                                og.drawLine(x1, y1, x2, y2);
                            }
                        }
                    }
                }
            }
        }
        for (i = 1; i <= this.natoms; ++i) {
            if (this.atomLabels[i].noLabelAtom) continue;
            og.setBackGroundColor();
            this.setPresetPastelBackGroundColor(og, i, true);
            this.atomLabels[i].fill(og);
            og.setColor(JME.color[this.an(i)]);
            Color strokeColor = atomTextStrokeColorArray[i];
            this.atomLabels[i].draw(og, strokeColor, h, fm);
        }
        if (!markColorBackground) {
            og.setFont(this.jme.gui.atomMapDrawingAreaFont);
            for (i = 1; i <= this.natoms; ++i) {
                AtomDisplayLabel al = this.atomLabels[i];
                String mapString = al.mapString;
                if (mapString == null) continue;
                double atomMapX = al.atomMapX;
                double atomMapY = al.atomMapY;
                og.setColor(Color.magenta);
                Color strokeColor = atomTextStrokeColorArray[i];
                if (strokeColor == null) {
                    og.drawString(mapString, atomMapX, atomMapY);
                    continue;
                }
                og.drawStringWithStroke(mapString, atomMapX, atomMapY, strokeColor, h / 20.0);
            }
        }
        if (this.touchedAtom > 0 || this.touchedBond > 0) {
            og.setColor(this.jme.action == 104 ? Color.red : Color.blue);
            if (this.touchedAtom > 0 && this.jme.action != 106) {
                Rectangle2D.Double r = this.atomLabels[this.touchedAtom].drawBox;
                og.drawRect(r.x, r.y, r.width, r.height);
            }
            if (this.touchedBond > 0 && this.jme.action != 113) {
                Bond b = this.bonds[this.touchedBond];
                int atom1 = b.va;
                int atom2 = b.vb;
                this.setCosSin(atom1, atom2);
                double cos2 = 4.0 * this.temp[0];
                double sin2 = 4.0 * this.temp[1];
                if (this.bondIsSidelined(b)) {
                    cos2 *= 1.5;
                    sin2 *= 1.5;
                }
                double[] px = new double[5];
                double[] py = new double[5];
                px[0] = this.x(atom1) + sin2;
                px[1] = this.x(atom2) + sin2;
                py[0] = this.y(atom1) - cos2;
                py[1] = this.y(atom2) - cos2;
                px[3] = this.x(atom1) - sin2;
                px[2] = this.x(atom2) - sin2;
                py[3] = this.y(atom1) + cos2;
                py[2] = this.y(atom2) + cos2;
                px[4] = px[0];
                py[4] = py[0];
                if (this.jme.action != 106) {
                    og.drawPolygon(px, py, 5);
                } else if (this.isRotatableBond(this.touchedBond)) {
                    this.drawRotatableBond(og);
                }
            }
        }
        if (this.uniColor != null) {
            og.resetOverrideColor();
        }
    }

    private boolean bondIsSidelined(Bond bond) {
        return bond.bondType == 2 && bond.stereo != 10 && (!Double.isNaN(bond.guideX) || !Double.isNaN(bond.guideY) && this.atomLabels[bond.va].noLabelAtom && this.atomLabels[bond.vb].noLabelAtom);
    }

    private void drawRotatableBond(PreciseGraphicsAWT og) {
        int va = this.bonds[this.touchedBond].va;
        int vb = this.bonds[this.touchedBond].vb;
        this.computeMultiPartIndices(this.touchedBond);
        int partA = this.atoms[va].partIndex;
        int partB = this.atoms[vb].partIndex;
        int sizeA = 0;
        int sizeB = 0;
        for (int i = 1; i <= this.natoms; ++i) {
            int pi = this.atoms[i].partIndex;
            if (pi == partA) {
                ++sizeA;
                continue;
            }
            if (pi != partB) continue;
            ++sizeB;
        }
        int partToDelete = sizeA > sizeB ? partB : partA;
        og.setColor(Color.red);
        for (int i = 1; i <= this.natoms; ++i) {
            this.atoms[i].deleteFlag = false;
            if (this.atoms[i].partIndex != partToDelete) continue;
            this.atoms[i].deleteFlag = true;
            Rectangle2D.Double r = this.atomLabels[i].drawBox;
            og.drawRect(r.x, r.y, r.width, r.height);
        }
    }

    private void drawSideLine(PreciseGraphicsAWT og, Bond bond, double xa, double ya, double xb, double yb, double cos2, double sin2) {
        double cx = bond.centerX;
        double cy = bond.centerY;
        double ox = cx + sin2 * 2.0;
        double oy = cy - cos2 * 2.0;
        double gx = bond.guideX;
        double gy = bond.guideY;
        double min = 3.0;
        if ((cx - gx) * (cx - gx) + (cy - gy) * (cy - gy) < min) {
            gx = Double.NaN;
        }
        double f = Double.isNaN(gx) ? -2.0f : ((ox - gx) * (ox - gx) + (oy - gy) * (oy - gy) > (cx - gx) * (cx - gx) + (cy - gy) * (cy - gy) ? -2.0f : 2.0f);
        double g = 0.1;
        double dx = xb - xa;
        double dy = yb - ya;
        double x1 = (xa += dx * g) + sin2 * f;
        double y1 = (ya += dy * g) - cos2 * f;
        double x2 = (xb -= dx * g) + sin2 * f;
        double y2 = (yb -= dy * g) - cos2 * f;
        og.drawLine(x1, y1, x2, y2);
    }

    void computeAtomLabels() {
        boolean showHs = this.parameters.hydrogenParams.showHs;
        boolean showMap = !this.parameters.mark || this.parameters.showAtomMapNumberWithBackgroundColor;
        FontMetrics fm = this.jme.gui.getAtomDrawingFontMetrics();
        double rb = 25.0;
        this.atomLabels = AtomDisplayLabel.createLabels(this, rb, fm, showHs, showMap, this.atomLabels);
    }

    @Override
    public Rectangle2D.Double computeBoundingBoxWithAtomLabels(Rectangle2D.Double union) {
        if (this.natoms == 0) {
            return union;
        }
        this.computeAtomLabels();
        for (int i = 1; i <= this.natoms; ++i) {
            union = Box.createUnion(this.atomLabels[i].drawBox, union, union);
        }
        return union;
    }

    void rubberBanding(double xnew, double ynew) {
        double dy;
        this.touchedAtom = 0;
        this.XY(0, xnew, ynew);
        if (this.jme.action != 205) {
            int atom = this.checkTouch(0, true);
            if (atom > 0) {
                this.touchedAtom = atom;
                if (atom == this.touched_org) {
                    this.XY(this.natoms, this.xorg, this.yorg);
                } else {
                    this.XY(this.natoms, this.x(atom), this.y(atom));
                }
            } else {
                this.setCosSin(this.touched_org, 0);
                this.XY(this.natoms, this.x(this.touched_org) + 25.0 * this.temp[0], this.y(this.touched_org) + 25.0 * this.temp[1]);
            }
            return;
        }
        this.touchedBond = 0;
        int last = this.chain[this.nchain];
        int parent = this.chain[this.nchain - 1];
        double dx = this.x(last) - this.x(parent);
        double rx = Math.sqrt(dx * dx + (dy = this.y(last) - this.y(parent)) * dy);
        if (rx < 1.0) {
            rx = 1.0;
        }
        double sina = dy / rx;
        double cosa = dx / rx;
        double vv = rx / 2.0 / Math.tan(0.5235987755982988);
        double xx = xnew - this.x(parent);
        double yy = ynew - this.y(parent);
        double xm = -rx / 2.0 + xx * cosa + yy * sina;
        double ym = yy * cosa - xx * sina;
        if (xm < 0.0) {
            if (this.nchain > 1) {
                this.deleteAtom(this.natoms);
                --this.nchain;
                this.stopChain = false;
            } else if (this.natoms == 2) {
                if (this.y(2) - this.y(1) < 0.0 && ynew - this.y(1) > 0.0) {
                    this.atoms[2].y = this.y(1) + rx / 2.0;
                } else if (this.y(2) - this.y(1) > 0.0 && ynew - this.y(1) < 0.0) {
                    this.atoms[2].y = this.y(1) - rx / 2.0;
                }
                if (this.x(2) - this.x(1) < 0.0 && xnew - this.x(1) > 0.0) {
                    this.atoms[2].x = this.x(1) + rx * 0.866;
                } else if (this.x(2) - this.x(1) > 0.0 && xnew - this.x(1) < 0.0) {
                    this.atoms[2].x = this.x(1) - rx * 0.866;
                }
            } else if (this.nv(this.chain[0]) == 2) {
                int ref = this.v(this.chain[0])[1];
                if (ref == this.chain[1]) {
                    ref = this.v(this.chain[0])[2];
                }
                if ((rx = Math.sqrt((dx = this.x(this.chain[0]) - this.x(ref)) * dx + (dy = this.y(this.chain[0]) - this.y(ref)) * dy)) < 1.0) {
                    rx = 1.0;
                }
                sina = dy / rx;
                cosa = dx / rx;
                xx = xnew - this.x(ref);
                yy = ynew - this.y(ref);
                double ymm = yy * cosa - xx * sina;
                xx = this.x(this.chain[1]) - this.x(ref);
                yy = this.y(this.chain[1]) - this.y(ref);
                double yc1 = yy * cosa - xx * sina;
                if (ymm > 0.0 && yc1 < 0.0 || ymm < 0.0 && yc1 > 0.0) {
                    int bd = this.nbonds;
                    this.addBondToAtom(0, this.chain[0], 0, false);
                    this.deleteBond(bd, true);
                    if (this.checkTouch(this.natoms, true) > 0) {
                        this.stopChain = true;
                    }
                }
            }
        } else {
            if (this.stopChain) {
                return;
            }
            double th = -1.0;
            if (xm < rx * 1.5) {
                th = (rx * 1.5 - xm) * vv / (rx * 1.5);
            }
            if (Math.abs(ym) > th) {
                ++this.nchain;
                if (this.nchain > 100) {
                    this.jme.showInfo("You are too focused on chains, enough of it for now !");
                    --this.nchain;
                    return;
                }
                this.addBondToAtom(1, this.natoms, (int)Math.round(ym), false);
                this.jme.willPostSave(false);
                this.chain[this.nchain] = this.natoms;
                if (this.checkTouch(this.natoms, true) > 0) {
                    this.stopChain = true;
                }
            }
        }
        this.touchedAtom = 0;
    }

    void checkChain() {
        if (this.stopChain) {
            int n = this.checkTouch(this.natoms, false);
            if (this.nv(n) < 6) {
                int parent = this.chain[this.nchain - 1];
                this.createAndAddNewBond(n, parent, 1);
            }
            this.deleteAtom(this.natoms);
        }
        this.stopChain = false;
    }

    int checkTouch(int atom, boolean onlyOne) {
        return this.checkTouchToAtom(atom, 1, this.natoms, 50.0, onlyOne);
    }

    protected int countNumberOverlapAtomOfAddedFragment(int fragmentFirstAtom, int fragmentLastAtom) {
        int result = 0;
        for (int at = 1; at <= this.natoms; ++at) {
            if (at >= fragmentFirstAtom || at <= fragmentLastAtom || this.checkTouchToAtom(at, fragmentFirstAtom, fragmentLastAtom, 50.0, true) == 0) continue;
            ++result;
        }
        return result;
    }

    public void avoidTouch(int from) {
        if (from == 0) {
            from = this.natoms;
        }
        for (int i = this.natoms; i > this.natoms - from; --i) {
            if (this.checkTouch(i, true) == 0) continue;
            this.moveXY(i, 6.0, 6.0);
        }
    }

    void checkBond() {
        int atom = this.checkTouch(this.natoms, false);
        if (atom == 0) {
            return;
        }
        --this.natoms;
        int i = this.getBondIndex(atom, this.touched_org);
        if (i > 0) {
            --this.nbonds;
            this.incrNV(this.touched_org, -1);
            if (this.bonds[i].bondType < (this.bonds[i].smallRing ? 2 : 3)) {
                ++this.bonds[i].bondType;
                this.bonds[i].stereo = 0;
                this.setBondCenter(this.bonds[i]);
            } else {
                this.info("Maximum allowed bond order has been reached!");
            }
            return;
        }
        if (this.nv(atom) == 6) {
            --this.nbonds;
            this.incrNV(this.touched_org, -1);
            this.info("Not possible connection !");
            return;
        }
        this.bonds[this.nbonds].vb = atom;
        this.incrNV(this.touched_org, -1);
        this.addBothNeighbors(atom, this.touched_org);
        this.setBondCenter(this.bonds[this.nbonds]);
    }

    public void addOtherMolToMe(JMEmol otherMol) {
        int i;
        int nn = this.natoms;
        for (i = 1; i <= otherMol.natoms; ++i) {
            this.createAtomFromOther(otherMol.atoms[i]);
            this.AN(this.natoms, otherMol.an(i));
        }
        for (i = 1; i <= otherMol.nbonds; ++i) {
            this.createAndAddBondFromOther(otherMol.bonds[i]);
            this.bonds[this.nbonds].va = otherMol.bonds[i].va + nn;
            this.bonds[this.nbonds].vb = otherMol.bonds[i].vb + nn;
        }
    }

    @Override
    protected Atom createAtomFromOther(Atom atomToDuplicate) {
        this.atomLabels = null;
        return super.createAtomFromOther(atomToDuplicate);
    }

    public void setAtomOrBondColors(String s, int delta, boolean isAtom) {
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            while (st.hasMoreTokens()) {
                int atomOrBond = Integer.valueOf(st.nextToken()) - delta;
                int color = Integer.valueOf(st.nextToken());
                if (isAtom) {
                    this.addAtomColor(atomOrBond, color);
                    continue;
                }
                this.addBondColor(atomOrBond, color);
            }
        }
        catch (Exception e) {
            System.err.println("Error in atom coloring");
            JMEUtil.log("Error in atom coloring");
        }
    }

    public void setAtomColors(String s, int delta) {
        this.setAtomOrBondColors(s, delta, true);
    }

    public void setBondColors(String s, int delta) {
        this.setAtomOrBondColors(s, delta, false);
    }

    public void addAtomColor(int at, int c) {
        if (at > 0 && at <= this.natoms) {
            this.atoms[at].addBackgroundColor(c);
        }
    }

    public int[] getAtomBackgroundColors(int at) {
        return at > 0 && at <= this.natoms ? this.atoms[at].getBackgroundColors() : null;
    }

    public void addBondColor(int b, int c) {
        if (b > 0 && b <= this.nbonds) {
            this.bonds[b].addBackgroundColor(c);
        }
    }

    public int[] getBondBackgroundColors(int b) {
        return b > 0 && b <= this.nbonds ? this.bonds[b].getBackgroundColors() : null;
    }

    public JMEmol deepCopy() {
        return new JMEmol(this);
    }

    boolean isRotatableBond(int a1, int a2) {
        return this.minimumRingSize(a1, a2) == 0;
    }

    boolean isRotatableBond(int b) {
        return this.isRotatableBond(this.bonds[b].va, this.bonds[b].vb);
    }

    public String createSmiles() {
        return this.createSmiles(this.parameters);
    }

    public String createSmiles(JMECore.Parameters pars) {
        return JMESmiles.getSmiles(this.deepCopy(), pars, this.isQuery);
    }

    public int findAtomChargeForOutput(int atomIndex) {
        int charge = 0;
        if (atomIndex > 0 && atomIndex <= this.nAtoms()) {
            Atom atom = this.atoms[atomIndex];
            charge = atom.q();
        }
        return charge;
    }

    public boolean hasMarkedAtom() {
        for (int at = 1; at <= this.natoms; ++at) {
            if (this.findAtomMapForOutput(at) <= 0) continue;
            return true;
        }
        return false;
    }

    public String createMolFile(String header) {
        return JMEWriter.createMolFile(this, header, true, this.computeCoordinate2DboundingBox());
    }

    public boolean changeCharge(int atom, int type) {
        String np = "Charge change not possible on ";
        if (type == 1) {
            this.incrQ(atom, 1);
            return true;
        }
        if (type == -1) {
            this.incrQ(atom, -1);
            return true;
        }
        int startCharge = this.q(atom);
        int startNH = this.atoms[atom].nh;
        int sbo = this.getSumOfBondOrder(atom);
        if (sbo == -1 && type == 0) {
            if (this.q(atom) == 0) {
                this.Q(atom, 1);
            } else if (this.q(atom) == 1) {
                this.Q(atom, -1);
            } else if (this.q(atom) == -1) {
                this.Q(atom, 0);
            }
        }
        switch (this.an(atom)) {
            case 1: {
                if (sbo != 0) break;
                if (this.q(atom) == 0) {
                    this.Q(atom, 1);
                    break;
                }
                if (this.q(atom) == 1) {
                    this.Q(atom, -1);
                    break;
                }
                this.Q(atom, 0);
                break;
            }
            case 2: {
                if (sbo > 2) {
                    this.info(np + "this boron !");
                }
                if (this.q(atom) == 0) {
                    this.Q(atom, 1);
                    break;
                }
                if (this.q(atom) != 1) break;
                this.Q(atom, 0);
                break;
            }
            case 3: {
                if (sbo > 3) {
                    this.info(np + "this carbon !");
                    break;
                }
                if (sbo >= 4) break;
                if (this.q(atom) == 0) {
                    this.Q(atom, -1);
                    break;
                }
                if (this.q(atom) == -1) {
                    this.Q(atom, 1);
                    break;
                }
                if (this.q(atom) != 1) break;
                this.Q(atom, 0);
                break;
            }
            case 4: 
            case 7: {
                if (sbo > 3) {
                    this.info(np + "multibonded N or P !");
                    break;
                }
                if (sbo == 3 && this.q(atom) == 0) {
                    this.Q(atom, 1);
                    break;
                }
                if (sbo == 3 && this.q(atom) == 1) {
                    this.Q(atom, 0);
                    break;
                }
                if (sbo < 3 && this.q(atom) == 0) {
                    this.Q(atom, 1);
                    break;
                }
                if (sbo < 3 && this.q(atom) == 1) {
                    this.Q(atom, -1);
                    break;
                }
                if (sbo >= 3 || this.q(atom) != -1) break;
                this.Q(atom, 0);
                break;
            }
            case 5: 
            case 8: 
            case 13: {
                if (sbo > 2) {
                    this.info(np + "multibonded " + Atom.zlabel[this.an(atom)] + " !");
                    break;
                }
                if (sbo == 2 && this.q(atom) == 0) {
                    this.Q(atom, 1);
                    break;
                }
                if (sbo == 2 && this.q(atom) == 1) {
                    this.Q(atom, 0);
                    break;
                }
                if (sbo < 2 && this.q(atom) == 0) {
                    this.Q(atom, -1);
                    break;
                }
                if (sbo < 2 && this.q(atom) == -1) {
                    this.Q(atom, 1);
                    break;
                }
                if (sbo >= 2 || this.q(atom) != 1) break;
                this.Q(atom, 0);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                if (sbo == 0 && this.q(atom) == 0) {
                    this.Q(atom, -1);
                    break;
                }
                if (sbo == 0 && this.q(atom) == -1) {
                    this.Q(atom, 0);
                    break;
                }
                this.info(np + "the halogen !");
                break;
            }
            case 32: {
                this.info("Use X button to change charge on the X atom !");
            }
        }
        if (Atom.chargedMetalType(this.an(atom)) > 0 && !this.toggleChargeAndHydrogenCountOfMetalAtom(this.atoms[atom], sbo)) {
            this.info(np + Atom.zlabel[this.an(atom)]);
        }
        return startCharge != this.q(atom) || startNH != this.atoms[atom].nh;
    }

    boolean toggleChargeAndHydrogenCountOfMetalAtom(Atom atom, int sbo) {
        int maxChargeIncrease;
        boolean changed = false;
        int maxMetalCharge = Atom.chargedMetalType(atom.an);
        if (maxMetalCharge > 0 && (maxChargeIncrease = maxMetalCharge - sbo) > 0) {
            int q = atom.q;
            int nh = atom.nh;
            if (q + nh < maxChargeIncrease) {
                q += maxChargeIncrease - nh;
            } else if (q + nh == maxChargeIncrease) {
                if (q == maxChargeIncrease) {
                    q = 0;
                    nh = maxChargeIncrease;
                } else {
                    q = 0;
                    nh = 0;
                    if (sbo == 0) {
                        this.info("Metallic " + Atom.zlabel[atom.an]);
                    }
                }
            }
            changed = atom.q != q || atom.nh != nh;
            atom.q = q;
            atom.nh = nh;
        }
        return changed;
    }

    public boolean markAtom(int newMark) {
        boolean hasBeenMarked;
        if (this.parameters.mark) {
            if (this.jme.options.markOnly1) {
                for (int at = 1; at <= this.natoms; ++at) {
                    if (at == this.touchedAtom) continue;
                    this.atoms[at].resetMark();
                }
            }
            if (newMark != this.atoms[this.touchedAtom].getMark()) {
                this.atoms[this.touchedAtom].setMark(newMark);
                return true;
            }
            this.atoms[this.touchedAtom].resetMark();
            return false;
        }
        Atom touchedAtomObject = this.atoms[this.touchedAtom];
        if (newMark <= 0) {
            touchedAtomObject.resetMap();
            hasBeenMarked = false;
        } else {
            hasBeenMarked = newMark != touchedAtomObject.getMap();
            touchedAtomObject.setMap(newMark);
            hasBeenMarked = true;
        }
        return hasBeenMarked;
    }

    public boolean markBond(int newMark) {
        if (this.parameters.mark) {
            if (this.jme.options.markOnly1) {
                for (int at = 1; at <= this.nbonds; ++at) {
                    if (at == this.touchedBond) continue;
                    this.bonds[at].resetMark();
                }
            }
            if (newMark != this.bonds[this.touchedBond].getMark()) {
                this.bonds[this.touchedBond].setMark(newMark);
                return true;
            }
            this.bonds[this.touchedBond].resetMark();
            return false;
        }
        return false;
    }

    public void failed(String msg) {
        this.info(msg);
        this.jme.setLastAction(9);
    }

    public JMEmol compute2DcoordinatesIfMissing() {
        return this.has2Dcoordinates() ? null : OclAdapter.compute2Dcoordinates(this);
    }

    public void clearRotation() {
        this.centery = Double.NaN;
        this.centerx = Double.NaN;
    }

    public void rotate(double movex) {
        if (Double.isNaN(this.centerx)) {
            Rectangle2D.Double bbox = this.computeBoundingBoxWithAtomLabels(null);
            this.centerx = bbox.getCenterX();
            this.centery = bbox.getCenterY();
        }
        this.rotate(movex, this.centerx, this.centery);
    }

    public JMEmol reComputeBondOrderIfAromaticBondType() {
        return OclAdapter.reComputeBondOrderIfAromaticBondType(this);
    }

    public boolean addBondToAtom(int action, int ia, int up, boolean forceLinear) {
        int bondType = action == 204 ? 3 : (action == 203 ? 2 : 1);
        Boolean b = super.addBondToAtom(bondType, ia, up, forceLinear, 50.0);
        if (b == null) {
            return false;
        }
        if (action == 201) {
            this.toggleBondStereo(this.nbonds);
        }
        this.xorg = this.x(this.natoms);
        this.yorg = this.y(this.natoms);
        return b;
    }

    public void cleanAfterChanged(boolean polarNitro) {
        this.setValenceState();
        this.cleanPolarBonds(polarNitro);
        this.ringInfo = null;
    }

    public void deleteAtomGroup() {
        while (true) {
            int atd = 0;
            for (int i = this.natoms; i >= 1; --i) {
                if (!this.atoms[i].deleteFlag || i <= atd) continue;
                atd = i;
            }
            if (atd == 0) break;
            this.deleteAtom(atd);
            this.atoms[atd].deleteFlag = false;
        }
    }

    public int deleteCoordinationBonds() {
        int cbCount = 0;
        int b = this.nbonds + 1;
        while (--b >= 1) {
            if (this.bonds[b].bondType != 0) continue;
            this.deleteBond(b, false);
            ++cbCount;
        }
        return cbCount;
    }

    public void toggleBondStereo(int bondIndex) {
        Bond bond = this.bonds[bondIndex];
        if (bond.bondType == 2) {
            this.toggleDoubleBondStereo(bond);
            return;
        }
        if (!bond.isSingle() && !bond.isCoordination()) {
            this.info("Stereomarking allowed only on single and double bonds!");
            return;
        }
        int atom1 = this.bonds[bondIndex].va;
        int atom2 = this.bonds[bondIndex].vb;
        if (this.nv(atom1) < 2 && this.nv(atom2) < 2) {
            bond.stereo = 0;
            this.info("Stereomarking meaningless on this bond !");
            return;
        }
        switch (bond.stereo) {
            case 0: {
                if (this.nv(atom2) <= this.nv(atom1)) {
                    bond.stereo = 1;
                    break;
                }
                bond.stereo = 3;
                break;
            }
            case 1: {
                bond.stereo = 2;
                break;
            }
            case 2: {
                bond.stereo = 5;
                break;
            }
            case 5: {
                if (this.nv(atom2) > 2) {
                    bond.stereo = 3;
                    break;
                }
                bond.stereo = 1;
                break;
            }
            case 3: {
                bond.stereo = 4;
                break;
            }
            case 4: {
                bond.stereo = 6;
                break;
            }
            case 6: {
                bond.stereo = this.nv(atom1) > 2 ? 1 : 3;
            }
        }
    }

    public void numberAtomsSequentially() {
        for (int i = 1; i <= this.natoms; ++i) {
            this.atoms[i].setMap(i);
        }
    }

    private void setRingInfo() {
        this.ringInfo = new GUI.RingInfo(this);
    }

    @Override
    public void setBondCenters() {
        this.ringInfo = null;
        this.haveMultipleBonds = false;
        super.setBondCenters();
    }

    @Override
    public void setBondCenter(Bond b) {
        super.setBondCenter(b);
        if (b.bondType == 2 || b.bondType == 3) {
            this.haveMultipleBonds = true;
        }
        this.ringInfo = null;
    }

    public int navigateBonds(int from, int dir) {
        if (this.natoms == 0 || this.nbonds == 0) {
            return 0;
        }
        if (from == 0 || from > this.natoms || -from > this.nbonds) {
            from = -1;
        }
        double dirx = 0.0;
        double diry = 0.0;
        switch (dir) {
            case 1: {
                diry = -1.0;
                break;
            }
            case 2: {
                diry = 1.0;
                break;
            }
            case 3: {
                dirx = -1.0;
                break;
            }
            case 4: {
                dirx = 1.0;
            }
        }
        if (from < 0) {
            Bond b = this.bonds[-from];
            this.setCosSin(b.va, b.vb);
            double dotprod = dirx * this.temp[0] + diry * this.temp[1];
            return dotprod < 0.0 ? b.va : b.vb;
        }
        Atom a = this.atoms[from];
        double max = -1.0;
        int maxi = 0;
        for (int i = 1; i <= a.nv; ++i) {
            this.setCosSin(from, a.v[i]);
            double dotprod = dirx * this.temp[0] + diry * this.temp[1];
            if (!(dotprod > max)) continue;
            max = dotprod;
            maxi = a.v[i];
        }
        return -this.getBondIndex(from, maxi);
    }

    public void toggleDoubleBondStereo(Bond bond) {
        this.ringInfo = null;
        bond.toggleNormalCrossedDoubleBond();
    }

    public void setBondType(int b, int type) {
        this.bonds[b].bondType = type;
        this.setBondCenter(this.bonds[b]);
    }

    public static class ReactionRole {
        public static final int NOROLE = 0;
        public static final int REACTANT = 1;
        public static final int AGENT = 2;
        public static final int PRODUCT = 3;
        public static final int[] all = new int[]{1, 2, 3};
        public static final int maxRole = 3;
        public static final int ANY = -1;
    }
}

