/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import javajs.api.JSONEncodable;
import javajs.util.A4d;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3d;

public abstract class M34d
implements JSONEncodable {
    public double m00;
    public double m01;
    public double m02;
    public double m10;
    public double m11;
    public double m12;
    public double m20;
    public double m21;
    public double m22;
    public int size;

    protected void setAA33(A4d a) {
        this.setXYZAngle(a.x, a.y, a.z, a.angle);
    }

    protected void setXYZAngle(double x, double y, double z, double angle) {
        double n = Math.sqrt(x * x + y * y + z * z);
        n = 1.0 / n;
        x *= n;
        y *= n;
        z *= n;
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        double omc = 1.0 - c;
        this.m00 = c + x * x * omc;
        this.m11 = c + y * y * omc;
        this.m22 = c + z * z * omc;
        double tmp1 = x * y * omc;
        double tmp2 = z * s;
        this.m01 = tmp1 - tmp2;
        this.m10 = tmp1 + tmp2;
        tmp1 = x * z * omc;
        tmp2 = y * s;
        this.m02 = tmp1 + tmp2;
        this.m20 = tmp1 - tmp2;
        tmp1 = y * z * omc;
        tmp2 = x * s;
        this.m12 = tmp1 - tmp2;
        this.m21 = tmp1 + tmp2;
    }

    public void rotate(T3d t) {
        this.rotate2(t, t);
    }

    public void rotate2(T3d t, T3d result) {
        result.set(this.m00 * t.x + this.m01 * t.y + this.m02 * t.z, this.m10 * t.x + this.m11 * t.y + this.m12 * t.z, this.m20 * t.x + this.m21 * t.y + this.m22 * t.z);
    }

    protected void setM33(M34d m1) {
        this.m00 = m1.m00;
        this.m01 = m1.m01;
        this.m02 = m1.m02;
        this.m10 = m1.m10;
        this.m11 = m1.m11;
        this.m12 = m1.m12;
        this.m20 = m1.m20;
        this.m21 = m1.m21;
        this.m22 = m1.m22;
    }

    protected void clear33() {
        this.m22 = 0.0;
        this.m21 = 0.0;
        this.m20 = 0.0;
        this.m12 = 0.0;
        this.m11 = 0.0;
        this.m10 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.m00 = 0.0;
    }

    protected void set33(int row, int col, double v) {
        switch (row) {
            case 0: {
                switch (col) {
                    case 0: {
                        this.m00 = v;
                        return;
                    }
                    case 1: {
                        this.m01 = v;
                        return;
                    }
                    case 2: {
                        this.m02 = v;
                        return;
                    }
                }
                break;
            }
            case 1: {
                switch (col) {
                    case 0: {
                        this.m10 = v;
                        return;
                    }
                    case 1: {
                        this.m11 = v;
                        return;
                    }
                    case 2: {
                        this.m12 = v;
                        return;
                    }
                }
                break;
            }
            case 2: {
                switch (col) {
                    case 0: {
                        this.m20 = v;
                        return;
                    }
                    case 1: {
                        this.m21 = v;
                        return;
                    }
                    case 2: {
                        this.m22 = v;
                        return;
                    }
                }
            }
        }
        this.err();
    }

    protected double get33(int row, int col) {
        switch (row) {
            case 0: {
                switch (col) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m01;
                    }
                    case 2: {
                        return this.m02;
                    }
                }
                break;
            }
            case 1: {
                switch (col) {
                    case 0: {
                        return this.m10;
                    }
                    case 1: {
                        return this.m11;
                    }
                    case 2: {
                        return this.m12;
                    }
                }
                break;
            }
            case 2: {
                switch (col) {
                    case 0: {
                        return this.m20;
                    }
                    case 1: {
                        return this.m21;
                    }
                    case 2: {
                        return this.m22;
                    }
                }
            }
        }
        this.err();
        return 0.0;
    }

    protected void setRow33(int row, double[] v) {
        switch (row) {
            case 0: {
                this.m00 = v[0];
                this.m01 = v[1];
                this.m02 = v[2];
                return;
            }
            case 1: {
                this.m10 = v[0];
                this.m11 = v[1];
                this.m12 = v[2];
                return;
            }
            case 2: {
                this.m20 = v[0];
                this.m21 = v[1];
                this.m22 = v[2];
                return;
            }
        }
        this.err();
    }

    public abstract void getRow(int var1, double[] var2);

    protected void getRow33(int row, double[] v) {
        switch (row) {
            case 0: {
                v[0] = this.m00;
                v[1] = this.m01;
                v[2] = this.m02;
                return;
            }
            case 1: {
                v[0] = this.m10;
                v[1] = this.m11;
                v[2] = this.m12;
                return;
            }
            case 2: {
                v[0] = this.m20;
                v[1] = this.m21;
                v[2] = this.m22;
                return;
            }
        }
        this.err();
    }

    protected void setColumn33(int column, double[] v) {
        switch (column) {
            case 0: {
                this.m00 = v[0];
                this.m10 = v[1];
                this.m20 = v[2];
                break;
            }
            case 1: {
                this.m01 = v[0];
                this.m11 = v[1];
                this.m21 = v[2];
                break;
            }
            case 2: {
                this.m02 = v[0];
                this.m12 = v[1];
                this.m22 = v[2];
                break;
            }
            default: {
                this.err();
            }
        }
    }

    protected void getColumn33(int column, double[] v) {
        switch (column) {
            case 0: {
                v[0] = this.m00;
                v[1] = this.m10;
                v[2] = this.m20;
                break;
            }
            case 1: {
                v[0] = this.m01;
                v[1] = this.m11;
                v[2] = this.m21;
                break;
            }
            case 2: {
                v[0] = this.m02;
                v[1] = this.m12;
                v[2] = this.m22;
                break;
            }
            default: {
                this.err();
            }
        }
    }

    protected void add33(M34d m1) {
        this.m00 += m1.m00;
        this.m01 += m1.m01;
        this.m02 += m1.m02;
        this.m10 += m1.m10;
        this.m11 += m1.m11;
        this.m12 += m1.m12;
        this.m20 += m1.m20;
        this.m21 += m1.m21;
        this.m22 += m1.m22;
    }

    protected void sub33(M34d m1) {
        this.m00 -= m1.m00;
        this.m01 -= m1.m01;
        this.m02 -= m1.m02;
        this.m10 -= m1.m10;
        this.m11 -= m1.m11;
        this.m12 -= m1.m12;
        this.m20 -= m1.m20;
        this.m21 -= m1.m21;
        this.m22 -= m1.m22;
    }

    protected void mul33(double x) {
        this.m00 *= x;
        this.m01 *= x;
        this.m02 *= x;
        this.m10 *= x;
        this.m11 *= x;
        this.m12 *= x;
        this.m20 *= x;
        this.m21 *= x;
        this.m22 *= x;
    }

    public void transpose33() {
        double tmp = this.m01;
        this.m01 = this.m10;
        this.m10 = tmp;
        tmp = this.m02;
        this.m02 = this.m20;
        this.m20 = tmp;
        tmp = this.m12;
        this.m12 = this.m21;
        this.m21 = tmp;
    }

    protected void setXRot(double angle) {
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = c;
        this.m12 = -s;
        this.m20 = 0.0;
        this.m21 = s;
        this.m22 = c;
    }

    protected void setYRot(double angle) {
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        this.m00 = c;
        this.m01 = 0.0;
        this.m02 = s;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = -s;
        this.m21 = 0.0;
        this.m22 = c;
    }

    protected void setZRot(double angle) {
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        this.m00 = c;
        this.m01 = -s;
        this.m02 = 0.0;
        this.m10 = s;
        this.m11 = c;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    }

    public double determinant3() {
        return this.m00 * (this.m11 * this.m22 - this.m21 * this.m12) - this.m01 * (this.m10 * this.m22 - this.m20 * this.m12) + this.m02 * (this.m10 * this.m21 - this.m20 * this.m11);
    }

    protected void err() {
        throw new ArrayIndexOutOfBoundsException("matrix column/row out of bounds");
    }

    abstract double getElement(int var1, int var2);

    abstract void setElement(int var1, int var2, double var3);

    public void clean() {
        int i = this.size;
        while (--i >= 0) {
            int j = this.size;
            while (--j >= 0) {
                this.setElement(i, j, this.approx0(this.getElement(i, j)));
            }
        }
    }

    private double approx0(double v) {
        return v > 1.0E-15 || v < -1.0E-15 ? v : 0.0;
    }

    @Override
    public String toJSON() {
        SB sb = new SB();
        double[] x = new double[this.size];
        sb.appendC('[');
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                sb.appendC(',');
            }
            this.getRow(i, x);
            sb.append(PT.toJSON(null, x));
        }
        sb.appendC(']');
        return sb.toString();
    }
}

