/*
 * Decompiled with CFR 0.152.
 */
package com.junrar.rarfile;

import com.junrar.io.Raw;
import com.junrar.rarfile.BaseBlock;

public class BlockHeader
extends BaseBlock {
    public static final short blockHeaderSize = 4;
    private long dataSize;
    private long packSize;

    public BlockHeader() {
    }

    public BlockHeader(BlockHeader bh) {
        super(bh);
        this.dataSize = this.packSize = bh.getDataSize();
        this.positionInFile = bh.getPositionInFile();
    }

    public BlockHeader(BaseBlock bb, byte[] blockHeader) {
        super(bb);
        this.dataSize = this.packSize = Raw.readIntLittleEndianAsLong(blockHeader, 0);
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public long getPackSize() {
        return this.packSize;
    }

    @Override
    public void print() {
        super.print();
    }
}

