/*
 * Decompiled with CFR 0.152.
 */
package com.integratedgraphics.extractor;

import com.integratedgraphics.extractor.ExtractorUtils;
import com.integratedgraphics.extractor.FindingAidCreator;
import com.integratedgraphics.extractor.IFDExtractor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.iupac.fairdata.common.IFDConst;
import org.iupac.fairdata.common.IFDException;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecExtractorHelper;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecExtractorHelperI;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecFindingAidHelperI;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecUtilities;
import org.iupac.fairdata.extract.DefaultStructureHelper;

abstract class IFDExtractorLayer0
extends FindingAidCreator {
    public static final String NEW_PAGE_KEY = "*NEW_PAGE*";
    protected static final String DEFAULT_STRUCTURE_DIR_URI = "./structures/";
    protected static final String DEFAULT_STRUCTURE_ZIP_URI = "./structures.zip";
    protected static final int LOG_ACCEPTED = 3;
    protected static final int LOG_IGNORED = 1;
    protected static final int LOG_OUTPUT = 2;
    protected static final int LOG_REJECTED = 0;
    protected static final Pattern objectDefPattern = Pattern.compile("\\{([^:]+)::([^}]+)\\}");
    protected static final Pattern pStarDotStar = Pattern.compile("\\*([^|/])\\*");
    protected static final String SUBST = "=>";
    protected static final String FAIRSPEC_EXTRACTOR_REFERENCES = IFDConst.getProp("FAIRSPEC_EXTRACTOR_REFERENCES");
    protected String stopAfter;
    protected Map<String, Object> config = null;
    protected BitSet bsPropertyVendors = new BitSet();
    protected BitSet bsRezipVendors = new BitSet();
    protected boolean cachePatternHasVendors;
    protected Map<String, Map<String, Object>> htURLReferences;
    protected String extractScript;
    protected File extractScriptFile;
    protected String extractScriptFileDir;
    protected FAIRSpecExtractorHelperI helper;
    protected Map<String, Map<String, Object>> htSpreadsheetMetadata;
    protected Map<String, ExtractorUtils.ExtractorResource> htResources = new HashMap<String, ExtractorUtils.ExtractorResource>();
    protected String ifdMetadataFileName = "IFD_METADATA";
    protected String ignoreRegex;
    protected String acceptRegex;
    protected String localSourceFile;
    protected String localizedName;
    protected String localSourceDir;
    protected FAIRSpecExtractorHelper.FileList lstAccepted = new FAIRSpecExtractorHelper.FileList(null, "accepted", null);
    protected FAIRSpecExtractorHelper.FileList lstIgnored;
    protected final FAIRSpecExtractorHelper.FileList lstRejected = new FAIRSpecExtractorHelper.FileList(null, "rejected", ".");
    protected FAIRSpecExtractorHelper.FileList lstWritten = new FAIRSpecExtractorHelper.FileList(null, "written", null);
    protected List<ExtractorUtils.ObjectParser> objectParsers;
    protected String originPath;
    protected Pattern rezipCachePattern;
    protected ArrayList<Object> rootPaths = new ArrayList();
    private DefaultStructureHelper structurePropertyManager;
    protected File targetDir;
    protected Map<String, ExtractorUtils.CacheRepresentation> vendorCache;
    protected Pattern vendorCachePattern;

    IFDExtractorLayer0() {
    }

    protected void checkStopAfter(String what) {
        this.log("!" + what + " #struc=" + this.faHelper.getStructureCollection().size() + " #spec=" + this.faHelper.getSpecCollection().size() + " #cmpd=" + this.faHelper.getCompoundCollection().size());
        boolean stopping = what.equals(this.stopAfter);
        if (stopping) {
            this.log("stopping after " + what);
            System.exit(0);
        }
    }

    public int getErrorCount() {
        return this.errors;
    }

    @Override
    protected FAIRSpecFindingAidHelperI getHelper() {
        return this.faHelper;
    }

    protected DefaultStructureHelper getStructurePropertyManager() {
        return this.structurePropertyManager == null ? (this.structurePropertyManager = new DefaultStructureHelper(this)) : this.structurePropertyManager;
    }

    protected void initializeExtractor() {
        this.setConfiguration();
        this.setDefaultRunParams();
    }

    protected FAIRSpecExtractorHelper newExtractionHelper() throws IFDException {
        return new FAIRSpecExtractorHelper(this, this.getCodeSource() + " " + this.getVersion());
    }

    private void setConfiguration() {
        try {
            this.config = FAIRSpecUtilities.getJSONResource(IFDExtractor.class, "extractor.config.json");
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }
}

