/*
 * Decompiled with CFR 0.152.
 */
package com.integratedgraphics.extractor;

import com.integratedgraphics.html.PageCreator;
import com.integratedgraphics.ifd.api.VendorPluginI;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.iupac.fairdata.common.IFDConst;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecFindingAid;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecFindingAidHelperI;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecUtilities;
import org.iupac.fairdata.core.IFDFindingAid;
import org.iupac.fairdata.core.IFDObject;
import org.iupac.fairdata.extract.MetadataReceiverI;

public abstract class FindingAidCreator
implements MetadataReceiverI {
    public boolean stopOnAnyFailure;
    public boolean debugReadOnly;
    public boolean createLandingPage = true;
    public boolean launchLandingPage = true;
    protected boolean debugging = false;
    public boolean readOnly = false;
    protected boolean isByID = true;
    protected boolean isByIDSet;
    protected boolean createFindingAidOnly = false;
    protected boolean allowNoPubInfo = false;
    protected boolean skipPubInfo = false;
    protected boolean addPublicationMetadata = false;
    protected boolean insitu = false;
    protected boolean createZippedCollection = true;
    protected boolean noOutput;
    protected boolean includeIgnoredFiles = true;
    protected FAIRSpecFindingAidHelperI faHelper;
    protected String localizedTopLevelZipURL;
    protected boolean haveExtracted;
    protected String errorLog = "";
    public int testID = -1;
    protected String thisRootPath;
    protected File targetPath;
    public String strWarnings = "";
    public int warnings;
    public int errors;
    protected boolean dataciteUp = true;
    protected boolean cleanCollectionDir = true;
    public boolean assetsOnly;
    protected String ifdid = "";

    protected FAIRSpecFindingAidHelperI getHelper() {
        return this.faHelper;
    }

    public void setTargetPath(File targetPath) {
        this.targetPath = targetPath;
    }

    public int getWarningCount() {
        return this.warnings;
    }

    protected void setDefaultRunParams() {
        System.out.flush();
        this.debugReadOnly = false;
        this.addPublicationMetadata = false;
        this.launchLandingPage = true;
        this.createLandingPage = true;
        this.cleanCollectionDir = true;
        this.stopOnAnyFailure = true;
        this.debugging = false;
        this.createFindingAidOnly = false;
        this.allowNoPubInfo = true;
        this.setDerivedFlags();
    }

    protected void setDerivedFlags() {
        this.createZippedCollection = this.createZippedCollection && !this.insitu && !this.debugReadOnly;
        this.cleanCollectionDir &= !this.insitu;
        this.readOnly |= this.debugReadOnly;
        this.noOutput = this.createFindingAidOnly || this.readOnly;
        this.skipPubInfo = !this.dataciteUp || this.debugReadOnly;
        this.createLandingPage &= !this.readOnly;
        this.launchLandingPage &= this.createLandingPage && !this.assetsOnly;
    }

    public String processFlags(String[] args, String moreFlags) {
        if (moreFlags == null) {
            moreFlags = "";
        }
        moreFlags = moreFlags + ";";
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            moreFlags = moreFlags + "-" + args[i] + ";";
        }
        moreFlags = this.checkFlags(moreFlags);
        this.setDerivedFlags();
        return moreFlags;
    }

    protected String checkFlags(String flags) {
        if ((flags = flags.toLowerCase()).indexOf("-") < 0) {
            flags = "-" + flags.replaceAll("\\;", "-;") + ";";
        }
        if (flags.indexOf("-addpublicationmetadata;") >= 0) {
            this.addPublicationMetadata = true;
        }
        if (flags.indexOf("-byid;") >= 0) {
            this.setExtractorOption(IFDConst.IFD_PROPERTY_COLLECTIONSET_BYID, "true");
        }
        if (flags.indexOf("-datacitedown;") >= 0) {
            this.dataciteUp = false;
        }
        if (flags.indexOf("-debugging;") >= 0) {
            this.debugging = true;
        }
        if (flags.indexOf("-debugreadonly;") >= 0) {
            this.debugReadOnly = true;
        }
        if (flags.indexOf("-findingaidonly;") >= 0) {
            this.createFindingAidOnly = true;
        }
        if (flags.indexOf("-noclean;") >= 0) {
            this.cleanCollectionDir = false;
        }
        if (flags.indexOf("-noignored;") >= 0) {
            this.includeIgnoredFiles = false;
        }
        if (flags.indexOf("-nopubinfo;") >= 0) {
            this.skipPubInfo = true;
        }
        if (flags.indexOf("-nostoponfailure;") >= 0) {
            this.stopOnAnyFailure = false;
        }
        if (flags.indexOf("-nolandingpage;") >= 0) {
            this.createLandingPage = false;
        }
        if (flags.indexOf("-nolaunch;") >= 0) {
            this.launchLandingPage = false;
        }
        if (flags.indexOf("-nozip;") >= 0) {
            this.createZippedCollection = false;
        }
        if (flags.indexOf("-insitu;") >= 0) {
            this.insitu = true;
        }
        if (flags.indexOf("-readonly;") >= 0) {
            this.readOnly = true;
        }
        if (flags.indexOf("-requirepubinfo;") >= 0) {
            this.allowNoPubInfo = false;
        }
        if (flags.indexOf("-assetsonly;") >= 0) {
            this.assetsOnly = true;
        }
        return flags;
    }

    protected static String getFlagEquals(String flags, String flag) {
        int pt = flags.indexOf(flag + "=");
        if (pt < 0) {
            return null;
        }
        String val = flags.substring(pt + flag.length() + 1);
        return val.substring(0, val.indexOf(";"));
    }

    protected void setExtractorOption(String key, String val) {
        if (!this.isByIDSet && key.equals(IFDConst.IFD_PROPERTY_COLLECTIONSET_BYID)) {
            this.isByID = val.equalsIgnoreCase("true");
            this.isByIDSet = true;
            this.getHelper().setById(this.isByID);
        } else {
            this.checkFlags(val);
        }
    }

    protected boolean processDOIURLs(String pubdoi, String datadoi, FAIRSpecFindingAidHelperI helper) throws IOException {
        String err;
        if (this.skipPubInfo) {
            return true;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (pubdoi != null && (err = helper.addRelatedInfo(pubdoi, this.addPublicationMetadata, list, "Crossref")) != null) {
            this.logWarn(err, "processDOIURLs");
            if (!this.allowNoPubInfo) {
                return false;
            }
        }
        if (datadoi != null && !this.skipPubInfo && (err = helper.addRelatedInfo(datadoi, this.addPublicationMetadata, list, "DataCite")) != null) {
            this.logWarn(err, "processDOIURLs");
            if (!this.allowNoPubInfo) {
                return false;
            }
        }
        return true;
    }

    protected boolean processPubURI() throws IOException {
        String pubdoi;
        String datadoi = (String)this.faHelper.getFindingAid().getPropertyValue(IFDConst.IFD_PROPERTY_COLLECTIONSET_SOURCE_DATA_DOI);
        if (datadoi == null) {
            datadoi = (String)this.faHelper.getFindingAid().getPropertyValue(IFDConst.IFD_PROPERTY_COLLECTIONSET_SOURCE_DATA_URI);
        }
        if ((pubdoi = (String)this.faHelper.getFindingAid().getPropertyValue(IFDConst.IFD_PROPERTY_COLLECTIONSET_SOURCE_PUBLICATION_DOI)) == null) {
            pubdoi = (String)this.faHelper.getFindingAid().getPropertyValue(IFDConst.IFD_PROPERTY_COLLECTIONSET_SOURCE_PUBLICATION_URI);
        }
        return this.processDOIURLs(pubdoi, datadoi, this.faHelper);
    }

    protected void logDigitalItemIgnored(String originPath, String localPath, String why, String method) {
        this.logWarn("digital item ignored, because " + why + ": " + originPath, method);
    }

    protected void logNote(String msg, String method) {
        msg = "!NOTE: " + msg + " -- Extractor." + method + " " + this.ifdid + " " + this.thisRootPath;
        this.log(msg);
    }

    protected void logWarn(String msg, String method) {
        msg = "! WARNING: " + msg + " -- Extractor." + method + " " + this.ifdid + " " + this.thisRootPath;
        this.log(msg);
    }

    public void logErr(String msg, String method) {
        msg = "!! ERROR: " + msg + " -- Extractor." + method + " " + this.ifdid + " " + this.thisRootPath;
        this.log(msg);
    }

    @Override
    public void log(String msg) {
        if (msg.startsWith("!!")) {
            ++this.errors;
            this.errorLog = this.errorLog + msg + "\n";
        } else if (msg.startsWith("! ")) {
            ++this.warnings;
            this.errorLog = this.errorLog + msg + "\n";
        }
        this.logToSys(msg);
    }

    public void logToSys(String msg) {
        boolean toSysOut;
        boolean toSysErr;
        if (FindingAidCreator.logging() && msg == "!!") {
            FAIRSpecUtilities.refreshLog();
        }
        boolean bl = toSysErr = msg.startsWith("!!") || msg.startsWith("! ");
        if (toSysErr) {
            this.strWarnings = this.strWarnings + msg + "\n";
        }
        boolean bl2 = toSysOut = toSysErr || msg.startsWith("!");
        if (this.testID >= 0) {
            msg = "test " + this.testID + ": " + msg;
        }
        if (FindingAidCreator.logging()) {
            try {
                FAIRSpecUtilities.logStream.write((msg + "\n").getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.out.flush();
        System.err.flush();
        if (toSysErr) {
            System.err.println(msg);
        } else if (toSysOut) {
            System.out.println(msg);
        }
        System.out.flush();
        System.err.flush();
    }

    protected static boolean logging() {
        return FAIRSpecUtilities.logStream != null;
    }

    @Override
    public IFDFindingAid getFindingAid() {
        return this.getHelper().getFindingAid();
    }

    protected void buildSite(File htmlPath) {
        try {
            PageCreator.buildSite(htmlPath, true, this.launchLandingPage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setNewObjectMetadata(IFDObject<?> o, String param) {
    }

    static {
        FAIRSpecFindingAid.loadProperties();
        VendorPluginI.init();
    }
}

