/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util.hash;

import com.actelion.research.calc.ArrayUtilsCalc;
import java.util.List;

public class HashSetInt {
    private int[][] data;
    private static final int DEFAULT_INITIAL_CAPACITY = 256;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private int threshold;
    private int size;
    private double loadFactor;

    public HashSetInt() {
        this.data = new int[256][];
        this.loadFactor = 0.75;
        this.threshold = (int)(256.0 * this.loadFactor);
    }

    public HashSetInt(int n) {
        double d = Math.log10(n) / Math.log10(2.0);
        int n2 = (int)Math.pow(2.0, (int)(d + 1.0));
        this.data = new int[n2][];
        this.loadFactor = 0.75;
        this.threshold = (int)((double)n2 * this.loadFactor);
    }

    public HashSetInt(List<Integer> list) {
        this(list.size());
        for (Integer n : list) {
            this.add(n);
        }
    }

    public HashSetInt(int[] nArray) {
        this(nArray.length);
        for (int n : nArray) {
            this.add(n);
        }
    }

    static int indexFor(int n, int n2) {
        return n & n2 - 1;
    }

    public void clear() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = null;
        }
        this.size = 0;
    }

    public boolean add(int n) {
        if (this.isEntry(n)) {
            return false;
        }
        int n2 = n;
        int n3 = HashSetInt.indexFor(n2, this.data.length);
        int[] nArray = null;
        if (this.data[n3] == null) {
            nArray = new int[1];
        } else {
            nArray = new int[this.data[n3].length + 1];
            System.arraycopy(this.data[n3], 0, nArray, 0, this.data[n3].length);
        }
        nArray[nArray.length - 1] = n;
        this.data[n3] = nArray;
        ++this.size;
        if (this.size > this.threshold) {
            this.resize(this.data.length * 2);
        }
        return true;
    }

    public boolean add(int[] nArray) {
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            if (this.add(nArray[i])) continue;
            bl = false;
        }
        return bl;
    }

    public boolean add(List<Integer> list) {
        boolean bl = true;
        for (int i = 0; i < list.size(); ++i) {
            if (this.add(list.get(i))) continue;
            bl = false;
        }
        return bl;
    }

    void resize(int n) {
        int[][] nArrayArray = new int[n][];
        this.transfer(nArrayArray);
        int n2 = this.data.length;
        if (n2 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        this.threshold = (int)((double)n * this.loadFactor);
    }

    public void remove(int n) {
        int n2 = HashSetInt.indexFor(n, this.data.length);
        int[] nArray = this.data[n2];
        if (nArray == null) {
            return;
        }
        int n3 = -1;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            n3 = i;
            break;
        }
        if (n3 == -1) {
            return;
        }
        if (nArray.length == 1) {
            this.data[n2] = null;
        } else {
            int[] nArray2 = new int[nArray.length - 1];
            int n4 = 0;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == n) continue;
                nArray2[n4++] = nArray[i];
            }
            this.data[n2] = nArray2;
        }
        --this.size;
    }

    void transfer(int[][] nArray) {
        for (int[] nArray2 : this.data) {
            if (nArray2 == null) continue;
            for (int i = 0; i < nArray2.length; ++i) {
                int n = HashSetInt.indexFor(nArray2[i], nArray.length);
                int[] nArray3 = null;
                if (nArray[n] == null) {
                    nArray3 = new int[1];
                } else {
                    nArray3 = new int[nArray[n].length + 1];
                    System.arraycopy(nArray[n], 0, nArray3, 0, nArray[n].length);
                }
                nArray3[nArray3.length - 1] = nArray2[i];
                nArray[n] = nArray3;
            }
        }
        this.data = nArray;
    }

    public boolean contains(int n) {
        return this.isEntry(n);
    }

    private boolean isEntry(int n) {
        int n2 = HashSetInt.indexFor(n, this.data.length);
        int[] nArray = this.data[n2];
        if (nArray == null) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public int size() {
        return this.size;
    }

    public int[] getValues() {
        int[] nArray = new int[this.size];
        int n = 0;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == null) continue;
            for (int j = 0; j < this.data[i].length; ++j) {
                nArray[n++] = this.data[i][j];
            }
        }
        return nArray;
    }

    public List<Integer> toList() {
        return ArrayUtilsCalc.toList(this.getValues());
    }
}

