/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util.graph.complete;

import com.actelion.research.util.graph.complete.ContainerMemory;
import com.actelion.research.util.graph.complete.FactorySolution;
import com.actelion.research.util.graph.complete.ICompleteGraph;
import com.actelion.research.util.graph.complete.IObjectiveCompleteGraph;
import com.actelion.research.util.graph.complete.SolutionCompleteGraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class CompleteGraphMatcher<T extends ICompleteGraph> {
    public static final boolean DEBUG = false;
    public static final int MIN_NUM_NODES_SIM = 2;
    public static final int MAX_NUM_NODES = 127;
    private static final int INIT_CAPACITY_MEMORY = 1000;
    private static final int SIZE_LIST_SOLUTION = 1000;
    public static final int MAX_NUM_SOLUTIONS = 10000;
    public static final byte DEFAULT_VAL = -1;
    private IObjectiveCompleteGraph<T> objectiveCompleteGraph;
    private int maxNumSolutions;
    private int nodesBase;
    private int nodesQuery;
    private ContainerMemory<SolutionCompleteGraph> cm;
    private List<List<SolutionCompleteGraph>> liliSolution;
    private HashSet<SolutionCompleteGraph> hsSolution;
    private byte[] arrIndexBaseTmp;
    private byte[] arrIndexQueryTmp;
    private SolutionCompleteGraph solutionBest;
    private long validSolutions;
    private long createdSolutions;
    private boolean nodeSimilarityWithoutSizeDifference;

    public CompleteGraphMatcher(IObjectiveCompleteGraph<T> iObjectiveCompleteGraph) {
        this.objectiveCompleteGraph = iObjectiveCompleteGraph;
        this.init();
    }

    public void setObjective(IObjectiveCompleteGraph<T> iObjectiveCompleteGraph) {
        this.objectiveCompleteGraph = iObjectiveCompleteGraph;
    }

    public void setVerbose(boolean bl) {
        this.objectiveCompleteGraph.setVerbose(bl);
    }

    public IObjectiveCompleteGraph<T> getObjectiveCompleteGraph() {
        return this.objectiveCompleteGraph;
    }

    private void init() {
        this.maxNumSolutions = 10000;
        this.cm = new ContainerMemory<SolutionCompleteGraph>(1000, new FactorySolution());
        this.liliSolution = new ArrayList<List<SolutionCompleteGraph>>(127);
        this.liliSolution.add(new ArrayList());
        for (int i = 1; i < 127; ++i) {
            this.liliSolution.add(new ArrayList(1000));
        }
        this.hsSolution = new HashSet(1000);
        this.arrIndexBaseTmp = new byte[127];
        this.arrIndexQueryTmp = new byte[127];
        this.solutionBest = new SolutionCompleteGraph();
        this.nodeSimilarityWithoutSizeDifference = false;
    }

    public void setNodeSimilarityWithoutSizeDifference(boolean bl) {
        this.nodeSimilarityWithoutSizeDifference = bl;
    }

    public void set(T t, T t2) {
        this.objectiveCompleteGraph.setBase(t);
        this.objectiveCompleteGraph.setQuery(t2);
    }

    private void initSearch() {
        List<SolutionCompleteGraph> list2;
        this.cm.reset();
        this.nodesBase = this.objectiveCompleteGraph.getBase().getNumPPNodes();
        this.nodesQuery = this.objectiveCompleteGraph.getQuery().getNumPPNodes();
        for (List<SolutionCompleteGraph> list2 : this.liliSolution) {
            list2.clear();
        }
        this.hsSolution.clear();
        int n = 1;
        list2 = this.liliSolution.get(n);
        for (byte by = 0; by < this.nodesQuery; by = (byte)((byte)(by + 1))) {
            for (byte by2 = 0; by2 < this.nodesBase; by2 = (byte)((byte)(by2 + 1))) {
                if (!this.objectiveCompleteGraph.areNodesMapping(by, by2)) continue;
                SolutionCompleteGraph solutionCompleteGraph = this.cm.get();
                solutionCompleteGraph.setNodesQuery(this.nodesQuery);
                solutionCompleteGraph.add(by, by2);
                list2.add(solutionCompleteGraph);
            }
        }
    }

    public double calculateSimilarity() {
        List<SolutionCompleteGraph> list;
        this.initSearch();
        if (this.nodesBase == 1 && this.nodesQuery == 1) {
            double d = this.objectiveCompleteGraph.getSimilarityNodes(0, 0);
            return d;
        }
        if (this.objectiveCompleteGraph.isModeFragment() && this.nodesQuery == 1) {
            List<SolutionCompleteGraph> list2 = this.liliSolution.get(1);
            double d = 0.0;
            for (SolutionCompleteGraph solutionCompleteGraph : list2) {
                double d2 = this.objectiveCompleteGraph.getSimilarity(solutionCompleteGraph);
                if (!(d2 > d)) continue;
                d = d2;
                this.solutionBest = solutionCompleteGraph;
            }
            return d;
        }
        int n = 0;
        for (int i = 1; i < this.nodesBase + 1; ++i) {
            list = this.liliSolution.get(i);
            boolean bl = false;
            this.hsSolution.clear();
            for (SolutionCompleteGraph solutionCompleteGraph : list) {
                if (this.getNeighbourSolutions(solutionCompleteGraph)) {
                    bl = true;
                }
                if (this.hsSolution.size() <= this.maxNumSolutions) continue;
                break;
            }
            if (!bl) break;
            n = i + 1;
            this.liliSolution.get(n).addAll(this.hsSolution);
            List<SolutionCompleteGraph> list3 = this.liliSolution.get(i);
            for (SolutionCompleteGraph solutionCompleteGraph : list3) {
                this.cm.back(solutionCompleteGraph);
            }
            list3.clear();
        }
        if (n == 0) {
            return 0.0;
        }
        if (!this.objectiveCompleteGraph.isModeFragment() && n < 2) {
            return 0.0;
        }
        List<SolutionCompleteGraph> list4 = this.liliSolution.get(n);
        list = new ArrayList<SolutionCompleteGraph>();
        for (SolutionCompleteGraph solutionCompleteGraph : list4) {
            float f = this.objectiveCompleteGraph.getSimilarity(solutionCompleteGraph);
            solutionCompleteGraph.setSimilarity(f);
            list.add(solutionCompleteGraph);
        }
        Collections.sort(list);
        this.solutionBest.copyIntoThis(list.get(list.size() - 1));
        double d = this.solutionBest.getSimilarity();
        return d;
    }

    public double calculateNodeSimilarity() {
        List<SolutionCompleteGraph> list;
        this.initSearch();
        if (this.nodesBase == 1 && this.nodesQuery == 1) {
            double d = this.objectiveCompleteGraph.getSimilarityNodes(0, 0);
            return d;
        }
        if (this.objectiveCompleteGraph.isModeFragment() && this.nodesQuery == 1) {
            List<SolutionCompleteGraph> list2 = this.liliSolution.get(1);
            double d = 0.0;
            for (SolutionCompleteGraph solutionCompleteGraph : list2) {
                double d2 = this.objectiveCompleteGraph.getSimilarityNodes(solutionCompleteGraph);
                if (!(d2 > d)) continue;
                d = d2;
                this.solutionBest = solutionCompleteGraph;
            }
            return d;
        }
        int n = 0;
        for (int i = 1; i < this.nodesBase + 1; ++i) {
            list = this.liliSolution.get(i);
            boolean bl = false;
            this.hsSolution.clear();
            for (SolutionCompleteGraph solutionCompleteGraph : list) {
                if (this.getNeighbourSolutions(solutionCompleteGraph)) {
                    bl = true;
                }
                if (this.hsSolution.size() <= this.maxNumSolutions) continue;
                break;
            }
            if (!bl) break;
            n = i + 1;
            this.liliSolution.get(n).addAll(this.hsSolution);
            List<SolutionCompleteGraph> list3 = this.liliSolution.get(i);
            for (SolutionCompleteGraph solutionCompleteGraph : list3) {
                this.cm.back(solutionCompleteGraph);
            }
            list3.clear();
        }
        if (n == 0) {
            return 0.0;
        }
        if (!this.objectiveCompleteGraph.isModeFragment() && n < 2) {
            return 0.0;
        }
        List<SolutionCompleteGraph> list4 = this.liliSolution.get(n);
        list = new ArrayList<SolutionCompleteGraph>();
        for (SolutionCompleteGraph solutionCompleteGraph : list4) {
            double d = this.objectiveCompleteGraph.getSimilarityNodes(solutionCompleteGraph);
            solutionCompleteGraph.setSimilarity(d);
            list.add(solutionCompleteGraph);
        }
        Collections.sort(list);
        this.solutionBest.copyIntoThis(list.get(list.size() - 1));
        double d = this.solutionBest.getSimilarity();
        return d;
    }

    public SolutionCompleteGraph getBestMatchingSolution() {
        SolutionCompleteGraph solutionCompleteGraph = new SolutionCompleteGraph();
        solutionCompleteGraph.copyIntoThis(this.solutionBest);
        return solutionCompleteGraph;
    }

    private boolean getNeighbourSolutions(SolutionCompleteGraph solutionCompleteGraph) {
        byte by;
        boolean bl = false;
        int n = solutionCompleteGraph.getSizeHeap();
        for (by = 0; by < this.arrIndexBaseTmp.length; ++by) {
            this.arrIndexBaseTmp[by] = 0;
            this.arrIndexQueryTmp[by] = 0;
        }
        for (by = 0; by < n; ++by) {
            this.arrIndexBaseTmp[solutionCompleteGraph.getIndexBaseFromHeap((int)by)] = 1;
            this.arrIndexQueryTmp[solutionCompleteGraph.getIndexQueryFromHeap((int)by)] = 1;
        }
        for (by = 0; by < this.nodesQuery; by = (byte)((byte)(by + 1))) {
            if (this.arrIndexQueryTmp[by] != 0) continue;
            for (byte by2 = 0; by2 < this.nodesBase; by2 = (byte)((byte)(by2 + 1))) {
                if (this.arrIndexBaseTmp[by2] != 0 || !this.objectiveCompleteGraph.areNodesMapping(by, by2)) continue;
                SolutionCompleteGraph solutionCompleteGraph2 = this.cm.getWithCopy(solutionCompleteGraph);
                solutionCompleteGraph2.copyIntoThis(solutionCompleteGraph);
                solutionCompleteGraph2.setNodesQuery(this.nodesQuery);
                solutionCompleteGraph2.add(by, by2);
                ++this.createdSolutions;
                if (this.hsSolution.contains(solutionCompleteGraph2)) {
                    this.cm.back(solutionCompleteGraph2);
                    continue;
                }
                if (this.objectiveCompleteGraph.isValidSolution(solutionCompleteGraph2)) {
                    this.hsSolution.add(solutionCompleteGraph2);
                    bl = true;
                    ++this.validSolutions;
                    continue;
                }
                this.cm.back(solutionCompleteGraph2);
            }
        }
        return bl;
    }

    public long getValidSolutions() {
        return this.validSolutions;
    }

    public long getCreatedSolutions() {
        return this.createdSolutions;
    }

    public void setMaxNumSolutions(int n) {
        this.maxNumSolutions = n;
    }
}

