/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util.datamodel;

import com.actelion.research.calc.Matrix;
import com.actelion.research.util.datamodel.IntVec;
import com.actelion.research.util.datamodel.ModelXY;
import com.actelion.research.util.datamodel.XY;
import com.actelion.research.util.datamodel.XYIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ModelXYIndex
extends ModelXY {
    public List<Integer> liIndex;

    public ModelXYIndex() {
    }

    public ModelXYIndex(Matrix matrix, Matrix matrix2) {
        super(matrix, matrix2);
    }

    public ModelXYIndex(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    public ModelXYIndex(ModelXYIndex modelXYIndex) {
        super(modelXYIndex);
        this.liIndex = new ArrayList<Integer>(modelXYIndex.X.rows());
        for (int n : modelXYIndex.liIndex) {
            this.liIndex.add(n);
        }
    }

    public ModelXYIndex(ModelXY modelXY) {
        super(modelXY);
    }

    public ModelXYIndex sub(int n, int n2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n2 - n);
        for (int i = n; i < n2; ++i) {
            arrayList.add(i);
        }
        return this.sub(arrayList);
    }

    public ModelXYIndex sub(List<Integer> list) {
        ModelXYIndex modelXYIndex = new ModelXYIndex();
        modelXYIndex.X = this.X.getSubMatrix(list);
        modelXYIndex.Y = this.Y.getSubMatrix(list);
        modelXYIndex.liIndex = new ArrayList<Integer>(list);
        return modelXYIndex;
    }

    public void sub(List<Integer> list, ModelXYIndex modelXYIndex) {
        if (modelXYIndex.X.rows() != list.size() || modelXYIndex.Y.rows() != list.size()) {
            throw new RuntimeException("Wrong number of rows!");
        }
        for (int i = 0; i < list.size(); ++i) {
            int n = list.get(i);
            double[] dArray = this.X.getRow(n);
            modelXYIndex.X.setRow(i, dArray);
            double[] dArray2 = this.Y.getRow(n);
            modelXYIndex.Y.setRow(i, dArray2);
        }
    }

    public ModelXYIndex getVariableSelectionOnX(IntVec intVec) {
        int n = intVec.getBitsSet();
        Matrix matrix = new Matrix(this.X.rows(), n);
        int n2 = intVec.sizeBits();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!intVec.isBitSet(i)) continue;
            matrix.copyColumn(this.X, i, n3++);
        }
        ModelXYIndex modelXYIndex = new ModelXYIndex();
        modelXYIndex.X = matrix;
        modelXYIndex.Y = new Matrix(this.Y);
        if (this.liIndex != null) {
            modelXYIndex.liIndex = new ArrayList<Integer>(this.X.rows());
            for (int n4 : this.liIndex) {
                modelXYIndex.liIndex.add(n4);
            }
        }
        return modelXYIndex;
    }

    @Override
    public ModelXYIndex getDeepClone() {
        return new ModelXYIndex(this);
    }

    public List<XYIndex> getAsListWithIndex() {
        int n = this.X.rows();
        ArrayList<XYIndex> arrayList = new ArrayList<XYIndex>(n);
        for (int i = 0; i < n; ++i) {
            XYIndex xYIndex = new XYIndex(this.X.getRowCopy(i), this.Y.getRowCopy(i));
            if (this.liIndex != null) {
                xYIndex.index = this.liIndex.get(i);
            }
            arrayList.add(xYIndex);
        }
        return arrayList;
    }

    @Override
    public ModelXYIndex getSortedByY(int n) {
        List<XYIndex> list = this.getAsListWithIndex();
        Collections.sort(list, XY.getComparatorY(n));
        double[][] dArrayArray = new double[list.size()][];
        double[][] dArrayArray2 = new double[list.size()][];
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            dArrayArray[i] = list.get((int)i).x;
            dArrayArray2[i] = list.get((int)i).y;
            arrayList.add(list.get((int)i).index);
        }
        ModelXYIndex modelXYIndex = new ModelXYIndex();
        modelXYIndex.X = new Matrix(dArrayArray);
        modelXYIndex.Y = new Matrix(dArrayArray2);
        modelXYIndex.liIndex = arrayList;
        return modelXYIndex;
    }
}

