/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util.datamodel;

import com.actelion.research.util.datamodel.IIdentifiedObject;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class IdentifiedObject<T>
implements IIdentifiedObject<T>,
Comparable<IdentifiedObject<T>> {
    private T data;
    private long id;

    public IdentifiedObject() {
    }

    public IdentifiedObject(T t, long l) {
        this.data = t;
        this.id = l;
    }

    @Override
    public T getData() {
        return this.data;
    }

    @Override
    public void setData(T t) {
        this.data = t;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long l) {
        this.id = l;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.id);
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(IdentifiedObject<T> identifiedObject) {
        if (this.id > identifiedObject.id) {
            return 1;
        }
        if (this.id < identifiedObject.id) {
            return -1;
        }
        return 0;
    }

    public static <T> HashMap<Long, T> getHashMap(List<IdentifiedObject<T>> list) {
        HashMap<Long, T> hashMap = new HashMap<Long, T>(list.size());
        for (IdentifiedObject<T> identifiedObject : list) {
            hashMap.put(identifiedObject.getId(), identifiedObject.getData());
        }
        return hashMap;
    }

    public static void shuffleArray(IdentifiedObject[] identifiedObjectArray) {
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        for (int i = identifiedObjectArray.length - 1; i > 0; --i) {
            int n = ((Random)threadLocalRandom).nextInt(i + 1);
            IdentifiedObject identifiedObject = identifiedObjectArray[n];
            identifiedObjectArray[n] = identifiedObjectArray[i];
            identifiedObjectArray[i] = identifiedObject;
        }
    }

    public static Comparator<IdentifiedObject> getComparatorId() {
        return new Comparator<IdentifiedObject>(){

            @Override
            public int compare(IdentifiedObject identifiedObject, IdentifiedObject identifiedObject2) {
                if (identifiedObject.id > identifiedObject2.id) {
                    return 1;
                }
                if (identifiedObject2.id > identifiedObject.id) {
                    return -1;
                }
                return identifiedObject2.compareTo(identifiedObject);
            }
        };
    }
}

