/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

public class Platform {
    private static boolean isWin = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
    private static boolean isMac = System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0;
    private static boolean isLinux = System.getProperty("os.name").toLowerCase().indexOf("nux") >= 0;
    private static boolean isUnix = System.getProperty("os.name").toLowerCase().indexOf("nix") >= 0;
    private static Properties PATH_PROPERTIES = null;
    private static String WINPATH = "\\\\idorsia.com\\app\\DDSC\\config";
    private static String WINPROPERTIES = WINPATH + "\\ApplicationDatabase.db";
    private static final String[] WINDOWS_APP_DIR = new String[]{"C:\\Program Files\\", "C:\\Program Files (x86)\\"};
    private static final String[][] WINDOWS_APPL_NAME = new String[][]{{"datawarrior", "DataWarrior\\DataWarrior.exe"}, {"orbit", "Orbit\\Orbit.exe"}, {"pymol", "PyMOL\\pymol.exe"}};
    private static final String[][] MACINTOSH_APP_NAME = new String[][]{{"orbit", "Orbit Image Analysis"}, {"datawarrior", "DataWarrior"}, {"actelion3d", "Actelion3D"}, {"pymol", "PyMol"}, {"spirit", "Spirit Database"}};

    public static boolean isWindows() {
        return isWin;
    }

    public static boolean isMacintosh() {
        return isMac;
    }

    public static boolean isLinux() {
        return isLinux;
    }

    public static boolean isUnix() {
        return isUnix;
    }

    public static boolean is64BitJRE() {
        return System.getProperty("os.arch").indexOf("64") != -1;
    }

    public static Process execute(String string, String ... stringArray) throws IOException {
        String string2 = Platform.findExecutable(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        if (stringArray != null && stringArray.length > 0) {
            for (String string3 : stringArray) {
                arrayList.add(string3);
            }
        }
        Process process = Platform.systemExec(arrayList.toArray(new String[0]));
        return process;
    }

    public static void execute(String[] stringArray) throws IOException {
        stringArray[0] = Platform.findExecutable(stringArray[0]);
        Platform.systemExec(stringArray);
    }

    public static Process systemExec(String[] stringArray) throws IOException {
        if (Platform.isWindows()) {
            String[] stringArray2 = new String[stringArray.length + 4];
            stringArray2[0] = "cmd";
            stringArray2[1] = "/c";
            stringArray2[2] = "start";
            stringArray2[3] = "\"\"";
            System.arraycopy(stringArray, 0, stringArray2, 4, stringArray.length);
            stringArray = stringArray2;
        }
        return Runtime.getRuntime().exec(stringArray);
    }

    public static void openDocument(String string) throws IOException, UnsupportedOperationException {
        if (!Desktop.isDesktopSupported()) {
            if (Platform.isLinux()) {
                throw new UnsupportedOperationException("Please check your OS installation: Is the libgnome2 library missing?");
            }
            throw new UnsupportedOperationException("Desktop integration on this OS/Machine not supported");
        }
        Desktop.getDesktop().open(new File(string));
    }

    private static String findExecutable(String object) {
        Object object4 = object;
        if (Platform.isWindows()) {
            for (Object object2 : WINDOWS_APPL_NAME) {
                if (!object2[0].equals(object)) continue;
                for (String string : WINDOWS_APP_DIR) {
                    String string2 = string.concat((String)object2[1]);
                    if (!new File(string2).exists()) continue;
                    return string2;
                }
            }
            for (Object object2 : WINDOWS_APP_DIR) {
                String string = ((String)object2).concat((String)object).concat("\\").concat((String)object).concat(".exe");
                if (!new File(string).exists()) continue;
                return string;
            }
            try {
                String string;
                if (PATH_PROPERTIES == null) {
                    PATH_PROPERTIES = new Properties();
                    PATH_PROPERTIES.load(new FileInputStream(WINPROPERTIES));
                }
                if ((string = PATH_PROPERTIES.getProperty((String)object)) != null) {
                    object4 = string;
                }
            }
            catch (Throwable throwable) {
                System.err.println("Error reading Application Database file: " + throwable);
            }
        }
        if (Platform.isMacintosh()) {
            for (Object object2 : MACINTOSH_APP_NAME) {
                if (!object2[0].equals(object)) continue;
                String string = "/Applications/" + (String)object2[1] + ".app/Contents/MacOS/" + (String)object;
                if (new File(string).exists()) {
                    return string;
                }
                String string3 = "/Applications/" + (String)object2[1] + ".app/Contents/MacOS/JavaApplicationStub";
                return new File(string3).exists() ? string3 : object4;
            }
        }
        if (Platform.isLinux()) {
            String string = "/opt/actelion/" + (String)object + "/" + (String)object;
            if (new File(string).exists()) {
                return string;
            }
            String string4 = "/opt/idorsia/" + (String)object + "/" + (String)object;
            if (new File(string4).exists()) {
                return string4;
            }
            String string5 = "/opt/" + (String)object + "/" + (String)object;
            if (new File(string5).exists()) {
                return string5;
            }
            return object4;
        }
        return object4;
    }
}

