/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import com.actelion.research.util.FittingFunction;

public class NumericalRecipes {
    private double _fit_siga;
    private double _fit_sigb;
    private double _fit_a;
    private double _fit_b;
    private double _fit_chi2;
    private double _fit_q;
    private double _gser_gamser;
    private double _gser_gln;
    private double _gcf_gammcf;
    private double _gcf_gln;
    private double ochisq;
    private double[] atry;
    private double[] beta;
    private double[] da;
    private double[][] oneda;
    private int mfit;

    public static void svbksb(double[][] dArray, double[] dArray2, double[][] dArray3, int n, int n2, double[] dArray4, double[] dArray5) {
        int n3;
        double d;
        int n4;
        double[] dArray6 = new double[n2];
        for (n4 = 0; n4 < n2; ++n4) {
            d = 0.0;
            if (dArray2[n4] != 0.0) {
                for (n3 = 0; n3 < n; ++n3) {
                    d += dArray[n3][n4] * dArray4[n3];
                }
                d /= dArray2[n4];
            }
            dArray6[n4] = d;
        }
        for (n4 = 0; n4 < n2; ++n4) {
            d = 0.0;
            for (n3 = 0; n3 < n2; ++n3) {
                d += dArray3[n4][n3] * dArray6[n3];
            }
            dArray5[n4] = d;
        }
    }

    public static void svdcmp(double[][] dArray, int n, int n2, double[] dArray2, double[][] dArray3) throws Exception {
        int n3;
        double d;
        double d2;
        int n4;
        double d3;
        int n5;
        double[] dArray4 = new double[n2];
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n6 = 0;
        for (n5 = 0; n5 < n2; ++n5) {
            n6 = n5 + 1;
            dArray4[n5] = d4 * d5;
            d4 = 0.0;
            d3 = 0.0;
            d5 = 0.0;
            if (n5 < n) {
                for (n4 = n5; n4 < n; ++n4) {
                    d4 += Math.abs(dArray[n4][n5]);
                }
                if (d4 != 0.0) {
                    for (n4 = n5; n4 < n; ++n4) {
                        double[] dArray5 = dArray[n4];
                        int n7 = n5;
                        dArray5[n7] = dArray5[n7] / d4;
                        d3 += dArray[n4][n5] * dArray[n4][n5];
                    }
                    d2 = dArray[n5][n5];
                    d5 = -NumericalRecipes.SIGN(Math.sqrt(d3), d2);
                    d = d2 * d5 - d3;
                    dArray[n5][n5] = d2 - d5;
                    for (n4 = n6; n4 < n2; ++n4) {
                        d3 = 0.0;
                        for (n3 = n5; n3 < n; ++n3) {
                            d3 += dArray[n3][n5] * dArray[n3][n4];
                        }
                        d2 = d3 / d;
                        for (n3 = n5; n3 < n; ++n3) {
                            double[] dArray6 = dArray[n3];
                            int n8 = n4;
                            dArray6[n8] = dArray6[n8] + d2 * dArray[n3][n5];
                        }
                    }
                    for (n4 = n5; n4 < n; ++n4) {
                        double[] dArray7 = dArray[n4];
                        int n9 = n5;
                        dArray7[n9] = dArray7[n9] * d4;
                    }
                }
            }
            dArray2[n5] = d4 * d5;
            d4 = 0.0;
            d3 = 0.0;
            d5 = 0.0;
            if (n5 < n && n5 != n2 - 1) {
                for (n4 = n6; n4 < n2; ++n4) {
                    d4 += Math.abs(dArray[n5][n4]);
                }
                if (d4 != 0.0) {
                    for (n4 = n6; n4 < n2; ++n4) {
                        double[] dArray8 = dArray[n5];
                        int n10 = n4;
                        dArray8[n10] = dArray8[n10] / d4;
                        d3 += dArray[n5][n4] * dArray[n5][n4];
                    }
                    d2 = dArray[n5][n6];
                    d5 = -NumericalRecipes.SIGN(Math.sqrt(d3), d2);
                    d = d2 * d5 - d3;
                    dArray[n5][n6] = d2 - d5;
                    for (n4 = n6; n4 < n2; ++n4) {
                        dArray4[n4] = dArray[n5][n4] / d;
                    }
                    for (n4 = n6; n4 < n; ++n4) {
                        d3 = 0.0;
                        for (n3 = n6; n3 < n2; ++n3) {
                            d3 += dArray[n4][n3] * dArray[n5][n3];
                        }
                        for (n3 = n6; n3 < n2; ++n3) {
                            double[] dArray9 = dArray[n4];
                            int n11 = n3;
                            dArray9[n11] = dArray9[n11] + d3 * dArray4[n3];
                        }
                    }
                    n4 = n6;
                    while (n4 < n2) {
                        double[] dArray10 = dArray[n5];
                        int n12 = n4++;
                        dArray10[n12] = dArray10[n12] * d4;
                    }
                }
            }
            d6 = Math.max(d6, Math.abs(dArray2[n5]) + Math.abs(dArray4[n5]));
        }
        n5 = n2 - 1;
        while (n5 >= 0) {
            if (n5 < n2 - 1) {
                if (d5 != 0.0) {
                    for (n4 = n6; n4 < n2; ++n4) {
                        dArray3[n4][n5] = dArray[n5][n4] / dArray[n5][n6] / d5;
                    }
                    for (n4 = n6; n4 < n2; ++n4) {
                        d3 = 0.0;
                        for (n3 = n6; n3 < n2; ++n3) {
                            d3 += dArray[n5][n3] * dArray3[n3][n4];
                        }
                        for (n3 = n6; n3 < n2; ++n3) {
                            double[] dArray11 = dArray3[n3];
                            int n13 = n4;
                            dArray11[n13] = dArray11[n13] + d3 * dArray3[n3][n5];
                        }
                    }
                }
                for (n4 = n6; n4 < n2; ++n4) {
                    dArray3[n4][n5] = 0.0;
                    dArray3[n5][n4] = 0.0;
                }
            }
            dArray3[n5][n5] = 1.0;
            d5 = dArray4[n5];
            n6 = n5--;
        }
        n5 = Math.min(n, n2) - 1;
        while (n5 >= 0) {
            n6 = n5 + 1;
            d5 = dArray2[n5];
            for (n4 = n6; n4 < n2; ++n4) {
                dArray[n5][n4] = 0.0;
            }
            if (d5 != 0.0) {
                d5 = 1.0 / d5;
                for (n4 = n6; n4 < n2; ++n4) {
                    d3 = 0.0;
                    for (n3 = n6; n3 < n; ++n3) {
                        d3 += dArray[n3][n5] * dArray[n3][n4];
                    }
                    d2 = d3 / dArray[n5][n5] * d5;
                    for (n3 = n5; n3 < n; ++n3) {
                        double[] dArray12 = dArray[n3];
                        int n14 = n4;
                        dArray12[n14] = dArray12[n14] + d2 * dArray[n3][n5];
                    }
                }
                for (n4 = n5; n4 < n; ++n4) {
                    double[] dArray13 = dArray[n4];
                    int n15 = n5;
                    dArray13[n15] = dArray13[n15] * d5;
                }
            } else {
                for (n4 = n5; n4 < n; ++n4) {
                    dArray[n4][n5] = 0.0;
                }
            }
            double[] dArray14 = dArray[n5];
            int n16 = n5--;
            dArray14[n16] = dArray14[n16] + 1.0;
        }
        block27: for (n5 = n2 - 1; n5 >= 0; --n5) {
            for (n4 = 1; n4 <= 30; ++n4) {
                double d7;
                double d8;
                int n17;
                int n18;
                double d9;
                n3 = 1;
                int n19 = 0;
                for (n6 = n5; n6 >= 0; --n6) {
                    n19 = n6 - 1;
                    if (Math.abs(dArray4[n6]) + d6 == d6) {
                        n3 = 0;
                        break;
                    }
                    if (Math.abs(dArray2[n19]) + d6 == d6) break;
                }
                if (n3 != 0) {
                    d9 = 0.0;
                    d3 = 1.0;
                    for (n18 = n6; n18 < n5; ++n18) {
                        d2 = d3 * dArray4[n18];
                        dArray4[n18] = d9 * dArray4[n18];
                        if (Math.abs(d2) + d6 == d6) break;
                        d5 = dArray2[n18];
                        dArray2[n18] = d = NumericalRecipes.pythag(d2, d5);
                        d = 1.0 / d;
                        d9 = d5 * d;
                        d3 = -d2 * d;
                        for (n17 = 0; n17 < n; ++n17) {
                            d8 = dArray[n17][n19];
                            d7 = dArray[n17][n18];
                            dArray[n17][n19] = d8 * d9 + d7 * d3;
                            dArray[n17][n18] = d7 * d9 - d8 * d3;
                        }
                    }
                }
                d7 = dArray2[n5];
                if (n6 == n5) {
                    if (!(d7 < 0.0)) continue block27;
                    dArray2[n5] = -d7;
                    for (n18 = 0; n18 < n2; ++n18) {
                        dArray3[n18][n5] = -dArray3[n18][n5];
                    }
                    continue block27;
                }
                if (n4 == 30) {
                    NumericalRecipes.nrerror("no convergence in 30 svdcmp iterations");
                }
                double d10 = dArray2[n6];
                n19 = n5 - 1;
                d8 = dArray2[n19];
                d5 = dArray4[n19];
                d = dArray4[n5];
                d2 = ((d8 - d7) * (d8 + d7) + (d5 - d) * (d5 + d)) / (2.0 * d * d8);
                d5 = NumericalRecipes.pythag(d2, 1.0);
                d2 = ((d10 - d7) * (d10 + d7) + d * (d8 / (d2 + NumericalRecipes.SIGN(d5, d2)) - d)) / d10;
                d3 = 1.0;
                d9 = 1.0;
                for (n18 = n6; n18 <= n19; ++n18) {
                    int n20;
                    n17 = n18 + 1;
                    d5 = dArray4[n17];
                    d8 = dArray2[n17];
                    d = d3 * d5;
                    d5 = d9 * d5;
                    dArray4[n18] = d7 = NumericalRecipes.pythag(d2, d);
                    d9 = d2 / d7;
                    d3 = d / d7;
                    d2 = d10 * d9 + d5 * d3;
                    d5 = d5 * d9 - d10 * d3;
                    d = d8 * d3;
                    d8 *= d9;
                    for (n20 = 0; n20 < n2; ++n20) {
                        d10 = dArray3[n20][n18];
                        d7 = dArray3[n20][n17];
                        dArray3[n20][n18] = d10 * d9 + d7 * d3;
                        dArray3[n20][n17] = d7 * d9 - d10 * d3;
                    }
                    dArray2[n18] = d7 = NumericalRecipes.pythag(d2, d);
                    if (d7 != 0.0) {
                        d7 = 1.0 / d7;
                        d9 = d2 * d7;
                        d3 = d * d7;
                    }
                    d2 = d9 * d5 + d3 * d8;
                    d10 = d9 * d8 - d3 * d5;
                    for (n20 = 0; n20 < n; ++n20) {
                        d8 = dArray[n20][n18];
                        d7 = dArray[n20][n17];
                        dArray[n20][n18] = d8 * d9 + d7 * d3;
                        dArray[n20][n17] = d7 * d9 - d8 * d3;
                    }
                }
                dArray4[n6] = 0.0;
                dArray4[n5] = d2;
                dArray2[n5] = d10;
            }
        }
    }

    public void fit(double[] dArray, double[] dArray2, int n, double[] dArray3, int n2) throws Exception {
        double d;
        int n3;
        int n4;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        this._fit_b = 0.0;
        if (n2 != 0) {
            d5 = 0.0;
            for (n4 = 0; n4 < n; ++n4) {
                double d6 = 1.0 / NumericalRecipes.SQR(dArray3[n4]);
                d5 += d6;
                d2 += dArray[n4] * d6;
                d3 += dArray2[n4] * d6;
            }
        } else {
            for (n4 = 0; n4 < n; ++n4) {
                d2 += dArray[n4];
                d3 += dArray2[n4];
            }
            d5 = n;
        }
        double d7 = d2 / d5;
        if (n2 == 0) {
            for (n3 = 0; n3 < n; ++n3) {
                d = (dArray[n3] - d7) / dArray3[n3];
                d4 += d * d;
                this._fit_b += d * dArray2[n3] / dArray3[n3];
            }
        } else {
            for (n3 = 0; n3 < n; ++n3) {
                d = dArray[n3] - d7;
                d4 += d * d;
                this._fit_b += d * dArray2[n3];
            }
        }
        this._fit_b /= d4;
        this._fit_a = (d3 - d2 * this._fit_b) / d5;
        this._fit_siga = Math.sqrt((1.0 + d2 * d2 / (d5 * d4)) / d5);
        this._fit_sigb = Math.sqrt(1.0 / d4);
        this._fit_chi2 = 0.0;
        this._fit_q = 1.0;
        if (n2 == 0) {
            for (n3 = 0; n3 < n; ++n3) {
                this._fit_chi2 += NumericalRecipes.SQR(dArray2[n3] - this._fit_a - this._fit_b * dArray[n3]);
            }
            double d8 = Math.sqrt(this._fit_chi2 / (double)(n - 2));
            this._fit_siga *= d8;
            this._fit_sigb *= d8;
        } else {
            for (n3 = 0; n3 < n; ++n3) {
                this._fit_chi2 += NumericalRecipes.SQR((dArray2[n3] - this._fit_a - this._fit_b * dArray[n3]) / dArray3[n3]);
            }
            if (n > 2) {
                this._fit_q = this.gammq(0.5 * (double)(n - 2), 0.5 * this._fit_chi2);
            }
        }
    }

    public void mrqmin(double[] dArray, double[] dArray2, double[] dArray3, int n, double[] dArray4, int[] nArray, int n2, double[][] dArray5, double[][] dArray6, FittingFunction fittingFunction) throws Exception {
        int n3;
        int n4;
        if (fittingFunction.alamda < 0.0) {
            this.atry = new double[n2];
            this.beta = new double[n2];
            this.da = new double[n2];
            this.mfit = 0;
            for (n4 = 0; n4 < n2; ++n4) {
                if (nArray[n4] == 0) continue;
                ++this.mfit;
            }
            this.oneda = new double[this.mfit][1];
            fittingFunction.alamda = 0.001;
            NumericalRecipes.mrqcof(dArray, dArray2, dArray3, n, dArray4, nArray, n2, dArray6, this.beta, fittingFunction);
            this.ochisq = fittingFunction.chisq;
            for (n4 = 0; n4 < n2; ++n4) {
                this.atry[n4] = dArray4[n4];
            }
        }
        for (n4 = 0; n4 < this.mfit; ++n4) {
            for (n3 = 0; n3 < this.mfit; ++n3) {
                dArray5[n4][n3] = dArray6[n4][n3];
            }
            dArray5[n4][n4] = dArray6[n4][n4] * (1.0 + fittingFunction.alamda);
            this.oneda[n4][0] = this.beta[n4];
        }
        NumericalRecipes.gaussj(dArray5, this.mfit, this.oneda, 1);
        for (n4 = 0; n4 < this.mfit; ++n4) {
            this.da[n4] = this.oneda[n4][0];
        }
        if (fittingFunction.alamda == 0.0) {
            NumericalRecipes.covsrt(dArray5, n2, nArray, this.mfit);
            this.oneda = null;
            this.da = null;
            this.beta = null;
            this.atry = null;
            return;
        }
        n4 = -1;
        for (n3 = 0; n3 < n2; ++n3) {
            if (nArray[n3] == 0) continue;
            this.atry[n3] = dArray4[n3] + this.da[++n4];
        }
        NumericalRecipes.mrqcof(dArray, dArray2, dArray3, n, this.atry, nArray, n2, dArray5, this.da, fittingFunction);
        if (fittingFunction.chisq < this.ochisq) {
            fittingFunction.alamda *= 0.1;
            this.ochisq = fittingFunction.chisq;
            for (n3 = 0; n3 < this.mfit; ++n3) {
                for (int i = 0; i < this.mfit; ++i) {
                    dArray6[n3][i] = dArray5[n3][i];
                }
                this.beta[n3] = this.da[n3];
            }
            for (n3 = 0; n3 < n2; ++n3) {
                dArray4[n3] = this.atry[n3];
            }
        } else {
            fittingFunction.alamda *= 10.0;
            fittingFunction.chisq = this.ochisq;
        }
    }

    private void gser(double d, double d2) throws Exception {
        double d3;
        this._gser_gln = this.gammln(d);
        if (d2 <= 0.0) {
            if (d2 < 0.0) {
                NumericalRecipes.nrerror("x less than 0 in routine gser");
            }
            this._gser_gamser = 0.0;
            return;
        }
        double d4 = d;
        double d5 = d3 = 1.0 / d;
        for (int i = 1; i <= 100; ++i) {
            d5 += (d3 *= d2 / (d4 += 1.0));
            if (!(Math.abs(d3) < Math.abs(d5) * 3.0E-7)) continue;
            this._gser_gamser = d5 * Math.exp(-d2 + d * Math.log(d2) - this._gser_gln);
            return;
        }
        NumericalRecipes.nrerror("a too large, ITMAX too small in routine gser");
    }

    private void gcf(double d, double d2) throws Exception {
        int n;
        double d3;
        this._gcf_gln = this.gammln(d);
        double d4 = d2 + 1.0 - d;
        double d5 = 9.999999999999999E29;
        double d6 = d3 = 1.0 / d4;
        for (n = 1; n <= 100; ++n) {
            double d7 = (double)(-n) * ((double)n - d);
            if (Math.abs(d3 = d7 * d3 + (d4 += 2.0)) < 1.0E-30) {
                d3 = 1.0E-30;
            }
            if (Math.abs(d5 = d4 + d7 / d5) < 1.0E-30) {
                d5 = 1.0E-30;
            }
            d3 = 1.0 / d3;
            double d8 = d3 * d5;
            d6 *= d8;
            if (Math.abs(d8 - 1.0) < 3.0E-7) break;
        }
        if (n > 100) {
            NumericalRecipes.nrerror("a too large, ITMAX too small in gcf");
        }
        this._gcf_gammcf = Math.exp(-d2 + d * Math.log(d2) - this._gcf_gln) * d6;
    }

    private double gammq(double d, double d2) throws Exception {
        if (d2 < 0.0 || d <= 0.0) {
            NumericalRecipes.nrerror("Invalid arguments in routine gammq");
        }
        if (d2 < d + 1.0) {
            this.gser(d, d2);
            return 1.0 - this._gser_gamser;
        }
        this.gcf(d, d2);
        return this._gcf_gammcf;
    }

    private double gammln(double d) {
        double[] dArray = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
        double d2 = d;
        double d3 = d;
        double d4 = d2 + 5.5;
        d4 -= (d2 + 0.5) * Math.log(d4);
        double d5 = 1.000000000190015;
        for (int i = 0; i <= 5; ++i) {
            d5 += dArray[i] / (d3 += 1.0);
        }
        return -d4 + Math.log(2.5066282746310007 * d5 / d2);
    }

    private static void covsrt(double[][] dArray, int n, int[] nArray, int n2) {
        int n3;
        int n4;
        for (n4 = n2; n4 < n; ++n4) {
            for (n3 = 0; n3 <= n4; ++n3) {
                dArray[n3][n4] = 0.0;
                dArray[n4][n3] = 0.0;
            }
        }
        n4 = n2 - 1;
        for (n3 = n - 1; n3 >= 0; --n3) {
            int n5;
            if (nArray[n3] == 0) continue;
            for (n5 = 0; n5 < n; ++n5) {
                NumericalRecipes.SWAP(dArray[n5][n4], dArray[n5][n3]);
            }
            for (n5 = 0; n5 < n; ++n5) {
                NumericalRecipes.SWAP(dArray[n4][n5], dArray[n3][n5]);
            }
            --n4;
        }
    }

    private static void mrqcof(double[] dArray, double[] dArray2, double[] dArray3, int n, double[] dArray4, int[] nArray, int n2, double[][] dArray5, double[] dArray6, FittingFunction fittingFunction) {
        int n3;
        double[] dArray7 = new double[n2];
        int n4 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            if (nArray[n3] == 0) continue;
            ++n4;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            for (int i = 0; i <= n3; ++i) {
                dArray5[n3][i] = 0.0;
            }
            dArray6[n3] = 0.0;
        }
        fittingFunction.chisq = 0.0;
        for (n3 = 0; n3 < n; ++n3) {
            double d = fittingFunction.fittingFunction(dArray[n3], dArray4, dArray7, n2);
            double d2 = 1.0 / (dArray3[n3] * dArray3[n3]);
            double d3 = dArray2[n3] - d;
            int n5 = -1;
            for (int i = 0; i < n2; ++i) {
                if (nArray[i] == 0) continue;
                double d4 = dArray7[i] * d2;
                ++n5;
                int n6 = -1;
                for (int j = 0; j <= i; ++j) {
                    if (nArray[j] == 0) continue;
                    double[] dArray8 = dArray5[n5];
                    int n7 = ++n6;
                    dArray8[n7] = dArray8[n7] + d4 * dArray7[j];
                }
                int n8 = n5;
                dArray6[n8] = dArray6[n8] + d3 * d4;
            }
            fittingFunction.chisq += d3 * d3 * d2;
        }
        for (n3 = 1; n3 < n4; ++n3) {
            for (int i = 0; i < n3; ++i) {
                dArray5[i][n3] = dArray5[n3][i];
            }
        }
    }

    private static void gaussj(double[][] dArray, int n, double[][] dArray2, int n2) throws Exception {
        int n3;
        int n4;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        for (n4 = 0; n4 < n; ++n4) {
            nArray3[n4] = 0;
        }
        for (n4 = 0; n4 < n; ++n4) {
            int n5;
            n3 = 0;
            int n6 = 0;
            double d = 0.0;
            for (n5 = 0; n5 < n; ++n5) {
                if (nArray3[n5] == 1) continue;
                for (int i = 0; i < n; ++i) {
                    if (nArray3[i] != 0 || !(Math.abs(dArray[n5][i]) >= d)) continue;
                    d = Math.abs(dArray[n5][i]);
                    n3 = n5;
                    n6 = i;
                }
            }
            int n7 = n6;
            nArray3[n7] = nArray3[n7] + 1;
            if (n3 != n6) {
                for (n5 = 0; n5 < n; ++n5) {
                    NumericalRecipes.SWAP(dArray[n3][n5], dArray[n6][n5]);
                }
                for (n5 = 0; n5 < n2; ++n5) {
                    NumericalRecipes.SWAP(dArray2[n3][n5], dArray2[n6][n5]);
                }
            }
            nArray2[n4] = n3;
            nArray[n4] = n6;
            if (dArray[n6][n6] == 0.0) {
                NumericalRecipes.nrerror("gaussj: Singular Matrix");
            }
            double d2 = 1.0 / dArray[n6][n6];
            dArray[n6][n6] = 1.0;
            int n8 = 0;
            while (n8 < n) {
                double[] dArray3 = dArray[n6];
                int n9 = n8++;
                dArray3[n9] = dArray3[n9] * d2;
            }
            n8 = 0;
            while (n8 < n2) {
                double[] dArray4 = dArray2[n6];
                int n10 = n8++;
                dArray4[n10] = dArray4[n10] * d2;
            }
            for (n8 = 0; n8 < n; ++n8) {
                int n11;
                if (n8 == n6) continue;
                double d3 = dArray[n8][n6];
                dArray[n8][n6] = 0.0;
                for (n11 = 0; n11 < n; ++n11) {
                    double[] dArray5 = dArray[n8];
                    int n12 = n11;
                    dArray5[n12] = dArray5[n12] - dArray[n6][n11] * d3;
                }
                for (n11 = 0; n11 < n2; ++n11) {
                    double[] dArray6 = dArray2[n8];
                    int n13 = n11;
                    dArray6[n13] = dArray6[n13] - dArray2[n6][n11] * d3;
                }
            }
        }
        for (n4 = n - 1; n4 >= 0; --n4) {
            if (nArray2[n4] == nArray[n4]) continue;
            for (n3 = 0; n3 < n; ++n3) {
                NumericalRecipes.SWAP(dArray[n3][nArray2[n4]], dArray[n3][nArray[n4]]);
            }
        }
    }

    private static double pythag(double d, double d2) {
        double d3;
        double d4 = Math.abs(d);
        return d4 > (d3 = Math.abs(d2)) ? d4 * Math.sqrt(1.0 + NumericalRecipes.SQR(d3 / d4)) : (d3 == 0.0 ? 0.0 : d3 * Math.sqrt(1.0 + NumericalRecipes.SQR(d4 / d3)));
    }

    private static double SQR(double d) {
        return d == 0.0 ? 0.0 : d * d;
    }

    private static double SIGN(double d, double d2) {
        return d2 >= 0.0 ? Math.abs(d) : -Math.abs(d);
    }

    private static void SWAP(double d, double d2) {
        double d3 = d;
        d = d2;
        d2 = d3;
    }

    private static void nrerror(String string) throws Exception {
        throw new Exception("Numerical Recipes run-time error: " + string);
    }
}

