/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;

public class Formatter {
    private LocaleFormat localeFormat = LocaleFormat.SWISS;
    private static DateFormat yyyyFormat = new SimpleDateFormat("yyyyMMdd");
    private static DateFormat dateFormat;
    private static DateFormat timeFormat;
    private static DateFormat[] dateTimeParsers;
    private static DateFormat[] dateTimeFormatters;
    private static final DecimalFormat df0;
    private static final DecimalFormat df1;
    private static final DecimalFormat df2;
    private static final DecimalFormat dfmax2;
    private static final DecimalFormat df3;
    private static final DecimalFormat dfmax3;
    private static final DecimalFormat df4;
    private static final DecimalFormat df8;
    private static final DecimalFormat dfE;
    public static final DecimalFormat dfI2;
    public static final DecimalFormat dfI3;

    public LocaleFormat getLocaleFormat() {
        return this.localeFormat;
    }

    public static void setLocaleFormat(LocaleFormat localeFormat) {
        assert (localeFormat != null);
        dateFormat = new SimpleDateFormat(localeFormat.getLocaleDateFormat());
        timeFormat = new SimpleDateFormat(localeFormat.getLocaleTimeFormat());
        dateTimeParsers = new SimpleDateFormat[]{new SimpleDateFormat(localeFormat.getLocaleDateFormat() + " " + localeFormat.getLocaleTimeFormat() + ":ss"), new SimpleDateFormat(localeFormat.getLocaleDateFormat() + " " + localeFormat.getLocaleTimeFormat()), new SimpleDateFormat(localeFormat.getLocaleDateFormat()), new SimpleDateFormat("MM.yy"), new SimpleDateFormat("yy")};
        dateTimeFormatters = new SimpleDateFormat[]{new SimpleDateFormat(localeFormat.getLocaleDateFormat() + "yy " + localeFormat.getLocaleTimeFormat() + ":ss"), new SimpleDateFormat(localeFormat.getLocaleDateFormat() + "yy " + localeFormat.getLocaleTimeFormat()), new SimpleDateFormat(localeFormat.getLocaleDateFormat() + "yy"), new SimpleDateFormat("MM.yyyy"), new SimpleDateFormat("yyyy")};
    }

    public static final String format0(Double d) {
        if (d == null) {
            return "";
        }
        return df0.format(d);
    }

    public static final String format1(Double d) {
        if (d == null) {
            return "";
        }
        return df1.format(d);
    }

    public static final String format2(Double d) {
        if (d == null) {
            return "";
        }
        return df2.format(d);
    }

    public static final String formatMax2(Double d) {
        if (d == null) {
            return "";
        }
        return dfmax2.format(d);
    }

    public static final String format3(Double d) {
        if (d == null) {
            return "";
        }
        return df3.format(d);
    }

    public static final String formatMax3(Double d) {
        if (d == null) {
            return "";
        }
        return dfmax3.format(d);
    }

    public static final String format4(Double d) {
        if (d == null) {
            return "";
        }
        return df4.format(d);
    }

    public static final String format8(Double d) {
        if (d == null) {
            return "";
        }
        return df8.format(d);
    }

    public static final String formatE(Double d) {
        if (d == null) {
            return "";
        }
        return dfE.format(d);
    }

    public static final String format(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Double) {
            return Formatter.format3((Double)object);
        }
        if (object instanceof Date) {
            return Formatter.formatDateTime((Date)object);
        }
        return "" + object;
    }

    public static final String formatDate(Date date) {
        return date == null ? "" : dateFormat.format(date);
    }

    public static final String formatTime(Date date) {
        return date == null ? "" : timeFormat.format(date);
    }

    public static final String formatDateTime(Date date) {
        if (date == null) {
            return "";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (calendar.get(13) != 0) {
            return dateTimeFormatters[0].format(date);
        }
        if (calendar.get(11) != 0 || calendar.get(12) != 0) {
            return dateTimeFormatters[1].format(date);
        }
        if (calendar.get(5) != 1) {
            return dateTimeFormatters[2].format(date);
        }
        if (calendar.get(2) != 0) {
            return dateTimeFormatters[3].format(date);
        }
        return dateTimeFormatters[4].format(date);
    }

    public static final String formatDateTimeShort(Date date) {
        if (date == null) {
            return "";
        }
        return dateTimeParsers[2].format(date);
    }

    public static final Date parseDate(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            return dateFormat.parse(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final Date parseDateTime(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        boolean bl = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ":/. ", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("/") || string2.equals(".")) {
                if (bl) {
                    if (++n <= 2) continue;
                    return null;
                }
                return null;
            }
            if (string2.equals(":")) {
                if (bl) {
                    return null;
                }
                if (++n2 <= 2) continue;
                return null;
            }
            if (string2.equals(" ")) {
                if (bl) {
                    ++n;
                    bl = false;
                    continue;
                }
                return null;
            }
            for (int i = 0; i < string2.length(); ++i) {
                if (Character.isDigit(string2.charAt(i))) continue;
                return null;
            }
            if (bl) {
                nArray[n] = Integer.parseInt(string2);
                continue;
            }
            nArray2[n2] = Integer.parseInt(string2);
        }
        if (bl) {
            ++n;
        } else {
            ++n2;
        }
        if (n == 0) {
            calendar.set(5, 1);
            calendar.set(2, 0);
            calendar.set(1, 0);
        } else if (n == 1) {
            calendar.set(5, 1);
            calendar.set(2, 0);
            calendar.set(1, nArray[0] < 100 ? nArray[0] + 2000 : nArray[0]);
        } else if (n == 2) {
            calendar.set(5, 1);
            calendar.set(2, nArray[0] - 1);
            calendar.set(1, nArray[1] < 100 ? nArray[1] + 2000 : nArray[1]);
        } else if (n == 3) {
            calendar.set(5, nArray[0]);
            calendar.set(2, nArray[1] - 1);
            calendar.set(1, nArray[2] < 100 ? nArray[2] + 2000 : nArray[2]);
        } else {
            return null;
        }
        if (n2 == 0) {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
        } else {
            if (n2 == 1) {
                return null;
            }
            if (n2 == 2) {
                calendar.set(11, nArray2[0]);
                calendar.set(12, nArray2[1]);
                calendar.set(13, 0);
            } else if (n2 == 3) {
                calendar.set(11, nArray2[0]);
                calendar.set(12, nArray2[1]);
                calendar.set(13, nArray2[2]);
            } else {
                return null;
            }
        }
        return calendar.getTime();
    }

    public static final String cleanDate(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        try {
            return Formatter.formatDate(Formatter.parseDate(string));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final String cleanDateTime(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        Date date = Formatter.parseDateTime(string);
        if (date == null) {
            return "";
        }
        return Formatter.formatDateTime(date);
    }

    public static final String formatYYYYMMDD() {
        return yyyyFormat.format(new Date());
    }

    public static void main(String[] stringArray) {
        System.out.println(Formatter.format3(Double.NaN));
        System.out.println(Formatter.parseDateTime("10.10.2013 12:23:20"));
        System.out.println(Formatter.parseDateTime("10.10.2013 12:23"));
        System.out.println(Formatter.parseDateTime("10.10.2013"));
        System.out.println(Formatter.parseDateTime("10.2013"));
        System.out.println(Formatter.parseDateTime("2013"));
        System.out.println();
        System.out.println(Formatter.formatDateTime(Formatter.parseDateTime("10.10.2013 12:23:20")));
        System.out.println(Formatter.formatDateTime(Formatter.parseDateTime("10.10.2013 12:23")));
        System.out.println(Formatter.formatDateTime(Formatter.parseDateTime("10.10.2013")));
        System.out.println();
        System.out.println("10.10.2013 12:23:20 -> " + Formatter.cleanDateTime("10.10.2013 12:23:20"));
        System.out.println("10/1/2013 12:60 -> " + Formatter.cleanDateTime("10.10.2013 12:60"));
        System.out.println("31.12.2013 23:60 -> " + Formatter.cleanDateTime("31.12.2013 23:60"));
        System.out.println("10.12.2013 -> " + Formatter.cleanDateTime("10.12.2013"));
        System.out.println("12.2013 -> " + Formatter.cleanDateTime("12.2013"));
        System.out.println("2013 -> " + Formatter.cleanDateTime("2013"));
        System.out.println("13 -> " + Formatter.cleanDateTime("13"));
        System.out.println();
        System.out.println(Formatter.cleanDateTime("10/10/2013"));
        System.out.println(Formatter.cleanDateTime("toto"));
    }

    static {
        df0 = new DecimalFormat("0", new DecimalFormatSymbols(Locale.US));
        df1 = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.US));
        df2 = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
        dfmax2 = new DecimalFormat("0.##", new DecimalFormatSymbols(Locale.US));
        df3 = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
        dfmax3 = new DecimalFormat("0.###", new DecimalFormatSymbols(Locale.US));
        df4 = new DecimalFormat("0.0000", new DecimalFormatSymbols(Locale.US));
        df8 = new DecimalFormat("0.00000000", new DecimalFormatSymbols(Locale.US));
        dfE = new DecimalFormat("0.00E0", new DecimalFormatSymbols(Locale.US));
        dfI2 = new DecimalFormat("00", new DecimalFormatSymbols(Locale.US));
        dfI3 = new DecimalFormat("000", new DecimalFormatSymbols(Locale.US));
        Formatter.setLocaleFormat(LocaleFormat.SWISS);
        df0.setRoundingMode(RoundingMode.HALF_UP);
        df1.setRoundingMode(RoundingMode.HALF_UP);
        df2.setRoundingMode(RoundingMode.HALF_UP);
        dfmax2.setRoundingMode(RoundingMode.HALF_UP);
        df3.setRoundingMode(RoundingMode.HALF_UP);
        dfmax3.setRoundingMode(RoundingMode.HALF_UP);
        df4.setRoundingMode(RoundingMode.HALF_UP);
        df8.setRoundingMode(RoundingMode.HALF_UP);
        dfE.setRoundingMode(RoundingMode.HALF_UP);
    }

    public static enum LocaleFormat {
        SWISS("dd.MM.yy", "HH:mm"),
        EUROPEAN("dd/MM/yy", "HH:mm"),
        AMERICAN("dd/MM/yy", "HH:mm");

        private String localeDateFormat;
        private String localeTimeFormat;

        private LocaleFormat(String string2, String string3) {
            this.localeDateFormat = string2;
            this.localeTimeFormat = string3;
        }

        public String getLocaleDateFormat() {
            return this.localeDateFormat;
        }

        public String getLocaleTimeFormat() {
            return this.localeTimeFormat;
        }
    }
}

