/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import java.io.File;
import java.nio.file.NotDirectoryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class CommandLineParser {
    public static final String SEP_TAG = ";";
    public static final String HELP = "-h";
    private HashMap<String, String> hmCommandValue = new HashMap();

    public CommandLineParser() {
    }

    public CommandLineParser(String[] stringArray) {
        this.parse(stringArray);
    }

    public CommandLineParser(String string, String string2) {
        if (string != null && string.length() > 0) {
            String[] stringArray;
            for (String string3 : stringArray = string.split(string2)) {
                String[] stringArray2 = string3.split("=");
                this.hmCommandValue.put(stringArray2[0].trim(), stringArray2[1].trim().replace("\"", ""));
            }
        }
    }

    public void add(String string, String string2) {
        if (this.hmCommandValue.containsKey(string)) {
            throw new RuntimeException("Contains already command " + string);
        }
        this.hmCommandValue.put(string, string2);
    }

    public String get(String string) {
        return this.hmCommandValue.get(string);
    }

    public int getOrDefault(String string, int n) {
        int n2 = n;
        if (this.contains(string)) {
            n2 = this.getAsInt(string);
        }
        return n2;
    }

    public double getOrDefault(String string, double d) {
        double d2 = d;
        if (this.contains(string)) {
            d2 = this.getAsInt(string);
        }
        return d2;
    }

    public String getOrDefault(String string, String string2) {
        String string3 = string2;
        if (this.contains(string)) {
            string3 = this.get(string);
        }
        return string3;
    }

    public List<String> getAsList(String string) {
        String string2 = this.hmCommandValue.get(string);
        String[] stringArray = string2.split(SEP_TAG);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : stringArray) {
            arrayList.add(string3.trim());
        }
        return arrayList;
    }

    public File getAsFile(String string) {
        return new File(this.get(string));
    }

    public File getAsDir(String string) throws NotDirectoryException {
        File file = this.getAsFile(string);
        if (!file.isDirectory()) {
            throw new NotDirectoryException("Not a dir " + file.getAbsolutePath());
        }
        return file;
    }

    public double getAsDouble(String string) {
        return Double.parseDouble(this.get(string));
    }

    public int getAsInt(String string) {
        return Integer.parseInt(this.get(string));
    }

    public long getAsLong(String string) {
        return Long.parseLong(this.get(string));
    }

    public boolean getAsBoolean(String string) {
        return Boolean.parseBoolean(this.get(string));
    }

    public boolean contains(String string) {
        return this.hmCommandValue.containsKey(string);
    }

    public boolean help() {
        return this.hmCommandValue.containsKey(HELP);
    }

    public boolean checkCommandWithValue(String string) {
        if (!this.contains(string)) {
            throw new RuntimeException("Argument '" + string + "' missing.");
        }
        if (this.get(string) == null) {
            throw new RuntimeException("Value for '" + string + "' missing.");
        }
        return true;
    }

    public int parse(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.startsWith("-")) {
                throw new RuntimeException("Wrong command line argument '" + string + "'");
            }
            String string2 = null;
            if (i < stringArray.length - 1 && !stringArray[i + 1].startsWith("-")) {
                string2 = stringArray[i + 1];
                ++i;
            }
            this.hmCommandValue.put(string, string2);
        }
        return this.hmCommandValue.size();
    }

    public int getNumArguments() {
        return this.hmCommandValue.size();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>(this.hmCommandValue.keySet());
        Collections.sort(arrayList);
        for (String string : arrayList) {
            stringBuilder.append(string);
            stringBuilder.append("\t");
            stringBuilder.append(this.hmCommandValue.get(string));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        String string = "-f file -D -C command";
        String[] stringArray2 = string.split(" ");
        CommandLineParser commandLineParser = new CommandLineParser();
        commandLineParser.parse(stringArray2);
        System.out.println(commandLineParser.toString());
        string = "width=234; color=233,0,0; resolution=\"super high\"; blur=false";
        commandLineParser = new CommandLineParser(string, SEP_TAG);
        System.out.println(commandLineParser.toString());
    }
}

