/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.share.gui.editor.actions;

import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.generic.GenericPoint;
import com.actelion.research.share.gui.DialogResult;
import com.actelion.research.share.gui.editor.Model;
import com.actelion.research.share.gui.editor.actions.AtomHighlightAction;
import com.actelion.research.share.gui.editor.dialogs.IBondQueryFeaturesDialog;
import com.actelion.research.share.gui.editor.geom.GeomFactory;
import com.actelion.research.share.gui.editor.geom.IDrawContext;
import com.actelion.research.share.gui.editor.io.IKeyEvent;
import com.actelion.research.share.gui.editor.io.IMouseEvent;

public abstract class BondHighlightAction
extends AtomHighlightAction {
    GenericPoint origin = null;
    GenericPoint last = null;
    boolean dragging = false;

    public BondHighlightAction(Model model) {
        super(model);
    }

    @Override
    boolean trackHighLight(GenericPoint genericPoint) {
        int n = this.model.getSelectedAtom();
        int n2 = this.model.getSelectedBond();
        this.lastHightlightPoint = genericPoint;
        StereoMolecule stereoMolecule = this.model.getMoleculeAt(genericPoint, true);
        if (super.trackHighLight(genericPoint)) {
            this.setHighlightBond(null, -1);
            return true;
        }
        int n3 = this.getBondAt(stereoMolecule, genericPoint);
        if (n3 >= 0) {
            this.setHighlightBond(stereoMolecule, n3);
            this.setHighlightAtom(stereoMolecule, -1);
            return true;
        }
        boolean bl = n != -1 || n2 != n3;
        this.setHighlightBond(null, -1);
        this.setHighlightAtom(null, -1);
        return bl;
    }

    void setHighlightBond(StereoMolecule stereoMolecule, int n) {
        this.model.setSelectedBond(n);
    }

    @Override
    public boolean onMouseDown(IMouseEvent iMouseEvent) {
        GenericPoint genericPoint;
        this.origin = genericPoint = new GenericPoint(iMouseEvent.getX(), iMouseEvent.getY());
        return false;
    }

    @Override
    public boolean onMouseMove(IMouseEvent iMouseEvent, boolean bl) {
        this.dragging = bl;
        GenericPoint genericPoint = new GenericPoint(iMouseEvent.getX(), iMouseEvent.getY());
        if (!bl) {
            return this.trackHighLight(genericPoint);
        }
        return this.onDrag(genericPoint);
    }

    protected boolean onDrag(GenericPoint genericPoint) {
        double d = Math.abs(genericPoint.getX() - this.origin.getX());
        double d2 = Math.abs(genericPoint.getY() - this.origin.getY());
        if (d > 5.0 || d2 > 5.0) {
            this.trackHighLight(genericPoint);
            this.last = genericPoint;
        } else {
            this.last = null;
        }
        return true;
    }

    @Override
    public boolean paint(IDrawContext iDrawContext) {
        StereoMolecule stereoMolecule = this.model.getMolecule();
        boolean bl = false;
        if (stereoMolecule != null) {
            int n = this.model.getSelectedAtom();
            int n2 = this.model.getSelectedBond();
            if (n2 != -1) {
                this.drawBondHighlight(iDrawContext, stereoMolecule, n2);
                bl = true;
            } else if (n != -1) {
                return super.paint(iDrawContext);
            }
        }
        return bl;
    }

    @Override
    public boolean onKeyPressed(IKeyEvent iKeyEvent) {
        int n = this.model.getSelectedBond();
        GeomFactory geomFactory = this.model.getGeomFactory();
        StereoMolecule stereoMolecule = this.model.getMolecule();
        if (stereoMolecule != null) {
            if (iKeyEvent.getCode().equals(geomFactory.getDeleteKey())) {
                if (n != -1) {
                    stereoMolecule.deleteBondAndSurrounding(n);
                    this.setHighlightBond(stereoMolecule, -1);
                    return true;
                }
            } else if (this.handleCharacter(iKeyEvent.getText())) {
                return true;
            }
        }
        return super.onKeyPressed(iKeyEvent);
    }

    private boolean handleCharacter(String string) {
        StereoMolecule stereoMolecule = this.model.getMolecule();
        int n = this.model.getSelectedBond();
        if (stereoMolecule != null && n != -1 && string != null && string.length() > 0) {
            char c = string.charAt(0);
            switch (c) {
                case 'q': {
                    return stereoMolecule.isFragment() ? this.showBondQFDialog(n) : false;
                }
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    return stereoMolecule.addRingToBond(n, c - 48, false, Molecule.getDefaultAverageBondLength());
                }
                case 'b': {
                    return stereoMolecule.addRingToBond(n, 6, true, Molecule.getDefaultAverageBondLength());
                }
                case '1': {
                    return stereoMolecule.changeBond(n, 1);
                }
                case '2': {
                    return stereoMolecule.changeBond(n, 2);
                }
                case '3': {
                    return stereoMolecule.changeBond(n, 4);
                }
                case 'u': {
                    return stereoMolecule.changeBond(n, 257);
                }
                case 'd': {
                    return stereoMolecule.changeBond(n, 129);
                }
                case 'c': {
                    return stereoMolecule.changeBond(n, 386);
                }
                case 'm': {
                    return stereoMolecule.changeBond(n, 32);
                }
            }
        }
        return false;
    }

    private boolean showBondQFDialog(int n) {
        StereoMolecule stereoMolecule = this.model.getMolecule();
        if (stereoMolecule != null) {
            GeomFactory geomFactory = this.model.getGeomFactory();
            IBondQueryFeaturesDialog iBondQueryFeaturesDialog = geomFactory.createBondFeaturesDialog(stereoMolecule, n);
            return iBondQueryFeaturesDialog.doModalAt(this.lastHightlightPoint.getX(), this.lastHightlightPoint.getY()) == DialogResult.IDOK;
        }
        return false;
    }
}

