/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.share.gui.editor.actions;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.generic.GenericPoint;
import com.actelion.research.share.gui.editor.Model;
import com.actelion.research.share.gui.editor.actions.AtomHighlightAction;
import com.actelion.research.share.gui.editor.geom.GeomFactory;
import com.actelion.research.share.gui.editor.geom.IDrawContext;
import com.actelion.research.share.gui.editor.io.IKeyEvent;
import com.actelion.research.share.gui.editor.io.IMouseEvent;

public class AtomMapAction
extends AtomHighlightAction {
    private GenericPoint firstPoint = null;
    private GenericPoint lastPoint = null;
    private int secondAtom = -1;

    public AtomMapAction(Model model) {
        super(model);
    }

    @Override
    public void onActionEnter() {
        int n = this.model.getDisplayMode();
        this.model.setDisplayMode(n | 0x10 | 0x40);
    }

    @Override
    public void onActionLeave() {
        int n = this.model.getDisplayMode();
        if ((n & 0x10) != 0) {
            this.model.setDisplayMode(n &= 0xFFFFFFAF);
        }
    }

    @Override
    public boolean onKeyPressed(IKeyEvent iKeyEvent) {
        GeomFactory geomFactory = this.model.getGeomFactory();
        if (iKeyEvent.getCode().equals(geomFactory.getDeleteKey())) {
            StereoMolecule stereoMolecule = this.model.getMolecule();
            boolean bl = false;
            for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
                if (stereoMolecule.getAtomMapNo(i) == 0) continue;
                stereoMolecule.setAtomMapNo(i, 0, false);
                bl = true;
            }
            return bl;
        }
        return super.onKeyPressed(iKeyEvent);
    }

    @Override
    public boolean onMouseMove(IMouseEvent iMouseEvent, boolean bl) {
        this.lastPoint = null;
        this.firstPoint = null;
        if (this.model.isReaction()) {
            StereoMolecule stereoMolecule = this.model.getMolecule();
            if (!bl) {
                GenericPoint genericPoint = new GenericPoint(iMouseEvent.getX(), iMouseEvent.getY());
                this.secondAtom = -1;
                if (this.trackHighLight(genericPoint)) {
                    int n;
                    int n2 = this.model.getSelectedAtom();
                    if (n2 != -1 && (n = stereoMolecule.getAtomMapNo(n2)) != 0) {
                        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                            if (i == n2 || stereoMolecule.getAtomMapNo(i) != n) continue;
                            this.secondAtom = i;
                            break;
                        }
                    }
                    return true;
                }
            } else {
                int n = this.model.getSelectedAtom();
                if (stereoMolecule != null && n != -1) {
                    GenericPoint genericPoint = new GenericPoint(iMouseEvent.getX(), iMouseEvent.getY());
                    this.firstPoint = new GenericPoint(stereoMolecule.getAtomX(n), stereoMolecule.getAtomY(n));
                    this.lastPoint = genericPoint;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    boolean trackHighLight(GenericPoint genericPoint) {
        int n = this.model.getSelectedAtom();
        boolean bl = super.trackHighLight(genericPoint);
        int n2 = this.model.getSelectedAtom();
        return bl || n != n2;
    }

    @Override
    public boolean onMouseUp(IMouseEvent iMouseEvent) {
        int n;
        int n2 = this.model.getDisplayMode();
        if ((n2 & 0x10) == 0) {
            this.model.setDisplayMode(n2 |= 0x10);
        }
        if ((n = this.model.getSelectedAtom()) != -1) {
            this.model.mapReaction(n, this.firstPoint, this.lastPoint);
        }
        this.model.setSelectedAtom(-1);
        this.lastPoint = null;
        this.firstPoint = null;
        return true;
    }

    @Override
    public boolean paint(IDrawContext iDrawContext) {
        boolean bl = false;
        iDrawContext.save();
        if (this.model.isReaction()) {
            StereoMolecule stereoMolecule = this.model.getMolecule();
            if (this.firstPoint != null && this.lastPoint != null) {
                int n;
                StereoMolecule stereoMolecule2 = this.model.getFragmentAt(this.firstPoint, false);
                StereoMolecule stereoMolecule3 = this.model.getFragmentAt(this.lastPoint, false);
                if (stereoMolecule3 != null && stereoMolecule3 != stereoMolecule2 && (n = stereoMolecule.findAtom((float)this.lastPoint.getX(), (float)this.lastPoint.getY())) != -1) {
                    this.drawAtomHighlight(iDrawContext, stereoMolecule, n);
                }
                GeomFactory geomFactory = this.model.getGeomFactory();
                iDrawContext.setStroke(geomFactory.getMapToolColor());
                iDrawContext.drawLine(this.firstPoint.getX(), this.firstPoint.getY(), this.lastPoint.getX(), this.lastPoint.getY());
            } else if (this.secondAtom != -1) {
                this.drawAtomHighlight(iDrawContext, stereoMolecule, this.secondAtom);
            }
        }
        bl = super.paint(iDrawContext);
        iDrawContext.restore();
        return bl;
    }
}

