/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.share.gui.editor;

import com.actelion.research.chem.AbstractDepictor;
import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.ChemistryHelper;
import com.actelion.research.chem.DepictorTransformation;
import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.IsomericSmilesCreator;
import com.actelion.research.chem.MarkushStructure;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.MolfileCreator;
import com.actelion.research.chem.MolfileParser;
import com.actelion.research.chem.MolfileV3Creator;
import com.actelion.research.chem.NamedSubstituents;
import com.actelion.research.chem.SSSearcher;
import com.actelion.research.chem.SmilesParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.coords.CoordinateInventor;
import com.actelion.research.chem.reaction.IReactionMapper;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.chem.reaction.ReactionEncoder;
import com.actelion.research.gui.generic.GenericPoint;
import com.actelion.research.gui.generic.GenericRectangle;
import com.actelion.research.share.gui.Arrow;
import com.actelion.research.share.gui.editor.ImageProvider;
import com.actelion.research.share.gui.editor.chem.AbstractExtendedDepictor;
import com.actelion.research.share.gui.editor.chem.IDrawingObject;
import com.actelion.research.share.gui.editor.geom.GeomFactory;
import com.actelion.research.share.gui.editor.listeners.IChangeListener;
import com.actelion.research.share.gui.editor.listeners.IValidationListener;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public abstract class Model {
    protected GeomFactory geomFactory;
    public static final int KEY_IS_ATOM_LABEL = 1;
    public static final int KEY_IS_SUBSTITUENT = 2;
    public static final int KEY_IS_VALID_START = 3;
    public static final int KEY_IS_INVALID = 4;
    public static final int MODE_MULTIPLE_FRAGMENTS = 1;
    public static final int MODE_MARKUSH_STRUCTURE = 2;
    public static final int MODE_REACTION = 4;
    public static final int MODE_DRAWING_OBJECTS = 8;
    public static final int MAX_CONNATOMS = 8;
    public static final int MIN_BOND_LENGTH_SQUARE = 100;
    private static final float FRAGMENT_MAX_CLICK_DISTANCE = 24.0f;
    private static final float FRAGMENT_GROUPING_DISTANCE = 1.2f;
    private static final float FRAGMENT_CLEANUP_DISTANCE = 1.5f;
    private static final float DEFAULT_ARROW_LENGTH = 0.08f;
    public static final int FAKE_ATOM_NO = 100;
    public static final int MAX_UNDO_SIZE = 5;
    private List<StereoMolecule> _undoList = new ArrayList<StereoMolecule>();
    private int selectedESRType = 0;
    private int selectedAtom = -1;
    private int selectedBond = -1;
    private int displayMode = 0;
    private int mReactantCount;
    private int[] mFragmentNo;
    private boolean mAtomColorSupported;
    private GenericPoint arrowPos = new GenericPoint(0.0, 0.0);
    private List<IValidationListener> validationListeners = new ArrayList<IValidationListener>();
    private List<IChangeListener> changeListeners = new ArrayList<IChangeListener>();
    private boolean needslayout = false;
    private int mMode = 0;
    private Dimension displaySize = new Dimension(0, 0);
    private StereoMolecule mMol = new StereoMolecule();
    private StringBuilder mAtomKeyStrokeBuffer = new StringBuilder();
    private List<IDrawingObject> mDrawingObjectList;
    private StereoMolecule[] mFragment;
    private IDrawingObject selectedDrawingObject;
    private IReactionMapper mMapper;
    private ImageProvider imageProvider;
    private AtomHighlightCallback atomHighlightCallback = null;
    private BondHighlightCallback bondHighlightCallback = null;

    public Model(GeomFactory geomFactory, int n) {
        this.geomFactory = geomFactory;
        this.mDrawingObjectList = new ArrayList<IDrawingObject>();
        this.mMode = n;
        if ((this.mMode & 6) != 0) {
            this.mMode |= 1;
        }
        if ((this.mMode & 0xC) != 0) {
            // empty if block
        }
        if (this.isReactionMode()) {
            this.arrowPos = new GenericPoint(0.0, 0.0);
            Arrow arrow = new Arrow(geomFactory.getDrawConfig(), 0.0, 0.0, 0.0, 0.0);
            this.mDrawingObjectList.add(arrow);
        }
    }

    public GeomFactory getGeomFactory() {
        return this.geomFactory;
    }

    public void cleanReaction(boolean bl) {
        Reaction reaction = this.getReaction();
        Dimension dimension = this.getDisplaySize();
        double d = dimension.getWidth();
        double d2 = dimension.getHeight();
        double d3 = d / 5.0;
        if (d > 0.0 && d2 > 0.0) {
            IDrawingObject iDrawingObject = this.getDrawingObjects().get(0);
            iDrawingObject.setRect((float)(0.5 * d), (float)(0.5 * d2), (float)(0.08 * d), 20.0f);
            this.arrowPos = new GenericPoint(0.5 * d, 0.5 * d2);
            this.mMode = 1;
            if (bl) {
                this.cleanupCoordinates(true, true);
            }
            ChemistryHelper.scaleInto(reaction, 0.0, 0.0, dimension.getWidth(), dimension.getHeight(), d3);
            this.setValue(reaction);
        }
    }

    public StereoMolecule getSelectedCopy(StereoMolecule stereoMolecule) {
        int n;
        int n2 = 0;
        for (n = 0; n < stereoMolecule.getAllAtoms(); ++n) {
            if (!stereoMolecule.isSelectedAtom(n)) continue;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        n = 0;
        for (int i = 0; i < stereoMolecule.getAllBonds(); ++i) {
            if (!stereoMolecule.isSelectedBond(i)) continue;
            ++n;
        }
        boolean[] blArray = new boolean[stereoMolecule.getAllAtoms()];
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            blArray[i] = stereoMolecule.isSelectedAtom(i);
        }
        StereoMolecule stereoMolecule2 = new StereoMolecule(n2, n);
        stereoMolecule.copyMoleculeByAtoms(stereoMolecule2, blArray, false, null);
        return stereoMolecule2;
    }

    public void scale(float f, float f2) {
        this.mMol.scaleCoords(Math.min(f, f2));
    }

    public Reaction getSelectedReaction() {
        Reaction reaction = new Reaction();
        for (int i = 0; i < this.mFragment.length; ++i) {
            StereoMolecule stereoMolecule = this.getSelectedCopy(this.mFragment[i]);
            if (stereoMolecule == null) continue;
            if (i < this.mReactantCount) {
                reaction.addReactant(stereoMolecule);
                continue;
            }
            reaction.addProduct(stereoMolecule);
        }
        return reaction;
    }

    private int findFragment(float f, float f2) {
        int n = -1;
        double d = 3.4028234663852886E38;
        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
            double d2;
            double d3 = (double)f - this.mMol.getAtomX(i);
            double d4 = Math.sqrt(d3 * d3 + (d2 = (double)f2 - this.mMol.getAtomY(i)) * d2);
            if (!(d4 < 24.0) || !(d > d4)) continue;
            d = d4;
            n = this.mFragmentNo[i];
        }
        return n;
    }

    public StereoMolecule[] getFragments() {
        return this.mFragment;
    }

    public void setFragments(StereoMolecule[] stereoMoleculeArray) {
        int n;
        this.mMol.deleteMolecule();
        this.mFragment = stereoMoleculeArray;
        for (n = 0; n < stereoMoleculeArray.length; ++n) {
            this.mMol.addMolecule(this.mFragment[n]);
        }
        this.pushUndo();
        this.mFragmentNo = new int[this.mMol.getAllAtoms()];
        n = 0;
        for (int i = 0; i < this.mFragment.length; ++i) {
            for (int j = 0; j < this.mFragment[i].getAllAtoms(); ++j) {
                this.mFragmentNo[n++] = i;
            }
        }
        this.mMode = 1;
        this.notifyChange();
    }

    public Reaction getReaction() {
        if ((this.mMode & 4) == 0) {
            return null;
        }
        Reaction reaction = new Reaction();
        this.syncFragments();
        for (int i = 0; i < this.mFragment.length; ++i) {
            if (i < this.mReactantCount) {
                reaction.addReactant(this.mFragment[i]);
                continue;
            }
            reaction.addProduct(this.mFragment[i]);
        }
        return reaction;
    }

    public void setReaction(Reaction reaction) {
        int n;
        Dimension dimension = this.getDisplaySize();
        this.mMol = new StereoMolecule();
        this.mFragment = new StereoMolecule[reaction.getMolecules()];
        this.mReactantCount = reaction.getReactants();
        boolean bl = false;
        for (n = 0; n < reaction.getMolecules(); ++n) {
            bl |= reaction.getMolecule(n).isFragment();
            StereoMolecule stereoMolecule = reaction.getMolecule(n);
            GenericRectangle genericRectangle = ChemistryHelper.getBoundingRect(stereoMolecule);
            this.mFragment[n] = stereoMolecule;
            this.mMol.addMolecule(this.mFragment[n]);
        }
        this.mMol.setFragment(bl);
        this.mFragmentNo = new int[this.mMol.getAllAtoms()];
        n = 0;
        for (int i = 0; i < this.mFragment.length; ++i) {
            for (int j = 0; j < this.mFragment[i].getAllAtoms(); ++j) {
                this.mFragmentNo[n++] = i;
            }
        }
        try {
            this.mMol.validate();
        }
        catch (Exception exception) {
            System.out.println("WARNING:" + exception);
        }
        this.mMode = 5;
        this.notifyChange();
    }

    public MarkushStructure getMarkushStructure() {
        if ((this.mMode & 2) == 0) {
            return null;
        }
        MarkushStructure markushStructure = new MarkushStructure();
        for (int i = 0; i < this.mFragment.length; ++i) {
            if (i < this.mReactantCount) {
                markushStructure.addCore(this.mFragment[i]);
                continue;
            }
            markushStructure.addRGroup(this.mFragment[i]);
        }
        return markushStructure;
    }

    public void setMarkushStructure(MarkushStructure markushStructure) {
        int n;
        this.mMol.deleteMolecule();
        this.mFragment = new StereoMolecule[markushStructure.getCoreCount() + markushStructure.getRGroupCount()];
        this.mReactantCount = markushStructure.getCoreCount();
        boolean bl = false;
        for (n = 0; n < markushStructure.getCoreCount() + markushStructure.getRGroupCount(); ++n) {
            this.mFragment[n] = n < markushStructure.getCoreCount() ? markushStructure.getCoreStructure(n) : markushStructure.getRGroup(n - markushStructure.getCoreCount());
            bl |= this.mFragment[n].isFragment();
            this.mMol.addMolecule(this.mFragment[n]);
        }
        this.mMol.setFragment(bl);
        this.pushUndo();
        this.mFragmentNo = new int[this.mMol.getAllAtoms()];
        n = 0;
        for (int i = 0; i < this.mFragment.length; ++i) {
            for (int j = 0; j < this.mFragment[i].getAllAtoms(); ++j) {
                this.mFragmentNo[n++] = i;
            }
        }
        this.mMode = 3;
        this.notifyChange();
    }

    public void setDisplayMode(int n) {
        this.displayMode = n;
        this.notifyChange();
    }

    public int getMode() {
        return this.mMode;
    }

    public StereoMolecule getMolecule() {
        return this.mMol;
    }

    public boolean isAtomColorSupported() {
        return this.mAtomColorSupported;
    }

    public void setAtomColorSupported(boolean bl) {
        this.mAtomColorSupported = bl;
    }

    protected void cleanupCoordinates(boolean bl, boolean bl2) {
        int n;
        int n2 = 0;
        for (n = 0; n < this.mMol.getAllAtoms(); n += 1) {
            if (!this.mMol.isSelectedAtom(n)) continue;
            ++n2;
        }
        int n3 = n = n2 != 0 && n2 != this.mMol.getAllAtoms() ? 1 : 0;
        if (!bl) {
            AbstractDepictor abstractDepictor = this.createDepictor(this.getMolecule());
            this.cleanupMoleculeCoordinates(abstractDepictor, bl2, n != 0);
        } else {
            AbstractExtendedDepictor abstractExtendedDepictor = this.createExtendedDepictor();
            this.cleanupMultiFragmentCoordinates(abstractExtendedDepictor, n != 0, bl2);
        }
        if (n) {
            this.mMol.removeAtomMarkers();
        }
    }

    private void cleanupMoleculeCoordinates(AbstractDepictor abstractDepictor, boolean bl, boolean bl2) {
        DepictorTransformation depictorTransformation;
        if (bl) {
            if (bl2) {
                for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                    this.mMol.setAtomMarker(i, !this.mMol.isSelectedAtom(i));
                }
            }
            new CoordinateInventor(bl2 ? 4 : 0).invent(this.mMol);
        }
        if ((depictorTransformation = abstractDepictor.simpleValidateView(new GenericRectangle(0.0, 0.0, this.getWidth(), this.getHeight()), 65536)) != null) {
            depictorTransformation.applyTo(this.mMol);
        }
    }

    private float getHeight() {
        return (float)this.displaySize.getHeight();
    }

    private float getWidth() {
        return (float)this.displaySize.getWidth();
    }

    private int maxUpdateMode() {
        return 65536;
    }

    private void cleanupMultiFragmentCoordinates(AbstractExtendedDepictor abstractExtendedDepictor, boolean bl, boolean bl2) {
        int n;
        Object[] objectArray;
        if (bl && bl2) {
            objectArray = new int[this.mFragment.length];
            for (n = 0; n < this.mMol.getAllAtoms(); ++n) {
                int n2 = this.mFragmentNo[n];
                this.mFragment[n2].setAtomMarker((int)objectArray[n2], !this.mMol.isSelectedAtom(n));
                int n3 = n2;
                objectArray[n3] = objectArray[n3] + true;
            }
        }
        objectArray = new GenericRectangle[this.mFragment.length];
        for (n = 0; n < this.mFragment.length; ++n) {
            if (bl2) {
                new CoordinateInventor(bl ? 4 : 0).invent(this.mFragment[n]);
            }
            AbstractDepictor abstractDepictor = this.createDepictor(this.mFragment[n]);
            abstractDepictor.updateCoords(null, null, 65536);
            objectArray[n] = abstractDepictor.getBoundingRect();
        }
        double d = 36.0;
        double d2 = this.mMol.getAverageBondLength();
        double d3 = this.isReaction() ? (double)(0.08f * this.getWidth()) : 0.0;
        double d4 = 0.5 * d;
        for (int i = 0; i <= this.mFragment.length; ++i) {
            if (this.isReaction() && i == this.mReactantCount) {
                this.mDrawingObjectList.get(0).setRect((float)(d4 - d / 20.0), this.getHeight() / 2.0f, (float)d3, this.getHeight() / 2.0f);
                d4 += d3;
            }
            if (i == this.mFragment.length) break;
            double d5 = d4 - objectArray[i].x;
            double d6 = 0.5 * ((double)this.getHeight() - objectArray[i].height) - objectArray[i].y;
            this.mFragment[i].translateCoords(d5, d6);
            d4 += d + objectArray[i].width;
        }
        abstractExtendedDepictor.updateCoords(null, new GenericRectangle(0.0, 0.0, this.getWidth(), this.getHeight()), this.maxUpdateMode());
        int[] nArray = new int[this.mFragment.length];
        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
            int n4 = this.mFragmentNo[i];
            this.mMol.setAtomX(i, this.mFragment[n4].getAtomX(nArray[n4]));
            this.mMol.setAtomY(i, this.mFragment[n4].getAtomY(nArray[n4]));
            int n5 = n4;
            nArray[n5] = nArray[n5] + 1;
        }
        this.mMol.setStereoBondsFromParity();
    }

    public void analyzeFragmentMembership() {
        this.mMol.ensureHelperArrays(15);
        int[] nArray = new int[this.mMol.getAllAtoms()];
        int n = this.mMol.getFragmentNumbers(nArray, false, true);
        n = this.joinCloseFragments(nArray, n);
        this.sortFragmentsByPosition(nArray, n);
        this.mFragmentNo = nArray;
        this.mFragment = this.mMol.getFragments(nArray, n);
    }

    private void syncFragments() {
        this.mMol.ensureHelperArrays(15);
        int[] nArray = new int[this.mMol.getAllAtoms()];
        int n = this.mMol.getFragmentNumbers(nArray, false, true);
        this.mFragment = this.mMol.getFragments(nArray, n);
        n = this.joinCloseFragments(nArray, n);
        this.sortFragmentsByPosition(nArray, n);
        this.mFragmentNo = nArray;
        for (StereoMolecule stereoMolecule : this.mFragment = this.mMol.getFragments(nArray, n)) {
            stereoMolecule.ensureHelperArrays(15);
        }
    }

    private int joinCloseFragments(int[] nArray, int n) {
        int n2;
        int n3;
        int n4;
        if (n < 2) {
            return n;
        }
        boolean[][] blArrayArray = new boolean[n][];
        for (int i = 1; i < n; ++i) {
            blArrayArray[i] = new boolean[i];
        }
        double d = this.mMol.getAverageBondLength();
        for (int i = 1; i < this.mMol.getAllAtoms(); ++i) {
            for (n4 = 0; n4 < i; ++n4) {
                int n5;
                double d2;
                double d3 = this.mMol.getAtomX(n4) - this.mMol.getAtomX(i);
                double d4 = Math.sqrt(d3 * d3 + (d2 = this.mMol.getAtomY(n4) - this.mMol.getAtomY(i)) * d2);
                if (!(d4 < (double)1.2f * d) || (n3 = nArray[i]) == (n5 = nArray[n4])) continue;
                if (n3 > n5) {
                    blArrayArray[n3][n5] = true;
                    continue;
                }
                blArrayArray[n5][n3] = true;
            }
        }
        int[] nArray2 = new int[n];
        for (n4 = 0; n4 < n; ++n4) {
            nArray2[n4] = n4;
        }
        n4 = 0;
        for (n2 = 1; n2 < n; ++n2) {
            for (int i = 0; i < n2; ++i) {
                int n6;
                int n7;
                if (!blArrayArray[n2][i] || (n7 = nArray2[n2]) == (n6 = nArray2[i])) continue;
                ++n4;
                int n8 = Math.min(n7, n6);
                int n9 = Math.max(n7, n6);
                for (n3 = 0; n3 < n; ++n3) {
                    if (nArray2[n3] == n9) {
                        nArray2[n3] = n8;
                        continue;
                    }
                    if (nArray2[n3] <= n9) continue;
                    int n10 = n3;
                    nArray2[n10] = nArray2[n10] - 1;
                }
            }
        }
        for (n2 = 0; n2 < this.mMol.getAllAtoms(); ++n2) {
            nArray[n2] = nArray2[nArray[n2]];
        }
        return n - n4;
    }

    private void sortFragmentsByPosition(int[] nArray, int n) {
        int n2;
        int n3;
        int[][] nArray2 = new int[n][(this.mMode & 6) != 0 ? 2 : 1];
        for (int i = 0; i < n; ++i) {
            nArray2[i][0] = i;
        }
        Point[] pointArray = this.calculateFragmentCenterOfGravity(nArray, n);
        if (this.isReactionMode()) {
            this.mReactantCount = 0;
            for (n3 = 0; n3 < n; ++n3) {
                int n4 = nArray2[n3][1] = this.isOnProductSide(pointArray[n3].x, pointArray[n3].y) ? 1 : 0;
                if (nArray2[n3][1] != 0) continue;
                ++this.mReactantCount;
            }
        } else if ((this.mMode & 2) != 0) {
            this.mReactantCount = n;
            for (n3 = 0; n3 < this.mMol.getAllAtoms(); ++n3) {
                if (this.mMol.getAtomicNo(n3) != 0 || nArray2[nArray[n3]][1] != 0) continue;
                nArray2[nArray[n3]][1] = 1;
                --this.mReactantCount;
            }
        }
        final Point[] pointArray2 = pointArray;
        Arrays.sort(nArray2, new Comparator<int[]>(){

            @Override
            public int compare(int[] nArray, int[] nArray2) {
                if ((Model.this.mMode & 6) != 0 && nArray[1] != nArray2[1]) {
                    return nArray[1] == 0 ? -1 : 1;
                }
                return pointArray2[nArray[0]].x < pointArray2[nArray2[0]].x ? -1 : 1;
            }
        });
        int[] nArray3 = new int[n];
        Point[] pointArray3 = new Point[n];
        for (n2 = 0; n2 < n; ++n2) {
            int n5 = nArray2[n2][0];
            nArray3[n5] = n2;
            pointArray3[n2] = pointArray[n5];
        }
        pointArray = pointArray3;
        for (n2 = 0; n2 < this.mMol.getAllAtoms(); ++n2) {
            nArray[n2] = nArray3[nArray[n2]];
        }
    }

    private boolean isReactionMode() {
        return (this.mMode & 4) != 0;
    }

    public boolean isOnProductSide(double d, double d2) {
        if (this.isReactionMode()) {
            return d > this.arrowPos.getX();
        }
        return d > this.getDisplaySize().getWidth() / 2.0;
    }

    private Point[] calculateFragmentCenterOfGravity(int[] nArray, int n) {
        int n2;
        Point[] pointArray = new Point[n];
        int[] nArray2 = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            pointArray[n2] = new Point(0, 0);
        }
        for (n2 = 0; n2 < this.mMol.getAllAtoms(); ++n2) {
            pointArray[nArray[n2]].x = (int)((double)pointArray[nArray[n2]].x + this.mMol.getAtomX(n2));
            pointArray[nArray[n2]].y = (int)((double)pointArray[nArray[n2]].y + this.mMol.getAtomY(n2));
            int n3 = nArray[n2];
            nArray2[n3] = nArray2[n3] + 1;
        }
        for (n2 = 0; n2 < n; ++n2) {
            pointArray[n2].x /= nArray2[n2];
            pointArray[n2].y /= nArray2[n2];
        }
        return pointArray;
    }

    public void setMapper(IReactionMapper iReactionMapper) {
        this.mMapper = iReactionMapper;
    }

    public void mapReaction(int n, GenericPoint genericPoint, GenericPoint genericPoint2) {
        StereoMolecule stereoMolecule = this.getMolecule();
        if (stereoMolecule != null && genericPoint != null && genericPoint2 != null) {
            int n2 = this.getNextMapNo();
            StereoMolecule stereoMolecule2 = this.getFragmentAt(genericPoint, false);
            StereoMolecule stereoMolecule3 = this.getFragmentAt(genericPoint2, false);
            boolean bl = this.isOnProductSide(genericPoint.getX(), genericPoint.getY());
            boolean bl2 = this.isOnProductSide(genericPoint2.getX(), genericPoint2.getY());
            if (stereoMolecule3 != null && stereoMolecule3 != stereoMolecule2 && bl ^ bl2) {
                int n3 = stereoMolecule.findAtom((int)genericPoint2.getX(), (int)genericPoint2.getY());
                if (n3 != -1) {
                    stereoMolecule.setAtomMapNo(n, n2, false);
                    stereoMolecule.setAtomMapNo(n3, n2, false);
                }
                if (this.mMapper != null) {
                    this.tryAutoMapReaction();
                }
            }
        }
    }

    public int getNextMapNo() {
        int n = 1;
        StereoMolecule stereoMolecule = this.mMol;
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            n = Math.max(stereoMolecule.getAtomMapNo(i) + 1, n);
        }
        return n;
    }

    public void popUndo() {
        if (this._undoList.size() > 0) {
            this.setValue(this._undoList.get(this._undoList.size() - 1), false);
            this._undoList.remove(this._undoList.size() - 1);
        }
    }

    public void pushUndo() {
        this._undoList.add(new StereoMolecule(this.mMol));
        if (this._undoList.size() > 5) {
            this._undoList.remove(0);
        }
    }

    public int getESRType() {
        return this.selectedESRType;
    }

    public void setESRType(int n) {
        this.selectedESRType = n;
        this.notifyChange();
    }

    public void addValidationListener(IValidationListener iValidationListener) {
        if (!this.validationListeners.contains(iValidationListener)) {
            this.validationListeners.add(iValidationListener);
        }
    }

    public void removeValidationListener(IValidationListener iValidationListener) {
        if (this.validationListeners.contains(iValidationListener)) {
            this.validationListeners.remove(iValidationListener);
        }
    }

    public void addChangeListener(IChangeListener iChangeListener) {
        if (!this.changeListeners.contains(iChangeListener)) {
            this.changeListeners.add(iChangeListener);
        }
    }

    public void removeChangeListener(IChangeListener iChangeListener) {
        if (this.changeListeners.contains(iChangeListener)) {
            this.changeListeners.remove(iChangeListener);
        }
    }

    public void setDisplaySize(Dimension dimension) {
        if (this.isReactionMode() && dimension.getWidth() != 0.0 && dimension.getHeight() != 0.0 && (dimension.getWidth() != this.displaySize.getWidth() || dimension.getHeight() != this.displaySize.getHeight())) {
            double d = dimension.getWidth() / this.displaySize.getWidth();
            double d2 = dimension.getHeight() / this.displaySize.getHeight();
            double d3 = Math.min(d, d2);
            this.scale(d3);
        }
        this.displaySize = dimension;
    }

    private void scale(double d) {
        AbstractDepictor abstractDepictor;
        DepictorTransformation depictorTransformation;
        if (!Double.isInfinite(d) && d != 1.0 && d > 0.0 && (depictorTransformation = (abstractDepictor = this.createDepictor(this.mMol)).simpleValidateView(new GenericRectangle(0.0, 0.0, this.getWidth(), this.getHeight()), 65536 + (int)this.mMol.getAverageBondLength())) != null) {
            depictorTransformation.applyTo(this.mMol);
        }
    }

    public Dimension getDisplaySize() {
        return this.displaySize;
    }

    public void deleteMolecule(StereoMolecule stereoMolecule) {
        System.err.println("DeleteMolecule needs to be implemented????");
    }

    public final void setValue(StereoMolecule stereoMolecule, boolean bl) {
        this.needsLayout(bl);
        this.mMol = stereoMolecule;
        this.notifyChange();
    }

    public void setValue(Reaction reaction) {
        this.setReaction(reaction);
    }

    public void changed() {
        this.notifyChange();
    }

    public void valueInvalidated() {
        for (IValidationListener iValidationListener : this.validationListeners) {
            iValidationListener.valueInvalidated();
        }
    }

    private void notifyChange() {
        for (IChangeListener iChangeListener : this.changeListeners) {
            iChangeListener.onChange();
        }
    }

    public StereoMolecule getMoleculeAt(GenericPoint genericPoint, boolean bl) {
        StereoMolecule stereoMolecule = this.mMol;
        if (stereoMolecule.findAtom(genericPoint.getX(), genericPoint.getY()) != -1) {
            return stereoMolecule;
        }
        if (bl) {
            for (int i = 0; i < stereoMolecule.getAllBonds(); ++i) {
                int n = stereoMolecule.getBondAtom(0, i);
                int n2 = stereoMolecule.getBondAtom(1, i);
                Line2D.Double double_ = new Line2D.Double(stereoMolecule.getAtomX(n), stereoMolecule.getAtomY(n), stereoMolecule.getAtomX(n2), stereoMolecule.getAtomY(n2));
                double d = double_.ptSegDist(genericPoint.getX(), genericPoint.getY());
                if (!(d < 5.0)) continue;
                return stereoMolecule;
            }
        }
        return null;
    }

    private int getFragmentByAtom(int n) {
        int n2;
        if (n >= 0 && n < this.getMolecule().getAllAtoms() && (n2 = this.mFragmentNo[n]) >= 0 && n2 < this.mFragmentNo.length) {
            return n2;
        }
        return -1;
    }

    public void selectFragmentByAtom(int n) {
        int n2 = this.getFragmentByAtom(n);
        for (int i = 0; n2 != -1 && i < this.mMol.getAllAtoms(); ++i) {
            if (this.mFragmentNo[i] != n2) continue;
            this.mMol.setAtomSelection(i, true);
        }
    }

    private boolean isPointOnAtomOrBond(StereoMolecule stereoMolecule, GenericPoint genericPoint, boolean bl) {
        int n;
        for (n = 0; n < stereoMolecule.getAllAtoms(); ++n) {
            GenericPoint genericPoint2 = new GenericPoint(stereoMolecule.getAtomX(n), stereoMolecule.getAtomY(n));
            if (!(Math.abs(genericPoint2.distance(genericPoint)) < 5.0)) continue;
            return true;
        }
        if (bl) {
            for (n = 0; n < stereoMolecule.getAllBonds(); ++n) {
                int n2 = stereoMolecule.getBondAtom(0, n);
                int n3 = stereoMolecule.getBondAtom(1, n);
                Line2D.Double double_ = new Line2D.Double(stereoMolecule.getAtomX(n2), stereoMolecule.getAtomY(n2), stereoMolecule.getAtomX(n3), stereoMolecule.getAtomY(n3));
                double d = double_.ptSegDist(genericPoint.getX(), genericPoint.getY());
                if (!(d < 5.0)) continue;
                return true;
            }
        }
        return false;
    }

    public StereoMolecule getFragmentAt(GenericPoint genericPoint, boolean bl) {
        for (StereoMolecule stereoMolecule : this.getFragments()) {
            if (!this.isPointOnAtomOrBond(stereoMolecule, genericPoint, bl)) continue;
            return stereoMolecule;
        }
        return null;
    }

    public static int rowFromESRType(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 1: {
                return 2;
            }
        }
        return 0;
    }

    public static int esrTypeFromRow(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
        }
        return 0;
    }

    public int getSelectedAtom() {
        return this.selectedAtom;
    }

    public void setSelectedAtom(int n) {
        if (this.selectedAtom != n && this.atomHighlightCallback != null) {
            this.atomHighlightCallback.onHighlight(n != -1 ? n : this.selectedAtom, n != -1);
        }
        this.selectedAtom = n;
    }

    public int getSelectedBond() {
        return this.selectedBond;
    }

    public void setSelectedBond(int n) {
        if (this.selectedBond != n && this.bondHighlightCallback != null) {
            this.bondHighlightCallback.onHighlight(n != -1 ? n : this.selectedBond, n != -1);
        }
        this.selectedBond = n;
    }

    public final void setMode(int n) {
        this.mMode = n;
        if ((this.mMode & 6) != 0) {
            this.mMode |= 1;
        }
    }

    public List<IDrawingObject> getDrawingObjects() {
        return this.mDrawingObjectList;
    }

    public void addDrawingObject(IDrawingObject iDrawingObject) {
        if (!this.mDrawingObjectList.contains(iDrawingObject)) {
            this.pushUndo();
            this.mDrawingObjectList.add(iDrawingObject);
        }
    }

    public boolean isReaction() {
        return this.isReactionMode();
    }

    public boolean isFragment() {
        boolean bl = false;
        bl = this.mMol.isFragment();
        return bl;
    }

    public void setFragment(boolean bl) {
        this.mMol.setFragment(bl);
        this.notifyChange();
    }

    public void setNewMolecule() {
        StereoMolecule stereoMolecule = new StereoMolecule();
        stereoMolecule.setFragment(this.isFragment());
        this.setValue(stereoMolecule, true);
    }

    public void needsLayout(boolean bl) {
        this.needslayout = bl;
    }

    public boolean needsLayout() {
        return this.needslayout;
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    GenericPoint calculateCenter(StereoMolecule stereoMolecule) {
        float f = 0.0f;
        float f2 = 0.0f;
        int n = stereoMolecule.getAllAtoms();
        for (int i = 0; i < n; ++i) {
            f = (float)((double)f + stereoMolecule.getAtomX(i));
            f2 = (float)((double)f2 + stereoMolecule.getAtomY(i));
        }
        return new GenericPoint(f / (float)n, f2 / (float)n);
    }

    public String getIDCode() {
        if (!this.isReaction()) {
            StereoMolecule stereoMolecule = this.getMolecule();
            if (stereoMolecule != null && this.mMol.getAllAtoms() > 0) {
                Canonizer canonizer = new Canonizer(stereoMolecule);
                return canonizer.getIDCode() + " " + canonizer.getEncodedCoordinates();
            }
        } else {
            Reaction reaction = this.getReaction();
            String string = ReactionEncoder.encode(reaction, true, 3);
            return string;
        }
        return null;
    }

    public StringBuilder getKeyStrokeBuffer() {
        return this.mAtomKeyStrokeBuffer;
    }

    public int getAtomKeyStrokeValidity(String string) {
        if (Molecule.getAtomicNoFromLabel(string) != 0) {
            return 1;
        }
        if (NamedSubstituents.getSubstituentIDCode(string) != null) {
            return 2;
        }
        if (this.isValidAtomKeyStrokeStart(string)) {
            return 3;
        }
        return 4;
    }

    private boolean isValidAtomKeyStroke(String string) {
        return Molecule.getAtomicNoFromLabel(string) != 0 || NamedSubstituents.getSubstituentIDCode(string) != null;
    }

    private boolean isValidAtomKeyStrokeStart(String string) {
        if (string.length() < 3) {
            for (int i = 1; i < Molecule.cAtomLabel.length; ++i) {
                if (!Molecule.cAtomLabel[i].startsWith(string)) continue;
                return true;
            }
        }
        return NamedSubstituents.isValidSubstituentNameStart(string);
    }

    public int getMarkushCount() {
        return 0;
    }

    public void tryAutoMapReaction() {
        int n;
        Object object;
        int n2;
        MySSSearcher mySSSearcher = new MySSSearcher();
        Reaction reaction = this.getReaction();
        for (n2 = 0; n2 < reaction.getMolecules(); ++n2) {
            object = reaction.getMolecule(n2);
            for (n = 0; n < ((ExtendedMolecule)object).getAtoms(); ++n) {
                if (((Molecule)object).getAtomMapNo(n) <= 0) continue;
                ((Molecule)object).setAtomicNo(n, 100 + ((Molecule)object).getAtomMapNo(n));
            }
        }
        if ((reaction = this.mMapper.mapReaction(reaction, mySSSearcher)) != null) {
            int n3;
            n2 = 0;
            object = new int[this.mFragment.length];
            for (n = 0; n < this.mMol.getAllAtoms(); ++n) {
                n3 = this.mFragmentNo[n];
                if (this.mFragment[n3].getAtomicNo((int)object[n3]) > 100) {
                    this.mMol.setAtomMapNo(n, this.mFragment[n3].getAtomicNo((int)object[n3]) - 100, false);
                    n2 = Math.max(this.mMol.getAtomMapNo(n), n2);
                }
                Object object2 = object;
                int n4 = n3;
                object2[n4] = object2[n4] + true;
            }
            object = new int[this.mFragment.length];
            for (n = 0; n < this.mMol.getAllAtoms(); ++n) {
                n3 = this.mFragmentNo[n];
                if (this.mFragment[n3].getAtomMapNo((int)object[n3]) > 0 && this.mFragment[n3].getAtomicNo((int)object[n3]) <= 100) {
                    this.mMol.setAtomMapNo(n, this.mFragment[n3].getAtomMapNo((int)object[n3]) + n2, true);
                }
                Object object3 = object;
                int n5 = n3;
                object3[n5] = object3[n5] + true;
            }
        }
        this.syncFragments();
    }

    public String getMolFile(boolean bl) {
        if (bl) {
            return new MolfileV3Creator(this.mMol).getMolfile();
        }
        return new MolfileCreator(this.mMol).getMolfile();
    }

    public void setMolFile(String string) {
        try {
            MolfileParser molfileParser = new MolfileParser();
            StereoMolecule stereoMolecule = new StereoMolecule();
            molfileParser.parse(stereoMolecule, string);
            this.setValue(stereoMolecule, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getSmiles() {
        return new IsomericSmilesCreator(this.mMol).getSmiles();
    }

    public void setSmiles(String string) {
        try {
            SmilesParser smilesParser = new SmilesParser();
            StereoMolecule stereoMolecule = new StereoMolecule();
            smilesParser.parse(stereoMolecule, string);
            this.setValue(stereoMolecule, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getReactantCount() {
        return this.mReactantCount;
    }

    private GenericPoint calculateCenterOfGravity() {
        int n = this.mMol.getAllAtoms();
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d += this.mMol.getAtomX(i);
            d2 += this.mMol.getAtomY(i);
        }
        return n > 0 ? new GenericPoint(d / (double)n, d2 / (double)n) : null;
    }

    public void flip(boolean bl) {
        GenericPoint genericPoint = this.calculateCenterOfGravity();
        if (genericPoint != null) {
            this.moveCoords((float)(-genericPoint.getX()), (float)(-genericPoint.getY()));
            if (bl) {
                this.scaleCoords(-1.0f, 1.0f);
            } else {
                this.scaleCoords(1.0f, -1.0f);
            }
            this.moveCoords((float)genericPoint.getX(), (float)genericPoint.getY());
            for (int i = 0; i < this.mMol.getAllBonds(); ++i) {
                if (this.mMol.getBondType(i) == 257) {
                    this.mMol.setBondType(i, 129);
                    continue;
                }
                if (this.mMol.getBondType(i) != 129) continue;
                this.mMol.setBondType(i, 257);
            }
        }
    }

    private void scaleCoords(float f, float f2) {
        int n = this.mMol.getAllAtoms();
        for (int i = 0; i < n; ++i) {
            this.mMol.setAtomX(i, this.mMol.getAtomX(i) * (double)f);
            this.mMol.setAtomY(i, this.mMol.getAtomY(i) * (double)f2);
        }
    }

    private void moveCoords(float f, float f2) {
        int n = this.mMol.getAllAtoms();
        for (int i = 0; i < n; ++i) {
            this.mMol.setAtomX(i, this.mMol.getAtomX(i) + (double)f);
            this.mMol.setAtomY(i, this.mMol.getAtomY(i) + (double)f2);
        }
    }

    public void registerAtomHighlightCallback(AtomHighlightCallback atomHighlightCallback) {
        this.atomHighlightCallback = atomHighlightCallback;
    }

    public void registerBondHighlightCallback(BondHighlightCallback bondHighlightCallback) {
        this.bondHighlightCallback = bondHighlightCallback;
    }

    public void addMolecule(StereoMolecule stereoMolecule, double d, double d2) {
        if (stereoMolecule != null && stereoMolecule.getAllAtoms() != 0) {
            if (this.mMol.getAllAtoms() == 0) {
                int n = 0;
                boolean bl = this.mMol.isFragment();
                this.scaleIntoView(stereoMolecule, n, 0.0, 0.0);
                stereoMolecule.copyMolecule(this.mMol);
                this.mMol.setFragment(bl);
                this.notifyChange();
            } else {
                int n = (int)this.mMol.getAverageBondLength();
                this.scaleIntoView(stereoMolecule, n, d, d2);
                int n2 = this.mMol.getAllAtoms();
                boolean bl = this.mMol.isFragment();
                this.mMol.addMolecule(stereoMolecule);
                for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                    this.mMol.setAtomSelection(i, i >= n2);
                }
                this.mMol.setFragment(bl);
                this.notifyChange();
            }
        }
    }

    private void scaleIntoView(StereoMolecule stereoMolecule, int n, double d, double d2) {
        AbstractDepictor abstractDepictor = this.createDepictor(stereoMolecule);
        DepictorTransformation depictorTransformation = abstractDepictor.simpleValidateView(new GenericRectangle(0.0, 0.0, this.getWidth(), this.getHeight()), 65536 + n);
        if (depictorTransformation != null) {
            depictorTransformation.move(d, d2);
            System.out.printf("Transform %s %s\n", depictorTransformation.getOffsetX(), d);
            depictorTransformation.applyTo(stereoMolecule);
        }
    }

    public IDrawingObject getSelectedDrawingObject() {
        return this.selectedDrawingObject;
    }

    public void setSelectedDrawingObject(IDrawingObject iDrawingObject) {
        if (this.selectedDrawingObject != iDrawingObject) {
            this.setSelectedAtom(-1);
            this.setSelectedBond(-1);
        }
        this.selectedDrawingObject = iDrawingObject;
        if (iDrawingObject != null) {
            this.selectedDrawingObject.setSelected(true);
        }
    }

    public void cleanMolecule(boolean bl, boolean bl2) {
        this.cleanupCoordinates(false, bl);
        this.valueInvalidated();
    }

    protected abstract AbstractExtendedDepictor createExtendedDepictor();

    protected abstract AbstractDepictor createDepictor(StereoMolecule var1);

    public abstract void analyzeReaction();

    public abstract boolean copyMolecule(boolean var1);

    public abstract boolean copyReaction(boolean var1);

    public abstract StereoMolecule pasteMolecule(double var1, double var3);

    public abstract Reaction pasteReaction(double var1, double var3);

    public ImageProvider getImageProvider() {
        return this.imageProvider;
    }

    public void setImageProvider(ImageProvider imageProvider) {
        this.imageProvider = imageProvider;
    }

    static class MySSSearcher
    extends SSSearcher {
        MySSSearcher() {
        }

        @Override
        public boolean areAtomsSimilar(int n, int n2) {
            if (this.mMolecule.getAtomicNo(n) == this.mFragment.getAtomicNo(n2) && (this.mMolecule.isAromaticAtom(n) || this.mFragment.isAromaticAtom(n2))) {
                return true;
            }
            return super.areAtomsSimilar(n, n2);
        }

        @Override
        public boolean areBondsSimilar(int n, int n2) {
            if (this.mMolecule.isAromaticBond(n) || this.mMolecule.isDelocalizedBond(n) || this.mFragment.isAromaticBond(n2) || this.mFragment.isDelocalizedBond(n2)) {
                return true;
            }
            return super.areBondsSimilar(n, n2);
        }
    }

    public static interface BondHighlightCallback {
        public void onHighlight(int var1, boolean var2);
    }

    public static interface AtomHighlightCallback {
        public void onHighlight(int var1, boolean var2);
    }
}

