/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.jfx.gui.chem;

import com.actelion.research.chem.AbstractDepictor;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.generic.GenericPolygon;
import com.actelion.research.jfx.gui.GraphicsContextImpl;
import javafx.geometry.Bounds;
import javafx.geometry.VPos;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class JFXCanvasDepictor
extends AbstractDepictor<Object> {
    private GraphicsContext ctx = null;
    private Font currentFont = Font.font((String)"Helvetica", (double)8.0);
    private double lineWidth = 1.0;

    public JFXCanvasDepictor(StereoMolecule stereoMolecule, int n) {
        super(stereoMolecule != null ? stereoMolecule : new StereoMolecule());
        super.setDisplayMode(n);
    }

    public JFXCanvasDepictor(StereoMolecule stereoMolecule) {
        this(stereoMolecule, 0);
    }

    @Override
    protected void init() {
        super.init();
    }

    @Override
    public void paint(Object object) {
        if (object instanceof GraphicsContext) {
            this.ctx = (GraphicsContext)object;
        } else if (object instanceof GraphicsContextImpl) {
            this.ctx = ((GraphicsContextImpl)object).getContext();
        } else {
            throw new IllegalArgumentException("Need to pass a Canvas object " + object);
        }
        super.paint(object);
    }

    @Override
    protected void drawBlackLine(AbstractDepictor.DepictorLine depictorLine) {
        this.ctx.save();
        this.ctx.setLineWidth(this.lineWidth);
        this.ctx.setLineCap(StrokeLineCap.ROUND);
        this.ctx.setLineJoin(StrokeLineJoin.MITER);
        this.ctx.beginPath();
        this.ctx.moveTo(depictorLine.x1, depictorLine.y1);
        this.ctx.lineTo(depictorLine.x2, depictorLine.y2);
        this.ctx.stroke();
        this.ctx.restore();
    }

    @Override
    protected void drawDottedLine(AbstractDepictor.DepictorLine depictorLine) {
        this.ctx.save();
        this.ctx.setLineCap(StrokeLineCap.ROUND);
        this.ctx.beginPath();
        this.ctx.moveTo(depictorLine.x1, depictorLine.y1);
        this.ctx.lineTo(depictorLine.x2, depictorLine.y2);
        this.ctx.stroke();
        this.ctx.restore();
    }

    @Override
    protected void drawPolygon(GenericPolygon genericPolygon) {
        this.ctx.save();
        double[] dArray = new double[genericPolygon.getSize()];
        double[] dArray2 = new double[genericPolygon.getSize()];
        for (int i = 0; i < genericPolygon.getSize(); ++i) {
            dArray[i] = genericPolygon.getX(i);
            dArray2[i] = genericPolygon.getY(i);
        }
        this.ctx.fillPolygon(dArray, dArray2, genericPolygon.getSize());
        this.ctx.restore();
    }

    @Override
    protected void drawString(String string, double d, double d2) {
        this.ctx.save();
        this.ctx.setFont(this.currentFont);
        this.ctx.setTextAlign(TextAlignment.CENTER);
        this.ctx.setTextBaseline(VPos.CENTER);
        this.ctx.fillText(string, d, d2);
        this.ctx.restore();
    }

    private Bounds getBounds(String string) {
        Text text = new Text(string);
        text.setFont(this.currentFont);
        return text.getLayoutBounds();
    }

    @Override
    protected void fillCircle(double d, double d2, double d3) {
        this.ctx.save();
        this.ctx.fillArc(d, d2, d3, d3, 0.0, 360.0, ArcType.ROUND);
        this.ctx.restore();
    }

    @Override
    protected double getStringWidth(String string) {
        return this.getBounds(string).getWidth();
    }

    @Override
    protected int getTextSize() {
        return (int)this.currentFont.getSize();
    }

    @Override
    protected void setTextSize(int n) {
        this.currentFont = Font.font((String)"Helvetica", (double)n);
    }

    @Override
    protected void setLineWidth(double d) {
        this.lineWidth = d;
    }

    @Override
    protected double getLineWidth() {
        return this.lineWidth;
    }

    @Override
    protected void setRGB(int n) {
        if (this.ctx != null) {
            Color color = new Color((double)((n & 0xFF0000) >> 16) / 255.0, (double)((n & 0xFF00) >> 8) / 255.0, (double)(n & 0xFF) / 255.0, 1.0);
            this.ctx.setStroke((Paint)color);
            this.ctx.setFill((Paint)color);
        }
    }
}

