/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.table;

import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.coords.CoordinateInventor;
import com.actelion.research.chem.reaction.ReactionEncoder;
import com.actelion.research.gui.LookAndFeelHelper;
import com.actelion.research.gui.table.ChemistryRenderPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;

public class ChemistryCellRenderer
implements ListCellRenderer,
TableCellRenderer {
    private ChemistryRenderPanel mRenderPanel = new ChemistryRenderPanel();
    private boolean mIsEnabled;
    private boolean mAlternateBackground;

    public ChemistryCellRenderer() {
        this(null);
    }

    public ChemistryCellRenderer(Dimension dimension) {
        if (dimension != null) {
            this.mRenderPanel.setPreferredSize(dimension);
        }
    }

    public void setAlternateRowBackground(boolean bl) {
        this.mAlternateBackground = bl;
    }

    public void setDisplayMode(int n) {
        this.mRenderPanel.setDisplayMode(n);
    }

    public void setTextSizeFactor(double d) {
        this.mRenderPanel.setTextSizeFactor(d);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.mIsEnabled = jList.isEnabled();
        return this.getCellRendererComponent(object, bl, bl2, n);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.mIsEnabled = jTable.isEnabled();
        return this.getCellRendererComponent(object, bl, bl2, n);
    }

    private Component getCellRendererComponent(Object object, boolean bl, boolean bl2, int n) {
        if (LookAndFeelHelper.isAqua() || LookAndFeelHelper.isQuaQua()) {
            this.mRenderPanel.setOpaque(true);
        } else {
            this.mRenderPanel.setOpaque(false);
        }
        if (object == null) {
            this.mRenderPanel.setChemistry(null);
        } else if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                this.mRenderPanel.setChemistry(null);
            } else {
                int n2 = string.indexOf(33);
                if (n2 > 0 && string.charAt(n2 - 1) == ' ') {
                    n2 = -1;
                }
                if (n2 != -1) {
                    this.mRenderPanel.setChemistry(ReactionEncoder.decode((String)object, true));
                } else {
                    int n3 = string.indexOf(10);
                    if (n3 == -1) {
                        n3 = string.indexOf(32);
                        if (n3 == -1) {
                            this.mRenderPanel.setChemistry(new IDCodeParser(true).getCompactMolecule(string));
                        } else {
                            this.mRenderPanel.setChemistry(new IDCodeParser(true).getCompactMolecule(string.substring(0, n3), string.substring(n3 + 1)));
                        }
                    } else {
                        StereoMolecule stereoMolecule = new StereoMolecule();
                        new IDCodeParser(true).parse(stereoMolecule, string.substring(0, n3));
                        do {
                            string = string.substring(n3 + 1);
                            n3 = string.indexOf(10);
                            stereoMolecule.addMolecule(new IDCodeParser(true).getCompactMolecule(n3 == -1 ? string : string.substring(0, n3)));
                        } while (n3 != -1);
                        new CoordinateInventor().invent(stereoMolecule);
                        this.mRenderPanel.setChemistry(stereoMolecule);
                    }
                }
            }
        } else {
            this.mRenderPanel.setChemistry(object);
        }
        this.mRenderPanel.setAlternateBackground(this.mAlternateBackground && (n & 1) == 1);
        this.mRenderPanel.setSelected(bl);
        this.mRenderPanel.setFocus(bl2);
        this.mRenderPanel.setOverruleForeground(this.mIsEnabled ? 0 : Color.GRAY.getRGB());
        return this.mRenderPanel;
    }
}

