/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.hidpi;

import com.actelion.research.gui.hidpi.ColorUtils;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import com.actelion.research.gui.hidpi.ScaledStyleSheet;
import java.awt.Color;
import java.awt.Font;
import java.io.StringReader;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.StyleSheet;

public class ScaledEditorKit
extends HTMLEditorKit {
    private static StyleSheet defaultStyles;
    private static ScaledEditorKit kit;
    static ViewFactory basicHTMLViewFactory;

    public static float getFontScaleFactor() {
        return HiDPIHelper.getUIScaleFactor();
    }

    @Override
    public StyleSheet getStyleSheet() {
        if (defaultStyles == null) {
            defaultStyles = new StyleSheet();
            StringReader stringReader = new StringReader("p { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }");
            try {
                defaultStyles.loadRules(stringReader, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            stringReader.close();
            defaultStyles.addStyleSheet(super.getStyleSheet());
        }
        return defaultStyles;
    }

    @Override
    public Document createDefaultDocument() {
        StyleSheet styleSheet = this.getStyleSheet();
        ScaledStyleSheet scaledStyleSheet = new ScaledStyleSheet();
        scaledStyleSheet.addStyleSheet(styleSheet);
        HTMLDocument hTMLDocument = new HTMLDocument(scaledStyleSheet);
        hTMLDocument.setParser(this.getParser());
        hTMLDocument.setAsynchronousLoadPriority(4);
        hTMLDocument.setTokenThreshold(100);
        return hTMLDocument;
    }

    Document createDefaultDocument(Font font, Color color) {
        StyleSheet styleSheet = this.getStyleSheet();
        ScaledStyleSheet scaledStyleSheet = new ScaledStyleSheet();
        scaledStyleSheet.addStyleSheet(styleSheet);
        HTMLDocument hTMLDocument = new HTMLDocument(scaledStyleSheet);
        hTMLDocument.setPreservesUnknownTags(false);
        hTMLDocument.getStyleSheet().addRule(this.displayPropertiesToCSS(font, color));
        hTMLDocument.setParser(this.getParser());
        hTMLDocument.setAsynchronousLoadPriority(Integer.MAX_VALUE);
        hTMLDocument.setPreservesUnknownTags(false);
        return hTMLDocument;
    }

    private String displayPropertiesToCSS(Font font, Color color) {
        StringBuffer stringBuffer = new StringBuffer("body {");
        if (font != null) {
            stringBuffer.append(" font-family: ");
            stringBuffer.append(font.getFamily());
            stringBuffer.append(" ; ");
            stringBuffer.append(" font-size: ");
            int n = Math.round((float)font.getSize() / ScaledEditorKit.getFontScaleFactor());
            stringBuffer.append(n);
            stringBuffer.append("pt ;");
            if (font.isBold()) {
                stringBuffer.append(" font-weight: bold ; ");
            }
            if (font.isItalic()) {
                stringBuffer.append(" font-style: italic ; ");
            }
        }
        if (color != null) {
            stringBuffer.append(" color: ").append(ColorUtils.colorToString(color)).append(" ; ");
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    @Override
    public ViewFactory getViewFactory() {
        if (basicHTMLViewFactory == null) {
            basicHTMLViewFactory = new BasicHTMLViewFactory();
        }
        return basicHTMLViewFactory;
    }

    public static ScaledEditorKit create() {
        if (kit == null) {
            kit = new ScaledEditorKit();
        }
        return kit;
    }

    static class BasicHTMLViewFactory
    extends HTMLEditorKit.HTMLFactory {
        BasicHTMLViewFactory() {
        }

        @Override
        public View create(Element element) {
            View view = super.create(element);
            if (view instanceof ImageView) {
                ((ImageView)view).setLoadsSynchronously(true);
            }
            return view;
        }
    }
}

