/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.fx;

import com.actelion.research.gui.fx.FXComponent;
import com.actelion.research.gui.generic.GenericActionEvent;
import com.actelion.research.gui.generic.GenericEventListener;
import com.actelion.research.gui.generic.GenericPopupMenu;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;

public class FXPopupMenu
extends FXComponent
implements GenericPopupMenu {
    private ContextMenu mPopupMenu = new ContextMenu();
    private Menu mSubMenu;
    private Node mOwner;

    public FXPopupMenu(Node node, GenericEventListener<GenericActionEvent> genericEventListener) {
        super(null);
        this.mOwner = node;
        this.addEventConsumer(genericEventListener);
    }

    @Override
    public void addItem(String string, String string2, boolean bl) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.disableProperty().set(!bl);
        String string3 = string2 == null ? string : string2;
        menuItem.setOnAction(actionEvent -> this.fireEvent(new GenericActionEvent((Object)this, 2, string3)));
        if (this.mSubMenu != null) {
            this.mSubMenu.getItems().add((Object)menuItem);
        } else {
            this.mPopupMenu.getItems().add((Object)menuItem);
        }
    }

    @Override
    public void addRadioButtonItem(String string, String string2, int n, boolean bl) {
        RadioMenuItem radioMenuItem = new RadioMenuItem(string);
        radioMenuItem.selectedProperty().set(bl);
        String string3 = string2 == null ? string : string2;
        radioMenuItem.setOnAction(actionEvent -> this.fireEvent(new GenericActionEvent((Object)this, 3, string3)));
        if (n != 0) {
            radioMenuItem.setStyle("-fx-background-color: #" + Integer.toHexString(n & 0xFFFFFF) + "; ");
        }
        if (this.mSubMenu != null) {
            this.mSubMenu.getItems().add((Object)radioMenuItem);
        } else {
            this.mPopupMenu.getItems().add((Object)radioMenuItem);
        }
    }

    @Override
    public void startSubMenu(String string) {
        this.mSubMenu = new Menu(string);
    }

    @Override
    public void endSubMenu() {
        this.mPopupMenu.getItems().add((Object)this.mSubMenu);
        this.mSubMenu = null;
    }

    @Override
    public void addSeparator() {
        if (this.mSubMenu != null) {
            this.mSubMenu.getItems().add((Object)new SeparatorMenuItem());
        } else {
            this.mPopupMenu.getItems().add((Object)new SeparatorMenuItem());
        }
    }

    @Override
    public void show(int n, int n2) {
        Point2D point2D = this.mOwner.localToScreen((double)n, (double)n2);
        this.mPopupMenu.show(this.mOwner.getScene().getWindow(), point2D.getX(), point2D.getY());
    }
}

