/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.fx;

import com.actelion.research.gui.LookAndFeelHelper;
import com.actelion.research.gui.fx.FXImage;
import com.actelion.research.gui.generic.GenericCursorHelper;
import com.actelion.research.util.Platform;
import javafx.geometry.Dimension2D;
import javafx.scene.Cursor;
import javafx.scene.ImageCursor;

public class FXCursorHelper
extends GenericCursorHelper {
    private static Cursor[] sCursor;
    private static boolean sIsDarkLaF;

    public static Cursor getCursor(int n) {
        boolean bl = LookAndFeelHelper.isDarkLookAndFeel();
        if (sIsDarkLaF != bl) {
            sIsDarkLaF = bl;
            sCursor = null;
        }
        if (sCursor == null) {
            sCursor = new Cursor[14];
        }
        if (sCursor[n] == null) {
            FXCursorHelper.sCursor[n] = FXCursorHelper.createCursor(n);
        }
        return sCursor[n];
    }

    public static Cursor createCursor(int n) {
        Dimension2D dimension2D = ImageCursor.getBestSize((double)32.0, (double)32.0);
        if (!Platform.isWindows() && dimension2D.getWidth() >= 24.0 && dimension2D.getHeight() >= 24.0 && IMAGE_NAME_32[n] != null) {
            FXImage fXImage = new FXImage("cursor/" + IMAGE_NAME_32[n]);
            FXCursorHelper.adaptForLaF(fXImage);
            fXImage.scale(24, 24);
            return new ImageCursor(fXImage.get(), (double)(HOTSPOT_32[2 * n] * 3 / 4), (double)(HOTSPOT_32[2 * n + 1] * 3 / 4));
        }
        if (dimension2D.getWidth() >= 16.0 && dimension2D.getHeight() >= 16.0 && n < IMAGE_DATA_16.length) {
            FXImage fXImage = new FXImage((int)dimension2D.getWidth(), (int)dimension2D.getHeight());
            FXCursorHelper.build16x16CursorImage(fXImage, n);
            FXCursorHelper.adaptForLaF(fXImage);
            return new ImageCursor(fXImage.get(), (double)HOTSPOT_16[2 * n], (double)HOTSPOT_16[2 * n + 1]);
        }
        if (n == 11) {
            return Cursor.DEFAULT;
        }
        if (n == 12) {
            return Cursor.TEXT;
        }
        if (n == 13) {
            return Cursor.HAND;
        }
        return Cursor.DEFAULT;
    }
}

