/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.editor;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.clipboard.ClipboardHandler;
import com.actelion.research.gui.dnd.MoleculeDropAdapter;
import com.actelion.research.gui.editor.GenericEditorArea;
import com.actelion.research.gui.generic.GenericCanvas;
import com.actelion.research.gui.generic.GenericDrawContext;
import com.actelion.research.gui.generic.GenericPoint;
import com.actelion.research.gui.swing.SwingDrawContext;
import com.actelion.research.gui.swing.SwingKeyHandler;
import com.actelion.research.gui.swing.SwingMouseHandler;
import com.actelion.research.gui.swing.SwingUIHelper;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.dnd.DropTarget;
import java.util.Map;
import javax.swing.JPanel;

public class SwingEditorArea
extends JPanel
implements GenericCanvas {
    private static final int ALLOWED_DROP_ACTIONS = 3;
    private GenericEditorArea mDrawArea;
    private SwingKeyHandler mKeyHandler;

    public SwingEditorArea(StereoMolecule stereoMolecule, int n) {
        this.setFocusable(true);
        this.mDrawArea = new GenericEditorArea(stereoMolecule, n, new SwingUIHelper(this), this);
        this.initializeDragAndDrop(3);
        SwingMouseHandler swingMouseHandler = new SwingMouseHandler(this.mDrawArea);
        this.addMouseListener(swingMouseHandler);
        this.addMouseMotionListener(swingMouseHandler);
        swingMouseHandler.addListener(this.mDrawArea);
        this.mKeyHandler = new SwingKeyHandler(this.mDrawArea);
        this.addKeyListener(this.mKeyHandler);
        this.mKeyHandler.addListener(this.mDrawArea);
        this.getGenericDrawArea().setClipboardHandler(new ClipboardHandler());
    }

    public SwingKeyHandler getKeyHandler() {
        return this.mKeyHandler;
    }

    public GenericEditorArea getGenericDrawArea() {
        return this.mDrawArea;
    }

    @Override
    public GenericDrawContext getDrawContext() {
        return new SwingDrawContext((Graphics2D)this.getGraphics());
    }

    @Override
    public double getCanvasWidth() {
        return this.getWidth();
    }

    @Override
    public double getCanvasHeight() {
        return this.getHeight();
    }

    @Override
    public int getBackgroundRGB() {
        return this.getBackground().getRGB();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        this.mDrawArea.paintContent(new SwingDrawContext((Graphics2D)graphics));
    }

    private void initializeDragAndDrop(int n) {
        if (n != 0) {
            MoleculeDropAdapter moleculeDropAdapter = new MoleculeDropAdapter(){

                @Override
                public void onDropMolecule(StereoMolecule stereoMolecule, Point point) {
                    SwingEditorArea.this.mDrawArea.addPastedOrDropped(stereoMolecule, point == null ? null : new GenericPoint(point.x, point.y));
                }
            };
            new DropTarget(this, n, moleculeDropAdapter, true, new OurFlavorMap());
        }
    }

    static class OurFlavorMap
    implements FlavorMap {
        OurFlavorMap() {
        }

        @Override
        public Map<DataFlavor, String> getNativesForFlavors(DataFlavor[] dataFlavorArray) {
            FlavorMap flavorMap = SystemFlavorMap.getDefaultFlavorMap();
            return flavorMap.getNativesForFlavors(dataFlavorArray);
        }

        @Override
        public Map<String, DataFlavor> getFlavorsForNatives(String[] stringArray) {
            FlavorMap flavorMap = SystemFlavorMap.getDefaultFlavorMap();
            return flavorMap.getFlavorsForNatives(stringArray);
        }
    }
}

