/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.editor;

import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.gui.editor.AsynchronousQueryBuilder;
import com.actelion.research.gui.generic.GenericActionEvent;
import com.actelion.research.gui.generic.GenericCheckBox;
import com.actelion.research.gui.generic.GenericComboBox;
import com.actelion.research.gui.generic.GenericUIHelper;
import com.actelion.research.gui.hidpi.HiDPIHelper;

public class BondQueryFeatureDialogBuilder
extends AsynchronousQueryBuilder {
    private ExtendedMolecule mMol;
    private int mBond;
    private int mFirstSpanItem;
    private GenericCheckBox mCBSingle;
    private GenericCheckBox mCBDouble;
    private GenericCheckBox mCBTriple;
    private GenericCheckBox mCBQuadruple;
    private GenericCheckBox mCBQuintuple;
    private GenericCheckBox mCBDelocalized;
    private GenericCheckBox mCBMetalLigand;
    private GenericCheckBox mCBIsBridge;
    private GenericCheckBox mCBMatchFormalOrder;
    private GenericCheckBox mCBMatchStereo;
    private GenericComboBox mComboBoxRing;
    private GenericComboBox mComboBoxRingSize;
    private GenericComboBox mComboBoxMinAtoms;
    private GenericComboBox mComboBoxMaxAtoms;

    public BondQueryFeatureDialogBuilder(GenericUIHelper genericUIHelper, ExtendedMolecule extendedMolecule, int n) {
        this.mDialog = genericUIHelper.createDialog(extendedMolecule.isSelectedAtom(extendedMolecule.getBondAtom(0, n)) && extendedMolecule.isSelectedAtom(extendedMolecule.getBondAtom(1, n)) ? "Bond Query Features (Multiple)" : "Bond Query Features", this);
        this.build(extendedMolecule, n);
    }

    private void build(ExtendedMolecule extendedMolecule, int n) {
        this.mMol = extendedMolecule;
        this.mBond = n;
        int n2 = HiDPIHelper.scale(8.0f);
        int[] nArray = new int[]{n2, -1, -2, -2, n2};
        int[] nArray2 = new int[]{n2, -2, n2, -2, -2, -2, -2, -2, -2, -2, n2, -2, n2, -2, n2, -2, n2, -2, 2 * n2, -2, n2 / 2, -2, n2 / 2, -2, 2 * n2};
        this.mDialog.setLayout(nArray, nArray2);
        this.mDialog.add(this.mDialog.createLabel("Desired Bond type(s):"), 1, 1, 3, 1);
        this.mCBSingle = this.mDialog.createCheckBox("Single");
        this.mDialog.add(this.mCBSingle, 1, 3, 3, 3);
        this.mCBDouble = this.mDialog.createCheckBox("Double");
        this.mDialog.add(this.mCBDouble, 1, 4, 3, 4);
        this.mCBTriple = this.mDialog.createCheckBox("Triple");
        this.mDialog.add(this.mCBTriple, 1, 5, 3, 5);
        this.mCBQuadruple = this.mDialog.createCheckBox("Quadruple");
        this.mDialog.add(this.mCBQuadruple, 1, 6, 3, 6);
        this.mCBQuintuple = this.mDialog.createCheckBox("Quintuple");
        this.mDialog.add(this.mCBQuintuple, 1, 7, 3, 7);
        this.mCBDelocalized = this.mDialog.createCheckBox("Delocalized");
        this.mDialog.add(this.mCBDelocalized, 1, 8, 3, 8);
        this.mCBMetalLigand = this.mDialog.createCheckBox("Coordinate (0-order)");
        this.mDialog.add(this.mCBMetalLigand, 1, 9, 3, 9);
        this.mComboBoxRing = this.mDialog.createComboBox();
        this.mComboBoxRing.addItem("any ring state");
        this.mComboBoxRing.addItem("is not in a ring");
        this.mComboBoxRing.addItem("is any ring bond");
        this.mComboBoxRing.addItem("is non-aromatic ring bond");
        this.mComboBoxRing.addItem("is aromatic bond");
        this.mComboBoxRing.addEventConsumer(this);
        this.mDialog.add(this.mComboBoxRing, 1, 11, 3, 11);
        this.mComboBoxRingSize = this.mDialog.createComboBox();
        this.mComboBoxRingSize.addItem("any ring size");
        this.mComboBoxRingSize.addItem("is in 3-membered ring");
        this.mComboBoxRingSize.addItem("is in 4-membered ring");
        this.mComboBoxRingSize.addItem("is in 5-membered ring");
        this.mComboBoxRingSize.addItem("is in 6-membered ring");
        this.mComboBoxRingSize.addItem("is in 7-membered ring");
        this.mDialog.add(this.mComboBoxRingSize, 1, 13, 3, 13);
        this.mCBMatchFormalOrder = this.mDialog.createCheckBox("Match formal bond order");
        this.mCBMatchFormalOrder.setSelected((extendedMolecule.getBondQueryFeatures(n) & 0x800000) != 0);
        this.mCBMatchFormalOrder.addEventConsumer(this);
        this.mDialog.add(this.mCBMatchFormalOrder, 1, 15, 3, 15);
        this.mCBMatchStereo = this.mDialog.createCheckBox("Match Stereo Configuration");
        this.mCBMatchStereo.setSelected((extendedMolecule.getBondQueryFeatures(n) & 0x100000) != 0);
        this.mCBMatchStereo.addEventConsumer(this);
        this.mDialog.add(this.mCBMatchStereo, 1, 17, 3, 17);
        this.mCBIsBridge = this.mDialog.createCheckBox("Is atom bridge between");
        this.mCBIsBridge.addEventConsumer(this);
        this.mDialog.add(this.mCBIsBridge, 1, 19, 3, 19);
        this.mComboBoxMinAtoms = this.mDialog.createComboBox();
        int n3 = 16;
        for (int i = 0; i < n3; ++i) {
            this.mComboBoxMinAtoms.addItem("" + i);
        }
        this.mDialog.add(this.mComboBoxMinAtoms, 2, 21);
        this.mDialog.add(this.mDialog.createLabel(" and"), 3, 21);
        this.mComboBoxMinAtoms.addEventConsumer(this);
        this.mComboBoxMaxAtoms = this.mDialog.createComboBox();
        this.populateComboBoxMaxAtoms(0);
        this.mDialog.add(this.mComboBoxMaxAtoms, 2, 23);
        this.mDialog.add(this.mDialog.createLabel(" atoms"), 3, 23);
        this.mMol.ensureHelperArrays(7);
        this.setInitialStates();
    }

    @Override
    public void eventHappened(GenericActionEvent genericActionEvent) {
        int n;
        if (this.handleOkCancel(genericActionEvent)) {
            return;
        }
        if (genericActionEvent.getSource() == this.mCBIsBridge || genericActionEvent.getSource() == this.mComboBoxRing) {
            this.enableItems();
        } else if (genericActionEvent.getSource() == this.mComboBoxMinAtoms && this.mFirstSpanItem != (n = this.mComboBoxMinAtoms.getSelectedIndex())) {
            int n2 = this.mFirstSpanItem + this.mComboBoxMaxAtoms.getSelectedIndex();
            int n3 = this.populateComboBoxMaxAtoms(n);
            if (n2 < n) {
                this.mComboBoxMaxAtoms.setSelectedIndex(0);
            } else if (n2 < n + n3) {
                this.mComboBoxMaxAtoms.setSelectedIndex(n2 - n);
            } else {
                this.mComboBoxMaxAtoms.setSelectedIndex(n3 - 1);
            }
            this.mFirstSpanItem = n;
        }
    }

    private void setInitialStates() {
        int n;
        int n2 = this.mMol.getBondQueryFeatures(this.mBond);
        int n3 = n = this.mMol.getBondType(this.mBond) == 64 || this.mMol.isDelocalizedBond(this.mBond) ? 6 : this.mMol.getBondOrder(this.mBond);
        if ((n2 & 1) != 0 || n == 1) {
            this.mCBSingle.setSelected(true);
        }
        if ((n2 & 2) != 0 || n == 2) {
            this.mCBDouble.setSelected(true);
        }
        if ((n2 & 4) != 0 || n == 3) {
            this.mCBTriple.setSelected(true);
        }
        if ((n2 & 0x20) != 0 || n == 4) {
            this.mCBQuadruple.setSelected(true);
        }
        if ((n2 & 0x40) != 0 || n == 5) {
            this.mCBQuintuple.setSelected(true);
        }
        if ((n2 & 8) != 0 || n == 6) {
            this.mCBDelocalized.setSelected(true);
        }
        if ((n2 & 0x10) != 0 || n == 0) {
            this.mCBMetalLigand.setSelected(true);
        }
        if ((n2 & 0x800000) != 0) {
            this.mCBMatchFormalOrder.setSelected(true);
        }
        if ((n2 & 0x100000) != 0) {
            this.mCBMatchStereo.setSelected(true);
        }
        int n4 = n2 & 0x180;
        int n5 = n2 & 0x600000;
        if (n4 == 128) {
            this.mComboBoxRing.setSelectedIndex(1);
        } else if (n5 == 0x200000) {
            this.mComboBoxRing.setSelectedIndex(4);
        } else if (n4 == 256) {
            if (n5 == 0) {
                this.mComboBoxRing.setSelectedIndex(2);
            } else if (n5 == 0x400000) {
                this.mComboBoxRing.setSelectedIndex(3);
            } else {
                this.mComboBoxRing.setSelectedIndex(0);
            }
        } else {
            this.mComboBoxRing.setSelectedIndex(0);
        }
        int n6 = (n2 & 0xE0000) >> 17;
        this.mComboBoxRingSize.setSelectedIndex(n6 == 0 ? 0 : n6 - 2);
        if ((n2 & 0x1FE00) != 0) {
            this.mCBIsBridge.setSelected(true);
            int n7 = (n2 & 0x1E00) >> 9;
            int n8 = (n2 & 0x1E000) >> 13;
            this.mComboBoxMinAtoms.setSelectedIndex(n7);
            this.populateComboBoxMaxAtoms(n7);
            this.mComboBoxMaxAtoms.setSelectedIndex(n8);
        } else {
            this.mComboBoxMaxAtoms.setSelectedIndex(0);
        }
        this.enableItems();
    }

    private int populateComboBoxMaxAtoms(int n) {
        this.mComboBoxMaxAtoms.removeAllItems();
        int n2 = 16;
        for (int i = 0; i < n2; ++i) {
            this.mComboBoxMaxAtoms.addItem("" + (n + i));
        }
        return n2;
    }

    private void enableItems() {
        boolean bl = this.mCBIsBridge.isSelected();
        this.mCBSingle.setEnabled(!bl);
        this.mCBDouble.setEnabled(!bl);
        this.mCBTriple.setEnabled(!bl);
        this.mCBQuadruple.setEnabled(!bl);
        this.mCBQuintuple.setEnabled(!bl);
        this.mCBDelocalized.setEnabled(!bl);
        this.mCBMetalLigand.setEnabled(!bl);
        this.mCBMatchStereo.setEnabled(!bl && this.mMol.getBondOrder(this.mBond) == 2 && this.mMol.getBondParity(this.mBond) != 0 && this.mMol.getBondParity(this.mBond) != 3);
        this.mComboBoxRing.setEnabled(!bl);
        this.mComboBoxRingSize.setEnabled(!bl && this.mComboBoxRing.getSelectedIndex() != 1);
        this.mComboBoxMinAtoms.setEnabled(bl);
        this.mComboBoxMaxAtoms.setEnabled(bl);
    }

    @Override
    protected void setQueryFeatures() {
        if (this.isSelectedBond(this.mBond)) {
            for (int i = 0; i < this.mMol.getAllBonds(); ++i) {
                if (!this.isSelectedBond(i)) continue;
                this.setQueryFeatures(i);
            }
        } else {
            this.setQueryFeatures(this.mBond);
        }
        this.mMol.validateBondQueryFeatures();
    }

    private void setQueryFeatures(int n) {
        int n2 = 0;
        if (this.mCBIsBridge.isSelected()) {
            int n3 = this.mComboBoxMinAtoms.getSelectedIndex();
            int n4 = this.mComboBoxMaxAtoms.getSelectedIndex();
            n2 |= n3 << 9;
            n2 |= n4 << 13;
            n2 &= 0xFFFFFFE0;
        } else {
            int n5;
            int n6;
            int n7 = -1;
            if (this.mCBSingle.isSelected()) {
                this.mMol.setBondType(n, 1);
                n7 = 1;
            } else if (this.mCBDelocalized.isSelected() && !this.mMol.isDelocalizedBond(n)) {
                this.mMol.setBondType(n, 64);
                n7 = 4;
            } else if (this.mCBDouble.isSelected()) {
                this.mMol.setBondType(n, 2);
                n7 = 2;
            } else if (this.mCBTriple.isSelected()) {
                this.mMol.setBondType(n, 4);
                n7 = 3;
            } else if (this.mCBMetalLigand.isSelected()) {
                this.mMol.setBondType(n, 32);
                n7 = 0;
            }
            if (this.mCBSingle.isSelected() && n7 != 1) {
                n2 |= 1;
            }
            if (this.mCBDouble.isSelected() && n7 != 2) {
                n2 |= 2;
            }
            if (this.mCBTriple.isSelected() && n7 != 3) {
                n2 |= 4;
            }
            if (this.mCBQuadruple.isSelected() && n7 != 4) {
                n2 |= 0x20;
            }
            if (this.mCBQuintuple.isSelected() && n7 != 5) {
                n2 |= 0x40;
            }
            if (this.mCBDelocalized.isSelected() && !this.mMol.isDelocalizedBond(n) && n7 != 4) {
                n2 |= 8;
            }
            if (this.mCBMetalLigand.isSelected() && n7 != 0) {
                n2 |= 0x10;
            }
            if (this.mCBMatchFormalOrder.isSelected()) {
                n2 |= 0x800000;
            }
            if (this.mCBMatchStereo.isSelected()) {
                n2 |= 0x100000;
            }
            if (this.mComboBoxRing.getSelectedIndex() != 0) {
                if (this.mComboBoxRing.getSelectedIndex() == 1) {
                    if (!this.mMol.isRingBond(n)) {
                        n2 |= 0x80;
                    }
                } else if (this.mComboBoxRing.getSelectedIndex() == 2) {
                    if (!this.mMol.isRingBond(n)) {
                        n2 |= 0x100;
                    }
                } else if (this.mComboBoxRing.getSelectedIndex() == 3) {
                    if (!this.mMol.isAromaticBond(n)) {
                        n2 |= 0x400100;
                    }
                } else if (this.mComboBoxRing.getSelectedIndex() == 4 && !this.mMol.isAromaticBond(n)) {
                    n2 |= 0x200000;
                }
            }
            if (this.mComboBoxRingSize.getSelectedIndex() != 0 && (n6 = this.mComboBoxRingSize.getSelectedIndex() + 2) != (n5 = this.mMol.getBondRingSize(n))) {
                n2 |= n6 << 17;
            }
        }
        this.mMol.setBondQueryFeature(n, 0xFFFFFF, false);
        this.mMol.setBondQueryFeature(n, n2, true);
    }

    private boolean isSelectedBond(int n) {
        return this.mMol.isSelectedAtom(this.mMol.getBondAtom(0, n)) && this.mMol.isSelectedAtom(this.mMol.getBondAtom(1, n));
    }
}

