/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.dock;

import com.actelion.research.gui.dock.DividerChangeListener;
import com.actelion.research.gui.dock.TreeContainer;
import com.actelion.research.gui.dock.TreeElement;
import com.actelion.research.gui.dock.TreeFork;
import com.actelion.research.gui.dock.TreeLeaf;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComponent;

public class TreeRoot
extends TreeContainer {
    private TreeElement mChildElement;

    public TreeRoot(JComponent jComponent, TreeElement treeElement) {
        this.mComponent = jComponent;
        this.mComponent.add((Component)treeElement.getComponent(), "Center");
        this.mChildElement = treeElement;
        this.mChildElement.setParent(this);
    }

    public void setDividerChangeListeners(Vector<DividerChangeListener> vector) {
        if (this.mChildElement instanceof TreeFork) {
            ((TreeFork)this.mChildElement).updateDividerChangeListeners(vector);
        }
    }

    public TreeElement getChild() {
        return this.mChildElement;
    }

    @Override
    public void setParent(TreeContainer treeContainer) {
        throw new IllegalArgumentException("no parent to root");
    }

    @Override
    public void removeWithLeaf(TreeLeaf treeLeaf) {
        treeLeaf.setParent(null);
    }

    @Override
    public void replaceChildElement(TreeElement treeElement, TreeElement treeElement2) {
        this.mComponent.remove(treeElement.getComponent());
        this.mComponent.add((Component)treeElement2.getComponent(), "Center");
        treeElement2.setParent(this);
        this.mChildElement = treeElement2;
    }

    @Override
    public void updateChildElement(Component component, TreeElement treeElement) {
        this.mComponent.remove(component);
        this.mComponent.add(treeElement.getComponent());
    }

    @Override
    protected void clearStateInfo() {
        this.mChildElement.clearStateInfo();
    }

    public ArrayList<String> createStateInfo() {
        this.clearStateInfo();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.mChildElement instanceof TreeLeaf) {
            ((TreeLeaf)this.mChildElement).addStateInfo(arrayList, "root");
        }
        if (this.mChildElement instanceof TreeFork) {
            ((TreeFork)this.mChildElement).addStateInfo(arrayList, "root");
        }
        return arrayList;
    }

    @Override
    public void printStatus() {
        if (this.mComponent == null) {
            System.out.println("Root childStatus: none");
        } else {
            String string = this.mComponent.getComponent(0) == this.mChildElement.getComponent() ? "OK" : "failed";
            System.out.println("Root childStatus:" + string);
            this.mChildElement.printStatus();
        }
    }
}

