/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.dock;

import com.actelion.research.gui.dock.Dockable;
import com.actelion.research.gui.dock.JDockingPanel;
import com.actelion.research.gui.dock.PopupProvider;
import com.actelion.research.gui.dock.TreeElement;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TreeLeaf
extends TreeElement
implements ChangeListener {
    private JDockingPanel mDockingPanel;
    private Dockable mVisibleDockable;
    private String mStateTitle;
    private boolean mIsAutomatedStateChange;

    public TreeLeaf(Dockable dockable, JDockingPanel jDockingPanel, boolean bl) {
        this.mComponent = dockable;
        this.mVisibleDockable = dockable;
        this.mDockingPanel = jDockingPanel;
        if (!bl) {
            this.mDockingPanel.visibilityChanged(dockable, true);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.mComponent instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            if (this.mVisibleDockable != jTabbedPane.getSelectedComponent()) {
                Dockable dockable = this.mVisibleDockable;
                this.mVisibleDockable = (Dockable)jTabbedPane.getSelectedComponent();
                if (!this.mIsAutomatedStateChange) {
                    this.mDockingPanel.visibilityChanged(dockable, false);
                    this.mDockingPanel.visibilityChanged(this.mVisibleDockable, true);
                    this.mDockingPanel.fireDockableSelected(this.mVisibleDockable);
                }
                this.mDockingPanel.selectDockable(this.mVisibleDockable);
            }
        } else if (this.mComponent instanceof Dockable) {
            Dockable dockable = this.mVisibleDockable;
            this.mVisibleDockable = (Dockable)this.mComponent;
            if (!this.mIsAutomatedStateChange) {
                this.mDockingPanel.visibilityChanged(dockable, false);
                this.mDockingPanel.visibilityChanged(this.mVisibleDockable, true);
            }
            this.mDockingPanel.selectDockable(this.mVisibleDockable);
        }
    }

    @Override
    public boolean isSelected() {
        if (this.mComponent instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)this.mComponent;
            for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
                if (!((Dockable)jTabbedPane.getComponentAt(i)).isSelected()) continue;
                return true;
            }
            return false;
        }
        if (this.mComponent instanceof Dockable) {
            return ((Dockable)this.mComponent).isSelected();
        }
        return false;
    }

    public void setSelected(boolean bl) {
        this.mVisibleDockable.setSelected(bl);
    }

    public void addContent(Dockable dockable, boolean bl) {
        JComponent jComponent;
        if (this.mComponent instanceof Dockable) {
            jComponent = (Dockable)this.mComponent;
            JTabbedPane jTabbedPane = new JTabbedPane(3){

                @Override
                public Dimension getMinimumSize() {
                    return new Dimension(HiDPIHelper.scale(100.0f), HiDPIHelper.scale(100.0f));
                }
            };
            jTabbedPane.putClientProperty("Quaqua.TabbedPane.contentBorderPainted", Boolean.FALSE);
            jTabbedPane.add((Component)jComponent, ((Dockable)jComponent).getTitle());
            jTabbedPane.add((Component)dockable, dockable.getTitle());
            jTabbedPane.addChangeListener(this);
            jTabbedPane.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    this.handlePopupTrigger(mouseEvent);
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    this.handlePopupTrigger(mouseEvent);
                }

                private void handlePopupTrigger(MouseEvent mouseEvent) {
                    Dockable dockable;
                    PopupProvider popupProvider;
                    JTabbedPane jTabbedPane;
                    int n;
                    if (mouseEvent.isPopupTrigger() && (n = (jTabbedPane = (JTabbedPane)mouseEvent.getSource()).indexAtLocation(mouseEvent.getX(), mouseEvent.getY())) != -1 && (popupProvider = (dockable = (Dockable)jTabbedPane.getComponentAt(n)).getPopupProvider()) != null) {
                        JPopupMenu jPopupMenu = popupProvider.createPopupMenu(dockable.getTitle(), dockable.isMaximized());
                        jPopupMenu.show(jTabbedPane, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
            this.mComponent = jTabbedPane;
            this.mParent.updateChildElement(jComponent, this);
        }
        if (this.mComponent instanceof JTabbedPane) {
            jComponent = (JTabbedPane)this.mComponent;
            this.mDockingPanel.visibilityChanged(this.mVisibleDockable, false);
            this.mIsAutomatedStateChange = true;
            ((JTabbedPane)jComponent).add((Component)dockable, dockable.getTitle());
            ((JTabbedPane)jComponent).setSelectedComponent(dockable);
            this.mIsAutomatedStateChange = false;
        }
        if (!bl) {
            this.mDockingPanel.visibilityChanged(dockable, true);
        }
        this.mVisibleDockable = dockable;
    }

    public boolean removeContent(Dockable dockable, boolean bl) {
        if (!bl) {
            this.mDockingPanel.visibilityChanged(dockable, false);
        }
        if (this.mComponent instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)this.mComponent;
            this.mIsAutomatedStateChange = true;
            try {
                jTabbedPane.remove(dockable);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mIsAutomatedStateChange = false;
            if (jTabbedPane.getTabCount() == 1) {
                this.mComponent = (JComponent)jTabbedPane.getComponentAt(0);
                this.mVisibleDockable = (Dockable)this.mComponent;
                this.mParent.updateChildElement(jTabbedPane, this);
            } else {
                this.mVisibleDockable = (Dockable)jTabbedPane.getSelectedComponent();
            }
            this.mDockingPanel.visibilityChanged(this.mVisibleDockable, true);
            return false;
        }
        this.mParent.removeWithLeaf(this);
        return true;
    }

    public int getDockableCount() {
        return this.mComponent instanceof JTabbedPane ? ((JTabbedPane)this.mComponent).getTabCount() : 1;
    }

    protected String addStateInfo(ArrayList<String> arrayList, String string) {
        if (this.mStateTitle == null) {
            if (this.mComponent instanceof JTabbedPane) {
                JTabbedPane jTabbedPane = (JTabbedPane)this.mComponent;
                for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
                    String string2 = jTabbedPane.getTitleAt(i);
                    if (i == 0) {
                        arrayList.add(string2 + "\t" + string);
                    } else {
                        arrayList.add(string2 + "\t" + this.mStateTitle + "\tcenter");
                    }
                    this.mStateTitle = string2;
                }
            } else if (this.mComponent instanceof Dockable) {
                this.mStateTitle = ((Dockable)this.mComponent).getTitle();
                arrayList.add(this.mStateTitle + "\t" + string);
            }
        }
        return this.mStateTitle;
    }

    public Dockable getDockable(int n) {
        if (this.mComponent instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)this.mComponent;
            return (Dockable)jTabbedPane.getComponentAt(n);
        }
        if (this.mComponent instanceof Dockable) {
            return n == 0 ? (Dockable)this.mComponent : null;
        }
        return null;
    }

    public Dockable getDragable(Point point) {
        JComponent jComponent;
        if (this.mComponent instanceof JTabbedPane) {
            jComponent = (JTabbedPane)this.mComponent;
            for (int i = 0; i < ((JTabbedPane)jComponent).getTabCount(); ++i) {
                Dockable dockable = (Dockable)((JTabbedPane)jComponent).getComponentAt(i);
                if (!dockable.getDragHandle().getBounds().contains(point)) continue;
                return dockable;
            }
        }
        if (this.mComponent instanceof Dockable && ((Dockable)(jComponent = (Dockable)this.mComponent)).getDragHandle().getBounds().contains(point)) {
            return jComponent;
        }
        return null;
    }

    public Rectangle getBounds() {
        return this.mComponent.getBounds();
    }

    public void setSelectedDockable(Dockable dockable) {
        if (this.mComponent instanceof JTabbedPane && this.mVisibleDockable != dockable) {
            this.mDockingPanel.visibilityChanged(this.mVisibleDockable, false);
            JTabbedPane jTabbedPane = (JTabbedPane)this.mComponent;
            this.mIsAutomatedStateChange = true;
            jTabbedPane.setSelectedComponent(dockable);
            this.mIsAutomatedStateChange = false;
            this.mDockingPanel.visibilityChanged(dockable, true);
        }
    }

    public void changeTitle(String string, String string2) {
        if (this.mComponent instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)this.mComponent;
            for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
                if (!jTabbedPane.getTitleAt(i).equals(string)) continue;
                jTabbedPane.setTitleAt(i, string2);
                break;
            }
        }
    }

    @Override
    protected void clearStateInfo() {
        this.mStateTitle = null;
    }

    @Override
    public void printStatus() {
        System.out.print("Leaf ");
        if (this.mComponent instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)this.mComponent;
            for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
                Dockable dockable = (Dockable)jTabbedPane.getComponentAt(i);
                System.out.print(dockable.getTitle() + ",");
            }
        } else {
            Dockable dockable = (Dockable)this.mComponent;
            System.out.print(dockable.getTitle());
        }
        System.out.println();
    }
}

