/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.dock;

import com.actelion.research.gui.dock.Dockable;
import com.actelion.research.gui.dock.JDockingPanel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class GhostPreview {
    private Rectangle mPreviewBounds;
    private Dockable mPreviewDockable;
    private BufferedImage mImage;

    public void createPreview(Dockable dockable, Dockable dockable2, int n, JDockingPanel jDockingPanel) {
        this.mPreviewBounds = this.getPreviewBounds(jDockingPanel.getAbsoluteBounds(dockable2), n);
        if (this.mPreviewDockable != dockable) {
            this.mImage = this.createImage(dockable);
            this.mPreviewDockable = dockable;
        }
    }

    public void drawPreview(Graphics2D graphics2D) {
        if (this.mImage == null) {
            return;
        }
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(this.mPreviewBounds.x, this.mPreviewBounds.y, this.mPreviewBounds.width, this.mPreviewBounds.height);
        Composite composite = graphics2D.getComposite();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.8f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.drawImage(this.mImage, this.mPreviewBounds.x, this.mPreviewBounds.y, this.mPreviewBounds.width, this.mPreviewBounds.height, null);
        graphics2D.setComposite(composite);
    }

    private Rectangle getPreviewBounds(Rectangle rectangle, int n) {
        switch (n) {
            case 1: {
                rectangle.height /= 2;
                return rectangle;
            }
            case 2: {
                rectangle.width /= 2;
                return rectangle;
            }
            case 3: {
                rectangle.y += rectangle.height;
                rectangle.height /= 2;
                rectangle.y -= rectangle.height;
                return rectangle;
            }
            case 4: {
                rectangle.x += rectangle.width;
                rectangle.width /= 2;
                rectangle.x -= rectangle.width;
                return rectangle;
            }
        }
        return rectangle;
    }

    private BufferedImage createImage(Component component) {
        BufferedImage bufferedImage = (BufferedImage)component.createImage(component.getWidth(), component.getHeight());
        Graphics2D graphics2D = bufferedImage.createGraphics();
        component.paintAll(graphics2D);
        return bufferedImage;
    }
}

