/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.dock;

import com.actelion.research.gui.HeaderPaintHelper;
import com.actelion.research.gui.LookAndFeelHelper;
import com.actelion.research.gui.dock.Dockable;
import com.actelion.research.gui.dock.HeaderMouseAdapter;
import com.actelion.research.gui.dock.PopupProvider;
import com.actelion.research.gui.dock.TransferableDockable;
import com.actelion.research.gui.hidpi.HiDPIIconButton;
import com.actelion.research.gui.swing.SwingCursorHelper;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class DockableHeader
extends JPanel {
    private static final long serialVersionUID = 537331491L;
    private static final double[][] SIZE = new double[][]{{-1.0, -2.0}, {-2.0}};
    private static final int ALLOWED_DRAG_ACTIONS = 2;
    private Dockable mDockable;
    private JLabel mTitleLabel;
    private JToolBar mToolBar;
    private HeaderMouseAdapter mMouseAdapter;
    private boolean mIsSelected;

    public DockableHeader(Dockable dockable, String string, JToolBar jToolBar) {
        super(new TableLayout(SIZE));
        this.mDockable = dockable;
        this.mTitleLabel = new JLabel(string, 10);
        this.mTitleLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.mTitleLabel.setOpaque(false);
        this.add((Component)this.mTitleLabel, "0,0");
        this.mToolBar = jToolBar != null ? jToolBar : this.createDefaultToolBar();
        this.add((Component)this.mToolBar, "1,0");
        this.setOpaque(true);
        this.mMouseAdapter = new HeaderMouseAdapter(this.mTitleLabel, dockable);
        this.mTitleLabel.addMouseListener(this.mMouseAdapter);
        this.mTitleLabel.addMouseMotionListener(this.mMouseAdapter);
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.mTitleLabel, 2, dragGestureEvent -> {
            if (!this.mDockable.isMaximized() && this.mDockable.getDockingPanel().getDockableCount() >= 2) {
                dragGestureEvent.startDrag(SwingCursorHelper.getCursor(4), new TransferableDockable(this.mDockable));
            }
        });
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateToolbarSeparators();
    }

    private JToolBar createDefaultToolBar() {
        JToolBar jToolBar = new JToolBar();
        if (LookAndFeelHelper.isSubstance()) {
            jToolBar.addSeparator();
        }
        HiDPIIconButton hiDPIIconButton = new HiDPIIconButton("maxButton.png", "Maximize view", "max_", 0, null);
        hiDPIIconButton.addActionListener(actionEvent -> this.mDockable.getDockingPanel().actionPerformed(new ActionEvent(hiDPIIconButton, 1001, "max_" + this.getTitle())));
        jToolBar.add(hiDPIIconButton);
        if (LookAndFeelHelper.isSubstance()) {
            jToolBar.addSeparator();
        }
        HiDPIIconButton hiDPIIconButton2 = new HiDPIIconButton("closeButton.png", "Close view", "close_", 0, null);
        hiDPIIconButton2.addActionListener(actionEvent -> this.mDockable.getDockingPanel().actionPerformed(new ActionEvent(hiDPIIconButton2, 1001, "close_" + this.getTitle())));
        jToolBar.add(hiDPIIconButton2);
        if (LookAndFeelHelper.isSubstance()) {
            jToolBar.addSeparator();
        }
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        jToolBar.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jToolBar.setOpaque(false);
        return jToolBar;
    }

    private void updateToolbarSeparators() {
        if (this.mToolBar != null) {
            ArrayList<JButton> arrayList = new ArrayList<JButton>();
            for (Component component : this.mToolBar.getComponents()) {
                if (!(component instanceof JButton)) continue;
                arrayList.add((JButton)component);
            }
            this.mToolBar.removeAll();
            if (LookAndFeelHelper.isSubstance()) {
                this.mToolBar.addSeparator();
            }
            for (JButton jButton : arrayList) {
                this.mToolBar.add(jButton);
                if (LookAndFeelHelper.isSubstance()) {
                    this.mToolBar.addSeparator();
                    continue;
                }
                if (!LookAndFeelHelper.isQuaQua()) continue;
                jButton.putClientProperty("Quaqua.Button.style", "toolBarTab");
            }
        }
    }

    public String getTitle() {
        return this.mTitleLabel.getText();
    }

    public void setTitle(String string) {
        this.mTitleLabel.setText(string);
    }

    public Dockable getDockable() {
        return this.mDockable;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = this.getWidth();
        int n2 = this.getHeight();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(HeaderPaintHelper.getHeaderPaint(this.mIsSelected, n2));
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setPaint(paint);
    }

    public void update(boolean bl) {
        this.mIsSelected = bl;
        this.repaint();
    }

    public PopupProvider getPopupProvider() {
        return this.mMouseAdapter.getPopupProvider();
    }

    public void setPopupProvider(PopupProvider popupProvider) {
        this.mMouseAdapter.setPopupProvider(popupProvider);
    }
}

